/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.util.Set;
import javax.annotation.Nullable;
import org.python.google.common.collect.Collections2;
import org.python.google.common.collect.EmptyImmutableSet;
import org.python.google.common.collect.ImmutableCollection;
import org.python.google.common.collect.SingletonImmutableSet;
import org.python.google.common.collect.UnmodifiableIterator;

public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    public static <E> ImmutableSet<E> of() {
        return EmptyImmutableSet.INSTANCE;
    }

    public static <E> ImmutableSet<E> of(E element) {
        return new SingletonImmutableSet<E>(element);
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Collections2.1.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return Collections2.1.hashCodeImpl(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    static {
        Math.floor(7.516192768E8);
    }
}

