/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.PageManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jnr.ffi.Runtime;
import jnr.ffi.provider.jffi.AllocatedDirectMemoryIO;
import jnr.ffi.provider.jffi.DirectMemoryIO;
import jnr.ffi.provider.jffi.NativeFinalizer;
import jnr.ffi.util.ref.FinalizableWeakReference;

public class TransientNativeMemory
extends DirectMemoryIO {
    private static final Map<Magazine, Boolean> referenceSet = new ConcurrentHashMap<Magazine, Boolean>();
    private static final ThreadLocal<Magazine> currentMagazine = new ThreadLocal();
    private static final int PAGES_PER_MAGAZINE = 2;
    private final Sentinel sentinel;
    private final int size;

    public static DirectMemoryIO allocate(Runtime runtime, int size, int align, boolean clear) {
        long address;
        if (size > 256) {
            return new AllocatedDirectMemoryIO(runtime, size, clear);
        }
        Magazine magazine = currentMagazine.get();
        Sentinel sentinel = magazine != null ? (Sentinel)magazine.get() : null;
        if (sentinel == null || (address = magazine.allocate(size, align)) == 0L) {
            long memory;
            PageManager pm = PageManager.getInstance();
            while ((memory = pm.allocatePages(2, 3)) == 0L || memory == -1L) {
                System.gc();
            }
            sentinel = new Sentinel(0);
            magazine = new Magazine(sentinel, pm, memory, 2);
            referenceSet.put(magazine, Boolean.TRUE);
            currentMagazine.set(magazine);
            address = magazine.allocate(size, align);
        }
        return new TransientNativeMemory(runtime, sentinel, address, size);
    }

    private TransientNativeMemory(Runtime runtime, Sentinel sentinel, long address, int size) {
        super(runtime, address);
        this.sentinel = sentinel;
        this.size = size;
    }

    private static long align(long offset, long align) {
        return offset + align - 1L & (align - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public long size() {
        return this.size;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TransientNativeMemory) {
            TransientNativeMemory mem = (TransientNativeMemory)obj;
            return mem.size == this.size && mem.address() == this.address;
        }
        return super.equals(obj);
    }

    public String toString() {
        return String.format(this.getClass().getName() + " address=%x size=%d", this.address, this.size());
    }

    public final void dispose() {
    }

    static class 1 {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Magazine
    extends FinalizableWeakReference<Sentinel> {
        private final PageManager pm;
        private final long page;
        private final long end;
        private final int pageCount;
        private long memory;

        Magazine(Sentinel sentinel, PageManager pm, long page, int pageCount) {
            super(sentinel, NativeFinalizer.getInstance().getFinalizerQueue());
            this.pm = pm;
            this.memory = this.page = page;
            this.pageCount = 2;
            this.end = this.memory + 2L * pm.pageSize();
        }

        final long allocate(int size, int align) {
            long address = TransientNativeMemory.align(this.memory, align);
            if (address + (long)size <= this.end) {
                this.memory = address + (long)size;
                return address;
            }
            return 0L;
        }

        @Override
        public final void finalizeReferent() {
            this.pm.freePages(this.page, this.pageCount);
            referenceSet.remove(this);
        }
    }

    static final class Sentinel {
        private Sentinel() {
        }

        /* synthetic */ Sentinel(byte by) {
            this();
        }
    }
}

