/*
 * Decompiled with CFR 0.152.
 */
package jline;

import com.kenai.jffi.Closure;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import jline.CandidateListCompletionHandler;
import jline.CursorBuffer;
import jline.History;
import jline.Terminal;

public final class ConsoleReader {
    private String prompt;
    private boolean useHistory = true;
    private boolean usePagination = false;
    private static String CR = System.getProperty("line.separator");
    private static ResourceBundle loc = ResourceBundle.getBundle((class$jline$CandidateListCompletionHandler == null ? (class$jline$CandidateListCompletionHandler = ConsoleReader.class$("jline.CandidateListCompletionHandler")) : class$jline$CandidateListCompletionHandler).getName());
    private static SortedMap KEYMAP_NAMES;
    private final short[] keybindings;
    private boolean bellEnabled = true;
    private Character mask = null;
    private static final Character NULL_MASK;
    private int autoprintThreshhold = Integer.getInteger("jline.completion.threshold", 100);
    private final Terminal terminal;
    private Closure completionHandler$2aacb16 = new CandidateListCompletionHandler();
    private InputStream in;
    final Writer out;
    final CursorBuffer buf = new CursorBuffer();
    private History history = new History();
    private List completors = new LinkedList();
    private Map triggeredActions = new HashMap();
    private StringBuffer searchTerm = null;
    private String previousSearchTerm = "";
    private int searchIndex = -1;
    private static /* synthetic */ Class class$jline$CandidateListCompletionHandler;

    public ConsoleReader() throws IOException {
        this(new FileInputStream(FileDescriptor.in), new PrintWriter(new OutputStreamWriter((OutputStream)System.out, System.getProperty("jline.WindowsTerminal.output.encoding", System.getProperty("file.encoding")))));
    }

    private ConsoleReader(InputStream in, Writer out) throws IOException {
        this(in, out, null);
    }

    public ConsoleReader(InputStream in, Writer out, InputStream bindings) throws IOException {
        this(in, out, bindings, Terminal.getTerminal());
    }

    private ConsoleReader(InputStream in, Writer out, InputStream bindings, Terminal term) throws IOException {
        this.terminal = term;
        InputStream inputStream = in;
        ConsoleReader consoleReader = this;
        this.in = inputStream;
        this.out = out;
        if (bindings == null) {
            try {
                String bindingFile = System.getProperty("jline.keybindings", new File(System.getProperty("user.home"), ".jlinebindings.properties").getAbsolutePath());
                if (new File(bindingFile).isFile()) {
                    bindings = new FileInputStream(new File(bindingFile));
                }
            }
            catch (Exception exception) {}
        }
        if (bindings == null) {
            bindings = this.terminal.getDefaultBindings();
        }
        this.keybindings = new short[131070];
        Arrays.fill(this.keybindings, (short)-99);
        if (bindings != null) {
            Properties p = new Properties();
            p.load(bindings);
            bindings.close();
            Iterator<Object> i = p.keySet().iterator();
            while (i.hasNext()) {
                String val = (String)i.next();
                try {
                    Short code = new Short(val);
                    String op = p.getProperty(val);
                    Short opval = (Short)KEYMAP_NAMES.get(op);
                    if (opval == null) continue;
                    this.keybindings[code.shortValue()] = opval;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    public final Terminal getTerminal() {
        return this.terminal;
    }

    public final void setBellEnabled(boolean bellEnabled) {
        this.bellEnabled = false;
    }

    public final int getTermwidth() {
        ConsoleReader consoleReader = this;
        return consoleReader.terminal.getTerminalWidth();
    }

    public final int getAutoprintThreshhold() {
        return this.autoprintThreshhold;
    }

    private int getCursorPosition() {
        int n;
        String string = this.prompt;
        if (string == null) {
            n = 0;
        } else {
            boolean bl = false;
            int n2 = 0;
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (!bl && c == '\u001b' && i < cArray.length - 1 && cArray[i + 1] == '[') {
                    ++i;
                    bl = true;
                    continue;
                }
                if (bl) {
                    if ('@' > c || c > '~') continue;
                    bl = false;
                    continue;
                }
                ++n2;
            }
            n = n2;
        }
        return n + this.buf.cursor;
    }

    public final void setDefaultPrompt(String prompt) {
        this.prompt = null;
    }

    /*
     * WARNING - void declaration
     */
    public final String readLine(String prompt, Character mask) throws IOException {
        this.mask = null;
        if (prompt != null) {
            this.prompt = prompt;
        }
        try {
            this.terminal.beforeReadLine(this, this.prompt, null);
            if (this.prompt != null && this.prompt.length() > 0) {
                this.out.write(this.prompt);
                this.out.flush();
            }
            if (!this.terminal.isSupported()) {
                void NORMAL;
                int n;
                InputStream inputStream = this.in;
                StringBuffer stringBuffer = new StringBuffer();
                while ((n = inputStream.read()) != -1 && n != 10 && n != 13) {
                    stringBuffer.append((char)n);
                }
                String string = stringBuffer.toString();
                return NORMAL;
            }
            int state = 1;
            boolean success = true;
            while (true) {
                ConsoleReader consoleReader;
                int n;
                int[] nArray;
                ConsoleReader consoleReader2;
                int n2;
                if ((n2 = (consoleReader2 = this).readVirtualKey()) == -1) {
                    nArray = null;
                } else {
                    n = consoleReader2.keybindings[n2];
                    int[] nArray2 = new int[2];
                    nArray2[0] = n2;
                    nArray = nArray2;
                    nArray2[1] = n;
                }
                int[] next = nArray;
                if (nArray == null) {
                    return null;
                }
                void c = next[0];
                int code = next[1];
                if (c == -1) {
                    return null;
                }
                if (state == 2) {
                    switch (code) {
                        case -64: {
                            state = 1;
                            break;
                        }
                        case -21: {
                            if (this.searchTerm.length() == 0) {
                                this.searchTerm.append(this.previousSearchTerm);
                            }
                            if (this.searchIndex == -1) {
                                this.searchIndex = this.history.searchBackwards(this.searchTerm.toString());
                                break;
                            }
                            this.searchIndex = this.history.searchBackwards(this.searchTerm.toString(), this.searchIndex);
                            break;
                        }
                        case -41: {
                            if (this.searchTerm.length() <= 0) break;
                            this.searchTerm.deleteCharAt(this.searchTerm.length() - 1);
                            this.searchIndex = this.history.searchBackwards(this.searchTerm.toString());
                            break;
                        }
                        case -99: {
                            this.searchTerm.appendCodePoint((int)c);
                            this.searchIndex = this.history.searchBackwards(this.searchTerm.toString());
                            break;
                        }
                        default: {
                            if (this.searchIndex != -1) {
                                this.history.setCurrentIndex(this.searchIndex);
                                this.setBuffer(this.history.current());
                                this.buf.cursor = this.history.current().indexOf(this.searchTerm.toString());
                            }
                            state = 1;
                        }
                    }
                    if (state == 2) {
                        if (this.searchTerm.length() == 0) {
                            this.printSearchStatus("", "");
                        } else if (this.searchIndex == -1) {
                            this.beep();
                        } else {
                            this.printSearchStatus(this.searchTerm.toString(), this.history.getHistory(this.searchIndex));
                        }
                    } else {
                        consoleReader2 = this;
                        consoleReader2.printString("\u001b[2K");
                        consoleReader2.redrawLine();
                        consoleReader = consoleReader2;
                        consoleReader.out.flush();
                    }
                }
                if (state != 1) continue;
                switch (code) {
                    case -59: {
                        if (this.buf.buffer.length() == 0) {
                            return null;
                        }
                        success = this.deleteCurrentCharacter();
                        break;
                    }
                    case -58: {
                        success = this.complete();
                        break;
                    }
                    case -1: {
                        success = this.setCursorPosition(0);
                        break;
                    }
                    case -7: {
                        success = this.killLine();
                        break;
                    }
                    case -8: {
                        boolean bl;
                        consoleReader2 = this;
                        if (!consoleReader2.terminal.isANSISupported()) {
                            bl = false;
                        } else {
                            consoleReader2.printANSISequence("2J");
                            consoleReader2.printANSISequence("1;1H");
                            consoleReader2.redrawLine();
                            bl = true;
                        }
                        success = bl;
                        break;
                    }
                    case -15: {
                        boolean bl;
                        consoleReader2 = this;
                        if (consoleReader2.buf.cursor == 0) {
                            bl = false;
                        } else {
                            ConsoleReader consoleReader3 = consoleReader2;
                            consoleReader3.backspace(Integer.MAX_VALUE);
                            bl = true;
                        }
                        success = bl;
                        break;
                    }
                    case -6: {
                        this.moveToEnd();
                        this.printNewline();
                        consoleReader2 = this;
                        String string = consoleReader2.buf.buffer.toString();
                        if (string.length() > 0) {
                            if (consoleReader2.mask == null && consoleReader2.useHistory) {
                                consoleReader2.history.addToHistory(string);
                            } else {
                                consoleReader2.mask = null;
                            }
                        }
                        consoleReader2.history.moveToEnd();
                        consoleReader2.buf.buffer.setLength(0);
                        consoleReader2.buf.cursor = 0;
                        String string2 = string;
                        return string2;
                    }
                    case -41: {
                        success = this.backspace();
                        break;
                    }
                    case -56: {
                        success = this.deleteCurrentCharacter();
                        break;
                    }
                    case -3: {
                        success = this.moveToEnd();
                        break;
                    }
                    case -4: {
                        success = this.moveCursor(-1) != 0;
                        break;
                    }
                    case -19: {
                        success = this.moveCursor(1) != 0;
                        break;
                    }
                    case -9: {
                        success = this.moveHistory(true);
                        break;
                    }
                    case -11: {
                        success = this.moveHistory(false);
                        break;
                    }
                    case -64: 
                    case -13: {
                        break;
                    }
                    case -60: {
                        success = this.paste();
                        break;
                    }
                    case -16: {
                        success = this.deletePreviousWord();
                        break;
                    }
                    case -43: {
                        success = this.previousWord();
                        break;
                    }
                    case -55: {
                        success = this.nextWord();
                        break;
                    }
                    case -61: {
                        success = this.history.moveToFirstEntry();
                        if (!success) break;
                        this.setBuffer(this.history.current());
                        break;
                    }
                    case -62: {
                        success = this.history.moveToLastEntry();
                        if (!success) break;
                        this.setBuffer(this.history.current());
                        break;
                    }
                    case -63: {
                        this.moveInternal(-this.buf.buffer.length());
                        this.killLine();
                        break;
                    }
                    case -48: {
                        this.buf.setOvertyping(!this.buf.isOvertyping());
                        break;
                    }
                    case -21: {
                        if (this.searchTerm != null) {
                            this.previousSearchTerm = this.searchTerm.toString();
                        }
                        this.searchTerm = new StringBuffer(this.buf.buffer);
                        state = 2;
                        if (this.searchTerm.length() > 0) {
                            this.searchIndex = this.history.searchBackwards(this.searchTerm.toString());
                            if (this.searchIndex == -1) {
                                this.beep();
                            }
                            this.printSearchStatus(this.searchTerm.toString(), this.searchIndex >= 0 ? this.history.getHistory(this.searchIndex) : "");
                            break;
                        }
                        this.searchIndex = -1;
                        this.printSearchStatus("", "");
                        break;
                    }
                    default: {
                        if (c != false) {
                            ActionListener action = (ActionListener)this.triggeredActions.get(new Character((char)c));
                            if (action != null) {
                                action.actionPerformed(null);
                                break;
                            }
                            n = 1;
                            n2 = c;
                            consoleReader2 = this;
                            char c2 = (char)n2;
                            CursorBuffer cursorBuffer = consoleReader2.buf;
                            cursorBuffer.buffer.insert(cursorBuffer.cursor++, c2);
                            if (cursorBuffer.isOvertyping() && cursorBuffer.cursor < cursorBuffer.buffer.length()) {
                                cursorBuffer.buffer.deleteCharAt(cursorBuffer.cursor);
                            }
                            if (consoleReader2.mask == null) {
                                consoleReader2.printCharacter(n2);
                            } else if (consoleReader2.mask.charValue() != '\u0000') {
                                consoleReader2.printCharacter(consoleReader2.mask.charValue());
                            }
                            consoleReader2.drawBuffer();
                            break;
                        }
                        success = false;
                    }
                }
                if (!success) {
                    this.beep();
                }
                consoleReader = this;
                consoleReader.out.flush();
            }
        }
        finally {
            this.terminal.afterReadLine$5d946c1f();
        }
    }

    private final boolean moveHistory(boolean next) throws IOException {
        if (next && !this.history.next()) {
            return false;
        }
        if (!next && !this.history.previous()) {
            return false;
        }
        this.setBuffer(this.history.current());
        return true;
    }

    private boolean paste() throws IOException {
        Clipboard clipboard;
        try {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Exception exception) {
            return false;
        }
        if (clipboard == null) {
            return false;
        }
        Transferable transferable = clipboard.getContents(null);
        if (transferable == null) {
            return false;
        }
        try {
            String value;
            Object content = transferable.getTransferData(DataFlavor.plainTextFlavor);
            if (content == null) {
                try {
                    content = new DataFlavor().getReaderForText(transferable);
                }
                catch (Exception exception) {}
            }
            if (content == null) {
                return false;
            }
            if (content instanceof Reader) {
                String line;
                value = "";
                BufferedReader read = new BufferedReader((Reader)content);
                while ((line = read.readLine()) != null) {
                    if (value.length() > 0) {
                        value = value + "\n";
                    }
                    value = value + line;
                }
            } else {
                value = content.toString();
            }
            if (value == null) {
                return true;
            }
            this.putString(value);
            return true;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return false;
        }
    }

    private boolean killLine() throws IOException {
        int cp = this.buf.cursor;
        int len = this.buf.buffer.length();
        if (cp >= len) {
            return false;
        }
        int num = this.buf.buffer.length() - cp;
        this.clearAhead(num);
        for (int i = 0; i < num; ++i) {
            this.buf.buffer.deleteCharAt(len - i - 1);
        }
        return true;
    }

    private final boolean complete() throws IOException {
        Closure comp;
        if (this.completors.size() == 0) {
            return false;
        }
        LinkedList candidates = new LinkedList();
        StringBuffer cfr_ignored_0 = this.buf.buffer;
        int cfr_ignored_1 = this.buf.cursor;
        int position = -1;
        Iterator i = this.completors.iterator();
        while (i.hasNext() && (position = (comp = (Closure)i.next()).complete$7424ba38()) == -1) {
        }
        if (candidates.size() == 0) {
            return false;
        }
        return this.completionHandler$2aacb16.complete(this, candidates, position);
    }

    public final void printColumns(Collection stuff) throws IOException {
        if (stuff == null || stuff.size() == 0) {
            return;
        }
        int width = this.getTermwidth();
        int maxwidth = 0;
        Iterator i = stuff.iterator();
        while (i.hasNext()) {
            maxwidth = Math.max(maxwidth, i.next().toString().length());
        }
        StringBuffer line = new StringBuffer();
        int showLines = Integer.MAX_VALUE;
        Iterator i2 = stuff.iterator();
        while (i2.hasNext()) {
            String cur = (String)i2.next();
            if (line.length() + maxwidth > width) {
                this.printString(line.toString().trim());
                this.printNewline();
                line.setLength(0);
                if (--showLines == 0) {
                    this.printString(loc.getString("display-more"));
                    ConsoleReader consoleReader = this;
                    consoleReader.out.flush();
                    int c = this.readVirtualKey();
                    if (c == 13 || c == 10) {
                        showLines = 1;
                    } else if (c != 113) {
                        ConsoleReader consoleReader2;
                        consoleReader = consoleReader2 = this;
                        showLines = consoleReader2.terminal.getTerminalHeight() - 1;
                    }
                    this.back(loc.getString("display-more").length());
                    if (c == 113) break;
                }
            }
            ConsoleReader.pad(cur, maxwidth + 3, line);
        }
        if (line.length() > 0) {
            this.printString(line.toString().trim());
            this.printNewline();
            line.setLength(0);
        }
    }

    private static void pad(String toPad, int len, StringBuffer appendTo) {
        appendTo.append(toPad);
        for (int i = 0; i < len - toPad.length(); ++i) {
            appendTo.append(' ');
        }
    }

    public final boolean setCursorPosition(int position) throws IOException {
        return this.moveCursor(position - this.buf.cursor) != 0;
    }

    private final void setBuffer(String buffer) throws IOException {
        if (buffer.equals(this.buf.buffer.toString())) {
            return;
        }
        int sameIndex = 0;
        int l1 = buffer.length();
        int l2 = this.buf.buffer.length();
        for (int i = 0; i < l1 && i < l2 && buffer.charAt(i) == this.buf.buffer.charAt(i); ++i) {
            ++sameIndex;
        }
        int diff = this.buf.cursor - sameIndex;
        if (diff < 0) {
            this.moveToEnd();
            diff = this.buf.buffer.length() - sameIndex;
        }
        this.backspace(diff);
        this.killLine();
        this.buf.buffer.setLength(sameIndex);
        this.putString(buffer.substring(sameIndex));
    }

    public final void redrawLine() throws IOException {
        this.printCharacter(13);
        ConsoleReader consoleReader = this;
        consoleReader.out.flush();
        this.drawLine();
    }

    public final void drawLine() throws IOException {
        if (this.prompt != null) {
            this.printString(this.prompt);
        }
        this.printString(this.buf.buffer.toString());
        CursorBuffer cursorBuffer = this.buf;
        if (cursorBuffer.buffer.length() != this.buf.cursor) {
            cursorBuffer = this.buf;
            this.back(cursorBuffer.buffer.length() - this.buf.cursor - 1);
        }
    }

    public final void printNewline() throws IOException {
        this.printString(CR);
        ConsoleReader consoleReader = this;
        consoleReader.out.flush();
    }

    public final void putString(String str) throws IOException {
        String string = str;
        CursorBuffer cursorBuffer = this.buf;
        if (cursorBuffer.buffer.length() == 0) {
            cursorBuffer.buffer.append(string);
        } else {
            cursorBuffer.buffer.insert(cursorBuffer.cursor, string);
        }
        cursorBuffer.cursor += string.length();
        if (cursorBuffer.isOvertyping() && cursorBuffer.cursor < cursorBuffer.buffer.length()) {
            cursorBuffer.buffer.delete(cursorBuffer.cursor, cursorBuffer.cursor + string.length());
        }
        this.printString(str);
        ConsoleReader consoleReader = this;
        consoleReader.drawBuffer(0);
    }

    public final void printString(String str) throws IOException {
        this.printCharacters(str.toCharArray());
    }

    private final void drawBuffer(int clear) throws IOException {
        Object object = this.buf;
        if (this.buf.cursor == ((CursorBuffer)object).buffer.length() && clear == 0) {
            return;
        }
        char[] chars = this.buf.buffer.substring(this.buf.cursor).toCharArray();
        if (this.mask != null) {
            Arrays.fill(chars, this.mask.charValue());
        }
        this.printCharacters(chars);
        this.clearAhead(clear);
        if (this.terminal.isANSISupported()) {
            if (chars.length > 0) {
                this.back(Math.max(chars.length - 1, 1));
            }
        } else {
            this.back(chars.length);
        }
        object = this;
        ((ConsoleReader)object).out.flush();
    }

    private final void drawBuffer() throws IOException {
        this.drawBuffer(0);
    }

    private final void clearAhead(int num) throws IOException {
        if (num == 0) {
            return;
        }
        if (this.terminal.isANSISupported()) {
            this.printANSISequence("J");
            return;
        }
        this.printCharacters(' ', num);
        ConsoleReader consoleReader = this;
        consoleReader.out.flush();
        this.back(num);
        consoleReader = this;
        consoleReader.out.flush();
    }

    private final void back(int num) throws IOException {
        if (num == 0) {
            return;
        }
        if (this.terminal.isANSISupported()) {
            int width = this.getTermwidth();
            int cursor = this.getCursorPosition();
            int currRow = (cursor + num) / width;
            int newRow = cursor / width;
            int newCol = cursor % width + 1;
            if (newRow < currRow) {
                this.printANSISequence(currRow - newRow + "A");
            }
            this.printANSISequence(newCol + "G");
            ConsoleReader consoleReader = this;
            consoleReader.out.flush();
            return;
        }
        this.printCharacters('\b', num);
        ConsoleReader consoleReader = this;
        consoleReader.out.flush();
    }

    public final void beep() throws IOException {
        ConsoleReader consoleReader = this;
        if (!consoleReader.bellEnabled) {
            return;
        }
        this.printCharacter(7);
        ConsoleReader consoleReader2 = this;
        consoleReader2.out.flush();
    }

    private final void printCharacter(int c) throws IOException {
        if (c == 9) {
            char[] cbuf = new char[4];
            Arrays.fill(cbuf, ' ');
            this.out.write(cbuf);
            return;
        }
        this.out.write(c);
    }

    private final void printCharacters(char[] c) throws IOException {
        char[] cbuf;
        int len = 0;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\t') {
                len += 4;
                continue;
            }
            ++len;
        }
        if (len == c.length) {
            cbuf = c;
        } else {
            cbuf = new char[len];
            int pos = 0;
            for (int i = 0; i < c.length; ++i) {
                if (c[i] == '\t') {
                    Arrays.fill(cbuf, pos, pos + 4, ' ');
                    pos += 4;
                    continue;
                }
                cbuf[pos] = c[i];
                ++pos;
            }
        }
        this.out.write(cbuf);
    }

    private final void printCharacters(char c, int num) throws IOException {
        if (num == 1) {
            this.printCharacter(c);
            return;
        }
        char[] chars = new char[num];
        Arrays.fill(chars, c);
        this.printCharacters(chars);
    }

    private final int backspace(int num) throws IOException {
        if (this.buf.cursor == 0) {
            return 0;
        }
        int termwidth = this.getTermwidth();
        int lines = this.getCursorPosition() / termwidth;
        int count2 = -this.moveCursor(-1 * num);
        this.buf.buffer.delete(this.buf.cursor, this.buf.cursor + count2);
        if (this.getCursorPosition() / termwidth != lines && this.terminal.isANSISupported()) {
            this.printANSISequence("J");
            ConsoleReader consoleReader = this;
            consoleReader.out.flush();
        }
        this.drawBuffer(count2);
        return count2;
    }

    public final boolean backspace() throws IOException {
        return this.backspace(1) == 1;
    }

    private final boolean moveToEnd() throws IOException {
        CursorBuffer cursorBuffer = this.buf;
        return this.moveCursor(cursorBuffer.buffer.length() - this.buf.cursor) > 0;
    }

    private final boolean deleteCurrentCharacter() throws IOException {
        block3: {
            block2: {
                CursorBuffer cursorBuffer = this.buf;
                if (cursorBuffer.buffer.length() == 0) break block2;
                cursorBuffer = this.buf;
                if (this.buf.cursor != cursorBuffer.buffer.length()) break block3;
            }
            return false;
        }
        this.buf.buffer.deleteCharAt(this.buf.cursor);
        this.drawBuffer(1);
        return true;
    }

    private final boolean previousWord() throws IOException {
        while (ConsoleReader.isDelimiter(this.buf.current()) && this.moveCursor(-1) != 0) {
        }
        while (!ConsoleReader.isDelimiter(this.buf.current()) && this.moveCursor(-1) != 0) {
        }
        return true;
    }

    private final boolean nextWord() throws IOException {
        while (ConsoleReader.isDelimiter(this.buf.current()) && this.moveCursor(1) != 0) {
        }
        while (!ConsoleReader.isDelimiter(this.buf.current()) && this.moveCursor(1) != 0) {
        }
        return true;
    }

    private final boolean deletePreviousWord() throws IOException {
        while (ConsoleReader.isDelimiter(this.buf.current()) && this.backspace()) {
        }
        while (!ConsoleReader.isDelimiter(this.buf.current()) && this.backspace()) {
        }
        return true;
    }

    private int moveCursor(int num) throws IOException {
        int where = num;
        if (this.buf.cursor == 0 && where <= 0) {
            return 0;
        }
        if (this.buf.cursor == this.buf.buffer.length() && where >= 0) {
            return 0;
        }
        if (this.buf.cursor + where < 0) {
            where = -this.buf.cursor;
        } else if (this.buf.cursor + where > this.buf.buffer.length()) {
            where = this.buf.buffer.length() - this.buf.cursor;
        }
        this.moveInternal(where);
        return where;
    }

    private final void moveInternal(int where) throws IOException {
        this.buf.cursor += where;
        if (this.terminal.isANSISupported()) {
            if (where < 0) {
                this.back(Math.abs(where));
            } else {
                int oldLine;
                int width = this.getTermwidth();
                int cursor = this.getCursorPosition();
                int newLine = cursor / width;
                if (newLine > (oldLine = (cursor - where) / width)) {
                    this.printANSISequence(newLine - oldLine + "B");
                }
                this.printANSISequence(1 + cursor % width + "G");
            }
            ConsoleReader consoleReader = this;
            consoleReader.out.flush();
            return;
        }
        if (where < 0) {
            int len = 0;
            for (int i = this.buf.cursor; i < this.buf.cursor - where; ++i) {
                CursorBuffer cursorBuffer = this.buf;
                if (cursorBuffer.buffer.charAt(i) == '\t') {
                    len += 4;
                    continue;
                }
                ++len;
            }
            char[] cbuf = new char[len];
            Arrays.fill(cbuf, '\b');
            this.out.write(cbuf);
            return;
        }
        if (this.buf.cursor == 0) {
            return;
        }
        if (this.mask == null) {
            this.printCharacters(this.buf.buffer.substring(this.buf.cursor - where, this.buf.cursor).toCharArray());
            return;
        }
        char c = this.mask.charValue();
        if (NULL_MASK.equals(this.mask)) {
            return;
        }
        this.printCharacters(c, Math.abs(where));
    }

    private int readVirtualKey() throws IOException {
        int n;
        int c;
        int n2 = c = this.terminal.readVirtualKey(this.in);
        ConsoleReader consoleReader = this;
        if (!consoleReader.terminal.getEcho()) {
            n = 0;
        } else {
            int n3;
            char c2 = (char)n2;
            ConsoleReader consoleReader2 = consoleReader;
            if (c2 == '\t') {
                int n4 = consoleReader2.getCursorPosition();
                n3 = 8 - n4 % 8;
            } else {
                char c3 = c2;
                StringBuffer stringBuffer = new StringBuffer();
                if (c3 >= ' ') {
                    if (c3 < '\u007f') {
                        stringBuffer.append(c3);
                    } else if (c3 == '\u007f') {
                        stringBuffer.append('^');
                        stringBuffer.append('?');
                    } else {
                        stringBuffer.append('M');
                        stringBuffer.append('-');
                        if (c3 >= '\u00a0') {
                            if (c3 < '\u00ff') {
                                stringBuffer.append((char)(c3 - 128));
                            } else {
                                stringBuffer.append('^');
                                stringBuffer.append('?');
                            }
                        } else {
                            stringBuffer.append('^');
                            stringBuffer.append((char)(c3 - 128 + 64));
                        }
                    }
                } else {
                    stringBuffer.append('^');
                    stringBuffer.append((char)(c3 + 64));
                }
                n3 = stringBuffer.length();
            }
            int n5 = n3;
            consoleReader.back(n5);
            consoleReader.drawBuffer(n5);
            n = n5;
        }
        return c;
    }

    public final int readCharacter(char[] allowed) throws IOException {
        char c;
        Arrays.sort(allowed);
        while (Arrays.binarySearch(allowed, c = (char)this.readVirtualKey()) < 0) {
        }
        return c;
    }

    public final History getHistory() {
        return this.history;
    }

    private static boolean isDelimiter(char c) {
        return !Character.isLetterOrDigit(c);
    }

    private void printANSISequence(String sequence) throws IOException {
        this.printCharacter(27);
        this.printCharacter(91);
        this.printString(sequence);
        ConsoleReader consoleReader = this;
        consoleReader.out.flush();
    }

    private void printSearchStatus(String searchTerm, String match) throws IOException {
        int i = match.indexOf(searchTerm);
        this.printString("\r(reverse-i-search) `" + searchTerm + "': " + match + "\u001b[K");
        this.printCharacters('\b', match.length() - i);
        ConsoleReader consoleReader = this;
        consoleReader.out.flush();
    }

    private static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TreeMap<String, Short> names = new TreeMap<String, Short>();
        names.put("MOVE_TO_BEG", new Short(-1));
        names.put("MOVE_TO_END", new Short(-3));
        names.put("PREV_CHAR", new Short(-4));
        names.put("NEWLINE", new Short(-6));
        names.put("KILL_LINE", new Short(-7));
        names.put("PASTE", new Short(-60));
        names.put("CLEAR_SCREEN", new Short(-8));
        names.put("NEXT_HISTORY", new Short(-9));
        names.put("PREV_HISTORY", new Short(-11));
        names.put("START_OF_HISTORY", new Short(-61));
        names.put("END_OF_HISTORY", new Short(-62));
        names.put("REDISPLAY", new Short(-13));
        names.put("KILL_LINE_PREV", new Short(-15));
        names.put("DELETE_PREV_WORD", new Short(-16));
        names.put("NEXT_CHAR", new Short(-19));
        names.put("REPEAT_PREV_CHAR", new Short(-20));
        names.put("SEARCH_PREV", new Short(-21));
        names.put("REPEAT_NEXT_CHAR", new Short(-24));
        names.put("SEARCH_NEXT", new Short(-25));
        names.put("PREV_SPACE_WORD", new Short(-27));
        names.put("TO_END_WORD", new Short(-29));
        names.put("REPEAT_SEARCH_PREV", new Short(-34));
        names.put("PASTE_PREV", new Short(-36));
        names.put("REPLACE_MODE", new Short(-37));
        names.put("SUBSTITUTE_LINE", new Short(-38));
        names.put("TO_PREV_CHAR", new Short(-39));
        names.put("NEXT_SPACE_WORD", new Short(-40));
        names.put("DELETE_PREV_CHAR", new Short(-41));
        names.put("ADD", new Short(-42));
        names.put("PREV_WORD", new Short(-43));
        names.put("CHANGE_META", new Short(-44));
        names.put("DELETE_META", new Short(-45));
        names.put("END_WORD", new Short(-46));
        names.put("NEXT_CHAR", new Short(-19));
        names.put("INSERT", new Short(-48));
        names.put("REPEAT_SEARCH_NEXT", new Short(-49));
        names.put("PASTE_NEXT", new Short(-50));
        names.put("REPLACE_CHAR", new Short(-51));
        names.put("SUBSTITUTE_CHAR", new Short(-52));
        names.put("TO_NEXT_CHAR", new Short(-53));
        names.put("UNDO", new Short(-54));
        names.put("NEXT_WORD", new Short(-55));
        names.put("DELETE_NEXT_CHAR", new Short(-56));
        names.put("CHANGE_CASE", new Short(-57));
        names.put("COMPLETE", new Short(-58));
        names.put("EXIT", new Short(-59));
        names.put("CLEAR_LINE", new Short(-63));
        names.put("ABORT", new Short(-64));
        KEYMAP_NAMES = new TreeMap(Collections.unmodifiableMap(names));
        NULL_MASK = new Character('\u0000');
    }
}

