/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util.thread;

import net.grinder.common.GrinderException;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.util.thread.InterruptibleRunnable;
import net.grinder.util.thread.ThreadPool;
import net.grinder.util.thread.ThreadSafeQueue;

public final class Executor {
    private final ThreadSafeQueue m_workQueue;
    private final ThreadPool m_threadPool;

    public Executor(int numberOfThreads) {
        this(new ThreadSafeQueue(), numberOfThreads);
    }

    Executor(ThreadSafeQueue workQueue, int numberOfThreads) {
        this.m_workQueue = workQueue;
        ThreadPool.InterruptibleRunnableFactory runnableFactory = new ThreadPool.InterruptibleRunnableFactory(){

            public InterruptibleRunnable create() {
                return new ExecutorRunnable();
            }
        };
        this.m_threadPool = new ThreadPool("Executor", numberOfThreads, runnableFactory);
        this.m_threadPool.start();
    }

    public void execute(InterruptibleRunnable work) throws ShutdownException {
        if (this.m_threadPool.isStopped()) {
            throw new ShutdownException("Executor is stopped");
        }
        try {
            this.m_workQueue.queue(work);
        }
        catch (ThreadSafeQueue.ShutdownException e) {
            throw new ShutdownException("Executor is stopped", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gracefulShutdown() {
        try {
            this.m_workQueue.gracefulShutdown();
        }
        finally {
            this.m_threadPool.stopAndWait();
        }
    }

    public void forceShutdown() {
        this.m_workQueue.shutdown();
        this.m_threadPool.stop();
    }

    public static final class ShutdownException
    extends GrinderException {
        private ShutdownException(String s) {
            super(s);
        }

        private ShutdownException(String s, Exception e) {
            super(s, e);
        }
    }

    private class ExecutorRunnable
    implements InterruptibleRunnable {
        private ExecutorRunnable() {
        }

        public void interruptibleRun() {
            while (true) {
                InterruptibleRunnable runnable;
                try {
                    runnable = (InterruptibleRunnable)Executor.this.m_workQueue.dequeue(true);
                }
                catch (ThreadSafeQueue.ShutdownException e) {
                    break;
                }
                catch (UncheckedInterruptedException e) {
                    Executor.this.forceShutdown();
                    break;
                }
                runnable.interruptibleRun();
            }
        }
    }
}

