/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import net.grinder.util.AbstractMultiLineFormatter;

public final class FixedWidthFormatter
extends AbstractMultiLineFormatter {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTRE = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int FLOW_TRUNCATE = 8;
    public static final int FLOW_WRAP = 9;
    public static final int FLOW_WORD_WRAP = 10;
    private static final char[] s_space = new char[256];
    private final int m_alignment;
    private final int m_flow;
    private final int m_width;

    public FixedWidthFormatter(int alignment, int flow, int width) {
        if (alignment != 0 && alignment != 1 && alignment != 2) {
            throw new IllegalArgumentException("Invalid alignment value");
        }
        if (flow != 8 && flow != 9 && flow != 10) {
            throw new IllegalArgumentException("Invalid flow value");
        }
        if (width <= 0) {
            throw new IllegalArgumentException("Invalid width value");
        }
        this.m_alignment = alignment;
        this.m_flow = flow;
        this.m_width = width;
    }

    private int findWordWrapSplitPosition(StringBuffer buffer) {
        int splitPosition;
        int length = buffer.length();
        int right = Math.min(length, this.m_width);
        for (splitPosition = 0; splitPosition < right; ++splitPosition) {
            if (buffer.charAt(splitPosition) != '\n') continue;
            return splitPosition;
        }
        if (length > this.m_width) {
            splitPosition = this.m_width;
            do {
                if (!Character.isWhitespace(buffer.charAt(splitPosition))) continue;
                return splitPosition;
            } while (--splitPosition >= 0);
            return this.m_width;
        }
        return -1;
    }

    public void transform(StringBuffer buffer, StringBuffer remainder) {
        int length = buffer.length();
        switch (this.m_flow) {
            case 8: {
                if (length <= this.m_width) break;
                buffer.setLength(this.m_width);
                break;
            }
            case 9: {
                if (length <= this.m_width) break;
                remainder.insert(0, buffer.substring(this.m_width));
                buffer.setLength(this.m_width);
                break;
            }
            case 10: {
                int end2 = length;
                int splitPosition = this.findWordWrapSplitPosition(buffer);
                if (splitPosition >= 0) {
                    char c;
                    int nextText;
                    for (nextText = splitPosition; nextText < length && Character.isWhitespace(c = buffer.charAt(nextText)); ++nextText) {
                        if (c != '\n') continue;
                        break;
                    }
                    if (nextText < length) {
                        remainder.insert(0, buffer.substring(nextText));
                    }
                    end2 = splitPosition;
                }
                while (end2 > 0 && Character.isWhitespace(buffer.charAt(end2 - 1))) {
                    --end2;
                }
                buffer.setLength(end2);
                if (this.m_alignment == 0) break;
                int start = 0;
                while (Character.isWhitespace(buffer.charAt(start))) {
                    ++start;
                }
                buffer.delete(0, start);
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid flow: " + this.m_flow));
            }
        }
        length = buffer.length();
        for (int k = 0; k < length; ++k) {
            if (!Character.isWhitespace(buffer.charAt(k))) continue;
            buffer.setCharAt(k, ' ');
        }
        if (length < this.m_width) {
            switch (this.m_alignment) {
                case 0: {
                    buffer.append(s_space, 0, this.m_width - length);
                    break;
                }
                case 1: {
                    int charsLeft = (this.m_width - length + 1) / 2;
                    int charsRight = (this.m_width - length) / 2;
                    buffer.insert(0, s_space, 0, charsLeft);
                    buffer.append(s_space, 0, charsRight);
                    break;
                }
                case 2: {
                    buffer.insert(0, s_space, 0, this.m_width - length);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Invalid alignment: " + this.m_alignment));
                }
            }
        }
    }

    static {
        for (int i = 0; i < s_space.length; ++i) {
            FixedWidthFormatter.s_space[i] = 32;
        }
    }
}

