/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.plugin.http.tcpproxyfilter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.grinder.common.Logger;
import net.grinder.plugin.http.tcpproxyfilter.HTTPRecordingResultProcessor;
import net.grinder.plugin.http.xml.HttpRecordingDocument;
import net.grinder.util.FixedWidthFormatter;
import net.grinder.util.SimpleLogger;

public class ProcessHTTPRecordingWithXSLT
implements HTTPRecordingResultProcessor {
    public static final String STYLESHEET_NAME_PROPERTY = "transformHTTPRecordingToScript";
    private final TransformerFactory m_transformerFactory = TransformerFactory.newInstance();
    private final InputStream m_styleSheetInputStream;
    private final Logger m_logger;

    private ProcessHTTPRecordingWithXSLT(InputStream styleSheetInputStream, Logger logger) {
        this.m_styleSheetInputStream = styleSheetInputStream;
        this.m_logger = logger;
        this.m_transformerFactory.setErrorListener(new LoggingErrorListener());
    }

    public ProcessHTTPRecordingWithXSLT(Logger logger) {
        this(ProcessHTTPRecordingWithXSLT.class.getResourceAsStream("resources/httpToJythonScript.xsl"), logger);
    }

    public ProcessHTTPRecordingWithXSLT(StyleSheetInputStream styleSheetFile, Logger logger) {
        this(styleSheetFile.getInputStream(), logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(HttpRecordingDocument result) throws IOException {
        try {
            Transformer transformer = this.m_transformerFactory.newTransformer(new StreamSource(this.m_styleSheetInputStream));
            transformer.setErrorListener(this.m_transformerFactory.getErrorListener());
            PrintWriter outputWriter = this.m_logger.getOutputLogWriter();
            transformer.transform(new DOMSource(result.getDomNode()), new StreamResult(outputWriter));
            outputWriter.println();
        }
        catch (TransformerException transformerException) {
        }
        finally {
            this.m_styleSheetInputStream.close();
        }
    }

    public static void main(String[] arguments) throws Exception {
        HttpRecordingDocument recording = HttpRecordingDocument.Factory.parse((InputStream)ProcessHTTPRecordingWithXSLT.class.getResourceAsStream("resources/recording.xml"));
        ProcessHTTPRecordingWithXSLT processor = new ProcessHTTPRecordingWithXSLT(new SimpleLogger("test", new PrintWriter(System.out), new PrintWriter(System.err), new FixedWidthFormatter(0, 10, 80)));
        processor.process(recording);
    }

    public static final class StyleSheetInputStream {
        private final InputStream m_inputStream;

        public StyleSheetInputStream(File file) throws FileNotFoundException {
            this.m_inputStream = new FileInputStream(file);
        }

        InputStream getInputStream() {
            return this.m_inputStream;
        }
    }

    private final class LoggingErrorListener
    implements ErrorListener {
        private LoggingErrorListener() {
        }

        private void logTransformerException(TransformerException e) {
            StringBuffer message = new StringBuffer(e.getMessage());
            if (e.getLocationAsString() != null) {
                message.append(" at ").append(e.getLocationAsString());
            }
            ProcessHTTPRecordingWithXSLT.this.m_logger.error(message.toString());
        }

        public void warning(TransformerException e) throws TransformerException {
            this.logTransformerException(e);
        }

        public void error(TransformerException e) throws TransformerException {
            this.logTransformerException(e);
            throw e;
        }

        public void fatalError(TransformerException e) throws TransformerException {
            this.logTransformerException(e);
            throw e;
        }
    }
}

