/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.grinder.console.common.ConsoleException;
import net.grinder.console.common.Resources;
import net.grinder.console.model.ConsoleProperties;
import net.grinder.console.swingui.IntegerField;

class SamplingControlPanel
extends JPanel {
    private final JSlider m_intervalSlider = new JSlider(100, 10000, 100);
    private final IntegerField m_collectSampleField = new IntegerField(0, 999999);
    private final IntegerField m_ignoreSampleField = new IntegerField(0, 999999);
    private final String m_sampleIntervalString;
    private final String m_ignoreSampleString;
    private final String m_collectSampleZeroString;
    private final String m_collectSampleString;
    private final String m_msUnit;
    private final String m_msUnits;
    private final String m_sampleUnit;
    private final String m_sampleUnits;
    private ConsoleProperties m_properties = null;

    public SamplingControlPanel(Resources resources) {
        this.m_sampleIntervalString = resources.getString("sampleInterval.label") + " ";
        this.m_ignoreSampleString = resources.getString("ignoreCount.label") + " ";
        this.m_collectSampleZeroString = resources.getString("collectCountZero.label", false);
        this.m_collectSampleString = resources.getString("collectCount.label") + " ";
        this.m_msUnit = " " + resources.getString("ms.unit");
        this.m_msUnits = " " + resources.getString("ms.units");
        this.m_sampleUnit = " " + resources.getString("sample.unit");
        this.m_sampleUnits = " " + resources.getString("sample.units");
        this.m_intervalSlider.setMajorTickSpacing(1000);
        this.m_intervalSlider.setMinorTickSpacing(100);
        this.m_intervalSlider.setPaintTicks(true);
        this.m_intervalSlider.setSnapToTicks(true);
        final JLabel intervalLabel = new JLabel();
        this.m_intervalSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                int minimum = SamplingControlPanel.this.m_intervalSlider.getMinimum();
                int spacing = SamplingControlPanel.this.m_intervalSlider.getMinorTickSpacing();
                int value = (SamplingControlPanel.this.m_intervalSlider.getValue() - minimum) / spacing * spacing + minimum;
                SamplingControlPanel.this.setIntervalLabelText(intervalLabel, value);
                if (SamplingControlPanel.this.m_properties != null) {
                    try {
                        SamplingControlPanel.this.m_properties.setSampleInterval(value);
                    }
                    catch (ConsoleException e) {
                        throw new AssertionError((Object)e.getMessage());
                    }
                }
            }
        });
        final JLabel ignoreSampleLabel = new JLabel();
        this.m_ignoreSampleField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                int value = SamplingControlPanel.this.m_ignoreSampleField.getValue();
                SamplingControlPanel.this.setIgnoreSampleLabelText(ignoreSampleLabel, value);
                if (SamplingControlPanel.this.m_properties != null) {
                    try {
                        SamplingControlPanel.this.m_properties.setIgnoreSampleCount(value);
                    }
                    catch (ConsoleException e) {
                        throw new AssertionError((Object)e.getMessage());
                    }
                }
            }
        });
        final JLabel collectSampleLabel = new JLabel();
        this.m_collectSampleField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                int value = SamplingControlPanel.this.m_collectSampleField.getValue();
                SamplingControlPanel.this.setCollectSampleLabelText(collectSampleLabel, value);
                if (SamplingControlPanel.this.m_properties != null) {
                    try {
                        SamplingControlPanel.this.m_properties.setCollectSampleCount(value);
                    }
                    catch (ConsoleException e) {
                        throw new AssertionError((Object)e.getMessage());
                    }
                }
            }
        });
        JPanel textFieldLabelPanel = new JPanel(new GridLayout(0, 1, 0, 1));
        textFieldLabelPanel.add(ignoreSampleLabel);
        textFieldLabelPanel.add(collectSampleLabel);
        JPanel textFieldControlPanel = new JPanel(new GridLayout(0, 1, 0, 1));
        textFieldControlPanel.add(this.m_ignoreSampleField);
        textFieldControlPanel.add(this.m_collectSampleField);
        JPanel textFieldPanel = new JPanel(new BorderLayout());
        textFieldPanel.add((Component)textFieldLabelPanel, "West");
        textFieldPanel.add((Component)textFieldControlPanel, "East");
        this.setLayout(new BoxLayout(this, 1));
        intervalLabel.setAlignmentX(0.0f);
        this.m_intervalSlider.setAlignmentX(0.0f);
        textFieldPanel.setAlignmentX(0.0f);
        this.add(intervalLabel);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(this.m_intervalSlider);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(textFieldPanel);
    }

    public void setProperties(ConsoleProperties properties) {
        this.m_properties = null;
        this.m_intervalSlider.setValue(properties.getSampleInterval());
        this.m_ignoreSampleField.setValue(properties.getIgnoreSampleCount());
        this.m_collectSampleField.setValue(properties.getCollectSampleCount());
        this.m_properties = properties;
    }

    public void refresh() {
        this.setProperties(this.m_properties);
    }

    private void setIntervalLabelText(JLabel label, int sampleInterval) {
        label.setText(this.m_sampleIntervalString + sampleInterval + (sampleInterval == 1 ? this.m_msUnit : this.m_msUnits));
    }

    private void setIgnoreSampleLabelText(JLabel label, int ignoreSample) {
        label.setText(this.m_ignoreSampleString + ignoreSample + (ignoreSample == 1 ? this.m_sampleUnit : this.m_sampleUnits));
    }

    private void setCollectSampleLabelText(JLabel label, int collectSample) {
        if (collectSample == 0 && this.m_collectSampleZeroString != null) {
            label.setText(this.m_collectSampleZeroString);
        } else {
            label.setText(this.m_collectSampleString + collectSample + (collectSample == 1 ? this.m_sampleUnit : this.m_sampleUnits));
        }
    }
}

