/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Sysconf;
import jnr.posix.FileStat;
import jnr.posix.Group;
import jnr.posix.JavaFileStat;
import jnr.posix.JavaLibCHelper;
import jnr.posix.JavaTimes;
import jnr.posix.LibC;
import jnr.posix.POSIX;
import jnr.posix.POSIXHandler;
import jnr.posix.Passwd;
import jnr.posix.SpawnFileAction;
import jnr.posix.Times;
import jnr.posix.util.Java5ProcessMaker;
import jnr.posix.util.Platform;
import jnr.posix.util.ProcessMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JavaPOSIX
implements POSIX {
    private final POSIXHandler handler;
    private final JavaLibCHelper helper;

    JavaPOSIX(POSIXHandler handler) {
        this.handler = handler;
        this.helper = new JavaLibCHelper(handler);
    }

    @Override
    public final ProcessMaker newProcessMaker(String ... command) {
        return new Java5ProcessMaker(this.handler, command);
    }

    @Override
    public final ProcessMaker newProcessMaker() {
        return new Java5ProcessMaker(this.handler);
    }

    @Override
    public final FileStat allocateStat() {
        return new JavaFileStat(this, this.handler);
    }

    @Override
    public final int chmod(String filename, int mode) {
        return this.helper.chmod(filename, mode);
    }

    @Override
    public final int chown(String filename, int user, int group) {
        return this.helper.chown(filename, user, group);
    }

    @Override
    public final int exec(String path, String ... argv) {
        this.handler.unimplementedError("No exec in Java (yet)");
        return -1;
    }

    @Override
    public final int exec(String path, String[] argv, String[] envp) {
        this.handler.unimplementedError("No exec in Java (yet)");
        return -1;
    }

    @Override
    public final int execv(String path, String[] argv) {
        this.handler.unimplementedError("No execv in Java (yet)");
        return -1;
    }

    @Override
    public final int execve(String path, String[] argv, String[] envp) {
        this.handler.unimplementedError("No execve in Java (yet)");
        return -1;
    }

    @Override
    public final FileStat fstat(FileDescriptor descriptor) {
        this.handler.unimplementedError("fstat unimplemented");
        return null;
    }

    @Override
    public final FileStat fstat(int descriptor) {
        this.handler.unimplementedError("fstat unimplemented");
        return null;
    }

    @Override
    public final int fstat(int fd, FileStat stat) {
        this.handler.unimplementedError("fstat unimplemented");
        return -1;
    }

    @Override
    public final int fstat(FileDescriptor descriptor, FileStat stat) {
        this.handler.unimplementedError("fstat unimplemented");
        return -1;
    }

    @Override
    public final int getegid() {
        return LoginInfo.GID;
    }

    @Override
    public final int geteuid() {
        return LoginInfo.UID;
    }

    @Override
    public final int getgid() {
        return LoginInfo.GID;
    }

    @Override
    public final String getlogin() {
        return this.helper.getlogin();
    }

    @Override
    public final int getpgid() {
        return this.unimplementedInt("getpgid");
    }

    @Override
    public final int getpgrp() {
        return this.unimplementedInt("getpgrp");
    }

    @Override
    public final int getpid() {
        return this.helper.getpid();
    }

    @Override
    public final int getppid() {
        return this.unimplementedInt("getppid");
    }

    @Override
    public final Passwd getpwent() {
        return this.helper.getpwent();
    }

    @Override
    public final Passwd getpwuid(int which) {
        return this.helper.getpwuid(which);
    }

    @Override
    public final Group getgrgid(int which) {
        this.handler.unimplementedError("getgrgid unimplemented");
        return null;
    }

    @Override
    public final Passwd getpwnam(String which) {
        this.handler.unimplementedError("getpwnam unimplemented");
        return null;
    }

    @Override
    public final Group getgrnam(String which) {
        this.handler.unimplementedError("getgrnam unimplemented");
        return null;
    }

    @Override
    public final Group getgrent() {
        this.handler.unimplementedError("getgrent unimplemented");
        return null;
    }

    @Override
    public final int setpwent() {
        return this.helper.setpwent();
    }

    @Override
    public final int endpwent() {
        return this.helper.endpwent();
    }

    @Override
    public final int setgrent() {
        return this.unimplementedInt("setgrent");
    }

    @Override
    public final int endgrent() {
        return this.unimplementedInt("endgrent");
    }

    @Override
    public final String getenv(String envName) {
        return this.helper.getEnv().get(envName);
    }

    @Override
    public final int getuid() {
        return LoginInfo.UID;
    }

    @Override
    public final int fork() {
        return -1;
    }

    @Override
    public final boolean isatty(FileDescriptor fd) {
        return fd == FileDescriptor.in || fd == FileDescriptor.out || fd == FileDescriptor.err;
    }

    @Override
    public final int kill(int pid, int signal) {
        return this.unimplementedInt("kill");
    }

    @Override
    public final int lchmod(String filename, int mode) {
        return this.unimplementedInt("lchmod");
    }

    @Override
    public final int lchown(String filename, int user, int group) {
        return this.unimplementedInt("lchown");
    }

    @Override
    public final int link(String oldpath, String newpath) {
        return this.helper.link(oldpath, newpath);
    }

    @Override
    public final FileStat lstat(String path) {
        FileStat stat = this.allocateStat();
        if (this.lstat(path, stat) < 0) {
            this.handler.error(Errno.ENOENT, path);
        }
        return stat;
    }

    @Override
    public final int lstat(String path, FileStat stat) {
        return this.helper.lstat(path, stat);
    }

    @Override
    public final int mkdir(String path, int mode) {
        return this.helper.mkdir(path, mode);
    }

    @Override
    public final int rmdir(String path) {
        return this.helper.rmdir(path);
    }

    @Override
    public final String readlink(String path) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(256);
        int result = this.helper.readlink(path, buffer, buffer.capacity());
        if (result == -1) {
            return null;
        }
        buffer.position(0);
        buffer.limit(result);
        return Charset.forName("ASCII").decode(buffer).toString();
    }

    @Override
    public final int setenv(String envName, String envValue, int overwrite) {
        Map<String, String> env = this.helper.getEnv();
        if (envName.contains("=")) {
            this.handler.error(Errno.EINVAL, envName);
            return -1;
        }
        if (overwrite == 0 && env.containsKey(envName)) {
            return 0;
        }
        env.put(envName, envValue);
        return 0;
    }

    @Override
    public final FileStat stat(String path) {
        FileStat stat = this.allocateStat();
        if (this.helper.stat(path, stat) < 0) {
            this.handler.error(Errno.ENOENT, path);
        }
        return stat;
    }

    @Override
    public final int stat(String path, FileStat stat) {
        return this.helper.stat(path, stat);
    }

    @Override
    public final int symlink(String oldpath, String newpath) {
        return this.helper.symlink(oldpath, newpath);
    }

    @Override
    public final int setegid(int egid) {
        return this.unimplementedInt("setegid");
    }

    @Override
    public final int seteuid(int euid) {
        return this.unimplementedInt("seteuid");
    }

    @Override
    public final int setgid(int gid) {
        return this.unimplementedInt("setgid");
    }

    @Override
    public final int getpgid(int pid) {
        return this.unimplementedInt("getpgid");
    }

    @Override
    public final int setpgid(int pid, int pgid) {
        return this.unimplementedInt("setpgid");
    }

    @Override
    public final int setpgrp(int pid, int pgrp) {
        return this.unimplementedInt("setpgrp");
    }

    @Override
    public final int setsid() {
        return this.unimplementedInt("setsid");
    }

    @Override
    public final int setuid(int uid) {
        return this.unimplementedInt("setuid");
    }

    @Override
    public final int umask(int mask) {
        return 0;
    }

    @Override
    public final int unsetenv(String envName) {
        if (this.helper.getEnv().remove(envName) == null) {
            this.handler.error(Errno.EINVAL, envName);
            return -1;
        }
        return 0;
    }

    @Override
    public final int utimes(String path, long[] atimeval, long[] mtimeval) {
        long mtimeMillis;
        if (mtimeval != null) {
            assert (mtimeval.length == 2);
            mtimeMillis = mtimeval[0] * 1000L + mtimeval[1] / 1000L;
        } else {
            mtimeMillis = System.currentTimeMillis();
        }
        new File(path).setLastModified(mtimeMillis);
        return 0;
    }

    @Override
    public final int wait(int[] status) {
        return this.unimplementedInt("wait");
    }

    @Override
    public final int waitpid(int pid, int[] status, int flags) {
        return this.unimplementedInt("waitpid");
    }

    @Override
    public final int getpriority(int which, int who) {
        return this.unimplementedInt("getpriority");
    }

    @Override
    public final int setpriority(int which, int who, int prio) {
        return this.unimplementedInt("setpriority");
    }

    @Override
    public final long posix_spawnp(String path, Collection<? extends SpawnFileAction> fileActions, Collection<? extends CharSequence> argv, Collection<? extends CharSequence> envp) {
        return this.unimplementedInt("posix_spawnp");
    }

    @Override
    public final int errno() {
        return JavaLibCHelper.errno();
    }

    @Override
    public final void errno(int value) {
        JavaLibCHelper.errno(value);
    }

    @Override
    public final boolean isNative() {
        return false;
    }

    @Override
    public final LibC libc() {
        return null;
    }

    private int unimplementedInt(String message) {
        this.handler.unimplementedError(message);
        return -1;
    }

    @Override
    public final long sysconf(Sysconf name) {
        switch (name) {
            case _SC_CLK_TCK: {
                return 1000L;
            }
        }
        this.errno(Errno.EOPNOTSUPP.intValue());
        return -1L;
    }

    @Override
    public final Times times() {
        return new JavaTimes();
    }

    static final class FakePasswd
    implements Passwd {
        private FakePasswd() {
        }

        public final String getLoginName() {
            return LoginInfo.USERNAME;
        }

        public final String getPassword() {
            return "";
        }

        public final long getUID() {
            return LoginInfo.UID;
        }

        public final long getGID() {
            return LoginInfo.GID;
        }

        public final int getPasswdChangeTime() {
            return 0;
        }

        public final String getAccessClass() {
            return "";
        }

        public final String getGECOS() {
            return this.getLoginName();
        }

        public final String getHome() {
            return "/";
        }

        public final String getShell() {
            return "/bin/sh";
        }

        public final int getExpire() {
            return -1;
        }
    }

    static final class IDHelper {
        private static final String ID_CMD = Platform.IS_SOLARIS ? "/usr/xpg4/bin/id" : "/usr/bin/id";
        private static final int NOBODY = Platform.IS_WINDOWS ? 0 : Short.MAX_VALUE;

        private IDHelper() {
        }

        public static int getInt(String option) {
            try {
                Process p = Runtime.getRuntime().exec(new String[]{ID_CMD, option});
                BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
                return Integer.parseInt(r.readLine());
            }
            catch (IOException iOException) {
                return NOBODY;
            }
            catch (NumberFormatException numberFormatException) {
                return NOBODY;
            }
            catch (SecurityException securityException) {
                return NOBODY;
            }
        }

        public static String getString(String option) {
            try {
                Process p = Runtime.getRuntime().exec(new String[]{ID_CMD, option});
                BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
                return r.readLine();
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    static final class LoginInfo {
        public static final int UID = IDHelper.getInt("-u");
        public static final int GID = IDHelper.getInt("-g");
        public static final String USERNAME = IDHelper.getString("-un");

        LoginInfo() {
        }
    }
}

