/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Platform {
    private static final Locale LOCALE = Locale.ENGLISH;
    private final OS os;
    private final CPU cpu;
    private final int addressSize;
    private final int longSize;
    protected final Pattern libPattern;

    private static final OS determineOS() {
        String osName = System.getProperty("os.name").split(" ")[0];
        if (Platform.startsWithIgnoreCase(osName, "mac") || Platform.startsWithIgnoreCase(osName, "darwin")) {
            return OS.DARWIN;
        }
        if (Platform.startsWithIgnoreCase(osName, "linux")) {
            return OS.LINUX;
        }
        if (Platform.startsWithIgnoreCase(osName, "sunos") || Platform.startsWithIgnoreCase(osName, "solaris")) {
            return OS.SOLARIS;
        }
        if (Platform.startsWithIgnoreCase(osName, "aix")) {
            return OS.AIX;
        }
        if (Platform.startsWithIgnoreCase(osName, "openbsd")) {
            return OS.OPENBSD;
        }
        if (Platform.startsWithIgnoreCase(osName, "freebsd")) {
            return OS.FREEBSD;
        }
        if (Platform.startsWithIgnoreCase(osName, "windows")) {
            return OS.WINDOWS;
        }
        return OS.UNKNOWN;
    }

    private static final Platform determinePlatform(OS os2) {
        switch (os2) {
            case DARWIN: {
                return new Darwin();
            }
            case LINUX: {
                return new Linux();
            }
            case WINDOWS: {
                return new Windows();
            }
            case UNKNOWN: {
                return new Unsupported(os2);
            }
        }
        return new Default(os2);
    }

    private static final Platform determinePlatform() {
        String providerName = System.getProperty("jaffl.provider");
        try {
            Class<?> c = Class.forName(providerName + "$Platform");
            return (Platform)c.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Platform.determinePlatform(Platform.determineOS());
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionInInitializerError(ex);
        }
        catch (InstantiationException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    private static CPU determineCPU() {
        String archString = System.getProperty("os.arch");
        if (Platform.equalsIgnoreCase("x86", archString) || Platform.equalsIgnoreCase("i386", archString) || Platform.equalsIgnoreCase("i86pc", archString)) {
            return CPU.I386;
        }
        if (Platform.equalsIgnoreCase("x86_64", archString) || Platform.equalsIgnoreCase("amd64", archString)) {
            return CPU.X86_64;
        }
        if (Platform.equalsIgnoreCase("ppc", archString) || Platform.equalsIgnoreCase("powerpc", archString)) {
            return CPU.PPC;
        }
        if (Platform.equalsIgnoreCase("ppc64", archString) || Platform.equalsIgnoreCase("powerpc64", archString)) {
            return CPU.PPC64;
        }
        if (Platform.equalsIgnoreCase("s390", archString) || Platform.equalsIgnoreCase("s390x", archString)) {
            return CPU.S390X;
        }
        for (CPU cpu : CPU.values()) {
            if (!Platform.equalsIgnoreCase(cpu.name(), archString)) continue;
            return cpu;
        }
        return CPU.UNKNOWN;
    }

    public Platform(OS os2, CPU cpu, int addressSize, int longSize, String libPattern) {
        this.os = os2;
        this.cpu = cpu;
        this.addressSize = addressSize;
        this.longSize = longSize;
        this.libPattern = Pattern.compile(libPattern);
    }

    private Platform(OS os2) {
        String libpattern;
        this.os = os2;
        this.cpu = Platform.determineCPU();
        switch (os2) {
            case WINDOWS: {
                libpattern = ".*\\.dll$";
                break;
            }
            case DARWIN: {
                libpattern = "lib.*\\.(dylib|jnilib)$";
                break;
            }
            default: {
                libpattern = "lib.*\\.so.*$";
            }
        }
        this.libPattern = Pattern.compile(libpattern);
        this.addressSize = Platform.calculateAddressSize(this.cpu);
        this.longSize = os2 == OS.WINDOWS ? 32 : this.addressSize;
    }

    private static final int calculateAddressSize(CPU cpu) {
        int dataModel = Integer.getInteger("sun.arch.data.model");
        if (dataModel != 32 && dataModel != 64) {
            switch (cpu) {
                case I386: 
                case PPC: 
                case SPARC: {
                    dataModel = 32;
                    break;
                }
                case X86_64: 
                case PPC64: 
                case SPARCV9: 
                case S390X: {
                    dataModel = 64;
                    break;
                }
                default: {
                    throw new ExceptionInInitializerError("Cannot determine cpu address size");
                }
            }
        }
        return dataModel;
    }

    public static final Platform getNativePlatform() {
        return SingletonHolder.PLATFORM;
    }

    @Deprecated
    public static final Platform getPlatform() {
        return SingletonHolder.PLATFORM;
    }

    public final OS getOS() {
        return this.os;
    }

    public final CPU getCPU() {
        return this.cpu;
    }

    public final boolean isBSD() {
        block3: {
            block2: {
                if (this.os == OS.FREEBSD) break block2;
                if (this.os != OS.OPENBSD && this.os != OS.NETBSD && this.os != OS.DARWIN) break block3;
            }
            return true;
        }
        return false;
    }

    public final boolean isUnix() {
        return this.os != OS.WINDOWS;
    }

    public final int longSize() {
        return this.longSize;
    }

    public final int addressSize() {
        return this.addressSize;
    }

    public String getName() {
        return (Object)((Object)this.cpu) + "-" + (Object)((Object)this.os);
    }

    public String mapLibraryName(String libName) {
        if (this.libPattern.matcher(libName).find()) {
            return libName;
        }
        return System.mapLibraryName(libName);
    }

    public String locateLibrary(String libName, List<String> libraryPath) {
        String mappedName = this.mapLibraryName(libName);
        for (String path : libraryPath) {
            File libFile = new File(path, mappedName);
            if (!libFile.exists()) continue;
            return libFile.getAbsolutePath();
        }
        return mappedName;
    }

    private static boolean startsWithIgnoreCase(String s1, String s2) {
        return s1.startsWith(s2) || s1.toUpperCase(LOCALE).startsWith(s2.toUpperCase(LOCALE)) || s1.toLowerCase(LOCALE).startsWith(s2.toLowerCase(LOCALE));
    }

    private static boolean equalsIgnoreCase(String s1, String s2) {
        return s1.equalsIgnoreCase(s2) || s1.toUpperCase(LOCALE).equals(s2.toUpperCase(LOCALE)) || s1.toLowerCase(LOCALE).equals(s2.toLowerCase(LOCALE));
    }

    static /* synthetic */ Platform access$000() {
        return Platform.determinePlatform();
    }

    /* synthetic */ Platform(OS x0, byte by) {
        this(x0);
    }

    static class Windows
    extends Supported {
        public Windows() {
            super(OS.WINDOWS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Linux
    extends Supported {
        public Linux() {
            super(OS.LINUX);
        }

        @Override
        public final String locateLibrary(String libName, List<String> libraryPath) {
            FilenameFilter filter = new FilenameFilter(this, libName){
                private Pattern p;
                private String exact;
                private /* synthetic */ String val$libName;
                private /* synthetic */ Linux this$0;
                {
                    this.val$libName = string;
                    this.p = Pattern.compile("lib" + this.val$libName + "\\.so\\.[0-9]+$");
                    this.exact = "lib" + this.val$libName + ".so";
                }

                public boolean accept(File dir, String name) {
                    return this.p.matcher(name).matches() || this.exact.equals(name);
                }
            };
            LinkedList<File> matches = new LinkedList<File>();
            for (String path : libraryPath) {
                File[] files = new File(path).listFiles(filter);
                if (files == null || files.length <= 0) continue;
                matches.addAll(Arrays.asList(files));
            }
            String bestMatch = null;
            for (File file : matches) {
                String path = file.getAbsolutePath();
                if (bestMatch == null && path.endsWith(".so")) {
                    bestMatch = path;
                    continue;
                }
                String num = path.substring(path.lastIndexOf(".so.") + 4);
                try {
                    if (Integer.parseInt(num) < 0) continue;
                    bestMatch = path;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (bestMatch != null) {
                return bestMatch;
            }
            return this.mapLibraryName(libName);
        }

        @Override
        public final String mapLibraryName(String libName) {
            if ("c".equals(libName) || "libc.so".equals(libName)) {
                return "libc.so.6";
            }
            return super.mapLibraryName(libName);
        }
    }

    static final class Darwin
    extends Supported {
        public Darwin() {
            super(OS.DARWIN);
        }

        public final String mapLibraryName(String libName) {
            if (this.libPattern.matcher(libName).find()) {
                return libName;
            }
            return "lib" + libName + ".dylib";
        }

        public final String getName() {
            return "Darwin";
        }
    }

    static final class Default
    extends Supported {
        public Default(OS os2) {
            super(os2);
        }
    }

    static class Unsupported
    extends Platform {
        public Unsupported(OS os2) {
            super(os2, (byte)0);
        }
    }

    static class Supported
    extends Platform {
        public Supported(OS os2) {
            super(os2, (byte)0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CPU {
        I386,
        X86_64,
        PPC,
        PPC64,
        SPARC,
        SPARCV9,
        S390X,
        MIPS32,
        ARM,
        UNKNOWN;


        public final String toString() {
            return this.name().toLowerCase(LOCALE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS {
        DARWIN,
        FREEBSD,
        NETBSD,
        OPENBSD,
        LINUX,
        SOLARIS,
        WINDOWS,
        AIX,
        ZLINUX,
        UNKNOWN;


        public final String toString() {
            return this.name().toLowerCase(LOCALE);
        }
    }

    static final class SingletonHolder {
        static final Platform PLATFORM = Platform.access$000();

        private SingletonHolder() {
        }
    }
}

