/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PySlice;

public abstract class SequenceIndexDelegate
implements Serializable {
    public abstract int len();

    public abstract PyObject getItem(int var1);

    public abstract void setItem(int var1, PyObject var2);

    public abstract void delItem(int var1);

    public abstract PyObject getSlice(int var1, int var2, int var3);

    public abstract void setSlice(int var1, int var2, int var3, PyObject var4);

    public abstract void delItems(int var1, int var2);

    public abstract String getTypeName();

    public void checkIdxAndSetItem(PyObject idx, PyObject value) {
        if (idx.isIndex()) {
            this.checkIdxAndSetItem(idx.asIndex(Py.IndexError), value);
            return;
        }
        if (idx instanceof PySlice) {
            this.checkIdxAndSetSlice((PySlice)idx, value);
            return;
        }
        throw Py.TypeError(this.getTypeName() + " indices must be integers");
    }

    public void checkIdxAndSetSlice(PySlice slice2, PyObject value) {
        int[] indices = slice2.indicesEx(this.len());
        if (slice2.step != Py.None && value.__len__() != indices[3]) {
            throw Py.ValueError(String.format("attempt to assign sequence of size %d to extended slice of size %d", value.__len__(), indices[3]));
        }
        this.setSlice(indices[0], indices[1], indices[2], value);
    }

    public void checkIdxAndSetItem(int idx, PyObject value) {
        this.setItem(this.checkIdx(idx), value);
    }

    public void checkIdxAndDelItem(PyObject idx) {
        if (idx.isIndex()) {
            this.delItem(this.checkIdx(idx.asIndex(Py.IndexError)));
            return;
        }
        if (idx instanceof PySlice) {
            PySlice slice2 = (PySlice)idx;
            this.delSlice(slice2.indicesEx(this.len()));
            return;
        }
        throw Py.TypeError(this.getTypeName() + " indices must be integers");
    }

    public PyObject checkIdxAndGetItem(PyObject idx) {
        PyObject res = this.checkIdxAndFindItem(idx);
        if (res == null) {
            throw Py.IndexError("index out of range: " + idx);
        }
        return res;
    }

    public PyObject checkIdxAndFindItem(PyObject idx) {
        if (idx.isIndex()) {
            return this.checkIdxAndFindItem(idx.asIndex(Py.IndexError));
        }
        if (idx instanceof PySlice) {
            return this.getSlice((PySlice)idx);
        }
        throw Py.TypeError(this.getTypeName() + " indices must be integers");
    }

    public PyObject getSlice(PySlice slice2) {
        int[] indices = slice2.indicesEx(this.len());
        return this.getSlice(indices[0], indices[1], indices[2]);
    }

    public PyObject checkIdxAndFindItem(int idx) {
        if ((idx = this.fixindex(idx)) == -1) {
            return null;
        }
        return this.getItem(idx);
    }

    private int checkIdx(int idx) {
        int i = this.fixindex(idx);
        if (i == -1) {
            throw Py.IndexError(this.getTypeName() + " assignment index out of range");
        }
        return i;
    }

    final int fixindex(int index) {
        int l = this.len();
        if (index < 0) {
            index += l;
        }
        if (index < 0 || index >= l) {
            return -1;
        }
        return index;
    }

    private void delSlice(int[] indices) {
        int p = indices[0];
        int step = indices[2];
        int count2 = indices[3];
        if (step > 1) {
            --step;
            while (count2 > 0) {
                this.delItem(p);
                --count2;
                p += step;
            }
        } else if (step <= 0) {
            while (count2 > 0) {
                this.delItem(p);
                --count2;
                p += step;
            }
        } else if (count2 > 0) {
            this.delItems(p, p + count2);
        }
    }
}

