/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.grinder.common.Closer;
import net.grinder.util.StreamCopier;

public final class Directory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final FileFilter s_matchAllFilesFilter = new MatchAllFilesFilter();
    private final File m_directory;
    private final List m_warnings = new ArrayList();

    public static FileFilter getMatchAllFilesFilter() {
        return s_matchAllFilesFilter;
    }

    public Directory() {
        this.m_directory = new File(".");
    }

    public Directory(File directory) throws DirectoryException {
        if (directory == null) {
            this.m_directory = new File(".");
        } else {
            if (directory.exists() && !directory.isDirectory()) {
                throw new DirectoryException("'" + directory.getPath() + "' is not a directory");
            }
            this.m_directory = directory;
        }
    }

    public void create() throws DirectoryException {
        if (!this.getFile().exists() && !this.getFile().mkdirs()) {
            throw new DirectoryException("Could not create directory '" + this.getFile() + "'");
        }
    }

    public File getFile() {
        return this.m_directory;
    }

    public File getFile(File child) {
        if (child == null) {
            return this.getFile();
        }
        return new File(this.getFile(), child.getPath());
    }

    public File[] listContents(FileFilter filter) {
        return this.listContents(filter, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] listContents(FileFilter filter, boolean includeDirectories, boolean absolutePaths) {
        ArrayList<File> resultList = new ArrayList<File>();
        HashSet<File> visited = new HashSet<File>();
        ArrayList<File> directoriesToVisit = new ArrayList<File>();
        File rootFile = this.getFile();
        if (rootFile.exists() && filter.accept(rootFile)) {
            directoriesToVisit.add(null);
            if (includeDirectories) {
                resultList.add(absolutePaths ? rootFile : new File(""));
            }
        }
        while (directoriesToVisit.size() > 0) {
            File[] directories = directoriesToVisit.toArray(new File[directoriesToVisit.size()]);
            directoriesToVisit.clear();
            for (int i = 0; i < directories.length; ++i) {
                File relativeDirectory = directories[i];
                File absoluteDirectory = this.getFile(relativeDirectory);
                visited.add(relativeDirectory);
                String[] children = absoluteDirectory.list();
                if (children == null) {
                    List list = this.m_warnings;
                    synchronized (list) {
                        this.m_warnings.add("Could not list '" + absoluteDirectory);
                        continue;
                    }
                }
                for (int j = 0; j < children.length; ++j) {
                    File relativeChild = new File(relativeDirectory, children[j]);
                    File absoluteChild = new File(absoluteDirectory, children[j]);
                    if (!filter.accept(absoluteChild)) continue;
                    if (includeDirectories && absoluteChild.isDirectory() || absoluteChild.isFile()) {
                        resultList.add(absolutePaths ? absoluteChild : relativeChild);
                    }
                    if (!absoluteChild.isDirectory() || visited.contains(relativeChild)) continue;
                    directoriesToVisit.add(relativeChild);
                }
            }
        }
        return resultList.toArray(new File[resultList.size()]);
    }

    public void deleteContents() throws DirectoryException {
        File[] deleteList = this.listContents(s_matchAllFilesFilter, true, true);
        for (int i = deleteList.length - 1; i >= 0; --i) {
            if (deleteList[i].equals(this.getFile()) || deleteList[i].delete()) continue;
            throw new DirectoryException("Could not delete '" + deleteList[i] + "'");
        }
    }

    public void delete() throws DirectoryException {
        if (!this.getFile().delete()) {
            throw new DirectoryException("Could not delete '" + this.getFile() + "'");
        }
    }

    public File getRelativePath(File file) {
        return Directory.getRelative(this.getFile(), file, null);
    }

    private static File getRelative(File parent, File child, File result) {
        File immediateParent = child.getParentFile();
        File nextResult = result == null ? new File(child.getName()) : new File(child.getName(), result.getPath());
        if (parent.equals(immediateParent)) {
            return nextResult;
        }
        if (immediateParent == null) {
            if (child.isAbsolute()) {
                return null;
            }
            return nextResult;
        }
        return Directory.getRelative(parent, immediateParent, nextResult);
    }

    public boolean isParentOf(File file) {
        File thisFile = this.getFile();
        for (File candidate = file.getParentFile(); candidate != null; candidate = candidate.getParentFile()) {
            if (!thisFile.equals(candidate)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(Directory target, boolean incremental) throws IOException {
        if (!this.getFile().exists()) {
            throw new DirectoryException("Source directory '" + this.getFile() + "' does not exist");
        }
        target.create();
        if (!incremental) {
            target.deleteContents();
        }
        File[] files = this.listContents(s_matchAllFilesFilter, true, false);
        StreamCopier streamCopier = new StreamCopier(4096, false);
        for (int i = 0; i < files.length; ++i) {
            File source = this.getFile(files[i]);
            File destination = target.getFile(files[i]);
            if (source.isDirectory()) {
                destination.mkdirs();
                continue;
            }
            if (incremental && destination.exists() && source.lastModified() <= destination.lastModified()) continue;
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(source);
                out = new FileOutputStream(destination);
                streamCopier.copy(in, out);
            }
            catch (Throwable throwable) {
                Closer.close(in);
                Closer.close(out);
                throw throwable;
            }
            Closer.close(in);
            Closer.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getWarnings() {
        List list = this.m_warnings;
        synchronized (list) {
            String[] stringArray;
            try {
                stringArray = this.m_warnings.toArray(new String[this.m_warnings.size()]);
                this.m_warnings.clear();
            }
            catch (Throwable throwable) {
                this.m_warnings.clear();
                throw throwable;
            }
            return stringArray;
        }
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != Directory.class) {
            return false;
        }
        return this.getFile().equals(((Directory)o).getFile());
    }

    private static class MatchAllFilesFilter
    implements FileFilter {
        private MatchAllFilesFilter() {
        }

        public boolean accept(File file) {
            return true;
        }
    }

    public static final class DirectoryException
    extends IOException {
        DirectoryException(String message) {
            super(message);
        }
    }
}

