/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process.jython;

import net.grinder.engine.process.ScriptEngine;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyException;
import org.python.core.PyTraceback;

final class JythonScriptExecutionException
extends ScriptEngine.ScriptExecutionException {
    private final String m_message;
    private final String m_shortMessage;

    public JythonScriptExecutionException(String message) {
        super(message);
        this.m_message = message;
        this.m_shortMessage = message;
    }

    public JythonScriptExecutionException(String doingWhat, PyException e) {
        super("");
        this.setStackTrace(new StackTraceElement[0]);
        Object javaError = e.value.__tojava__(Throwable.class);
        if (javaError == null || javaError == Py.NoConversion) {
            StringBuffer pyExceptionMessage = new StringBuffer();
            if (e.type instanceof PyClass) {
                pyExceptionMessage.append(((PyClass)e.type).__name__);
            } else {
                pyExceptionMessage.append(e.type.__str__());
            }
            if (e.value != Py.None) {
                pyExceptionMessage.append(": ");
                pyExceptionMessage.append(e.value.__str__());
            }
            this.m_shortMessage = "Jython exception: " + pyExceptionMessage + " [" + doingWhat + "]";
            this.m_message = JythonScriptExecutionException.tracebackToMessage(pyExceptionMessage.toString(), e.traceback);
            this.initCause(null);
        } else {
            this.m_shortMessage = "Java exception " + doingWhat;
            this.m_message = JythonScriptExecutionException.tracebackToMessage(this.m_shortMessage, e.traceback);
            this.initCause((Throwable)javaError);
        }
    }

    public String getShortMessage() {
        return this.m_shortMessage;
    }

    public String getMessage() {
        return this.m_message;
    }

    public String toString() {
        return this.getLocalizedMessage();
    }

    private static String tracebackToMessage(String prefix, PyTraceback traceback) {
        StringBuffer result = new StringBuffer(prefix);
        String[] frames = traceback.dumpStack().split("\n");
        for (int i = frames.length - 1; i >= 1; --i) {
            result.append(System.getProperty("line.separator"));
            result.append("\t");
            result.append(frames[i].trim());
        }
        return result.toString();
    }
}

