/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.common;

import java.io.File;
import java.io.Serializable;
import net.grinder.util.Directory;

public final class ScriptLocation
implements Serializable {
    private static final long serialVersionUID = 771173195260716872L;
    private final Directory m_directory;
    private final File m_shortFile;
    private final File m_absoluteFile;

    public ScriptLocation(Directory directory, File file) {
        this.m_directory = directory;
        File relativeFile = directory.getRelativePath(file);
        this.m_shortFile = relativeFile != null ? relativeFile : file;
        this.m_absoluteFile = file.isAbsolute() ? file : directory.getFile(file);
    }

    public ScriptLocation(File file) throws Directory.DirectoryException {
        this(new Directory(file.getAbsoluteFile().getParentFile()), new File(file.getName()));
    }

    public Directory getDirectory() {
        return this.m_directory;
    }

    public File getFile() {
        return this.m_absoluteFile;
    }

    public String toString() {
        return this.m_shortFile.getPath();
    }

    public int hashCode() {
        return this.getDirectory().hashCode() ^ this.getFile().hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != ScriptLocation.class) {
            return false;
        }
        ScriptLocation otherScriptLocation = (ScriptLocation)other;
        return this.getDirectory().equals(otherScriptLocation.getDirectory()) && this.getFile().equals(otherScriptLocation.getFile());
    }
}

