/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

final class CompositeTreeModel
implements TreeModel {
    private final List m_wrappers = new ArrayList();
    private final EventListenerList m_listeners = new EventListenerList();
    private final Object m_rootNode = new Object();

    CompositeTreeModel() {
    }

    void addTreeModel(TreeModel treeModel, boolean includeRoot) {
        DelegateWrapper wrapper = includeRoot ? new RootWrapper(treeModel) : new FirstLevelWrapper(treeModel);
        EventListener[] eventListeners = this.m_listeners.getListeners(TreeModelListener.class);
        for (int i = 0; i < eventListeners.length; ++i) {
            wrapper.addTreeModelListener((TreeModelListener)eventListeners[i]);
        }
        this.m_wrappers.add(wrapper);
    }

    public Object getRoot() {
        return this.m_rootNode;
    }

    public Object getChild(Object parent, int index) {
        if (index < 0) {
            return null;
        }
        if (parent.equals(this.getRoot())) {
            int base = 0;
            Iterator iterator = this.m_wrappers.iterator();
            while (iterator.hasNext()) {
                DelegateWrapper wrapper = (DelegateWrapper)iterator.next();
                int numberOfTopLevelNodes = wrapper.getNumberOfTopLevelNodes();
                if (index - base < numberOfTopLevelNodes) {
                    return wrapper.getTopLevelNode(index - base);
                }
                base += numberOfTopLevelNodes;
            }
        } else {
            Iterator iterator = this.m_wrappers.iterator();
            while (iterator.hasNext()) {
                DelegateWrapper wrapper = (DelegateWrapper)iterator.next();
                Object delegateAnswer = wrapper.getChild(parent, index);
                if (delegateAnswer == null) continue;
                return delegateAnswer;
            }
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent.equals(this.getRoot())) {
            int answer = 0;
            Iterator iterator = this.m_wrappers.iterator();
            while (iterator.hasNext()) {
                DelegateWrapper wrapper = (DelegateWrapper)iterator.next();
                answer += wrapper.getNumberOfTopLevelNodes();
            }
            return answer;
        }
        Iterator iterator = this.m_wrappers.iterator();
        while (iterator.hasNext()) {
            DelegateWrapper wrapper = (DelegateWrapper)iterator.next();
            int delegateAnswer = wrapper.getChildCount(parent);
            if (delegateAnswer == 0) continue;
            return delegateAnswer;
        }
        return 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        if (parent.equals(this.getRoot())) {
            int base = 0;
            Iterator iterator = this.m_wrappers.iterator();
            while (iterator.hasNext()) {
                DelegateWrapper wrapper = (DelegateWrapper)iterator.next();
                int delegateAnswer = wrapper.getIndexOfTopLevelNode(child);
                if (delegateAnswer != -1) {
                    return base + delegateAnswer;
                }
                base += wrapper.getNumberOfTopLevelNodes();
            }
        } else {
            Iterator iterator = this.m_wrappers.iterator();
            while (iterator.hasNext()) {
                DelegateWrapper wrapper = (DelegateWrapper)iterator.next();
                int delegateAnswer = wrapper.getIndexOfChild(parent, child);
                if (delegateAnswer == -1) continue;
                return delegateAnswer;
            }
        }
        return -1;
    }

    public boolean isLeaf(Object node) {
        Iterator iterator = this.m_wrappers.iterator();
        while (iterator.hasNext()) {
            DelegateWrapper wrapper = (DelegateWrapper)iterator.next();
            if (!wrapper.isLeaf(node)) continue;
            return true;
        }
        return false;
    }

    public void addTreeModelListener(TreeModelListener listener) {
        this.m_listeners.add(TreeModelListener.class, listener);
        Iterator iterator = this.m_wrappers.iterator();
        while (iterator.hasNext()) {
            DelegateWrapper wrapper = (DelegateWrapper)iterator.next();
            wrapper.addTreeModelListener(listener);
        }
    }

    public void removeTreeModelListener(TreeModelListener listener) {
        this.m_listeners.remove(TreeModelListener.class, listener);
        Iterator iterator = this.m_wrappers.iterator();
        while (iterator.hasNext()) {
            DelegateWrapper wrapper = (DelegateWrapper)iterator.next();
            wrapper.removeTreeModelListener(listener);
        }
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    private final class FirstLevelWrapper
    extends DelegateWrapper {
        public FirstLevelWrapper(TreeModel model) {
            super(model);
        }

        public Object getTopLevelNode(int i) {
            return super.getChild(this.getModel().getRoot(), i);
        }

        public int getNumberOfTopLevelNodes() {
            return super.getChildCount(this.getModel().getRoot());
        }

        public int getIndexOfTopLevelNode(Object node) {
            return super.getIndexOfChild(this.getModel().getRoot(), node);
        }

        protected TreeModelEvent mapTreeModelEvent(TreeModelEvent e) {
            Object[] path = e.getPath();
            if (path.length > 0) {
                path[0] = CompositeTreeModel.this.getRoot();
            }
            return new TreeModelEvent((Object)this, path, e.getChildIndices(), e.getChildren());
        }
    }

    private final class RootWrapper
    extends DelegateWrapper {
        public RootWrapper(TreeModel model) {
            super(model);
        }

        public Object getTopLevelNode(int i) {
            return i == 0 ? this.getModel().getRoot() : null;
        }

        public int getNumberOfTopLevelNodes() {
            return 1;
        }

        public int getIndexOfTopLevelNode(Object node) {
            return node.equals(this.getModel().getRoot()) ? 0 : -1;
        }

        protected TreeModelEvent mapTreeModelEvent(TreeModelEvent e) {
            Object[] path = e.getPath();
            if (path.length > 0 && path[0].equals(CompositeTreeModel.this.getRoot())) {
                return e;
            }
            Object[] newPath = new Object[path.length + 1];
            System.arraycopy(path, 0, newPath, 1, path.length);
            newPath[0] = CompositeTreeModel.this.getRoot();
            return new TreeModelEvent((Object)this, newPath, e.getChildIndices(), e.getChildren());
        }
    }

    private static abstract class DelegateWrapper {
        private final TreeModel m_model;
        private final Map m_delegateListenerMap = new HashMap();

        protected DelegateWrapper(TreeModel model) {
            this.m_model = model;
        }

        public abstract Object getTopLevelNode(int var1);

        public abstract int getNumberOfTopLevelNodes();

        public abstract int getIndexOfTopLevelNode(Object var1);

        public final TreeModel getModel() {
            return this.m_model;
        }

        public final Object getChild(Object parent, int index) {
            try {
                return this.getModel().getChild(parent, index);
            }
            catch (ClassCastException e) {
                return null;
            }
        }

        public int getChildCount(Object parent) {
            try {
                return this.getModel().getChildCount(parent);
            }
            catch (ClassCastException e) {
                return 0;
            }
        }

        public int getIndexOfChild(Object parent, Object child) {
            try {
                return this.getModel().getIndexOfChild(parent, child);
            }
            catch (ClassCastException e) {
                return -1;
            }
        }

        public final boolean isLeaf(Object node) {
            try {
                return this.getModel().isLeaf(node);
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        protected abstract TreeModelEvent mapTreeModelEvent(TreeModelEvent var1);

        public void addTreeModelListener(TreeModelListener listener) {
            TreeModelListener delegateListener = new TreeModelListener(this, listener){
                private final /* synthetic */ TreeModelListener val$listener;
                private final /* synthetic */ DelegateWrapper this$0;
                {
                    this.this$0 = this$0;
                    this.val$listener = val$listener;
                }

                public void treeNodesChanged(TreeModelEvent e) {
                    this.val$listener.treeNodesChanged(this.this$0.mapTreeModelEvent(e));
                }

                public void treeNodesInserted(TreeModelEvent e) {
                    this.val$listener.treeNodesInserted(this.this$0.mapTreeModelEvent(e));
                }

                public void treeNodesRemoved(TreeModelEvent e) {
                    this.val$listener.treeNodesRemoved(this.this$0.mapTreeModelEvent(e));
                }

                public void treeStructureChanged(TreeModelEvent e) {
                    this.val$listener.treeStructureChanged(this.this$0.mapTreeModelEvent(e));
                }
            };
            this.m_delegateListenerMap.put(listener, delegateListener);
            this.getModel().addTreeModelListener(delegateListener);
        }

        public void removeTreeModelListener(TreeModelListener listener) {
            TreeModelListener delegateListener = (TreeModelListener)this.m_delegateListenerMap.remove(listener);
            if (delegateListener != null) {
                this.getModel().removeTreeModelListener(delegateListener);
            }
        }
    }
}

