/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import net.grinder.communication.CommunicationException;
import net.grinder.communication.Message;
import net.grinder.communication.Receiver;
import net.grinder.communication.Sender;
import net.grinder.util.thread.InterruptibleRunnable;
import net.grinder.util.thread.ThreadPool;

public final class MessagePump {
    private final ThreadPool m_threadPool;
    private final Receiver m_receiver;
    private final Sender m_sender;
    private boolean m_shutdownTriggered = false;

    public MessagePump(Receiver receiver, Sender sender, int numberOfThreads) {
        this.m_receiver = receiver;
        this.m_sender = sender;
        ThreadPool.InterruptibleRunnableFactory runnableFactory = new ThreadPool.InterruptibleRunnableFactory(){

            public InterruptibleRunnable create() {
                return new MessagePumpRunnable();
            }
        };
        this.m_threadPool = new ThreadPool("Message pump", numberOfThreads, runnableFactory);
        this.m_threadPool.start();
    }

    public void shutdown() {
        if (!this.m_shutdownTriggered) {
            this.m_shutdownTriggered = true;
            this.m_receiver.shutdown();
            this.m_sender.shutdown();
            this.m_threadPool.stopAndWait();
        }
    }

    private class MessagePumpRunnable
    implements InterruptibleRunnable {
        private MessagePumpRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void interruptibleRun() {
            try {
                while (!MessagePump.this.m_threadPool.isStopped()) {
                    Message message = MessagePump.this.m_receiver.waitForMessage();
                    if (message == null) {
                        MessagePump.this.shutdown();
                        continue;
                    }
                    MessagePump.this.m_sender.send(message);
                }
            }
            catch (CommunicationException communicationException) {
            }
            finally {
                MessagePump.this.shutdown();
            }
        }
    }
}

