/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.grinder.communication.BlockingSender;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.Message;
import net.grinder.communication.MessageDispatchRegistry;
import net.grinder.communication.MessageRequiringResponse;
import net.grinder.communication.NoResponseMessage;
import net.grinder.communication.Sender;
import net.grinder.util.ListenerSupport;

public final class MessageDispatchSender
implements Sender,
MessageDispatchRegistry {
    private final Map m_handlers = Collections.synchronizedMap(new HashMap());
    private final Map m_responders = Collections.synchronizedMap(new HashMap());
    private final ListenerSupport m_fallbackHandlers = new ListenerSupport();

    public Sender set(Class messageType, Sender messageHandler) {
        return this.m_handlers.put(messageType, messageHandler);
    }

    public BlockingSender set(Class messageType, BlockingSender messageResponder) {
        return this.m_responders.put(messageType, messageResponder);
    }

    public void addFallback(Sender messageHandler) {
        this.m_fallbackHandlers.add(messageHandler);
    }

    public void send(final Message message) throws CommunicationException {
        MessageRequiringResponse messageRequringResponse;
        if (message instanceof MessageRequiringResponse) {
            MessageRequiringResponse messageRequringResponse2 = (MessageRequiringResponse)message;
            Message requestMessage = messageRequringResponse2.getMessage();
            BlockingSender responder = (BlockingSender)this.m_responders.get(requestMessage.getClass());
            if (responder != null) {
                messageRequringResponse2.sendResponse(responder.blockingSend(requestMessage));
                return;
            }
        } else {
            Sender handler = (Sender)this.m_handlers.get(message.getClass());
            if (handler != null) {
                handler.send(message);
                return;
            }
        }
        final CommunicationException[] exception = new CommunicationException[1];
        this.m_fallbackHandlers.apply(new ListenerSupport.Informer(){

            public void inform(Object listener) {
                try {
                    ((Sender)listener).send(message);
                }
                catch (CommunicationException e) {
                    exception[0] = e;
                }
            }
        });
        if (message instanceof MessageRequiringResponse && !(messageRequringResponse = (MessageRequiringResponse)message).isResponseSent()) {
            messageRequringResponse.sendResponse(new NoResponseMessage());
        }
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        BlockingSender[] responders;
        Sender[] handlers;
        Map map = this.m_handlers;
        synchronized (map) {
            handlers = this.m_handlers.values().toArray(new Sender[this.m_handlers.size()]);
        }
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i].shutdown();
        }
        Map map2 = this.m_responders;
        synchronized (map2) {
            responders = this.m_responders.values().toArray(new BlockingSender[this.m_responders.size()]);
        }
        for (int i = 0; i < responders.length; ++i) {
            responders[i].shutdown();
        }
        this.m_fallbackHandlers.apply(new ListenerSupport.Informer(){

            public void inform(Object listener) {
                ((Sender)listener).shutdown();
            }
        });
    }
}

