/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jnr.ffi.Platform;
import jnr.netdb.NetDBEntry;
import jnr.netdb.NetDBParser;
import jnr.netdb.Protocol;
import jnr.netdb.ProtocolsDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileProtocolsDB
implements ProtocolsDB {
    private final File protocolsFile;

    public static final FileProtocolsDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private FileProtocolsDB(File protocolsFile) {
        this.protocolsFile = protocolsFile;
    }

    private static final File locateProtocolsFile() {
        if (Platform.getNativePlatform().getOS().equals((Object)Platform.OS.WINDOWS)) {
            String systemRoot;
            try {
                systemRoot = System.getProperty("SystemRoot", "C:\\windows");
            }
            catch (SecurityException securityException) {
                systemRoot = "C:\\windows";
            }
            return new File(systemRoot + "\\system32\\drivers\\etc\\protocol");
        }
        return new File("/etc/protocols");
    }

    private static FileProtocolsDB load() {
        try {
            File protocolsFile = FileProtocolsDB.locateProtocolsFile();
            NetDBParser parser = new NetDBParser(new FileReader(protocolsFile));
            try {
                parser.iterator().next();
            }
            finally {
                parser.close();
            }
            return new FileProtocolsDB(protocolsFile);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public Protocol getProtocolByName(String name) {
        return this.parse(new Filter(this, name){
            private /* synthetic */ String val$name;
            private /* synthetic */ FileProtocolsDB this$0;
            {
                this.val$name = string;
            }

            public boolean filter(Protocol p) {
                if (p.getName().equals(this.val$name)) {
                    return true;
                }
                for (String alias2 : p.getAliases()) {
                    if (!alias2.equals(this.val$name)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public Protocol getProtocolByNumber(Integer proto) {
        return this.parse(new Filter(this, proto){
            private /* synthetic */ Integer val$proto;
            private /* synthetic */ FileProtocolsDB this$0;
            {
                this.val$proto = n;
            }

            public boolean filter(Protocol p) {
                return p.getProto() == this.val$proto.intValue();
            }
        });
    }

    @Override
    public Collection<Protocol> getAllProtocols() {
        LinkedList allProtocols = new LinkedList();
        this.parse(new Filter(this, allProtocols){
            private /* synthetic */ List val$allProtocols;
            private /* synthetic */ FileProtocolsDB this$0;
            {
                this.val$allProtocols = list;
            }

            public boolean filter(Protocol s) {
                this.val$allProtocols.add(s);
                return false;
            }
        });
        return Collections.unmodifiableList(allProtocols);
    }

    private final NetDBParser loadProtocolsFile() {
        try {
            return new NetDBParser(new FileReader(this.protocolsFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new NetDBParser(new StringReader(""));
        }
    }

    private final Protocol parse(Filter filter) {
        NetDBParser parser = this.loadProtocolsFile();
        try {
            for (NetDBEntry e : parser) {
                try {
                    Protocol p = new Protocol(e.name, Integer.parseInt(e.data, 10), e.aliases);
                    if (!filter.filter(p)) continue;
                    Protocol protocol = p;
                    return protocol;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        finally {
            try {
                parser.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    static /* synthetic */ FileProtocolsDB access$000() {
        return FileProtocolsDB.load();
    }

    static interface Filter {
        public boolean filter(Protocol var1);
    }

    static final class SingletonHolder {
        public static final FileProtocolsDB INSTANCE = FileProtocolsDB.access$000();

        private SingletonHolder() {
        }
    }
}

