/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import java.io.PrintWriter;
import net.grinder.common.Test;
import net.grinder.statistics.ExpressionView;
import net.grinder.statistics.StatisticExpression;
import net.grinder.statistics.StatisticsSet;

class ThreadDataWriter {
    private final PrintWriter m_out;
    private final ExpressionView[] m_expressionViews;
    private final StringBuffer m_buffer = new StringBuffer();
    private final int m_bufferAfterThreadIDIndex;
    private int m_bufferAfterRunNumberIndex = -1;
    private int m_lastRunNumber = -1;

    public ThreadDataWriter(PrintWriter dataFilePrintWriter, ExpressionView[] expressionViews, int threadID) {
        this.m_out = dataFilePrintWriter;
        this.m_expressionViews = expressionViews;
        this.m_buffer.append(threadID);
        this.m_buffer.append(", ");
        this.m_bufferAfterThreadIDIndex = this.m_buffer.length();
    }

    public void report(int runNumber, Test test, long timeSinceExecutionStart, StatisticsSet statistics) {
        if (runNumber == this.m_lastRunNumber && this.m_lastRunNumber != -1) {
            this.m_buffer.setLength(this.m_bufferAfterRunNumberIndex);
        } else {
            this.m_lastRunNumber = runNumber;
            this.m_buffer.setLength(this.m_bufferAfterThreadIDIndex);
            this.m_buffer.append(runNumber);
            this.m_buffer.append(", ");
            this.m_bufferAfterRunNumberIndex = this.m_buffer.length();
        }
        this.m_buffer.append(test.getNumber());
        this.m_buffer.append(", ");
        this.m_buffer.append(timeSinceExecutionStart);
        for (int i = 0; i < this.m_expressionViews.length; ++i) {
            this.m_buffer.append(", ");
            StatisticExpression expression = this.m_expressionViews[i].getExpression();
            if (expression.isDouble()) {
                this.m_buffer.append(expression.getDoubleValue(statistics));
                continue;
            }
            this.m_buffer.append(expression.getLongValue(statistics));
        }
        this.m_out.println(this.m_buffer);
    }
}

