/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.Function;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicInteger;
import org.python.modules.jffi.AsmClassBuilder;
import org.python.modules.jffi.DefaultInvokerFactory;
import org.python.modules.jffi.FastIntMethodGenerator;
import org.python.modules.jffi.FastLongMethodGenerator;
import org.python.modules.jffi.FastNumericMethodGenerator;
import org.python.modules.jffi.Invoker;
import org.python.modules.jffi.JITCompiler;
import org.python.modules.jffi.JITMethodGenerator;
import org.python.modules.jffi.JITSignature;
import org.python.modules.jffi.NativeDataConverter;
import org.python.modules.jffi.NativeType;

final class JITHandle {
    private static final int THRESHOLD = Integer.getInteger("jython.ctypes.compile.threshold", 100);
    private final JITSignature jitSignature;
    private volatile boolean compilationFailed = false;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final JITCompiler compiler;
    private WeakReference<Class<? extends Invoker>> compiledClassRef = null;

    JITHandle(JITCompiler compiler, JITSignature signature, boolean compilationFailed) {
        this.compiler = compiler;
        this.jitSignature = signature;
        this.compilationFailed = compilationFailed;
    }

    final boolean compilationFailed() {
        return this.compilationFailed;
    }

    final Invoker compile(Function function, NativeDataConverter resultConverter, NativeDataConverter[] parameterConverters) {
        Class compiledClass;
        if (this.compilationFailed || this.counter.incrementAndGet() < THRESHOLD) {
            return null;
        }
        JITHandle jITHandle = this;
        synchronized (jITHandle) {
            if (this.compiledClassRef == null || (compiledClass = (Class)this.compiledClassRef.get()) == null) {
                JITSignature jITSignature = this.jitSignature;
                JITMethodGenerator jITMethodGenerator = null;
                JITMethodGenerator[] jITMethodGeneratorArray = new JITMethodGenerator[]{new FastIntMethodGenerator(), new FastLongMethodGenerator(), new FastNumericMethodGenerator()};
                for (int i = 0; i < 3; ++i) {
                    if (!jITMethodGeneratorArray[i].isSupported(jITSignature)) continue;
                    jITMethodGenerator = jITMethodGeneratorArray[i];
                    break;
                }
                if ((compiledClass = jITMethodGenerator == null ? null : new AsmClassBuilder(jITMethodGenerator, jITSignature).build()) == null) {
                    this.compilationFailed = true;
                    return null;
                }
                this.compiler.registerClass(this, compiledClass);
                this.compiledClassRef = new WeakReference<Class>(compiledClass);
            }
        }
        try {
            Constructor cons = compiledClass.getDeclaredConstructor(Function.class, NativeDataConverter.class, NativeDataConverter[].class, Invoker.class);
            return (Invoker)cons.newInstance(function, null, parameterConverters, JITHandle.createFallbackInvoker(function, this.jitSignature));
        }
        catch (Throwable throwable) {
            Throwable t = throwable;
            throwable.printStackTrace();
            return null;
        }
    }

    private static Class<? extends Invoker> newInvokerClass(JITSignature jitSignature) {
        JITMethodGenerator generator = null;
        JITMethodGenerator[] generators = new JITMethodGenerator[]{new FastIntMethodGenerator(), new FastLongMethodGenerator(), new FastNumericMethodGenerator()};
        for (int i = 0; i < 3; ++i) {
            if (!generators[i].isSupported(jitSignature)) continue;
            generator = generators[i];
            break;
        }
        if (generator == null) {
            return null;
        }
        return new AsmClassBuilder(generator, jitSignature).build();
    }

    private static Invoker createFallbackInvoker(Function function, JITSignature signature) {
        NativeType[] parameterTypes = new NativeType[signature.getParameterCount()];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = signature.getParameterType(i);
        }
        NativeType nativeType = signature.getResultType();
        NativeType[] nativeTypeArray = parameterTypes;
        Function function2 = function;
        DefaultInvokerFactory defaultInvokerFactory = DefaultInvokerFactory.getFactory();
        DefaultInvokerFactory.ParameterMarshaller[] parameterMarshallerArray = new DefaultInvokerFactory.ParameterMarshaller[nativeTypeArray.length];
        for (int i = 0; i < parameterMarshallerArray.length; ++i) {
            parameterMarshallerArray[i] = DefaultInvokerFactory.getMarshaller(nativeTypeArray[i]);
        }
        return DefaultInvokerFactory.createInvoker(function2, nativeType, parameterMarshallerArray);
    }
}

