/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.python.indexer.Def;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.Util;
import org.python.indexer.ast.NAssign;
import org.python.indexer.ast.NBlock;
import org.python.indexer.ast.NBody;
import org.python.indexer.ast.NList;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NStr;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;

public final class NModule
extends NNode {
    public String name;
    public NBody body;
    private String file;
    private String md5;

    public NModule() {
    }

    public NModule(NBlock body, int start, int end) {
        super(start, end);
        this.body = new NBody(body);
        this.addChildren(this.body);
    }

    public final void setFile(String file) throws Exception {
        this.file = file;
        this.name = Util.moduleNameFor(file);
        this.md5 = Util.getMD5(new File(file));
    }

    public final void setFile(File path) throws Exception {
        this.file = path.getCanonicalPath();
        this.name = Util.moduleNameFor(this.file);
        this.md5 = Util.getMD5(path);
    }

    public final void setFileAndMD5(String path, String md5) throws Exception {
        this.file = path;
        this.name = Util.moduleNameFor(this.file);
        this.md5 = md5;
    }

    @Override
    public final String getFile() {
        return this.file;
    }

    public final String getMD5() {
        return this.md5;
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        NBinding mb = Indexer.idx.moduleTable.lookupLocal(this.file);
        if (mb == null) {
            Indexer.idx.reportFailedAssertion("No module for " + this.name + ": " + this.file);
            this.setType(new NModuleType(this.name, this.file, s));
        } else {
            this.setType(mb.getType());
        }
        NModule.resolveExpr(this.body, this.getTable());
        this.resolveExportedNames();
        return this.getType();
    }

    private void resolveExportedNames() throws Exception {
        NModuleType mtype = null;
        NType thisType = this.getType();
        Object object = thisType;
        if (thisType instanceof NModuleType) {
            object = thisType;
            mtype = (NModuleType)object;
        } else {
            object = thisType;
            if (object instanceof NUnionType) {
                object = thisType;
                for (NType u : ((NUnionType)object).getTypes()) {
                    object = u;
                    if (!(u instanceof NModuleType)) continue;
                    object = u;
                    mtype = (NModuleType)object;
                    break;
                }
            }
        }
        if (mtype == null) {
            object = this;
            Indexer.idx.reportFailedAssertion("Found non-module type for " + this + " in " + ((NModule)object).file + ": " + thisType);
            return;
        }
        Scope table = mtype.getTable();
        for (NStr nstr : this.getExportedNameNodes()) {
            String name = nstr.n.toString();
            NBinding b = table.lookupLocal(name);
            if (b == null) continue;
            Indexer.idx.putLocation(nstr, b);
        }
    }

    public final List<NStr> getExportedNameNodes() throws Exception {
        ArrayList<NStr> exports = new ArrayList<NStr>();
        NType nType = this.getType();
        if (!(nType instanceof NModuleType)) {
            return exports;
        }
        NBinding all = this.getTable().lookupLocal("__all__");
        if (all == null) {
            return exports;
        }
        Def def = all.getSignatureNode();
        if (def == null) {
            return exports;
        }
        NNode __all__ = this.getDeepestNodeAtOffset(def.start());
        if (!(__all__ instanceof NName)) {
            return exports;
        }
        NNode assign = __all__.getParent();
        if (!(assign instanceof NAssign)) {
            return exports;
        }
        NNode rvalue = ((NAssign)assign).rvalue;
        if (!(rvalue instanceof NList)) {
            return exports;
        }
        for (NNode elt : ((NList)rvalue).elts) {
            if (!(elt instanceof NStr)) continue;
            NStr nstr = (NStr)elt;
            if (nstr.n == null) continue;
            exports.add(nstr);
        }
        return exports;
    }

    public final String toString() {
        NModule nModule = this;
        return "<Module:" + nModule.file + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NModule.visitNode(this.body, v);
        }
    }
}

