/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jnr.netdb.NetDBEntry;
import jnr.netdb.NetDBParser;
import jnr.netdb.Service;
import jnr.netdb.ServicesDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FileServicesDB
implements ServicesDB {
    public static String fileName = "/etc/services";

    FileServicesDB() {
    }

    public static final ServicesDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static final ServicesDB load() {
        try {
            NetDBParser parser = FileServicesDB.parseServicesFile();
            try {
                parser.iterator().next();
            }
            finally {
                parser.close();
            }
            return new FileServicesDB();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static NetDBParser parseServicesFile() {
        try {
            return new NetDBParser(new FileReader(new File(fileName)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new NetDBParser(new StringReader(""));
        }
    }

    private static final Service parseServicesEntry(NetDBEntry e) {
        int port;
        String[] portproto = e.data.split("/");
        if (portproto.length < 2) {
            return null;
        }
        try {
            port = Integer.parseInt(portproto[0], 10);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new Service(e.name, port, portproto[1], e.aliases);
    }

    private final Service parse(Filter filter) {
        NetDBParser parser = FileServicesDB.parseServicesFile();
        try {
            for (NetDBEntry e : parser) {
                Service s = FileServicesDB.parseServicesEntry(e);
                if (s == null || !filter.filter(s)) continue;
                Service service = s;
                return service;
            }
        }
        finally {
            try {
                parser.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    @Override
    public final Service getServiceByName(String name, String proto) {
        return this.parse(new Filter(this, proto, name){
            private /* synthetic */ String val$proto;
            private /* synthetic */ String val$name;
            private /* synthetic */ FileServicesDB this$0;
            {
                this.val$proto = string;
                this.val$name = string2;
            }

            public boolean filter(Service s) {
                if (!s.proto.equals(this.val$proto) && this.val$proto != null) {
                    return false;
                }
                if (s.getName().equals(this.val$name)) {
                    return true;
                }
                for (String alias2 : s.getAliases()) {
                    if (!alias2.equals(this.val$name)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public final Service getServiceByPort(Integer port, String proto) {
        return this.parse(new Filter(this, port, proto){
            private /* synthetic */ Integer val$port;
            private /* synthetic */ String val$proto;
            private /* synthetic */ FileServicesDB this$0;
            {
                this.val$port = n;
                this.val$proto = string;
            }

            public boolean filter(Service s) {
                return s.getPort() == this.val$port.intValue() && (s.proto.equals(this.val$proto) || this.val$proto == null);
            }
        });
    }

    @Override
    public final Collection<Service> getAllServices() {
        LinkedList allServices = new LinkedList();
        this.parse(new Filter(this, allServices){
            private /* synthetic */ List val$allServices;
            private /* synthetic */ FileServicesDB this$0;
            {
                this.val$allServices = list;
            }

            public boolean filter(Service s) {
                this.val$allServices.add(s);
                return false;
            }
        });
        return Collections.unmodifiableList(allServices);
    }

    static /* synthetic */ ServicesDB access$000() {
        return FileServicesDB.load();
    }

    static interface Filter {
        public boolean filter(Service var1);
    }

    static final class SingletonHolder {
        public static final ServicesDB INSTANCE = FileServicesDB.access$000();

        private SingletonHolder() {
        }
    }
}

