/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider;

import java.lang.annotation.Annotation;
import jnr.ffi.annotations.Direct;
import jnr.ffi.annotations.In;
import jnr.ffi.annotations.NulTerminate;
import jnr.ffi.annotations.Out;
import jnr.ffi.annotations.Pinned;
import jnr.ffi.annotations.Transient;

public final class ParameterFlags {
    public static final int OUT = 1;
    public static final int IN = 2;
    public static final int PINNED = 4;
    public static final int NULTERMINATE = 8;
    public static final int TRANSIENT = 16;
    public static final int DIRECT = 32;

    private ParameterFlags() {
    }

    public static final int parse(Annotation[] annotations) {
        int flags = 0;
        Annotation[] arr$ = annotations;
        int len$ = annotations.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation a = arr$[i$];
            flags |= a instanceof Out ? 1 : 0;
            flags |= a instanceof In ? 2 : 0;
            flags |= a instanceof Transient ? 16 : 0;
            flags |= a instanceof Direct ? 32 : 0;
            flags |= a instanceof Pinned ? 4 : 0;
            flags |= a instanceof NulTerminate ? 8 : 0;
        }
        return flags;
    }

    public static final boolean isFlag(Annotation annotation) {
        return annotation instanceof Pinned || annotation instanceof Transient || annotation instanceof Direct || annotation instanceof NulTerminate || annotation instanceof Out || annotation instanceof In;
    }

    public static final boolean isPinned(int flags) {
        return (flags & 4) != 0;
    }

    public static final boolean isTransient(int flags) {
        return (flags & 0x10) != 0;
    }

    public static final boolean isDirect(int flags) {
        return (flags & 0x20) != 0;
    }

    public static final boolean isNulTerminate(int flags) {
        return (flags & 8) != 0;
    }

    public static final boolean isOut(int flags) {
        return (flags & 3) != 2;
    }

    public static final boolean isIn(int flags) {
        return (flags & 3) != 1;
    }
}

