/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Address
extends Number
implements Comparable<Address> {
    private static final Address NULL = new Address(0L);
    private final long address;

    private Address(long address) {
        this.address = address;
    }

    public Address(Address address) {
        this.address = address.address;
    }

    public final long address() {
        return this.address;
    }

    @Override
    public final int intValue() {
        return (int)this.address;
    }

    @Override
    public final long longValue() {
        return this.address;
    }

    @Override
    public final float floatValue() {
        return this.address;
    }

    @Override
    public final double doubleValue() {
        return this.address;
    }

    public final long nativeAddress() {
        return this.address;
    }

    public final int hashCode() {
        return (int)(this.address ^ this.address >>> 32);
    }

    public final boolean equals(Object obj) {
        return obj instanceof Address && this.address == ((Address)obj).address || obj == null && this.address == 0L;
    }

    public final String toString() {
        return Long.toString(this.address, 10);
    }

    public final String toHexString() {
        return Long.toString(this.address, 16);
    }

    @Override
    public final int compareTo(Address other) {
        if (this.address < other.address) {
            return -1;
        }
        if (this.address > other.address) {
            return 1;
        }
        return 0;
    }

    public final boolean isNull() {
        return this.address == 0L;
    }

    public static Address valueOf(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new Address(address);
    }

    public static Address valueOf(int address) {
        if (address == 0) {
            return NULL;
        }
        return new Address((long)address & 0xFFFFFFFFL);
    }
}

