/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util.thread;

import net.grinder.common.UncheckedInterruptedException;
import net.grinder.util.thread.InterruptibleRunnable;
import net.grinder.util.thread.InterruptibleRunnableAdapter;

public final class ThreadPool {
    private final ThreadGroup m_threadGroup;
    private final Thread[] m_threads;
    private boolean m_started = false;
    private boolean m_stopped = false;

    public ThreadPool(String name, int numberOfThreads, InterruptibleRunnableFactory runnableFactory) {
        this.m_threadGroup = new ThreadGroup(name);
        this.m_threadGroup.setDaemon(true);
        this.m_threads = new Thread[numberOfThreads];
        for (int i = 0; i < this.m_threads.length; ++i) {
            InterruptibleRunnableAdapter runnable = new InterruptibleRunnableAdapter(runnableFactory.create());
            this.m_threads[i] = new Thread(this.m_threadGroup, runnable, name + " thread " + i);
            this.m_threads[i].setDaemon(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (this.m_stopped) {
                throw new IllegalStateException("Stopped");
            }
            if (this.m_started) {
                throw new IllegalStateException("Already started");
            }
            this.m_started = true;
        }
        for (int i = 0; i < this.m_threads.length; ++i) {
            this.m_threads[i].start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.m_stopped = true;
        }
        this.m_threadGroup.interrupt();
    }

    public void stopAndWait() {
        this.stop();
        InterruptedException interrupted = null;
        for (int i = 0; i < this.m_threads.length; ++i) {
            while (this.m_threads[i] != Thread.currentThread() && this.m_threads[i].isAlive()) {
                try {
                    this.m_threads[i].join();
                }
                catch (InterruptedException e) {
                    interrupted = e;
                }
            }
        }
        if (interrupted != null) {
            throw new UncheckedInterruptedException(interrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopped() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            return this.m_stopped;
        }
    }

    public ThreadGroup getThreadGroup() {
        return this.m_threadGroup;
    }

    public static interface InterruptibleRunnableFactory {
        public InterruptibleRunnable create();
    }
}

