/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.statistics;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class StatisticsIndexMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map m_doubleMap = new HashMap();
    private final Map m_longMap = new HashMap();
    private final Map m_doubleSampleMap = new HashMap();
    private final Map m_longSampleMap = new HashMap();
    private final int m_numberOfDoubles;
    private final int m_numberOfLongs;
    public static final String HTTP_PLUGIN_RESPONSE_STATUS_KEY = "httpplugin.responseStatus";
    public static final String HTTP_PLUGIN_RESPONSE_LENGTH_KEY = "httpplugin.responseLength";
    public static final String HTTP_PLUGIN_RESPONSE_ERRORS_KEY = "httpplugin.responseErrors";
    public static final String HTTP_PLUGIN_DNS_TIME_KEY = "httpplugin.dnsTime";
    public static final String HTTP_PLUGIN_CONNECT_TIME_KEY = "httpplugin.connectTime";
    public static final String HTTP_PLUGIN_FIRST_BYTE_TIME_KEY = "httpplugin.firstByteTime";

    StatisticsIndexMap() {
        int nextLongIndex = 0;
        int nextDoubleIndex = 0;
        this.m_longMap.put("errors", new LongIndex(nextLongIndex++));
        this.m_longMap.put("untimedTests", new LongIndex(nextLongIndex++));
        this.m_longMap.put("period", new LongIndex(nextLongIndex++));
        this.m_longMap.put(HTTP_PLUGIN_RESPONSE_STATUS_KEY, new LongIndex(nextLongIndex++));
        this.m_longMap.put(HTTP_PLUGIN_RESPONSE_LENGTH_KEY, new LongIndex(nextLongIndex++));
        this.m_longMap.put(HTTP_PLUGIN_RESPONSE_ERRORS_KEY, new LongIndex(nextLongIndex++));
        this.m_longMap.put(HTTP_PLUGIN_DNS_TIME_KEY, new LongIndex(nextLongIndex++));
        this.m_longMap.put(HTTP_PLUGIN_CONNECT_TIME_KEY, new LongIndex(nextLongIndex++));
        this.m_longMap.put(HTTP_PLUGIN_FIRST_BYTE_TIME_KEY, new LongIndex(nextLongIndex++));
        this.m_longMap.put("userLong0", new LongIndex(nextLongIndex++));
        this.m_longMap.put("userLong1", new LongIndex(nextLongIndex++));
        this.m_longMap.put("userLong2", new LongIndex(nextLongIndex++));
        this.m_longMap.put("userLong3", new LongIndex(nextLongIndex++));
        this.m_longMap.put("userLong4", new LongIndex(nextLongIndex++));
        this.m_doubleMap.put("peakTPS", new DoubleIndex(nextDoubleIndex++));
        this.m_doubleMap.put("userDouble0", new DoubleIndex(nextDoubleIndex++));
        this.m_doubleMap.put("userDouble1", new DoubleIndex(nextDoubleIndex++));
        this.m_doubleMap.put("userDouble2", new DoubleIndex(nextDoubleIndex++));
        this.m_doubleMap.put("userDouble3", new DoubleIndex(nextDoubleIndex++));
        this.m_doubleMap.put("userDouble4", new DoubleIndex(nextDoubleIndex++));
        this.createLongSampleIndex("timedTests", new LongIndex(nextLongIndex++), new LongIndex(nextLongIndex++), new DoubleIndex(nextDoubleIndex++));
        this.m_numberOfDoubles = nextDoubleIndex;
        this.m_numberOfLongs = nextLongIndex;
    }

    int getNumberOfDoubles() {
        return this.m_numberOfDoubles;
    }

    int getNumberOfLongs() {
        return this.m_numberOfLongs;
    }

    Collection getDoubleSampleIndicies() {
        return this.m_doubleSampleMap.values();
    }

    Collection getLongSampleIndicies() {
        return this.m_longSampleMap.values();
    }

    public DoubleIndex getDoubleIndex(String statisticName) {
        return (DoubleIndex)this.m_doubleMap.get(statisticName);
    }

    public LongIndex getLongIndex(String statisticName) {
        return (LongIndex)this.m_longMap.get(statisticName);
    }

    public DoubleSampleIndex getDoubleSampleIndex(String statisticName) {
        return (DoubleSampleIndex)this.m_doubleSampleMap.get(statisticName);
    }

    public LongSampleIndex getLongSampleIndex(String statisticName) {
        return (LongSampleIndex)this.m_longSampleMap.get(statisticName);
    }

    private LongSampleIndex createLongSampleIndex(String statisticName, LongIndex sumIndex, LongIndex countIndex, DoubleIndex varianceIndex) {
        LongSampleIndex result = new LongSampleIndex(sumIndex, countIndex, varianceIndex);
        this.m_longSampleMap.put(statisticName, result);
        return result;
    }

    DoubleSampleIndex createDoubleSampleIndex(String statisticName, DoubleIndex sumIndex, LongIndex countIndex, DoubleIndex varianceIndex) {
        DoubleSampleIndex result = new DoubleSampleIndex(sumIndex, countIndex, varianceIndex);
        this.m_doubleSampleMap.put(statisticName, result);
        return result;
    }

    void removeDoubleSampleIndex(String statisticName) {
        this.m_doubleSampleMap.remove(statisticName);
    }

    public static final class LongSampleIndex
    extends SampleIndex {
        private final LongIndex m_sumIndex;

        private LongSampleIndex(LongIndex sumIndex, LongIndex countIndex, DoubleIndex varianceIndex) {
            super(countIndex, varianceIndex);
            this.m_sumIndex = sumIndex;
        }

        LongIndex getSumIndex() {
            return this.m_sumIndex;
        }
    }

    public static final class DoubleSampleIndex
    extends SampleIndex {
        private final DoubleIndex m_sumIndex;

        private DoubleSampleIndex(DoubleIndex sumIndex, LongIndex countIndex, DoubleIndex varianceIndex) {
            super(countIndex, varianceIndex);
            this.m_sumIndex = sumIndex;
        }

        DoubleIndex getSumIndex() {
            return this.m_sumIndex;
        }
    }

    static class SampleIndex {
        private final LongIndex m_countIndex;
        private final DoubleIndex m_varianceIndex;

        protected SampleIndex(LongIndex countIndex, DoubleIndex varianceIndex) {
            this.m_countIndex = countIndex;
            this.m_varianceIndex = varianceIndex;
        }

        final LongIndex getCountIndex() {
            return this.m_countIndex;
        }

        final DoubleIndex getVarianceIndex() {
            return this.m_varianceIndex;
        }
    }

    public static final class LongIndex
    extends AbstractSimpleIndex {
        private LongIndex(int i) {
            super(i);
        }
    }

    public static final class DoubleIndex
    extends AbstractSimpleIndex {
        private DoubleIndex(int i) {
            super(i);
        }
    }

    static abstract class AbstractSimpleIndex {
        private final int m_value;

        protected AbstractSimpleIndex(int i) {
            this.m_value = i;
        }

        public final int getValue() {
            return this.m_value;
        }
    }
}

