/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import net.grinder.common.FilenameFactory;
import net.grinder.common.GrinderException;
import net.grinder.common.GrinderProperties;
import net.grinder.common.Logger;
import net.grinder.common.processidentity.WorkerIdentity;
import net.grinder.engine.process.ShutdownException;
import net.grinder.engine.process.ThreadContext;
import net.grinder.engine.process.ThreadContextLocator;
import net.grinder.engine.process.ThreadStarter;
import net.grinder.engine.process.ThreadStopper;
import net.grinder.script.InternalScriptContext;
import net.grinder.script.InvalidContextException;
import net.grinder.script.SSLControl;
import net.grinder.script.Statistics;
import net.grinder.script.TestRegistry;
import net.grinder.util.Sleeper;

final class ScriptContextImplementation
implements InternalScriptContext {
    private final WorkerIdentity m_workerIdentity;
    private final WorkerIdentity m_firstWorkerIdentity;
    private final ThreadContextLocator m_threadContextLocator;
    private final GrinderProperties m_properties;
    private final Logger m_logger;
    private final FilenameFactory m_filenameFactory;
    private final Sleeper m_sleeper;
    private final SSLControl m_sslControl;
    private final Statistics m_scriptStatistics;
    private final TestRegistry m_testRegistry;
    private final ThreadStarter m_threadStarter;
    private final ThreadStopper m_threadStopper;

    public ScriptContextImplementation(WorkerIdentity workerIdentity, WorkerIdentity firstWorkerIdentity, ThreadContextLocator threadContextLocator, GrinderProperties properties, Logger logger, FilenameFactory filenameFactory, Sleeper sleeper, SSLControl sslControl, Statistics scriptStatistics, TestRegistry testRegistry, ThreadStarter threadStarter, ThreadStopper threadStopper) {
        this.m_workerIdentity = workerIdentity;
        this.m_firstWorkerIdentity = firstWorkerIdentity;
        this.m_threadContextLocator = threadContextLocator;
        this.m_properties = properties;
        this.m_logger = logger;
        this.m_filenameFactory = filenameFactory;
        this.m_sleeper = sleeper;
        this.m_sslControl = sslControl;
        this.m_scriptStatistics = scriptStatistics;
        this.m_testRegistry = testRegistry;
        this.m_threadStarter = threadStarter;
        this.m_threadStopper = threadStopper;
    }

    public int getAgentNumber() {
        return this.m_workerIdentity.getAgentIdentity().getNumber();
    }

    public String getProcessName() {
        return this.m_workerIdentity.getName();
    }

    public int getProcessNumber() {
        return this.m_workerIdentity.getNumber();
    }

    public int getFirstProcessNumber() {
        return this.m_firstWorkerIdentity.getNumber();
    }

    public int getThreadNumber() {
        ThreadContext threadContext = this.m_threadContextLocator.get();
        if (threadContext != null) {
            return threadContext.getThreadNumber();
        }
        return -1;
    }

    public int getRunNumber() {
        ThreadContext threadContext = this.m_threadContextLocator.get();
        if (threadContext != null) {
            return threadContext.getRunNumber();
        }
        return -1;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public void sleep(long meanTime) throws GrinderException {
        this.m_sleeper.sleepNormal(meanTime);
    }

    public void sleep(long meanTime, long sigma) throws GrinderException {
        this.m_sleeper.sleepNormal(meanTime, sigma);
    }

    public int startWorkerThread() throws GrinderException {
        return this.m_threadStarter.startThread(null);
    }

    public int startWorkerThread(Object testRunner) throws GrinderException {
        return this.m_threadStarter.startThread(testRunner);
    }

    public void stopThisWorkerThread() throws InvalidContextException {
        if (this.m_threadContextLocator.get() != null) {
            throw new ShutdownException("Thread has been shut down");
        }
        throw new InvalidContextException("stopThisWorkerThread() must be called from  a worker thread");
    }

    public boolean stopWorkerThread(int threadNumber) {
        return this.m_threadStopper.stopThread(threadNumber);
    }

    public FilenameFactory getFilenameFactory() {
        return this.m_filenameFactory;
    }

    public GrinderProperties getProperties() {
        return this.m_properties;
    }

    public Statistics getStatistics() {
        return this.m_scriptStatistics;
    }

    public SSLControl getSSLControl() {
        return this.m_sslControl;
    }

    public TestRegistry getTestRegistry() {
        return this.m_testRegistry;
    }
}

