/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.communication;

import java.util.Timer;
import net.grinder.common.GrinderProperties;
import net.grinder.common.processidentity.AgentIdentity;
import net.grinder.communication.Message;
import net.grinder.communication.MessageDispatchRegistry;
import net.grinder.console.communication.ConsoleCommunication;
import net.grinder.console.communication.ProcessControl;
import net.grinder.console.communication.ProcessStatusImplementation;
import net.grinder.messages.agent.ResetGrinderMessage;
import net.grinder.messages.agent.StartGrinderMessage;
import net.grinder.messages.agent.StopGrinderMessage;
import net.grinder.messages.console.AgentAddress;
import net.grinder.messages.console.AgentProcessReportMessage;
import net.grinder.messages.console.WorkerProcessReportMessage;
import net.grinder.util.AllocateLowestNumber;
import net.grinder.util.AllocateLowestNumberImplementation;

public class ProcessControlImplementation
implements ProcessControl {
    private final ConsoleCommunication m_consoleCommunication;
    private final ProcessStatusImplementation m_processStatusSet;
    private final AllocateLowestNumber m_agentNumberMap = new AllocateLowestNumberImplementation();

    public ProcessControlImplementation(Timer timer, ConsoleCommunication consoleCommunication) {
        this.m_consoleCommunication = consoleCommunication;
        this.m_processStatusSet = new ProcessStatusImplementation(timer, this.m_agentNumberMap);
        MessageDispatchRegistry messageDispatchRegistry = consoleCommunication.getMessageDispatchRegistry();
        messageDispatchRegistry.set(AgentProcessReportMessage.class, new MessageDispatchRegistry.AbstractHandler(){

            public void send(Message message) {
                ProcessControlImplementation.this.m_processStatusSet.addAgentStatusReport((AgentProcessReportMessage)message);
            }
        });
        messageDispatchRegistry.set(WorkerProcessReportMessage.class, new MessageDispatchRegistry.AbstractHandler(){

            public void send(Message message) {
                ProcessControlImplementation.this.m_processStatusSet.addWorkerStatusReport((WorkerProcessReportMessage)message);
            }
        });
    }

    public void startWorkerProcesses(GrinderProperties properties) {
        final GrinderProperties propertiesToSend = properties != null ? properties : new GrinderProperties();
        this.m_agentNumberMap.forEach(new AllocateLowestNumber.IteratorCallback(){

            public void objectAndNumber(Object object, int number) {
                ProcessControlImplementation.this.m_consoleCommunication.sendToAddressedAgents(new AgentAddress((AgentIdentity)object), new StartGrinderMessage(propertiesToSend, number));
            }
        });
    }

    public void resetWorkerProcesses() {
        this.m_consoleCommunication.sendToAgents(new ResetGrinderMessage());
    }

    public void stopAgentAndWorkerProcesses() {
        this.m_consoleCommunication.sendToAgents(new StopGrinderMessage());
    }

    public void addProcessStatusListener(ProcessControl.Listener listener) {
        this.m_processStatusSet.addListener(listener);
    }

    public int getNumberOfLiveAgents() {
        return this.m_processStatusSet.getNumberOfLiveAgents();
    }
}

