/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.communication.Address;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.ConnectionType;

public final class Connector {
    private final String m_hostString;
    private final int m_port;
    private final ConnectionType m_connectionType;

    public Connector(String hostString, int port, ConnectionType connectionType) {
        this.m_hostString = hostString;
        this.m_port = port;
        this.m_connectionType = connectionType;
    }

    Socket connect() throws CommunicationException {
        return this.connect(null);
    }

    Socket connect(Address address) throws CommunicationException {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(this.m_hostString);
        }
        catch (UnknownHostException e) {
            throw new CommunicationException("Could not resolve host '" + this.m_hostString + '\'', e);
        }
        try {
            Socket socket = new Socket(inetAddress, this.m_port);
            OutputStream outputStream = socket.getOutputStream();
            this.m_connectionType.write(outputStream);
            ObjectOutputStream objectStream = new ObjectOutputStream(outputStream);
            objectStream.writeObject(address);
            objectStream.flush();
            return socket;
        }
        catch (IOException e) {
            UncheckedInterruptedException.ioException(e);
            throw new CommunicationException("Failed to connect to '" + inetAddress + ':' + this.m_port + '\'', e);
        }
    }

    public int hashCode() {
        return this.m_hostString.hashCode() ^ this.m_port ^ this.m_connectionType.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != Connector.class) {
            return false;
        }
        Connector other = (Connector)o;
        return this.m_port == other.m_port && this.m_connectionType.equals(other.m_connectionType) && this.m_hostString.equals(other.m_hostString);
    }

    public String getEndpointAsString() {
        String host;
        try {
            host = InetAddress.getByName(this.m_hostString).toString();
        }
        catch (UnknownHostException e) {
            host = this.m_hostString;
        }
        return host + ":" + this.m_port;
    }

    static ConnectDetails read(InputStream in) throws CommunicationException {
        ConnectionType type = ConnectionType.read(in);
        try {
            Address address = (Address)new ObjectInputStream(in).readObject();
            return new ConnectDetails(type, address);
        }
        catch (IOException e) {
            throw new CommunicationException("Could not read address details", e);
        }
        catch (ClassNotFoundException e) {
            throw new CommunicationException("Could not read address details", e);
        }
    }

    static final class ConnectDetails {
        private final ConnectionType m_connectionType;
        private final Address m_address;

        private ConnectDetails(ConnectionType connectionType, Address address) {
            this.m_connectionType = connectionType;
            this.m_address = address;
        }

        public ConnectionType getConnectionType() {
            return this.m_connectionType;
        }

        public Address getAddress() {
            return this.m_address;
        }
    }
}

