/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.thread;

import org.python.core.ContextManager;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.ThreadState;

public class PyLock
extends PyObject
implements ContextManager {
    private boolean locked = false;

    public boolean acquire() {
        return this.acquire(true);
    }

    public synchronized boolean acquire(boolean waitflag) {
        if (waitflag) {
            while (this.locked) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Interrupted thread");
                }
            }
            this.locked = true;
            return true;
        }
        if (this.locked) {
            return false;
        }
        this.locked = true;
        return true;
    }

    public synchronized void release() {
        if (this.locked) {
            this.locked = false;
            this.notifyAll();
            return;
        }
        throw Py.ValueError("lock not acquired");
    }

    public boolean locked() {
        return this.locked;
    }

    @Override
    public PyObject __enter__(ThreadState ts) {
        this.acquire();
        return this;
    }

    @Override
    public boolean __exit__(ThreadState ts, PyException exception) {
        this.release();
        return false;
    }
}

