/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.Iterator;
import org.python.indexer.Indexer;
import org.python.indexer.Scope;
import org.python.indexer.ast.NIndex;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NDictType;
import org.python.indexer.types.NFuncType;
import org.python.indexer.types.NListType;
import org.python.indexer.types.NTupleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;
import org.python.indexer.types.NUnknownType;

public final class NSubscript
extends NNode {
    private NNode value;
    private NNode slice;

    public NSubscript(NNode value, NNode slice2) {
        this(null, null, 0, 1);
    }

    public NSubscript(NNode value, NNode slice2, int start, int end) {
        super(start, end);
        this.value = value;
        this.slice = slice2;
        this.addChildren(value, slice2);
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        NType vt = NSubscript.resolveExpr(this.value, s);
        NType st = NSubscript.resolveExpr(this.slice, s);
        NType nType = vt;
        if (nType instanceof NUnknownType) {
            nType = st;
            if (nType instanceof NListType) {
                return this.setType(vt);
            }
            return this.setType(new NUnknownType());
        }
        nType = st;
        if (nType instanceof NListType) {
            NType getslice_type = vt.getTable().lookupTypeAttr("__getslice__");
            if (getslice_type == null) {
                this.addError("The type can't be sliced: " + vt);
                return this.setType(new NUnknownType());
            }
            nType = getslice_type;
            if (!(nType instanceof NFuncType)) {
                this.addError("The type's __getslice__ method is not a function: " + getslice_type);
                return this.setType(new NUnknownType());
            }
            nType = getslice_type;
            nType = ((NFuncType)nType).getReturnType();
            return this.setType(NUnknownType.follow(nType));
        }
        if (this.slice instanceof NIndex) {
            nType = vt;
            if (nType instanceof NListType) {
                this.warnUnlessNumIndex(st);
                nType = vt;
                return this.setType(((NListType)nType).getElementType());
            }
            nType = vt;
            if (nType instanceof NTupleType) {
                this.warnUnlessNumIndex(st);
                nType = vt;
                return this.setType(((NTupleType)nType).toListType().getElementType());
            }
            NType nType2 = vt;
            if (nType2 == Indexer.idx.builtins.BaseStr) {
                this.warnUnlessNumIndex(st);
                return this.setType(Indexer.idx.builtins.BaseStr);
            }
            nType = vt;
            if (nType instanceof NDictType) {
                NType nType3 = st;
                nType = nType3;
                nType = vt;
                if (!NUnknownType.follow(nType3).equals(((NDictType)nType).getKeyType())) {
                    this.addWarning("Possible KeyError (wrong type for subscript)");
                }
                nType = vt;
                return this.setType(((NDictType)nType).getValueType());
            }
        }
        if ((nType = vt) instanceof NUnionType) {
            nType = vt;
            Iterator<NType> i$ = ((NUnionType)nType).getTypes().iterator();
            while (i$.hasNext()) {
                i$.next();
                NType gt = vt.getTable().lookupTypeAttr("__getitem__");
                if (gt == null) continue;
                return this.setType(this.get__getitem__type(gt, gt));
            }
        }
        NType gt = vt.getTable().lookupTypeAttr("__getitem__");
        return this.setType(this.get__getitem__type(gt, vt));
    }

    private void warnUnlessNumIndex(NType subscriptType) {
        NType follow;
        NType nType = subscriptType;
        NType nType2 = follow = NUnknownType.follow(nType);
        if (!(follow == Indexer.idx.builtins.BaseNum) && !((nType = follow) instanceof NUnknownType)) {
            this.addWarning("Possible KeyError: subscript should be a number; found " + follow);
        }
    }

    private NType get__getitem__type(NType gt, NType vt) {
        if (gt == null) {
            this.addError("indexing type without __getitem__ method: " + vt);
            return new NUnknownType();
        }
        NType nType = gt;
        if (!(nType instanceof NFuncType)) {
            this.addError("The type's __getitem__ method is not a function: " + gt);
            return new NUnknownType();
        }
        nType = gt;
        nType = ((NFuncType)nType).getReturnType();
        return NUnknownType.follow(nType);
    }

    public final String toString() {
        return "<Subscript:" + this.value + ":" + this.slice + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NSubscript.visitNode(this.value, v);
            NSubscript.visitNode(this.slice, v);
        }
    }
}

