/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.base;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.python.google.common.base.CharMatcher;

public final class Objects$ToStringHelper {
    private final String className;
    private final List<ValueHolder> valueHolders = new LinkedList<ValueHolder>();
    private boolean omitNullValues = false;

    private Objects$ToStringHelper(String className) {
        this.className = CharMatcher.LookupTable.checkNotNull(className);
    }

    public final Objects$ToStringHelper add(String name, @Nullable Object value) {
        CharMatcher.LookupTable.checkNotNull(name);
        this.addHolder((Object)value).builder.append(name).append('=').append(value);
        return this;
    }

    public final Objects$ToStringHelper add(String name, int value) {
        this.checkNameAndAppend(name).append(value);
        return this;
    }

    public final Objects$ToStringHelper add(String name, long value) {
        this.checkNameAndAppend(name).append(value);
        return this;
    }

    private StringBuilder checkNameAndAppend(String name) {
        CharMatcher.LookupTable.checkNotNull(name);
        return this.addHolder().builder.append(name).append('=');
    }

    public final Objects$ToStringHelper addValue(@Nullable Object value) {
        this.addHolder((Object)value).builder.append(value);
        return this;
    }

    public final String toString() {
        boolean needsSeparator = false;
        StringBuilder builder = new StringBuilder(32).append(this.className).append('{');
        for (ValueHolder valueHolder : this.valueHolders) {
            if (needsSeparator) {
                builder.append(", ");
            } else {
                needsSeparator = true;
            }
            StringBuilder sequence = valueHolder.builder;
            builder.append((CharSequence)sequence);
        }
        return builder.append('}').toString();
    }

    private ValueHolder addHolder() {
        ValueHolder valueHolder = new ValueHolder(0);
        this.valueHolders.add(valueHolder);
        return valueHolder;
    }

    private ValueHolder addHolder(@Nullable Object value) {
        ValueHolder valueHolder = this.addHolder();
        this.addHolder().isNull = value == null;
        return valueHolder;
    }

    /* synthetic */ Objects$ToStringHelper(String x0, byte by) {
        this(x0);
    }

    static final class ValueHolder {
        final StringBuilder builder = new StringBuilder();
        boolean isNull;

        private ValueHolder() {
        }

        /* synthetic */ ValueHolder(byte by) {
            this();
        }
    }
}

