/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.Platform;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.Buffer;
import jnr.ffi.Address;
import jnr.ffi.NativeLong;
import jnr.ffi.NativeType;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.annotations.Delegate;
import jnr.ffi.provider.ParameterFlags;
import jnr.ffi.provider.jffi.AsmRuntime;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.LocalVariable;
import jnr.ffi.provider.jffi.NativeRuntime;
import jnr.ffi.provider.jffi.NumberUtil;
import jnr.ffi.provider.jffi.ParameterType;
import jnr.ffi.provider.jffi.SigType;
import jnr.ffi.provider.jffi.SkinnyMethodAdapter;
import org.python.objectweb.asm.ClassVisitor;
import org.python.objectweb.asm.Label;
import org.python.objectweb.asm.MethodVisitor;

final class AsmUtil {
    private AsmUtil() {
    }

    public static final MethodVisitor newTraceMethodVisitor(MethodVisitor mv) {
        try {
            Class<MethodVisitor> tmvClass = Class.forName("org.python.objectweb.asm.util.TraceMethodVisitor").asSubclass(MethodVisitor.class);
            Constructor<MethodVisitor> c = tmvClass.getDeclaredConstructor(MethodVisitor.class);
            return c.newInstance(mv);
        }
        catch (Throwable throwable) {
            return mv;
        }
    }

    public static final ClassVisitor newTraceClassVisitor(ClassVisitor cv, OutputStream out) {
        return AsmUtil.newTraceClassVisitor(cv, new PrintWriter(out, true));
    }

    public static final ClassVisitor newTraceClassVisitor(ClassVisitor cv, PrintWriter out) {
        try {
            Class<ClassVisitor> tmvClass = Class.forName("org.python.objectweb.asm.util.TraceClassVisitor").asSubclass(ClassVisitor.class);
            Constructor<ClassVisitor> c = tmvClass.getDeclaredConstructor(ClassVisitor.class, PrintWriter.class);
            return c.newInstance(cv, out);
        }
        catch (Throwable throwable) {
            return cv;
        }
    }

    public static final ClassVisitor newTraceClassVisitor(PrintWriter out) {
        try {
            Class<ClassVisitor> tmvClass = Class.forName("org.python.objectweb.asm.util.TraceClassVisitor").asSubclass(ClassVisitor.class);
            Constructor<ClassVisitor> c = tmvClass.getDeclaredConstructor(PrintWriter.class);
            return c.newInstance(out);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static final ClassVisitor newCheckClassAdapter(ClassVisitor cv) {
        try {
            Class<ClassVisitor> tmvClass = Class.forName("org.python.objectweb.asm.util.CheckClassAdapter").asSubclass(ClassVisitor.class);
            Constructor<ClassVisitor> c = tmvClass.getDeclaredConstructor(ClassVisitor.class);
            return c.newInstance(cv);
        }
        catch (Throwable throwable) {
            return cv;
        }
    }

    public static final Class unboxedReturnType(Class type) {
        if (Pointer.class.isAssignableFrom(type) || Struct.class.isAssignableFrom(type) || String.class.isAssignableFrom(type)) {
            if (Platform.getPlatform().addressSize() == 32) {
                return Integer.TYPE;
            }
            return Long.TYPE;
        }
        return AsmUtil.unboxedType(type);
    }

    public static final Class unboxedParameterType(Class type) {
        if (Buffer.class.isAssignableFrom(type)) {
            if (Platform.getPlatform().addressSize() == 32) {
                return Integer.TYPE;
            }
            return Long.TYPE;
        }
        return AsmUtil.unboxedType(type);
    }

    public static final Class unboxedType(Class boxedType) {
        if (boxedType == Byte.class) {
            return Byte.TYPE;
        }
        if (boxedType == Short.class) {
            return Short.TYPE;
        }
        if (boxedType == Integer.class) {
            return Integer.TYPE;
        }
        if (boxedType == Long.class) {
            return Long.TYPE;
        }
        if (boxedType == Float.class) {
            return Float.TYPE;
        }
        if (boxedType == Double.class) {
            return Double.TYPE;
        }
        if (boxedType == Boolean.class) {
            return Boolean.TYPE;
        }
        if (boxedType == NativeLong.class) {
            if (Platform.getPlatform().longSize() == 32) {
                return Integer.TYPE;
            }
            return Long.TYPE;
        }
        if (Pointer.class.isAssignableFrom(boxedType) || Struct.class.isAssignableFrom(boxedType)) {
            if (Platform.getPlatform().addressSize() == 32) {
                return Integer.TYPE;
            }
            return Long.TYPE;
        }
        if (Address.class == boxedType) {
            if (Platform.getPlatform().addressSize() == 32) {
                return Integer.TYPE;
            }
            return Long.TYPE;
        }
        if (String.class == boxedType) {
            if (Platform.getPlatform().addressSize() == 32) {
                return Integer.TYPE;
            }
            return Long.TYPE;
        }
        return boxedType;
    }

    public static final Class boxedType(Class type) {
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        return type;
    }

    static final void emitReturnOp(SkinnyMethodAdapter mv, Class returnType) {
        if (!returnType.isPrimitive()) {
            mv.areturn();
            return;
        }
        if (Long.TYPE == returnType) {
            mv.lreturn();
            return;
        }
        if (Float.TYPE == returnType) {
            mv.freturn();
            return;
        }
        if (Double.TYPE == returnType) {
            mv.dreturn();
            return;
        }
        if (Void.TYPE == returnType) {
            mv.voidreturn();
            return;
        }
        mv.ireturn();
    }

    static final int calculateLocalVariableSpace(Class type) {
        if (Long.TYPE == type || Double.TYPE == type) {
            return 2;
        }
        return 1;
    }

    private static int calculateLocalVariableSpace(SigType type) {
        return AsmUtil.calculateLocalVariableSpace(type.getDeclaredType());
    }

    static final int calculateLocalVariableSpace(Class ... types) {
        int size = 0;
        for (int i = 0; i < types.length; ++i) {
            size += AsmUtil.calculateLocalVariableSpace(types[i]);
        }
        return size;
    }

    static int calculateLocalVariableSpace(SigType ... types) {
        int size = 0;
        SigType[] arr$ = types;
        int len$ = types.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            SigType type;
            SigType sigType = type = arr$[i$];
            size += AsmUtil.calculateLocalVariableSpace(sigType.getDeclaredType());
        }
        return size;
    }

    private static final void unboxPointerOrStruct(SkinnyMethodAdapter mv, Class type, Class nativeType) {
        mv.invokestatic(CodegenUtils.p(AsmRuntime.class), Long.TYPE == nativeType ? "longValue" : "intValue", CodegenUtils.sig(nativeType, type));
    }

    static final void unboxPointer(SkinnyMethodAdapter mv, Class nativeType) {
        AsmUtil.unboxPointerOrStruct(mv, Pointer.class, nativeType);
    }

    static final void unboxBoolean(SkinnyMethodAdapter mv, Class boxedType, Class nativeType) {
        mv.invokevirtual(CodegenUtils.p(boxedType), "booleanValue", "()Z");
        NumberUtil.widen(mv, Boolean.TYPE, nativeType);
    }

    static final void unboxBoolean(SkinnyMethodAdapter mv, Class nativeType) {
        AsmUtil.unboxBoolean(mv, Boolean.class, nativeType);
    }

    static void unboxNumber(SkinnyMethodAdapter mv, Class boxedType, Class unboxedType, NativeType nativeType) {
        block12: {
            block11: {
                if (!Number.class.isAssignableFrom(boxedType)) break block11;
                switch (nativeType) {
                    case SCHAR: 
                    case UCHAR: {
                        mv.invokevirtual(CodegenUtils.p(boxedType), "byteValue", "()B");
                        NumberUtil.convertPrimitive(mv, Byte.TYPE, unboxedType, nativeType);
                        break block12;
                    }
                    case SSHORT: 
                    case USHORT: {
                        mv.invokevirtual(CodegenUtils.p(boxedType), "shortValue", "()S");
                        NumberUtil.convertPrimitive(mv, Short.TYPE, unboxedType, nativeType);
                        break block12;
                    }
                    case SINT: 
                    case UINT: 
                    case SLONG: 
                    case ULONG: 
                    case ADDRESS: {
                        if (NumberUtil.sizeof(nativeType) == 4) {
                            mv.invokevirtual(CodegenUtils.p(boxedType), "intValue", "()I");
                            NumberUtil.convertPrimitive(mv, Integer.TYPE, unboxedType, nativeType);
                        } else {
                            mv.invokevirtual(CodegenUtils.p(boxedType), "longValue", "()J");
                            NumberUtil.convertPrimitive(mv, Long.TYPE, unboxedType, nativeType);
                        }
                        break block12;
                    }
                    case SLONGLONG: 
                    case ULONGLONG: {
                        mv.invokevirtual(CodegenUtils.p(boxedType), "longValue", "()J");
                        NumberUtil.narrow(mv, Long.TYPE, unboxedType);
                        break block12;
                    }
                    case FLOAT: {
                        mv.invokevirtual(CodegenUtils.p(boxedType), "floatValue", "()F");
                        break block12;
                    }
                    case DOUBLE: {
                        mv.invokevirtual(CodegenUtils.p(boxedType), "doubleValue", "()D");
                    }
                    default: {
                        return;
                    }
                }
            }
            if (Boolean.class.isAssignableFrom(boxedType)) {
                Class clazz = unboxedType;
                SkinnyMethodAdapter skinnyMethodAdapter = mv;
                AsmUtil.unboxBoolean(skinnyMethodAdapter, Boolean.class, clazz);
                return;
            }
            throw new IllegalArgumentException("unsupported boxed type: " + boxedType);
        }
    }

    static final void unboxNumber(SkinnyMethodAdapter mv, Class boxedType, Class nativeType) {
        if (Number.class.isAssignableFrom(boxedType)) {
            if (Byte.TYPE == nativeType) {
                mv.invokevirtual(CodegenUtils.p(boxedType), "byteValue", "()B");
                return;
            }
            if (Short.TYPE == nativeType) {
                mv.invokevirtual(CodegenUtils.p(boxedType), "shortValue", "()S");
                return;
            }
            if (Integer.TYPE == nativeType) {
                mv.invokevirtual(CodegenUtils.p(boxedType), "intValue", "()I");
                return;
            }
            if (Long.TYPE == nativeType) {
                mv.invokevirtual(CodegenUtils.p(boxedType), "longValue", "()J");
                return;
            }
            if (Float.TYPE == nativeType) {
                mv.invokevirtual(CodegenUtils.p(boxedType), "floatValue", "()F");
                return;
            }
            if (Double.TYPE == nativeType) {
                mv.invokevirtual(CodegenUtils.p(boxedType), "doubleValue", "()D");
                return;
            }
            throw new IllegalArgumentException("unsupported Number subclass: " + boxedType);
        }
        if (Boolean.class.isAssignableFrom(boxedType)) {
            Class clazz = nativeType;
            SkinnyMethodAdapter skinnyMethodAdapter = mv;
            AsmUtil.unboxBoolean(skinnyMethodAdapter, Boolean.class, clazz);
            return;
        }
        throw new IllegalArgumentException("unsupported boxed type: " + boxedType);
    }

    static final void boxValue(SkinnyMethodAdapter mv, Class boxedType, Class unboxedType) {
        if (boxedType == unboxedType || boxedType.isPrimitive()) {
            return;
        }
        if (Boolean.class.isAssignableFrom(boxedType)) {
            NumberUtil.narrow(mv, unboxedType, Boolean.TYPE);
            mv.invokestatic(Boolean.class, "valueOf", Boolean.class, Boolean.TYPE);
            return;
        }
        if (Pointer.class.isAssignableFrom(boxedType)) {
            mv.invokestatic(AsmRuntime.class, "pointerValue", Pointer.class, unboxedType);
            return;
        }
        if (Address.class == boxedType || NativeLong.class.isAssignableFrom(boxedType)) {
            mv.invokestatic(boxedType, "valueOf", boxedType, unboxedType);
            return;
        }
        if (Struct.class.isAssignableFrom(boxedType)) {
            Class clazz = unboxedType;
            Class clazz2 = boxedType;
            SkinnyMethodAdapter skinnyMethodAdapter = mv;
            Label label = new Label();
            Label label2 = new Label();
            if (Long.TYPE == clazz) {
                skinnyMethodAdapter.dup2();
                skinnyMethodAdapter.lconst_0();
                skinnyMethodAdapter.lcmp();
                skinnyMethodAdapter.ifne(label);
                skinnyMethodAdapter.pop2();
            } else {
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.ifne(label);
                skinnyMethodAdapter.pop();
            }
            skinnyMethodAdapter.aconst_null();
            skinnyMethodAdapter.go_to(label2);
            skinnyMethodAdapter.label(label);
            skinnyMethodAdapter.newobj(CodegenUtils.p(clazz2));
            skinnyMethodAdapter.dup();
            try {
                clazz2.asSubclass(Struct.class).getConstructor(Runtime.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException("struct subclass " + clazz2.getName() + " has no constructor that takes a " + Runtime.class.getName(), noSuchMethodException);
            }
            skinnyMethodAdapter.invokestatic(CodegenUtils.p(NativeRuntime.class), "getInstance", CodegenUtils.sig(NativeRuntime.class, new Class[0]));
            skinnyMethodAdapter.invokespecial(clazz2, "<init>", Void.TYPE, Runtime.class);
            if (Long.TYPE == clazz) {
                skinnyMethodAdapter.dup_x2();
            } else {
                skinnyMethodAdapter.dup_x1();
            }
            skinnyMethodAdapter.invokestatic(AsmRuntime.class, "useMemory", Void.TYPE, clazz, Struct.class);
            skinnyMethodAdapter.label(label2);
            return;
        }
        if (Number.class.isAssignableFrom(boxedType) && AsmUtil.boxedType(unboxedType) == boxedType) {
            mv.invokestatic(boxedType, "valueOf", boxedType, unboxedType);
            return;
        }
        if (String.class == boxedType) {
            mv.invokestatic(AsmRuntime.class, "stringValue", String.class, unboxedType);
            return;
        }
        throw new IllegalArgumentException("cannot box value of type " + unboxedType + " to " + boxedType);
    }

    private static void boxStruct(SkinnyMethodAdapter mv, Class structClass, Class nativeType) {
        Label nonnull = new Label();
        Label end = new Label();
        if (Long.TYPE == nativeType) {
            mv.dup2();
            mv.lconst_0();
            mv.lcmp();
            mv.ifne(nonnull);
            mv.pop2();
        } else {
            mv.dup();
            mv.ifne(nonnull);
            mv.pop();
        }
        mv.aconst_null();
        mv.go_to(end);
        mv.label(nonnull);
        mv.newobj(CodegenUtils.p(structClass));
        mv.dup();
        try {
            structClass.asSubclass(Struct.class).getConstructor(Runtime.class);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("struct subclass " + structClass.getName() + " has no constructor that takes a " + Runtime.class.getName(), ex);
        }
        mv.invokestatic(CodegenUtils.p(NativeRuntime.class), "getInstance", CodegenUtils.sig(NativeRuntime.class, new Class[0]));
        mv.invokespecial(structClass, "<init>", Void.TYPE, Runtime.class);
        if (Long.TYPE == nativeType) {
            mv.dup_x2();
        } else {
            mv.dup_x1();
        }
        mv.invokestatic(AsmRuntime.class, "useMemory", Void.TYPE, nativeType, Struct.class);
        mv.label(end);
    }

    static boolean isDelegate(Class klass) {
        for (Method m : klass.getMethods()) {
            if (!m.isAnnotationPresent(Delegate.class)) continue;
            return true;
        }
        return false;
    }

    static boolean isDelegate(SigType type) {
        return AsmUtil.isDelegate(type.getDeclaredType());
    }

    static final int getParameterFlags(Annotation[] annotations) {
        return ParameterFlags.parse(annotations);
    }

    static final int getNativeArrayFlags(int flags) {
        int nflags = 0 | (ParameterFlags.isIn(flags) ? 1 : 0);
        nflags |= ParameterFlags.isOut(flags) ? 2 : 0;
        return nflags |= ParameterFlags.isNulTerminate(flags) || ParameterFlags.isIn(flags) ? 4 : 0;
    }

    static final int getNativeArrayFlags(Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        return AsmUtil.getNativeArrayFlags(ParameterFlags.parse(annotations));
    }

    static LocalVariable[] getParameterVariables(ParameterType[] parameterTypes) {
        LocalVariable[] lvars = new LocalVariable[parameterTypes.length];
        int lvar = 1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            lvars[i] = new LocalVariable(parameterTypes[i].getDeclaredType(), lvar);
            ParameterType parameterType = parameterTypes[i];
            lvar += AsmUtil.calculateLocalVariableSpace(parameterType.getDeclaredType());
        }
        return lvars;
    }

    static LocalVariable[] getParameterVariables(Class[] parameterTypes) {
        LocalVariable[] lvars = new LocalVariable[parameterTypes.length];
        int idx = 1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            lvars[i] = new LocalVariable(parameterTypes[i], idx);
            idx += AsmUtil.calculateLocalVariableSpace(parameterTypes[i]);
        }
        return lvars;
    }

    static void load(SkinnyMethodAdapter mv, Class parameterType, LocalVariable parameter) {
        if (!parameterType.isPrimitive()) {
            mv.aload(parameter);
            return;
        }
        if (Long.TYPE == parameterType) {
            mv.lload(parameter);
            return;
        }
        if (Float.TYPE == parameterType) {
            mv.fload(parameter);
            return;
        }
        if (Double.TYPE == parameterType) {
            mv.dload(parameter);
            return;
        }
        mv.iload(parameter);
    }

    static void emitReturn(SkinnyMethodAdapter mv, Class returnType, Class nativeIntType) {
        if (returnType.isPrimitive()) {
            if (Long.TYPE == returnType) {
                mv.lreturn();
                return;
            }
            if (Float.TYPE == returnType) {
                mv.freturn();
                return;
            }
            if (Double.TYPE == returnType) {
                mv.dreturn();
                return;
            }
            if (Void.TYPE == returnType) {
                mv.voidreturn();
                return;
            }
            mv.ireturn();
            return;
        }
        AsmUtil.boxValue(mv, returnType, nativeIntType);
        mv.areturn();
    }
}

