/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.Platform;
import org.python.modules.jffi.AbstractNumericMethodGenerator;
import org.python.modules.jffi.JITSignature;
import org.python.modules.jffi.NativeType;

final class FastIntMethodGenerator
extends AbstractNumericMethodGenerator {
    private static final int MAX_PARAMETERS = FastIntMethodGenerator.getMaximumFastIntParameters();
    private static final String[] signatures = FastIntMethodGenerator.buildSignatures(Integer.TYPE, MAX_PARAMETERS);
    private static final String[] methodNames = new String[]{"invokeVrI", "invokeIrI", "invokeIIrI", "invokeIIIrI", "invokeIIIIrI", "invokeIIIIIrI", "invokeIIIIIIrI"};
    private static final String[] noErrnoMethodNames = new String[]{"invokeNoErrnoVrI", "invokeNoErrnoIrI", "invokeNoErrnoIIrI", "invokeNoErrnoIIIrI"};

    FastIntMethodGenerator() {
    }

    @Override
    final String getInvokerMethodName(JITSignature signature) {
        int parameterCount = signature.getParameterCount();
        if (signature.isIgnoreError() && parameterCount <= MAX_PARAMETERS && parameterCount <= noErrnoMethodNames.length) {
            return noErrnoMethodNames[signature.getParameterCount()];
        }
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= methodNames.length) {
            return methodNames[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    @Override
    final String getInvokerSignature(int parameterCount) {
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= signatures.length) {
            return signatures[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    @Override
    final Class getInvokerIntType() {
        return Integer.TYPE;
    }

    @Override
    public final boolean isSupported(JITSignature signature) {
        boolean bl;
        Platform platform;
        NativeType nativeType;
        int parameterCount = signature.getParameterCount();
        if (!signature.getCallingConvention().equals((Object)CallingConvention.DEFAULT) || parameterCount > MAX_PARAMETERS) {
            return false;
        }
        Platform platform2 = Platform.getPlatform();
        if (platform2.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return false;
        }
        if (!Platform.getCPU().equals((Object)Platform.CPU.I386) && !Platform.getCPU().equals((Object)Platform.CPU.X86_64)) {
            return false;
        }
        for (int i = 0; i < parameterCount; ++i) {
            boolean bl2;
            nativeType = signature.getParameterType(i);
            platform = platform2;
            switch (nativeType) {
                case POINTER: 
                case BUFFER_IN: 
                case BUFFER_OUT: 
                case BUFFER_INOUT: {
                    if (platform.addressSize() == 32) {
                        bl2 = true;
                        break;
                    }
                    bl2 = false;
                    break;
                }
                default: {
                    bl2 = FastIntMethodGenerator.isFastIntType(platform, nativeType);
                }
            }
            if (bl2) continue;
            return false;
        }
        nativeType = signature.getResultType();
        platform = platform2;
        switch (nativeType) {
            case VOID: {
                return true;
            }
            case POINTER: 
            case STRING: {
                if (platform.addressSize() == 32) {
                    bl = true;
                    break;
                }
                return false;
            }
            default: {
                bl = FastIntMethodGenerator.isFastIntType(platform, nativeType);
            }
        }
        return bl;
    }

    private static int getMaximumFastIntParameters() {
        try {
            Invoker.class.getDeclaredMethod("invokeIIIIIIrI", Function.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            return 6;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Invoker.class.getDeclaredMethod("invokeIIIrI", Function.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                return 3;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                return -1;
            }
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    private static boolean isFastIntType(Platform platform, NativeType type) {
        switch (type) {
            case BOOL: 
            case BYTE: 
            case UBYTE: 
            case SHORT: 
            case USHORT: 
            case INT: 
            case UINT: {
                return true;
            }
            case LONG: 
            case ULONG: {
                return platform.longSize() == 32;
            }
        }
        return false;
    }

    private static boolean isFastIntResult(Platform platform, NativeType type) {
        switch (type) {
            case VOID: {
                return true;
            }
            case POINTER: 
            case STRING: {
                return platform.addressSize() == 32;
            }
        }
        return FastIntMethodGenerator.isFastIntType(platform, type);
    }

    private static boolean isFastIntParameter(Platform platform, NativeType type) {
        switch (type) {
            case POINTER: 
            case BUFFER_IN: 
            case BUFFER_OUT: 
            case BUFFER_INOUT: {
                return platform.addressSize() == 32;
            }
        }
        return FastIntMethodGenerator.isFastIntType(platform, type);
    }
}

