/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.python.indexer.AstCache;
import org.python.indexer.Builtins;
import org.python.indexer.Diagnostic;
import org.python.indexer.IndexingException;
import org.python.indexer.NBinding;
import org.python.indexer.Outliner;
import org.python.indexer.Ref;
import org.python.indexer.Scope;
import org.python.indexer.Util;
import org.python.indexer.ast.NModule;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NUrl;
import org.python.indexer.types.NFuncType;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;
import org.python.indexer.types.NUnknownType;

public class Indexer {
    public static Indexer idx;
    public Scope moduleTable = new Scope(null, Scope.Type.GLOBAL);
    public Scope globaltable = new Scope(null, Scope.Type.GLOBAL);
    private Map<String, NBinding> allBindings = new HashMap<String, NBinding>();
    private Map<Ref, List<NBinding>> locations = new HashMap<Ref, List<NBinding>>();
    public Map<String, List<Diagnostic>> problems = new HashMap<String, List<Diagnostic>>();
    public Map<String, List<Diagnostic>> parseErrs = new HashMap<String, List<Diagnostic>>();
    public String currentFile = null;
    public String projDir = null;
    public List<String> path = new ArrayList<String>();
    private AstCache astCache;
    public Set<String> failedModules = new HashSet<String>();
    private Map<String, Set<String>> unresolvedModules = new TreeMap<String, Set<String>>();
    public Builtins builtins;
    private boolean aggressiveAssertions;
    private int nloc = 0;
    private int nunbound = 0;
    private int nunknown = 0;
    private int nprob = 0;
    private int nparsing = 0;
    private int loadedFiles = 0;
    private Logger logger = Logger.getLogger(Indexer.class.getCanonicalName());

    public Indexer() {
        idx = this;
        this.builtins = new Builtins(this.globaltable, this.moduleTable);
        this.builtins.init();
    }

    public void setLogger(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("null logger param");
        }
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setProjectDir(String cd) throws IOException {
        this.projDir = Util.canonicalize(cd);
    }

    public void enableAggressiveAssertions(boolean enable) {
        this.aggressiveAssertions = enable;
    }

    public boolean aggressiveAssertionsEnabled() {
        return this.aggressiveAssertions;
    }

    public void handleException(String msg, Throwable cause) {
        if (cause instanceof StackOverflowError) {
            this.logger.log(Level.WARNING, msg, cause);
            return;
        }
        if (this.aggressiveAssertionsEnabled()) {
            if (msg != null) {
                throw new IndexingException(msg, cause);
            }
            throw new IndexingException(cause);
        }
        if (msg == null) {
            msg = "<null msg>";
        }
        if (cause == null) {
            cause = new Exception();
        }
        this.logger.log(Level.WARNING, msg, cause);
    }

    public void reportFailedAssertion(String msg) {
        if (this.aggressiveAssertionsEnabled()) {
            throw new IndexingException(msg, new Exception());
        }
    }

    public void addPaths(List<String> p) throws IOException {
        for (String s : p) {
            this.addPath(s);
        }
    }

    public void addPath(String p) throws IOException {
        this.path.add(Util.canonicalize(p));
    }

    public void setPath(List<String> path) throws IOException {
        this.path = new ArrayList<String>(path.size());
        this.addPaths(path);
    }

    public List<String> getLoadPath() {
        ArrayList<String> loadPath = new ArrayList<String>();
        if (this.projDir != null) {
            loadPath.add(this.projDir);
        }
        loadPath.addAll(this.path);
        return loadPath;
    }

    public boolean isLibFile(String file) {
        if (file.startsWith(File.separator)) {
            return true;
        }
        if (this.path != null) {
            for (String p : this.path) {
                if (!file.startsWith(p)) continue;
                return true;
            }
        }
        return false;
    }

    public Map<String, NBinding> getBindings() {
        return this.allBindings;
    }

    public NBinding lookupQname(String qname) {
        return this.allBindings.get(qname);
    }

    public NType lookupQnameType(String qname) {
        NBinding b = this.lookupQname(qname);
        if (b != null) {
            return b.followType();
        }
        return null;
    }

    private NModuleType getCachedModule(String file) {
        return (NModuleType)this.moduleTable.lookupType(file);
    }

    public NModuleType getModuleForFile(String file) throws Exception {
        if (this.failedModules.contains(file)) {
            return null;
        }
        NModuleType m = this.getCachedModule(file);
        if (m != null) {
            return m;
        }
        return this.loadFile(file);
    }

    public List<Diagnostic> getDiagnosticsForFile(String file) {
        List<Diagnostic> errs = this.problems.get(file);
        if (errs != null) {
            return errs;
        }
        return new ArrayList<Diagnostic>();
    }

    public List<Outliner.Entry> generateOutline(String file) throws Exception {
        return new Outliner().generate(this, file);
    }

    public void putLocation(NNode node, NBinding b) {
        if (node == null) {
            return;
        }
        this.putLocation(new Ref(node), b);
    }

    public void putLocation(Ref ref, NBinding b) {
        if (ref == null) {
            return;
        }
        List<NBinding> bindings = this.locations.get(ref);
        if (bindings == null) {
            bindings = new ArrayList<NBinding>(1);
            this.locations.put(ref, bindings);
        }
        if (!bindings.contains(b)) {
            bindings.add(b);
        }
        b.addRef(ref);
    }

    public void updateLocation(Ref node, NBinding b) {
        if (node == null) {
            return;
        }
        List<NBinding> bindings = this.locations.get(node);
        if (bindings == null) {
            bindings = new ArrayList<NBinding>(1);
            this.locations.put(node, bindings);
        } else {
            for (NBinding oldb : bindings) {
                oldb.removeRef(node);
            }
            bindings.clear();
        }
        if (!bindings.contains(b)) {
            bindings.add(b);
        }
        b.addRef(node);
    }

    public void removeBinding(NBinding b) {
        this.allBindings.remove(b);
    }

    public NBinding putBinding(NBinding b) {
        if (b == null) {
            throw new IllegalArgumentException("null binding arg");
        }
        String qname = b.getQname();
        if (qname == null || qname.length() == 0) {
            throw new IllegalArgumentException("Null/empty qname: " + b);
        }
        NBinding existing = this.allBindings.get(qname);
        if (existing == b) {
            return b;
        }
        if (existing != null) {
            this.duplicateBindingFailure(b, existing);
            if (b.getKind() == NBinding.Kind.MODULE) {
                return b;
            }
            return existing;
        }
        this.allBindings.put(qname, b);
        return b;
    }

    private void duplicateBindingFailure(NBinding newb, NBinding oldb) {
    }

    public void putProblem(NNode loc, String msg) {
        String file;
        if (loc != null && (file = loc.getFile()) != null) {
            this.addFileErr(file, loc.start(), loc.end(), msg);
        }
    }

    public void putProblem(String file, int beg, int end, String msg) {
        if (file != null) {
            this.addFileErr(file, beg, end, msg);
        }
    }

    private void addFileErr(String file, int beg, int end, String msg) {
        List<Diagnostic> msgs = Indexer.getFileErrs(file, this.problems);
        msgs.add(new Diagnostic(file, Diagnostic.Type.ERROR, beg, end, msg));
    }

    static List<Diagnostic> getFileErrs(String file, Map<String, List<Diagnostic>> map) {
        List<Diagnostic> msgs = map.get(file);
        if (msgs == null) {
            msgs = new ArrayList<Diagnostic>();
            map.put(file, msgs);
        }
        return msgs;
    }

    public NModuleType loadFile(String path) throws Exception {
        return this.loadFile(path, false);
    }

    public NModuleType loadString(String path, String contents) throws Exception {
        NModuleType module = this.getCachedModule(path);
        if (module != null) {
            this.finer("\nusing cached module " + path + " [succeeded]");
            return module;
        }
        return this.parseAndResolve(path, contents);
    }

    public NModuleType loadFile(String path, boolean skipChain) throws Exception {
        File f = new File(path);
        if (f.isDirectory()) {
            this.finer("\n    loading init file from directory: " + path);
            f = Util.joinPath(path, "__init__.py");
            path = f.getAbsolutePath();
        }
        if (!f.canRead()) {
            this.finer("\nfile not not found or cannot be read: " + path);
            return null;
        }
        NModuleType module = this.getCachedModule(path);
        if (module != null) {
            this.finer("\nusing cached module " + path + " [succeeded]");
            return module;
        }
        if (!skipChain) {
            this.loadParentPackage(path);
        }
        try {
            return this.parseAndResolve(path);
        }
        catch (StackOverflowError soe) {
            this.handleException("Error loading " + path, soe);
            return null;
        }
    }

    private void loadParentPackage(String file) throws Exception {
        File f = new File(file);
        File parent = f.getParentFile();
        if (parent == null || this.isInLoadPath(parent)) {
            return;
        }
        if (parent != null && f.isFile() && "__init__.py".equals(f.getName())) {
            parent = parent.getParentFile();
        }
        if (parent == null || this.isInLoadPath(parent)) {
            return;
        }
        File initpy = Util.joinPath(parent, "__init__.py");
        if (!initpy.isFile() || !initpy.canRead()) {
            return;
        }
        this.loadFile(initpy.getPath());
    }

    private boolean isInLoadPath(File dir) {
        for (String s : this.getLoadPath()) {
            if (!new File(s).equals(dir)) continue;
            return true;
        }
        return false;
    }

    private NModuleType parseAndResolve(String file) throws Exception {
        return this.parseAndResolve(file, null);
    }

    private NModuleType parseAndResolve(String file, String contents) throws Exception {
        NModuleType nmt = (NModuleType)this.moduleTable.lookupType(file);
        if (nmt != null) {
            return nmt;
        }
        NModuleType mod2 = new NModuleType(Util.moduleNameFor(file), file, this.globaltable);
        this.moduleTable.put(file, new NUrl("file://" + file), mod2, NBinding.Kind.MODULE);
        try {
            NModule ast = contents != null ? this.getAstForFile(file, contents) : this.getAstForFile(file);
            if (ast == null) {
                return null;
            }
            this.finer("resolving: " + file);
            ast.resolve(this.globaltable);
            this.finer("[success]");
            ++this.loadedFiles;
            return mod2;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (this.astCache != null) {
                this.astCache.clear();
            }
            System.gc();
            return null;
        }
    }

    private AstCache getAstCache() throws Exception {
        if (this.astCache == null) {
            this.astCache = AstCache.get();
        }
        return this.astCache;
    }

    public NModule getAstForFile(String file) throws Exception {
        return this.getAstCache().getAST(file);
    }

    public NModule getAstForFile(String file, String contents) throws Exception {
        return this.getAstCache().getAST(file, contents);
    }

    public NModuleType getBuiltinModule(String qname) throws Exception {
        return this.builtins.get(qname);
    }

    public NModuleType loadModule(String modname) throws Exception {
        if (this.failedModules.contains(modname)) {
            return null;
        }
        NModuleType cached = this.getCachedModule(modname);
        if (cached != null) {
            this.finer("\nusing cached module " + modname);
            return cached;
        }
        NModuleType mt = this.getBuiltinModule(modname);
        if (mt != null) {
            return mt;
        }
        this.finer("looking for module " + modname);
        if (modname.endsWith(".py")) {
            modname = modname.substring(0, modname.length() - 3);
        }
        String modpath = modname.replace('.', File.separatorChar);
        modpath = modpath.replaceFirst("(/python[23])/([0-9]/)", "$1.$2");
        List<String> loadPath = this.getLoadPath();
        for (String p : loadPath) {
            NModuleType m;
            String name;
            String dirname = p + modpath;
            String pyname = dirname + ".py";
            String initname = Util.joinPath(dirname, "__init__.py").getAbsolutePath();
            if (Util.isReadableFile(initname)) {
                name = initname;
            } else {
                if (!Util.isReadableFile(pyname)) continue;
                name = pyname;
            }
            if ((m = this.loadFile(name = Util.canonicalize(name))) == null) continue;
            this.finer("load of module " + modname + "[succeeded]");
            return m;
        }
        this.finer("failed to find module " + modname + " in load path");
        this.failedModules.add(modname);
        return null;
    }

    public void loadFileRecursive(String fullname) throws Exception {
        File file_or_dir = new File(fullname);
        if (file_or_dir.isDirectory()) {
            for (File file : file_or_dir.listFiles()) {
                this.loadFileRecursive(file.getAbsolutePath());
            }
            return;
        }
        if (file_or_dir.getAbsolutePath().endsWith(".py")) {
            this.loadFile(file_or_dir.getAbsolutePath());
        }
    }

    public void ready() {
        this.fine("Checking for undeclared variables");
        for (Map.Entry<Ref, List<NBinding>> ent : this.locations.entrySet()) {
            Ref ref = ent.getKey();
            List<NBinding> bindings = ent.getValue();
            this.convertCallToNew(ref, bindings);
            if (this.countDefs(bindings) == 0) continue;
            ++this.nloc;
        }
        this.nprob = this.problems.size();
        this.nparsing = this.parseErrs.size();
        HashSet<String> removals = new HashSet<String>();
        for (Map.Entry<String, NBinding> e : this.allBindings.entrySet()) {
            NBinding nb = e.getValue();
            if (!nb.isProvisional() && nb.getNumDefs() != 0) continue;
            removals.add(e.getKey());
        }
        for (String s : removals) {
            this.allBindings.remove(s);
        }
        this.locations.clear();
    }

    private void convertCallToNew(Ref ref, List<NBinding> bindings) {
        NType tt;
        NType t;
        if (ref.isRef()) {
            return;
        }
        if (bindings.isEmpty()) {
            return;
        }
        NBinding nb = bindings.get(0);
        NType nType = t = nb.followType();
        if (t instanceof NUnionType && (t = ((NUnionType)(nType = t)).firstKnownNonNullAlternate()) == null) {
            return;
        }
        nType = t;
        nType = tt = NUnknownType.follow(nType);
        if (!(tt instanceof NUnknownType) && !((nType = tt) instanceof NFuncType)) {
            ref.markAsNew();
        }
    }

    public void clearAstCache() {
        if (this.astCache != null) {
            this.astCache.clear();
        }
    }

    public void clearModuleTable() {
        this.moduleTable.clear();
        this.moduleTable = new Scope(null, Scope.Type.GLOBAL);
        this.clearAstCache();
    }

    private int countDefs(List<NBinding> bindings) {
        int count2 = 0;
        for (NBinding b : bindings) {
            count2 += b.getNumDefs();
        }
        return count2;
    }

    private String printBindings() {
        StringBuilder sb = new StringBuilder();
        TreeSet<String> sorter = new TreeSet<String>();
        sorter.addAll(this.allBindings.keySet());
        for (String key : sorter) {
            NBinding b = this.allBindings.get(key);
            sb.append(b.toString()).append("\n");
        }
        return sb.toString();
    }

    public void recordUnresolvedModule(String qname, String file) {
        Set<String> importers = this.unresolvedModules.get(qname);
        if (importers == null) {
            importers = new TreeSet<String>();
            this.unresolvedModules.put(qname, importers);
        }
        importers.add(file);
    }

    public String getStatusReport() {
        StringBuilder sb = new StringBuilder();
        sb.append("Summary: \n- modules loaded: ").append(this.loadedFiles).append("\n- unresolved modules: ").append(this.unresolvedModules.size()).append("\n");
        for (String s : this.unresolvedModules.keySet()) {
            sb.append(s).append(": ");
            Set<String> importers = this.unresolvedModules.get(s);
            if (importers.size() > 5) {
                sb.append(importers.iterator().next());
                sb.append(" and ");
                sb.append(importers.size());
                sb.append(" more");
            } else {
                String files = importers.toString();
                sb.append(files.substring(1, files.length() - 1));
            }
            sb.append("\n");
        }
        sb.append("\nsemantics problems: ").append(this.nprob);
        sb.append("\nparsing problems: ").append(this.nparsing);
        return sb.toString();
    }

    private String percent(int num, int total) {
        double pct = (double)num / (double)total;
        pct = (double)Math.round(pct * 10000.0) / 100.0;
        return num + "/" + total + " = " + pct + "%";
    }

    public int numFilesLoaded() {
        return this.loadedFiles;
    }

    public List<String> getLoadedFiles() {
        ArrayList<String> files = new ArrayList<String>();
        for (String file : this.moduleTable.keySet()) {
            if (!file.startsWith(File.separator)) continue;
            files.add(file);
        }
        return files;
    }

    public void log(Level level, String msg) {
        if (this.logger.isLoggable(level)) {
            this.logger.log(level, msg);
        }
    }

    public void severe(String msg) {
        this.log(Level.SEVERE, msg);
    }

    public void warn(String msg) {
        this.log(Level.WARNING, msg);
    }

    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public void fine(String msg) {
        this.log(Level.FINE, msg);
    }

    public void finer(String msg) {
        this.log(Level.FINER, msg);
    }

    public void release() {
        this.globaltable = null;
        this.moduleTable = null;
        this.clearAstCache();
        this.astCache = null;
        this.locations = null;
        this.problems.clear();
        this.problems = null;
        this.parseErrs.clear();
        this.parseErrs = null;
        this.path.clear();
        this.path = null;
        this.failedModules.clear();
        this.failedModules = null;
        this.unresolvedModules.clear();
        this.unresolvedModules = null;
        this.builtins = null;
        this.allBindings.clear();
        this.allBindings = null;
        idx = null;
    }

    public String toString() {
        return "<Indexer:locs=" + this.locations.size() + ":unbound=" + this.nunbound + ":probs=" + this.problems.size() + ":files=" + this.loadedFiles + ">";
    }
}

