/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.base.Joiner;
import org.python.google.common.collect.Collections2;
import org.python.google.common.collect.ImmutableEntry;
import org.python.google.common.collect.UnmodifiableIterator;

public final class Maps {
    private static Joiner.MapJoiner STANDARD_JOINER = Collections2.STANDARD_JOINER.withKeyValueSeparator("=");

    public static <K, V> Map.Entry<K, V> immutableEntry(@Nullable K key, @Nullable V value) {
        return new ImmutableEntry<K, V>(key, value);
    }

    static boolean equalsImpl(Map<?, ?> map, Object object) {
        if (map == object) {
            return true;
        }
        if (object instanceof Map) {
            Map o = (Map)object;
            return ((Object)map.entrySet()).equals(o.entrySet());
        }
        return false;
    }

    static String toStringImpl(Map<?, ?> map) {
        StringBuilder sb = Collections2.newStringBuilderForCollection(map.size()).append('{');
        Map<?, ?> map2 = map;
        StringBuilder stringBuilder = sb;
        Joiner.MapJoiner mapJoiner = STANDARD_JOINER;
        Set<Map.Entry<?, ?>> set = map2.entrySet();
        StringBuilder stringBuilder2 = stringBuilder;
        Joiner.MapJoiner mapJoiner2 = mapJoiner;
        mapJoiner.appendTo(stringBuilder2, set.iterator());
        return sb.append('}').toString();
    }

    static boolean containsValueImpl(Map<?, ?> map, @Nullable Object value) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!CharMatcher.LookupTable.equal(entry.getValue(), value)) continue;
            return true;
        }
        return false;
    }

    static <K, V> UnmodifiableIterator<V> valueIterator(UnmodifiableIterator<Map.Entry<K, V>> entryIterator) {
        return new UnmodifiableIterator<V>(entryIterator){
            private /* synthetic */ UnmodifiableIterator val$entryIterator;
            {
                this.val$entryIterator = unmodifiableIterator;
            }

            @Override
            public final boolean hasNext() {
                return this.val$entryIterator.hasNext();
            }

            @Override
            public final V next() {
                return ((Map.Entry)this.val$entryIterator.next()).getValue();
            }
        };
    }
}

