/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.Function;
import com.kenai.jffi.InvocationBuffer;
import com.kenai.jffi.ObjectBuffer;
import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import java.nio.Buffer;
import java.nio.ByteOrder;

public final class HeapInvocationBuffer
extends InvocationBuffer {
    private static Encoder encoder;
    private final CallContext callContext;
    private final byte[] buffer;
    private ObjectBuffer objectBuffer;
    private int paramOffset = 0;
    private int paramIndex = 0;

    public HeapInvocationBuffer(Function function) {
        this.callContext = function.getCallContext();
        this.buffer = new byte[encoder.getBufferSize(this.callContext)];
    }

    public HeapInvocationBuffer(CallContext callContext) {
        this.callContext = callContext;
        this.buffer = new byte[encoder.getBufferSize(callContext)];
    }

    public HeapInvocationBuffer(CallContext context, int objectCount) {
        this.callContext = context;
        this.buffer = new byte[encoder.getBufferSize(context)];
        this.objectBuffer = new ObjectBuffer(objectCount);
    }

    final byte[] array() {
        return this.buffer;
    }

    final ObjectBuffer objectBuffer() {
        return this.objectBuffer;
    }

    public final void putByte(int value) {
        this.paramOffset = encoder.putByte(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putShort(int value) {
        this.paramOffset = encoder.putShort(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putInt(int value) {
        this.paramOffset = encoder.putInt(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putLong(long value) {
        this.paramOffset = encoder.putLong(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putFloat(float value) {
        this.paramOffset = encoder.putFloat(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putDouble(double value) {
        this.paramOffset = encoder.putDouble(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putAddress(long value) {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    private final ObjectBuffer getObjectBuffer() {
        if (this.objectBuffer == null) {
            this.objectBuffer = new ObjectBuffer();
        }
        return this.objectBuffer;
    }

    public final void putArray(byte[] array, int offset, int length, int flags) {
        this.paramOffset = encoder.skipAddress(this.paramOffset);
        int n = flags;
        int n2 = length;
        int n3 = offset;
        byte[] byArray = array;
        int n4 = this.paramIndex++;
        ObjectBuffer objectBuffer = this.getObjectBuffer();
        objectBuffer.putObject(byArray, n3, n2, ObjectBuffer.makeObjectFlags(n, 0x11000000, n4));
    }

    public final void putArray(short[] array, int offset, int length, int flags) {
        this.paramOffset = encoder.skipAddress(this.paramOffset);
        int n = flags;
        int n2 = length;
        int n3 = offset;
        short[] sArray = array;
        int n4 = this.paramIndex++;
        ObjectBuffer objectBuffer = this.getObjectBuffer();
        objectBuffer.putObject(sArray, n3, n2, ObjectBuffer.makeObjectFlags(n, 0x12000000, n4));
    }

    public final void putArray(int[] array, int offset, int length, int flags) {
        this.paramOffset = encoder.skipAddress(this.paramOffset);
        int n = flags;
        int n2 = length;
        int n3 = offset;
        int[] nArray = array;
        int n4 = this.paramIndex++;
        ObjectBuffer objectBuffer = this.getObjectBuffer();
        objectBuffer.putObject(nArray, n3, n2, ObjectBuffer.makeObjectFlags(n, 0x13000000, n4));
    }

    public final void putArray(long[] array, int offset, int length, int flags) {
        this.paramOffset = encoder.skipAddress(this.paramOffset);
        int n = flags;
        int n2 = length;
        int n3 = offset;
        long[] lArray = array;
        int n4 = this.paramIndex++;
        ObjectBuffer objectBuffer = this.getObjectBuffer();
        objectBuffer.putObject(lArray, n3, n2, ObjectBuffer.makeObjectFlags(n, 0x14000000, n4));
    }

    public final void putArray(float[] array, int offset, int length, int flags) {
        this.paramOffset = encoder.skipAddress(this.paramOffset);
        int n = flags;
        int n2 = length;
        int n3 = offset;
        float[] fArray = array;
        int n4 = this.paramIndex++;
        ObjectBuffer objectBuffer = this.getObjectBuffer();
        objectBuffer.putObject(fArray, n3, n2, ObjectBuffer.makeObjectFlags(n, 0x15000000, n4));
    }

    public final void putArray(double[] array, int offset, int length, int flags) {
        this.paramOffset = encoder.skipAddress(this.paramOffset);
        int n = flags;
        int n2 = length;
        int n3 = offset;
        double[] dArray = array;
        int n4 = this.paramIndex++;
        ObjectBuffer objectBuffer = this.getObjectBuffer();
        objectBuffer.putObject(dArray, n3, n2, ObjectBuffer.makeObjectFlags(n, 0x16000000, n4));
    }

    public final void putDirectBuffer(Buffer value, int offset, int length) {
        this.paramOffset = encoder.skipAddress(this.paramOffset);
        int n = length;
        int n2 = offset;
        Buffer buffer = value;
        int n3 = this.paramIndex++;
        ObjectBuffer objectBuffer = this.getObjectBuffer();
        int n4 = n3;
        objectBuffer.putObject(buffer, n2, n, n4 << 16 & 0xFF0000 | 0x20000000);
    }

    static int FFI_ALIGN(int v, int a) {
        return (v - 1 | a - 1) + 1;
    }

    static {
        Encoder encoder;
        Platform platform = Platform.getPlatform();
        int cfr_ignored_0 = Platform.getCPU().dataModel;
        Foreign foreign = Foreign.getInstance();
        Platform platform2 = Platform.getPlatform();
        if (Platform.getCPU() == Platform.CPU.I386 && foreign.isRawParameterPackingEnabled()) {
            encoder = new I386RawEncoder(0);
        } else {
            ArrayIO arrayIO;
            ArrayIO arrayIO2;
            if (ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
                platform = platform2;
                arrayIO2 = Platform.getCPU().dataModel == 64 ? BE64ArrayIO.INSTANCE : BE32ArrayIO.INSTANCE;
            } else {
                platform = platform2;
                arrayIO2 = arrayIO = Platform.getCPU().dataModel == 64 ? LE64ArrayIO.INSTANCE : LE32ArrayIO.INSTANCE;
            }
            if (foreign.isRawParameterPackingEnabled()) {
                ArrayIO arrayIO3 = arrayIO;
                encoder = new RawEncoder(arrayIO3, 0);
            } else {
                ArrayIO arrayIO4 = arrayIO;
                encoder = new DefaultEncoder(arrayIO4);
            }
        }
        HeapInvocationBuffer.encoder = encoder;
    }

    static final class BE64ArrayIO
    extends BigEndianArrayIO {
        static final ArrayIO INSTANCE = new BE64ArrayIO();

        private BE64ArrayIO() {
            super((byte)0);
        }

        public final void putAddress(byte[] buffer, int offset, long value) {
            this.putLong(buffer, offset, value);
        }
    }

    static final class BE32ArrayIO
    extends BigEndianArrayIO {
        static final ArrayIO INSTANCE = new BE32ArrayIO();

        private BE32ArrayIO() {
            super((byte)0);
        }

        public final void putAddress(byte[] buffer, int offset, long value) {
            buffer[offset] = (byte)(value >> 24);
            buffer[offset + 1] = (byte)(value >> 16);
            buffer[offset + 2] = (byte)(value >> 8);
            buffer[offset + 3] = (byte)value;
        }
    }

    static abstract class BigEndianArrayIO
    extends ArrayIO {
        private BigEndianArrayIO() {
            super((byte)0);
        }

        public final void putByte(byte[] buffer, int offset, int value) {
            buffer[offset] = (byte)value;
        }

        public final void putShort(byte[] buffer, int offset, int value) {
            buffer[offset] = (byte)(value >> 8);
            buffer[offset + 1] = (byte)value;
        }

        public final void putInt(byte[] buffer, int offset, int value) {
            buffer[offset] = value >> 24;
            buffer[offset + 1] = (byte)(value >> 16);
            buffer[offset + 2] = (byte)(value >> 8);
            buffer[offset + 3] = (byte)value;
        }

        public final void putLong(byte[] buffer, int offset, long value) {
            buffer[offset] = (byte)(value >> 56);
            buffer[offset + 1] = (byte)(value >> 48);
            buffer[offset + 2] = (byte)(value >> 40);
            buffer[offset + 3] = (byte)(value >> 32);
            buffer[offset + 4] = (byte)(value >> 24);
            buffer[offset + 5] = (byte)(value >> 16);
            buffer[offset + 6] = (byte)(value >> 8);
            buffer[offset + 7] = (byte)value;
        }

        /* synthetic */ BigEndianArrayIO(byte by) {
            this();
        }
    }

    static final class LE64ArrayIO
    extends LittleEndianArrayIO {
        static final ArrayIO INSTANCE = new LE64ArrayIO();

        private LE64ArrayIO() {
            super((byte)0);
        }

        public final void putAddress(byte[] buffer, int offset, long value) {
            this.putLong(buffer, offset, value);
        }
    }

    static final class LE32ArrayIO
    extends LittleEndianArrayIO {
        static final ArrayIO INSTANCE = new LE32ArrayIO();

        private LE32ArrayIO() {
            super((byte)0);
        }

        public final void putAddress(byte[] buffer, int offset, long value) {
            buffer[offset] = (byte)value;
            buffer[offset + 1] = (byte)(value >> 8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = (byte)(value >> 24);
        }
    }

    static abstract class LittleEndianArrayIO
    extends ArrayIO {
        private LittleEndianArrayIO() {
            super((byte)0);
        }

        public final void putByte(byte[] buffer, int offset, int value) {
            buffer[offset] = (byte)value;
        }

        public final void putShort(byte[] buffer, int offset, int value) {
            buffer[offset] = (byte)value;
            buffer[offset + 1] = (byte)(value >> 8);
        }

        public final void putInt(byte[] buffer, int offset, int value) {
            buffer[offset] = (byte)value;
            buffer[offset + 1] = (byte)(value >> 8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = value >> 24;
        }

        public final void putLong(byte[] buffer, int offset, long value) {
            buffer[offset] = (byte)value;
            buffer[offset + 1] = (byte)(value >> 8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = (byte)(value >> 24);
            buffer[offset + 4] = (byte)(value >> 32);
            buffer[offset + 5] = (byte)(value >> 40);
            buffer[offset + 6] = (byte)(value >> 48);
            buffer[offset + 7] = (byte)(value >> 56);
        }

        /* synthetic */ LittleEndianArrayIO(byte by) {
            this();
        }
    }

    static abstract class ArrayIO {
        private ArrayIO() {
        }

        public abstract void putByte(byte[] var1, int var2, int var3);

        public abstract void putShort(byte[] var1, int var2, int var3);

        public abstract void putInt(byte[] var1, int var2, int var3);

        public abstract void putLong(byte[] var1, int var2, long var3);

        public final void putFloat(byte[] buffer, int offset, float value) {
            this.putInt(buffer, offset, Float.floatToRawIntBits(value));
        }

        public final void putDouble(byte[] buffer, int offset, double value) {
            this.putLong(buffer, offset, Double.doubleToRawLongBits(value));
        }

        public abstract void putAddress(byte[] var1, int var2, long var3);

        /* synthetic */ ArrayIO(byte by) {
            this();
        }
    }

    static final class DefaultEncoder
    extends Encoder {
        private final ArrayIO io;

        public DefaultEncoder(ArrayIO io) {
            this.io = io;
        }

        public final int getBufferSize(CallContext callContext) {
            return callContext.getParameterCount() << 3;
        }

        public final int putByte(byte[] buffer, int offset, int value) {
            this.io.putByte(buffer, offset, value);
            return offset + 8;
        }

        public final int putShort(byte[] buffer, int offset, int value) {
            this.io.putShort(buffer, offset, value);
            return offset + 8;
        }

        public final int putInt(byte[] buffer, int offset, int value) {
            this.io.putInt(buffer, offset, value);
            return offset + 8;
        }

        public final int putLong(byte[] buffer, int offset, long value) {
            this.io.putLong(buffer, offset, value);
            return offset + 8;
        }

        public final int putFloat(byte[] buffer, int offset, float value) {
            this.io.putFloat(buffer, offset, value);
            return offset + 8;
        }

        public final int putDouble(byte[] buffer, int offset, double value) {
            this.io.putDouble(buffer, offset, value);
            return offset + 8;
        }

        public final int putAddress(byte[] buffer, int offset, long value) {
            this.io.putAddress(buffer, offset, value);
            return offset + 8;
        }

        public final int skipAddress(int offset) {
            return offset + 8;
        }
    }

    static final class RawEncoder
    extends Encoder {
        private final ArrayIO io;

        private RawEncoder(ArrayIO io) {
            this.io = io;
        }

        public final int getBufferSize(CallContext callContext) {
            return callContext.getRawParameterSize();
        }

        public final int putByte(byte[] buffer, int offset, int value) {
            offset = HeapInvocationBuffer.FFI_ALIGN(offset, FFI_SIZEOF_ARG);
            this.io.putByte(buffer, offset, value);
            return offset + BYTE_SIZE;
        }

        public final int putShort(byte[] buffer, int offset, int value) {
            offset = HeapInvocationBuffer.FFI_ALIGN(offset, FFI_SIZEOF_ARG);
            this.io.putShort(buffer, offset, value);
            return offset + SHORT_SIZE;
        }

        public final int putInt(byte[] buffer, int offset, int value) {
            offset = HeapInvocationBuffer.FFI_ALIGN(offset, FFI_SIZEOF_ARG);
            this.io.putInt(buffer, offset, value);
            return offset + INT_SIZE;
        }

        public final int putLong(byte[] buffer, int offset, long value) {
            offset = HeapInvocationBuffer.FFI_ALIGN(offset, FFI_SIZEOF_ARG);
            this.io.putLong(buffer, offset, value);
            return offset + LONG_SIZE;
        }

        public final int putFloat(byte[] buffer, int offset, float value) {
            offset = HeapInvocationBuffer.FFI_ALIGN(offset, FFI_SIZEOF_ARG);
            this.io.putFloat(buffer, offset, value);
            return offset + FLOAT_SIZE;
        }

        public final int putDouble(byte[] buffer, int offset, double value) {
            offset = HeapInvocationBuffer.FFI_ALIGN(offset, FFI_SIZEOF_ARG);
            this.io.putDouble(buffer, offset, value);
            return offset + DOUBLE_SIZE;
        }

        public final int putAddress(byte[] buffer, int offset, long value) {
            offset = HeapInvocationBuffer.FFI_ALIGN(offset, FFI_SIZEOF_ARG);
            this.io.putAddress(buffer, offset, value);
            return offset + ADDRESS_SIZE;
        }

        public final int skipAddress(int offset) {
            return HeapInvocationBuffer.FFI_ALIGN(offset, FFI_SIZEOF_ARG) + ADDRESS_SIZE;
        }

        /* synthetic */ RawEncoder(ArrayIO x0, byte by) {
            this(x0);
        }
    }

    static final class I386RawEncoder
    extends Encoder {
        private static final ArrayIO IO = LE32ArrayIO.INSTANCE;

        private I386RawEncoder() {
        }

        public final int getBufferSize(CallContext callContext) {
            return callContext.getRawParameterSize();
        }

        public final int putByte(byte[] buffer, int offset, int value) {
            IO.putByte(buffer, offset, value);
            return offset + 4;
        }

        public final int putShort(byte[] buffer, int offset, int value) {
            IO.putShort(buffer, offset, value);
            return offset + 4;
        }

        public final int putInt(byte[] buffer, int offset, int value) {
            IO.putInt(buffer, offset, value);
            return offset + 4;
        }

        public final int putLong(byte[] buffer, int offset, long value) {
            IO.putLong(buffer, offset, value);
            return offset + 8;
        }

        public final int putFloat(byte[] buffer, int offset, float value) {
            IO.putFloat(buffer, offset, value);
            return offset + 4;
        }

        public final int putDouble(byte[] buffer, int offset, double value) {
            IO.putDouble(buffer, offset, value);
            return offset + 8;
        }

        public final int putAddress(byte[] buffer, int offset, long value) {
            IO.putAddress(buffer, offset, value);
            return offset + 4;
        }

        public final int skipAddress(int offset) {
            return offset + 4;
        }

        /* synthetic */ I386RawEncoder(byte by) {
            this();
        }
    }

    static abstract class Encoder {
        static final int BYTE_SIZE;
        static final int SHORT_SIZE;
        static final int INT_SIZE;
        static final int LONG_SIZE;
        static final int FLOAT_SIZE;
        static final int DOUBLE_SIZE;
        static final int ADDRESS_SIZE;
        static final int FFI_SIZEOF_ARG;

        Encoder() {
        }

        public abstract int getBufferSize(CallContext var1);

        public abstract int putByte(byte[] var1, int var2, int var3);

        public abstract int putShort(byte[] var1, int var2, int var3);

        public abstract int putInt(byte[] var1, int var2, int var3);

        public abstract int putLong(byte[] var1, int var2, long var3);

        public abstract int putFloat(byte[] var1, int var2, float var3);

        public abstract int putDouble(byte[] var1, int var2, double var3);

        public abstract int putAddress(byte[] var1, int var2, long var3);

        public abstract int skipAddress(int var1);

        static {
            Type.SINT8.alignment();
            BYTE_SIZE = Type.SINT8.size();
            Type.SSHORT.alignment();
            SHORT_SIZE = Type.SSHORT.size();
            Type.SINT.alignment();
            INT_SIZE = Type.SINT.size();
            Type.SINT64.alignment();
            LONG_SIZE = Type.SINT64.size();
            Type.FLOAT.alignment();
            FLOAT_SIZE = Type.FLOAT.size();
            Type.DOUBLE.alignment();
            DOUBLE_SIZE = Type.DOUBLE.size();
            Type.LONGDOUBLE.alignment();
            Type.LONGDOUBLE.size();
            Type.POINTER.alignment();
            ADDRESS_SIZE = Type.POINTER.size();
            FFI_SIZEOF_ARG = Platform.getPlatform().longSize() == 32 ? 4 : 8;
        }
    }
}

