/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.MemoryIO;
import java.util.concurrent.atomic.AtomicBoolean;
import jnr.ffi.Runtime;
import jnr.ffi.provider.jffi.DirectMemoryIO;
import jnr.ffi.provider.jffi.NativeRuntime;

class AllocatedDirectMemoryIO
extends DirectMemoryIO {
    private final AtomicBoolean allocated = new AtomicBoolean(true);
    private final int size;

    public AllocatedDirectMemoryIO(Runtime runtime, int size, boolean clear) {
        super(runtime, MemoryIO.allocateMemory(size, clear));
        this.size = size;
        if (this.address == 0L) {
            throw new OutOfMemoryError("Failed to allocate " + size + " bytes");
        }
    }

    public AllocatedDirectMemoryIO(int size, boolean clear) {
        this(NativeRuntime.getInstance(), size, clear);
    }

    public long size() {
        return this.size;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AllocatedDirectMemoryIO) {
            AllocatedDirectMemoryIO mem = (AllocatedDirectMemoryIO)obj;
            return mem.size == this.size && mem.address() == this.address;
        }
        return super.equals(obj);
    }

    public String toString() {
        return String.format(this.getClass().getName() + " address=%x size=%d", this.address, this.size());
    }

    public final void dispose() {
        if (this.allocated.getAndSet(false)) {
            MemoryIO.freeMemory(this.address);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.allocated.getAndSet(false)) {
                MemoryIO.freeMemory(this.address);
            }
            return;
        }
        finally {
            super.finalize();
        }
    }
}

