/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.identity;

import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xpath.XPath;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.util.IntStack;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.psvi.ElementPSVI;

public class XPathMatcher {
    protected static final boolean DEBUG_ALL = false;
    protected static final boolean DEBUG_METHODS = false;
    protected static final boolean DEBUG_METHODS2 = false;
    protected static final boolean DEBUG_METHODS3 = false;
    protected static final boolean DEBUG_MATCH = false;
    protected static final boolean DEBUG_STACK = false;
    protected static final boolean DEBUG_ANY = false;
    protected static final int MATCHED = 1;
    protected static final int MATCHED_ATTRIBUTE = 3;
    protected static final int MATCHED_DESCENDANT = 5;
    private XPath.LocationPath[] fLocationPaths;
    private int[] fMatched;
    protected String fMatchedString;
    private IntStack[] fStepIndexes;
    private int[] fCurrentStep;
    private int[] fNoMatchDepth;
    protected SymbolTable fSymbolTable;

    public XPathMatcher(XPath xPath) {
        this.fLocationPaths = xPath.getLocationPaths();
        this.fStepIndexes = new IntStack[this.fLocationPaths.length];
        int n = 0;
        while (n < this.fStepIndexes.length) {
            this.fStepIndexes[n] = new IntStack();
            ++n;
        }
        this.fCurrentStep = new int[this.fLocationPaths.length];
        this.fNoMatchDepth = new int[this.fLocationPaths.length];
        this.fMatched = new int[this.fLocationPaths.length];
    }

    public int isMatched() {
        int n = 0;
        while (n < this.fLocationPaths.length) {
            if ((this.fMatched[n] & 1) == 1) {
                return this.fMatched[n];
            }
            ++n;
        }
        return 0;
    }

    public String getMatchedString() {
        return this.fMatchedString;
    }

    protected void handleContent(XSElementDecl xSElementDecl, ElementPSVI elementPSVI) {
    }

    protected void matched(String string, XSSimpleType xSSimpleType, boolean bl) throws XNIException {
    }

    public void startDocumentFragment(SymbolTable symbolTable) throws XNIException {
        this.fSymbolTable = symbolTable;
        this.fMatchedString = null;
        int n = 0;
        while (n < this.fLocationPaths.length) {
            this.fStepIndexes[n].clear();
            this.fCurrentStep[n] = 0;
            this.fNoMatchDepth[n] = 0;
            this.fMatched[n] = 0;
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void startElement(QName var1_1, XMLAttributes var2_2, XSElementDecl var3_3) throws XNIException {
        var4_4 = 0;
        while (var4_4 < this.fLocationPaths.length) {
            block22: {
                block24: {
                    block23: {
                        block21: {
                            var5_5 = this.fCurrentStep[var4_4];
                            this.fStepIndexes[var4_4].push(var5_5);
                            if ((this.fMatched[var4_4] & 5) != 1 && this.fNoMatchDepth[var4_4] <= 0) break block21;
                            v0 = var4_4;
                            this.fNoMatchDepth[v0] = this.fNoMatchDepth[v0] + 1;
                            break block22;
                        }
                        var6_6 = this.fLocationPaths[var4_4].steps;
                        while (this.fCurrentStep[var4_4] < var6_6.length && var6_6[this.fCurrentStep[var4_4]].axis.type == 3) {
                            v1 = var4_4;
                            this.fCurrentStep[v1] = this.fCurrentStep[v1] + 1;
                        }
                        if (this.fCurrentStep[var4_4] != var6_6.length) break block23;
                        this.fMatched[var4_4] = 1;
                        break block22;
                    }
                    var7_7 = this.fCurrentStep[var4_4];
                    while (this.fCurrentStep[var4_4] < var6_6.length && var6_6[this.fCurrentStep[var4_4]].axis.type == 4) {
                        v2 = var4_4;
                        this.fCurrentStep[v2] = this.fCurrentStep[v2] + 1;
                    }
                    v3 = var8_8 = this.fCurrentStep[var4_4] > var7_7;
                    if (this.fCurrentStep[var4_4] != var6_6.length) break block24;
                    v4 = var4_4;
                    this.fNoMatchDepth[v4] = this.fNoMatchDepth[v4] + 1;
                    break block22;
                }
                if (this.fCurrentStep[var4_4] != var5_5 && this.fCurrentStep[var4_4] <= var7_7 || var6_6[this.fCurrentStep[var4_4]].axis.type != 1) ** GOTO lbl42
                var9_9 = var6_6[this.fCurrentStep[var4_4]];
                var10_11 = var9_9.nodeTest;
                if (var10_11.type == 1 && !var10_11.name.equals(var1_1)) {
                    if (this.fCurrentStep[var4_4] > var7_7) {
                        this.fCurrentStep[var4_4] = var7_7;
                    } else {
                        v5 = var4_4;
                        this.fNoMatchDepth[v5] = this.fNoMatchDepth[v5] + 1;
                    }
                } else {
                    v6 = var4_4;
                    this.fCurrentStep[v6] = this.fCurrentStep[v6] + 1;
lbl42:
                    // 2 sources

                    if (this.fCurrentStep[var4_4] == var6_6.length) {
                        if (var8_8) {
                            this.fCurrentStep[var4_4] = var7_7;
                            this.fMatched[var4_4] = 5;
                        } else {
                            this.fMatched[var4_4] = 1;
                        }
                    } else if (this.fCurrentStep[var4_4] < var6_6.length && var6_6[this.fCurrentStep[var4_4]].axis.type == 2) {
                        var9_10 = var2_2.getLength();
                        if (var9_10 > 0) {
                            var10_11 = var6_6[this.fCurrentStep[var4_4]].nodeTest;
                            var11_12 = new QName();
                            var12_13 = null;
                            if (var3_3 != null && (var13_15 = var3_3.fType) != null && var13_15.getTypeCategory() == 13) {
                                var14_16 = (XSComplexTypeDecl)var13_15;
                                var12_13 = var14_16.getAttrGrp();
                            }
                            var13_14 = 0;
                            while (var13_14 < var9_10) {
                                var2_2.getName(var13_14, var11_12);
                                if (var10_11.type != 1 || var10_11.name.equals(var11_12)) {
                                    v7 = var4_4;
                                    this.fCurrentStep[v7] = this.fCurrentStep[v7] + 1;
                                    if (this.fCurrentStep[var4_4] != var6_6.length) break;
                                    this.fMatched[var4_4] = 3;
                                    var14_17 = 0;
                                    while (var14_17 < var4_4 && (this.fMatched[var14_17] & 1) != 1) {
                                        ++var14_17;
                                    }
                                    if (var14_17 != var4_4) break;
                                    this.fMatchedString = var15_18 = var2_2.getValue(var13_14);
                                    var16_19 = null;
                                    if (var12_13 != null && (var17_20 = var12_13.getAttributeUse(var11_12.uri, var11_12.localpart)) != null) {
                                        var18_21 = var17_20.fAttrDecl;
                                        var16_19 = (XSSimpleType)var18_21.getTypeDefinition();
                                    }
                                    this.matched(this.fMatchedString, var16_19, false);
                                    break;
                                }
                                ++var13_14;
                            }
                        }
                        if ((this.fMatched[var4_4] & 1) != 1) {
                            if (this.fCurrentStep[var4_4] > var7_7) {
                                this.fCurrentStep[var4_4] = var7_7;
                            } else {
                                v8 = var4_4;
                                this.fNoMatchDepth[v8] = this.fNoMatchDepth[v8] + 1;
                            }
                        }
                    }
                }
            }
            ++var4_4;
        }
    }

    public void endElement(QName qName, XSElementDecl xSElementDecl, ElementPSVI elementPSVI) {
        int n = 0;
        while (n < this.fLocationPaths.length) {
            this.fCurrentStep[n] = this.fStepIndexes[n].pop();
            if (this.fNoMatchDepth[n] > 0) {
                int n2 = n;
                this.fNoMatchDepth[n2] = this.fNoMatchDepth[n2] - 1;
            } else {
                int n3 = 0;
                while (n3 < n && (this.fMatched[n3] & 1) != 1) {
                    ++n3;
                }
                if (n3 >= n && this.fMatched[n3] != 0 && (this.fMatched[n3] & 3) != 3) {
                    this.handleContent(xSElementDecl, elementPSVI);
                    this.fMatched[n] = 0;
                }
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = super.toString();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        stringBuffer.append(string);
        int n2 = 0;
        while (n2 < this.fLocationPaths.length) {
            stringBuffer.append('[');
            XPath.Step[] stepArray = this.fLocationPaths[n2].steps;
            int n3 = 0;
            while (n3 < stepArray.length) {
                if (n3 == this.fCurrentStep[n2]) {
                    stringBuffer.append('^');
                }
                stringBuffer.append(stepArray[n2].toString());
                if (n3 < stepArray.length - 1) {
                    stringBuffer.append('/');
                }
                ++n3;
            }
            if (this.fCurrentStep[n2] == stepArray.length) {
                stringBuffer.append('^');
            }
            stringBuffer.append(']');
            stringBuffer.append(',');
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

