/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.filters.DefaultFilter;
import org.cyberneko.html.filters.Identity;
import org.cyberneko.html.filters.Writer;

public class Script
extends DefaultFilter {
    protected static final String AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    protected static final String FILTERS = "http://cyberneko.org/html/properties/filters";
    protected static final String SCRIPT_TYPE = "text/x-nekoscript";
    protected HTMLConfiguration fConfiguration;
    protected StringBuffer fBuffer;
    protected String fSystemId;
    protected int fScriptCount;

    public Script(HTMLConfiguration config) {
        this.fConfiguration = config;
    }

    public void startDocument(XMLLocator locator, String encoding, Augmentations augs) throws XNIException {
        this.fBuffer = null;
        this.fSystemId = locator != null ? locator.getLiteralSystemId() : null;
        this.fScriptCount = 0;
        super.startDocument(locator, encoding, augs);
    }

    public void startElement(QName element, XMLAttributes attrs, Augmentations augs) throws XNIException {
        String value;
        if (element.rawname.equalsIgnoreCase("script") && attrs != null && (value = attrs.getValue("type")) != null && value.equalsIgnoreCase(SCRIPT_TYPE)) {
            this.fBuffer = new StringBuffer();
            return;
        }
        super.startElement(element, attrs, augs);
    }

    public void emptyElement(QName element, XMLAttributes attrs, Augmentations augs) throws XNIException {
        String value;
        if (element.rawname.equalsIgnoreCase("script") && attrs != null && (value = attrs.getValue("type")) != null && value.equalsIgnoreCase(SCRIPT_TYPE)) {
            return;
        }
        super.emptyElement(element, attrs, augs);
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (this.fBuffer != null) {
            this.fBuffer.append(text.ch, text.offset, text.length);
        } else {
            super.characters(text, augs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(QName element, Augmentations augs) throws XNIException {
        if (this.fBuffer != null) {
            try {
                String line;
                BufferedReader in = new BufferedReader(new StringReader(this.fBuffer.toString()));
                StringWriter sout = new StringWriter();
                PrintWriter out = new PrintWriter(sout);
                while ((line = in.readLine()) != null) {
                    line.trim();
                    if (line.length() == 0) continue;
                    switch (line.charAt(0)) {
                        case '(': {
                            out.print('<');
                            out.print(line.substring(1));
                            out.print('>');
                            break;
                        }
                        case '\"': {
                            out.print(line.substring(1));
                            break;
                        }
                        case ')': {
                            out.print("</");
                            out.print(line.substring(1));
                            out.print('>');
                        }
                    }
                }
                String systemId = this.fSystemId != null ? this.fSystemId + '_' : "";
                ++this.fScriptCount;
                systemId = systemId + "script" + this.fScriptCount;
                XMLInputSource source = new XMLInputSource(null, systemId, null, (Reader)new StringReader(sout.toString()), "UTF-8");
                this.fConfiguration.pushInputSource(source);
            }
            catch (IOException iOException) {
            }
            finally {
                this.fBuffer = null;
            }
        } else {
            super.endElement(element, augs);
        }
    }

    public static void main(String[] argv) throws Exception {
        HTMLConfiguration parser = new HTMLConfiguration();
        parser.setFeature(AUGMENTATIONS, true);
        XMLDocumentFilter[] filters = new XMLDocumentFilter[]{new Script(parser), new Identity(), new Writer()};
        parser.setProperty(FILTERS, (Object)filters);
        for (int i = 0; i < argv.length; ++i) {
            parser.parse(new XMLInputSource(null, argv[i], null));
        }
    }
}

