package org.apache.lucene.codecs.lucene40;

import java.io.IOException;

import org.apache.lucene.codecs.BlockTreeTermsWriter;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.LuceneTestCase;

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Read-write version of {@link Lucene40PostingsFormat} for testing.
 */
@SuppressWarnings("deprecation")
public class Lucene40RWPostingsFormat extends Lucene40PostingsFormat {
  
  @Override
  public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
    if (!LuceneTestCase.OLD_FORMAT_IMPERSONATION_IS_ACTIVE) {
      return super.fieldsConsumer(state);
    } else {
      PostingsWriterBase docs = new Lucene40PostingsWriter(state);
      
      // TODO: should we make the terms index more easily
      // pluggable?  Ie so that this codec would record which
      // index impl was used, and switch on loading?
      // Or... you must make a new Codec for this?
      boolean success = false;
      try {
        FieldsConsumer ret = new BlockTreeTermsWriter(state, docs, minBlockSize, maxBlockSize);
        success = true;
        return ret;
      } finally {
        if (!success) {
          docs.close();
        }
      }
    }
  }
}
