/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.easymock.ArgumentsMatcher;
import org.easymock.MockControl;
import org.easymock.internal.RuntimeExceptionWrapper;

public class LegacyMatcherProvider {
    private ArgumentsMatcher defaultMatcher;
    private boolean defaultMatcherSet;
    private Map<Method, ArgumentsMatcher> matchers = new HashMap<Method, ArgumentsMatcher>();

    public ArgumentsMatcher getMatcher(Method method) {
        if (!this.matchers.containsKey(method)) {
            if (!this.defaultMatcherSet) {
                this.setDefaultMatcher(MockControl.EQUALS_MATCHER);
            }
            this.matchers.put(method, this.defaultMatcher);
        }
        return this.matchers.get(method);
    }

    public void setDefaultMatcher(ArgumentsMatcher matcher) {
        if (this.defaultMatcherSet) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("default matcher can only be set once directly after creation of the MockControl"));
        }
        this.defaultMatcher = matcher;
        this.defaultMatcherSet = true;
    }

    public void setMatcher(Method method, ArgumentsMatcher matcher) {
        if (this.matchers.containsKey(method) && this.matchers.get(method) != matcher) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("for method " + method.getName() + "(" + (method.getParameterTypes().length == 0 ? "" : "...") + "), a matcher has already been set"));
        }
        this.matchers.put(method, matcher);
    }
}

