/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import org.testng.IConfigureCallBack;
import org.testng.IHookCallBack;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.annotations.DataProvider;
import org.testng.collections.Lists;
import org.testng.internal.InvokeMethodRunnable;
import org.testng.internal.MethodHelper;
import org.testng.internal.TestResult;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.thread.IExecutor;
import org.testng.internal.thread.IFutureResult;
import org.testng.internal.thread.ThreadExecutionException;
import org.testng.internal.thread.ThreadTimeoutException;
import org.testng.internal.thread.ThreadUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInvocationHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object invokeMethod(Method thisMethod, Object instance, Object[] parameters) throws InvocationTargetException, IllegalAccessException {
        block11: {
            boolean isStatic;
            Object result = null;
            Utils.checkInstanceOrStatic(instance, thisMethod);
            if (!(instance != null && thisMethod.getDeclaringClass().isAssignableFrom(instance.getClass()) || (isStatic = Modifier.isStatic(thisMethod.getModifiers())))) {
                Class<?> clazz;
                try {
                    thisMethod = clazz.getMethod(thisMethod.getName(), thisMethod.getParameterTypes());
                }
                catch (Exception e) {
                    boolean found = false;
                    for (clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                        try {
                            thisMethod = clazz.getDeclaredMethod(thisMethod.getName(), thisMethod.getParameterTypes());
                            found = true;
                            break;
                        }
                        catch (Exception e2) {
                            continue;
                        }
                    }
                    if (found) break block11;
                    if (thisMethod.getDeclaringClass().getName().equals(instance.getClass().getName())) {
                        throw new RuntimeException("Can't invoke method " + thisMethod + ", probably due to classloader mismatch");
                    }
                    throw new RuntimeException("Can't invoke method " + thisMethod + " on this instance of " + instance.getClass() + " due to class mismatch");
                }
            }
        }
        Method method = thisMethod;
        synchronized (method) {
            if (!Modifier.isPublic(thisMethod.getModifiers())) {
                thisMethod.setAccessible(true);
            }
        }
        return thisMethod.invoke(instance, parameters);
    }

    protected static Iterator<Object[]> invokeDataProvider(Object instance, Method dataProvider, ITestNGMethod method, ITestContext testContext, Object fedInstance, IAnnotationFinder annotationFinder) {
        Iterator<Object[]> result;
        block12: {
            result = null;
            Method testMethod = method.getMethod();
            try {
                List lParameters = Lists.newArrayList();
                Class<?>[] parameterTypes = dataProvider.getParameterTypes();
                if (parameterTypes.length > 2) {
                    throw new TestNGException("DataProvider " + dataProvider + " cannot have more than two parameters");
                }
                int i = 0;
                for (Class<?> cls : parameterTypes) {
                    boolean isTestInstance = annotationFinder.hasTestInstance(dataProvider, i++);
                    if (cls.equals(Method.class)) {
                        lParameters.add(testMethod);
                        continue;
                    }
                    if (cls.equals(ITestContext.class)) {
                        lParameters.add(testContext);
                        continue;
                    }
                    if (!isTestInstance) continue;
                    lParameters.add(fedInstance);
                }
                Object[] parameters = lParameters.toArray(new Object[lParameters.size()]);
                Class<?> returnType = dataProvider.getReturnType();
                if (Object[][].class.isAssignableFrom(returnType)) {
                    Object[][] oResult;
                    Object[][] originalResult = (Object[][])MethodInvocationHelper.invokeMethod(dataProvider, instance, parameters);
                    int[] indices = dataProvider.getAnnotation(DataProvider.class).indices();
                    if (indices.length > 0) {
                        oResult = new Object[indices.length][];
                        for (int j = 0; j < indices.length; ++j) {
                            oResult[j] = originalResult[indices[j]];
                        }
                    } else {
                        oResult = originalResult;
                    }
                    method.setParameterInvocationCount(oResult.length);
                    result = MethodHelper.createArrayIterator(oResult);
                    break block12;
                }
                if (Iterator.class.isAssignableFrom(returnType)) {
                    result = (Iterator<Object[]>)MethodInvocationHelper.invokeMethod(dataProvider, instance, parameters);
                    break block12;
                }
                throw new TestNGException("Data Provider " + dataProvider + " must return" + " either Object[][] or Iterator<Object>[], not " + returnType);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.getCause());
            }
        }
        return result;
    }

    protected static void invokeHookable(final Object testInstance, final Object[] parameters, Object hookableInstance, final Method thisMethod, TestResult testResult) throws Throwable {
        Method runMethod = hookableInstance.getClass().getMethod("run", IHookCallBack.class, ITestResult.class);
        final Throwable[] error = new Throwable[1];
        IHookCallBack callback = new IHookCallBack(){

            public void runTestMethod(ITestResult tr) {
                try {
                    MethodInvocationHelper.invokeMethod(thisMethod, testInstance, parameters);
                }
                catch (Throwable t) {
                    error[0] = t;
                    tr.setThrowable(t);
                }
            }

            public Object[] getParameters() {
                return parameters;
            }
        };
        runMethod.invoke(hookableInstance, callback, testResult);
        if (error[0] != null) {
            throw error[0];
        }
    }

    protected static void invokeWithTimeout(ITestNGMethod tm, Object instance, Object[] parameterValues, ITestResult testResult) throws InterruptedException, ThreadExecutionException {
        if (ThreadUtil.isTestNGThread()) {
            MethodInvocationHelper.invokeWithTimeoutWithNoExecutor(tm, instance, parameterValues, testResult);
        } else {
            MethodInvocationHelper.invokeWithTimeoutWithNewExecutor(tm, instance, parameterValues, testResult);
        }
    }

    private static void invokeWithTimeoutWithNoExecutor(ITestNGMethod tm, Object instance, Object[] parameterValues, ITestResult testResult) {
        InvokeMethodRunnable imr = new InvokeMethodRunnable(tm, instance, parameterValues);
        try {
            imr.run();
            testResult.setStatus(1);
        }
        catch (Exception ex) {
            testResult.setThrowable(ex.getCause());
            testResult.setStatus(2);
        }
    }

    private static void invokeWithTimeoutWithNewExecutor(ITestNGMethod tm, Object instance, Object[] parameterValues, ITestResult testResult) throws InterruptedException, ThreadExecutionException {
        IExecutor exec = ThreadUtil.createExecutor(1, tm.getMethod().getName());
        InvokeMethodRunnable imr = new InvokeMethodRunnable(tm, instance, parameterValues);
        IFutureResult future = exec.submitRunnable(imr);
        exec.shutdown();
        long realTimeOut = MethodHelper.calculateTimeOut(tm);
        boolean finished = exec.awaitTermination(realTimeOut);
        if (!finished) {
            exec.stopNow();
            ThreadTimeoutException exception = new ThreadTimeoutException("Method " + tm.getClass().getName() + "." + tm.getMethodName() + "()" + " didn't finish within the time-out " + realTimeOut);
            exception.setStackTrace(exec.getStackTraces()[0]);
            testResult.setThrowable(exception);
            testResult.setStatus(2);
        } else {
            Utils.log("Invoker " + Thread.currentThread().hashCode(), 3, "Method " + tm.getMethod() + " completed within the time-out " + tm.getTimeOut());
            future.get();
            testResult.setStatus(1);
        }
    }

    protected static void invokeConfigurable(final Object instance, final Object[] parameters, Object configurableInstance, final Method thisMethod, ITestResult testResult) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, Throwable {
        Method runMethod = configurableInstance.getClass().getMethod("run", IConfigureCallBack.class, ITestResult.class);
        final Throwable[] error = new Throwable[1];
        IConfigureCallBack callback = new IConfigureCallBack(){

            public void runConfigurationMethod(ITestResult tr) {
                try {
                    MethodInvocationHelper.invokeMethod(thisMethod, instance, parameters);
                }
                catch (Throwable t) {
                    error[0] = t;
                    tr.setThrowable(t);
                }
            }

            public Object[] getParameters() {
                return parameters;
            }
        };
        runMethod.invoke(configurableInstance, callback, testResult);
        if (error[0] != null) {
            throw error[0];
        }
    }
}

