/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.constraint;

import java.util.Map;
import org.jmock.core.Constraint;

public class IsMapContaining
implements Constraint {
    private final Constraint keyConstraint;
    private final Constraint valueConstraint;

    public IsMapContaining(Constraint keyConstraint, Constraint valueConstraint) {
        this.keyConstraint = keyConstraint;
        this.valueConstraint = valueConstraint;
    }

    public boolean eval(Object o) {
        if (o != null && o instanceof Map) {
            Map map = (Map)o;
            for (Map.Entry entry : map.entrySet()) {
                if (!this.keyConstraint.eval(entry.getKey()) || !this.valueConstraint.eval(entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public StringBuffer describeTo(StringBuffer buffer) {
        buffer.append("map containing [");
        this.keyConstraint.describeTo(buffer);
        buffer.append("->");
        this.valueConstraint.describeTo(buffer);
        buffer.append("]");
        return buffer;
    }
}

