# Try to find libmodulemd 2.3+
#
#  LIBMODULEMD_FOUND - system has libmodulemd
#  LIBMODULEMD_INCLUDE_DIRS - the libmodulemd include directory
#  LIBMODULEMD_LIBRARIES - Link these to use libmodulemd
#
#  Copyright (c) 2019 Stephen Gallagher <sgallagh@redhat.com>

#  Redistribution and use is allowed according to the terms of the New
#  BSD license.

IF ( LIBMODULEMD_LIBRARIES AND LIBMODULEMD_INCLUDE_DIRS )
  # in cache already
  SET(LIBMODULEMD_FOUND TRUE)
ELSE ( LIBMODULEMD_LIBRARIES AND LIBMODULEMD_INCLUDE_DIRS )

	INCLUDE(FindPkgConfig)

	IF ( LIBMODULEMD_FIND_REQUIRED )
		SET ( _pkgconfig_REQUIRED "REQUIRED" )
	ELSE ( LIBMODULEMD_FIND_REQUIRED )
		SET ( _pkgconfig_REQUIRED "" )
	endif ( LIBMODULEMD_FIND_REQUIRED )

	PKG_SEARCH_MODULE ( LIBMODULEMD ${_pkgconfig_REQUIRED} modulemd-2.0>=2.3 )

	IF (LIBMODULEMD_FOUND)
    IF (NOT LIBMODULEMD_FIND_QUIETLY)
      MESSAGE (STATUS "Found libmodulemd: ${LIBMODULEMD_LIBRARIES} ${LIBMODULEMD_INCLUDE_DIRS}")
    ENDIF (NOT LIBMODULEMD_FIND_QUIETLY)
  ELSE (LIBMODULEMD_FOUND)
    IF (LIBMODULEMD_FIND_REQUIRED)
      MESSAGE (SEND_ERROR "Could not find libmodulemd")
    ENDIF (LIBMODULEMD_FIND_REQUIRED)
  ENDIF (LIBMODULEMD_FOUND)

  # show the LIBMODULEMD_INCLUDE_DIRS and LIBMODULEMD_LIBRARIES variables only in the advanced view
  MARK_AS_ADVANCED(LIBMODULEMD_INCLUDE_DIRS LIBMODULEMD_LIBRARIES)

ENDIF ( LIBMODULEMD_LIBRARIES AND LIBMODULEMD_INCLUDE_DIRS )
