# Blackfin testcase for divide instructions
# mach: bfin


	.include "testutils.inc"

	start

	/*
	 * Evaluate given a signed integer dividend and signed interger divisor
	 * input is:
	 *  r0 = dividend, or numerator
	 *  r1 = divisor, or denominator
	 * output is:
	 *  r0 = quotient (16-bits)
	 */
	.macro divide num:req, den:req
	imm32 r0 \num
	r1 = \den (Z);

	r0 <<= 1;	/* Left shift dividend by 1 needed for integer division */
	p0 = 15;	/* Evaluate the quotient to 16 bits. */

	/* Initialize AQ status bit and dividend for the DIVQ loop. */
	divs (r0, r1);

	/* Evaluate DIVQ p0=15 times. */
	lsetup (1f, 1f) lc0=p0;
1:
	divq (r0, r1);

	/* Sign extend the 16-bit quotient to 32bits.  */
	r0 = r0.l (x);

	imm32 r1, (\num / \den);
	CC = r0 == r1
	if CC jump 2f;
	fail
2:
	.endm

	/* test a bunch of values, making sure not to :
	 * - exceed a signed 16-bit divisor
	 * - exceed a signed 16-bit answer
	 */
        divide  0x00000001, 0x0001      /* expect 0x0001 */
        divide  0x00000001, 0x0002      /* expect 0x0000 */
        divide  0x00000001, 0x0003      /* expect 0x0000 */
        divide  0x00000001, 0x0004      /* expect 0x0000 */
        divide  0x00000001, 0x0007      /* expect 0x0000 */
        divide  0x00000001, 0x0008      /* expect 0x0000 */
        divide  0x00000001, 0x000f      /* expect 0x0000 */
        divide  0x00000001, 0x0010      /* expect 0x0000 */
        divide  0x00000001, 0x001f      /* expect 0x0000 */
        divide  0x00000001, 0x0020      /* expect 0x0000 */
        divide  0x00000001, 0x003f      /* expect 0x0000 */
        divide  0x00000001, 0x0040      /* expect 0x0000 */
        divide  0x00000001, 0x007f      /* expect 0x0000 */
        divide  0x00000001, 0x0080      /* expect 0x0000 */
        divide  0x00000001, 0x00ff      /* expect 0x0000 */
        divide  0x00000001, 0x0100      /* expect 0x0000 */
        divide  0x00000001, 0x01ff      /* expect 0x0000 */
        divide  0x00000001, 0x0200      /* expect 0x0000 */
        divide  0x00000001, 0x03ff      /* expect 0x0000 */
        divide  0x00000001, 0x0400      /* expect 0x0000 */
        divide  0x00000001, 0x07ff      /* expect 0x0000 */
        divide  0x00000001, 0x0800      /* expect 0x0000 */
        divide  0x00000001, 0x0fff      /* expect 0x0000 */
        divide  0x00000001, 0x1000      /* expect 0x0000 */
        divide  0x00000001, 0x1fff      /* expect 0x0000 */
        divide  0x00000001, 0x2000      /* expect 0x0000 */
        divide  0x00000001, 0x3fff      /* expect 0x0000 */
        divide  0x00000001, 0x4000      /* expect 0x0000 */
        divide  0x00000001, 0x7fff      /* expect 0x0000 */
        divide  0x00000002, 0x0001      /* expect 0x0002 */
        divide  0x00000002, 0x0002      /* expect 0x0001 */
        divide  0x00000002, 0x0003      /* expect 0x0000 */
        divide  0x00000002, 0x0004      /* expect 0x0000 */
        divide  0x00000002, 0x0007      /* expect 0x0000 */
        divide  0x00000002, 0x0008      /* expect 0x0000 */
        divide  0x00000002, 0x000f      /* expect 0x0000 */
        divide  0x00000002, 0x0010      /* expect 0x0000 */
        divide  0x00000002, 0x001f      /* expect 0x0000 */
        divide  0x00000002, 0x0020      /* expect 0x0000 */
        divide  0x00000002, 0x003f      /* expect 0x0000 */
        divide  0x00000002, 0x0040      /* expect 0x0000 */
        divide  0x00000002, 0x007f      /* expect 0x0000 */
        divide  0x00000002, 0x0080      /* expect 0x0000 */
        divide  0x00000002, 0x00ff      /* expect 0x0000 */
        divide  0x00000002, 0x0100      /* expect 0x0000 */
        divide  0x00000002, 0x01ff      /* expect 0x0000 */
        divide  0x00000002, 0x0200      /* expect 0x0000 */
        divide  0x00000002, 0x03ff      /* expect 0x0000 */
        divide  0x00000002, 0x0400      /* expect 0x0000 */
        divide  0x00000002, 0x07ff      /* expect 0x0000 */
        divide  0x00000002, 0x0800      /* expect 0x0000 */
        divide  0x00000002, 0x0fff      /* expect 0x0000 */
        divide  0x00000002, 0x1000      /* expect 0x0000 */
        divide  0x00000002, 0x1fff      /* expect 0x0000 */
        divide  0x00000002, 0x2000      /* expect 0x0000 */
        divide  0x00000002, 0x3fff      /* expect 0x0000 */
        divide  0x00000002, 0x4000      /* expect 0x0000 */
        divide  0x00000002, 0x7fff      /* expect 0x0000 */
        divide  0x00000003, 0x0001      /* expect 0x0003 */
        divide  0x00000003, 0x0002      /* expect 0x0001 */
        divide  0x00000003, 0x0003      /* expect 0x0001 */
        divide  0x00000003, 0x0004      /* expect 0x0000 */
        divide  0x00000003, 0x0007      /* expect 0x0000 */
        divide  0x00000003, 0x0008      /* expect 0x0000 */
        divide  0x00000003, 0x000f      /* expect 0x0000 */
        divide  0x00000003, 0x0010      /* expect 0x0000 */
        divide  0x00000003, 0x001f      /* expect 0x0000 */
        divide  0x00000003, 0x0020      /* expect 0x0000 */
        divide  0x00000003, 0x003f      /* expect 0x0000 */
        divide  0x00000003, 0x0040      /* expect 0x0000 */
        divide  0x00000003, 0x007f      /* expect 0x0000 */
        divide  0x00000003, 0x0080      /* expect 0x0000 */
        divide  0x00000003, 0x00ff      /* expect 0x0000 */
        divide  0x00000003, 0x0100      /* expect 0x0000 */
        divide  0x00000003, 0x01ff      /* expect 0x0000 */
        divide  0x00000003, 0x0200      /* expect 0x0000 */
        divide  0x00000003, 0x03ff      /* expect 0x0000 */
        divide  0x00000003, 0x0400      /* expect 0x0000 */
        divide  0x00000003, 0x07ff      /* expect 0x0000 */
        divide  0x00000003, 0x0800      /* expect 0x0000 */
        divide  0x00000003, 0x0fff      /* expect 0x0000 */
        divide  0x00000003, 0x1000      /* expect 0x0000 */
        divide  0x00000003, 0x1fff      /* expect 0x0000 */
        divide  0x00000003, 0x2000      /* expect 0x0000 */
        divide  0x00000003, 0x3fff      /* expect 0x0000 */
        divide  0x00000003, 0x4000      /* expect 0x0000 */
        divide  0x00000003, 0x7fff      /* expect 0x0000 */
        divide  0x00000004, 0x0001      /* expect 0x0004 */
        divide  0x00000004, 0x0002      /* expect 0x0002 */
        divide  0x00000004, 0x0003      /* expect 0x0001 */
        divide  0x00000004, 0x0004      /* expect 0x0001 */
        divide  0x00000004, 0x0007      /* expect 0x0000 */
        divide  0x00000004, 0x0008      /* expect 0x0000 */
        divide  0x00000004, 0x000f      /* expect 0x0000 */
        divide  0x00000004, 0x0010      /* expect 0x0000 */
        divide  0x00000004, 0x001f      /* expect 0x0000 */
        divide  0x00000004, 0x0020      /* expect 0x0000 */
        divide  0x00000004, 0x003f      /* expect 0x0000 */
        divide  0x00000004, 0x0040      /* expect 0x0000 */
        divide  0x00000004, 0x007f      /* expect 0x0000 */
        divide  0x00000004, 0x0080      /* expect 0x0000 */
        divide  0x00000004, 0x00ff      /* expect 0x0000 */
        divide  0x00000004, 0x0100      /* expect 0x0000 */
        divide  0x00000004, 0x01ff      /* expect 0x0000 */
        divide  0x00000004, 0x0200      /* expect 0x0000 */
        divide  0x00000004, 0x03ff      /* expect 0x0000 */
        divide  0x00000004, 0x0400      /* expect 0x0000 */
        divide  0x00000004, 0x07ff      /* expect 0x0000 */
        divide  0x00000004, 0x0800      /* expect 0x0000 */
        divide  0x00000004, 0x0fff      /* expect 0x0000 */
        divide  0x00000004, 0x1000      /* expect 0x0000 */
        divide  0x00000004, 0x1fff      /* expect 0x0000 */
        divide  0x00000004, 0x2000      /* expect 0x0000 */
        divide  0x00000004, 0x3fff      /* expect 0x0000 */
        divide  0x00000004, 0x4000      /* expect 0x0000 */
        divide  0x00000004, 0x7fff      /* expect 0x0000 */
        divide  0x00000007, 0x0001      /* expect 0x0007 */
        divide  0x00000007, 0x0002      /* expect 0x0003 */
        divide  0x00000007, 0x0003      /* expect 0x0002 */
        divide  0x00000007, 0x0004      /* expect 0x0001 */
        divide  0x00000007, 0x0007      /* expect 0x0001 */
        divide  0x00000007, 0x0008      /* expect 0x0000 */
        divide  0x00000007, 0x000f      /* expect 0x0000 */
        divide  0x00000007, 0x0010      /* expect 0x0000 */
        divide  0x00000007, 0x001f      /* expect 0x0000 */
        divide  0x00000007, 0x0020      /* expect 0x0000 */
        divide  0x00000007, 0x003f      /* expect 0x0000 */
        divide  0x00000007, 0x0040      /* expect 0x0000 */
        divide  0x00000007, 0x007f      /* expect 0x0000 */
        divide  0x00000007, 0x0080      /* expect 0x0000 */
        divide  0x00000007, 0x00ff      /* expect 0x0000 */
        divide  0x00000007, 0x0100      /* expect 0x0000 */
        divide  0x00000007, 0x01ff      /* expect 0x0000 */
        divide  0x00000007, 0x0200      /* expect 0x0000 */
        divide  0x00000007, 0x03ff      /* expect 0x0000 */
        divide  0x00000007, 0x0400      /* expect 0x0000 */
        divide  0x00000007, 0x07ff      /* expect 0x0000 */
        divide  0x00000007, 0x0800      /* expect 0x0000 */
        divide  0x00000007, 0x0fff      /* expect 0x0000 */
        divide  0x00000007, 0x1000      /* expect 0x0000 */
        divide  0x00000007, 0x1fff      /* expect 0x0000 */
        divide  0x00000007, 0x2000      /* expect 0x0000 */
        divide  0x00000007, 0x3fff      /* expect 0x0000 */
        divide  0x00000007, 0x4000      /* expect 0x0000 */
        divide  0x00000007, 0x7fff      /* expect 0x0000 */
        divide  0x00000008, 0x0001      /* expect 0x0008 */
        divide  0x00000008, 0x0002      /* expect 0x0004 */
        divide  0x00000008, 0x0003      /* expect 0x0002 */
        divide  0x00000008, 0x0004      /* expect 0x0002 */
        divide  0x00000008, 0x0007      /* expect 0x0001 */
        divide  0x00000008, 0x0008      /* expect 0x0001 */
        divide  0x00000008, 0x000f      /* expect 0x0000 */
        divide  0x00000008, 0x0010      /* expect 0x0000 */
        divide  0x00000008, 0x001f      /* expect 0x0000 */
        divide  0x00000008, 0x0020      /* expect 0x0000 */
        divide  0x00000008, 0x003f      /* expect 0x0000 */
        divide  0x00000008, 0x0040      /* expect 0x0000 */
        divide  0x00000008, 0x007f      /* expect 0x0000 */
        divide  0x00000008, 0x0080      /* expect 0x0000 */
        divide  0x00000008, 0x00ff      /* expect 0x0000 */
        divide  0x00000008, 0x0100      /* expect 0x0000 */
        divide  0x00000008, 0x01ff      /* expect 0x0000 */
        divide  0x00000008, 0x0200      /* expect 0x0000 */
        divide  0x00000008, 0x03ff      /* expect 0x0000 */
        divide  0x00000008, 0x0400      /* expect 0x0000 */
        divide  0x00000008, 0x07ff      /* expect 0x0000 */
        divide  0x00000008, 0x0800      /* expect 0x0000 */
        divide  0x00000008, 0x0fff      /* expect 0x0000 */
        divide  0x00000008, 0x1000      /* expect 0x0000 */
        divide  0x00000008, 0x1fff      /* expect 0x0000 */
        divide  0x00000008, 0x2000      /* expect 0x0000 */
        divide  0x00000008, 0x3fff      /* expect 0x0000 */
        divide  0x00000008, 0x4000      /* expect 0x0000 */
        divide  0x00000008, 0x7fff      /* expect 0x0000 */
        divide  0x0000000f, 0x0001      /* expect 0x000f */
        divide  0x0000000f, 0x0002      /* expect 0x0007 */
        divide  0x0000000f, 0x0003      /* expect 0x0005 */
        divide  0x0000000f, 0x0004      /* expect 0x0003 */
        divide  0x0000000f, 0x0007      /* expect 0x0002 */
        divide  0x0000000f, 0x0008      /* expect 0x0001 */
        divide  0x0000000f, 0x000f      /* expect 0x0001 */
        divide  0x0000000f, 0x0010      /* expect 0x0000 */
        divide  0x0000000f, 0x001f      /* expect 0x0000 */
        divide  0x0000000f, 0x0020      /* expect 0x0000 */
        divide  0x0000000f, 0x003f      /* expect 0x0000 */
        divide  0x0000000f, 0x0040      /* expect 0x0000 */
        divide  0x0000000f, 0x007f      /* expect 0x0000 */
        divide  0x0000000f, 0x0080      /* expect 0x0000 */
        divide  0x0000000f, 0x00ff      /* expect 0x0000 */
        divide  0x0000000f, 0x0100      /* expect 0x0000 */
        divide  0x0000000f, 0x01ff      /* expect 0x0000 */
        divide  0x0000000f, 0x0200      /* expect 0x0000 */
        divide  0x0000000f, 0x03ff      /* expect 0x0000 */
        divide  0x0000000f, 0x0400      /* expect 0x0000 */
        divide  0x0000000f, 0x07ff      /* expect 0x0000 */
        divide  0x0000000f, 0x0800      /* expect 0x0000 */
        divide  0x0000000f, 0x0fff      /* expect 0x0000 */
        divide  0x0000000f, 0x1000      /* expect 0x0000 */
        divide  0x0000000f, 0x1fff      /* expect 0x0000 */
        divide  0x0000000f, 0x2000      /* expect 0x0000 */
        divide  0x0000000f, 0x3fff      /* expect 0x0000 */
        divide  0x0000000f, 0x4000      /* expect 0x0000 */
        divide  0x0000000f, 0x7fff      /* expect 0x0000 */
        divide  0x00000010, 0x0001      /* expect 0x0010 */
        divide  0x00000010, 0x0002      /* expect 0x0008 */
        divide  0x00000010, 0x0003      /* expect 0x0005 */
        divide  0x00000010, 0x0004      /* expect 0x0004 */
        divide  0x00000010, 0x0007      /* expect 0x0002 */
        divide  0x00000010, 0x0008      /* expect 0x0002 */
        divide  0x00000010, 0x000f      /* expect 0x0001 */
        divide  0x00000010, 0x0010      /* expect 0x0001 */
        divide  0x00000010, 0x001f      /* expect 0x0000 */
        divide  0x00000010, 0x0020      /* expect 0x0000 */
        divide  0x00000010, 0x003f      /* expect 0x0000 */
        divide  0x00000010, 0x0040      /* expect 0x0000 */
        divide  0x00000010, 0x007f      /* expect 0x0000 */
        divide  0x00000010, 0x0080      /* expect 0x0000 */
        divide  0x00000010, 0x00ff      /* expect 0x0000 */
        divide  0x00000010, 0x0100      /* expect 0x0000 */
        divide  0x00000010, 0x01ff      /* expect 0x0000 */
        divide  0x00000010, 0x0200      /* expect 0x0000 */
        divide  0x00000010, 0x03ff      /* expect 0x0000 */
        divide  0x00000010, 0x0400      /* expect 0x0000 */
        divide  0x00000010, 0x07ff      /* expect 0x0000 */
        divide  0x00000010, 0x0800      /* expect 0x0000 */
        divide  0x00000010, 0x0fff      /* expect 0x0000 */
        divide  0x00000010, 0x1000      /* expect 0x0000 */
        divide  0x00000010, 0x1fff      /* expect 0x0000 */
        divide  0x00000010, 0x2000      /* expect 0x0000 */
        divide  0x00000010, 0x3fff      /* expect 0x0000 */
        divide  0x00000010, 0x4000      /* expect 0x0000 */
        divide  0x00000010, 0x7fff      /* expect 0x0000 */
        divide  0x0000001f, 0x0001      /* expect 0x001f */
        divide  0x0000001f, 0x0002      /* expect 0x000f */
        divide  0x0000001f, 0x0003      /* expect 0x000a */
        divide  0x0000001f, 0x0004      /* expect 0x0007 */
        divide  0x0000001f, 0x0007      /* expect 0x0004 */
        divide  0x0000001f, 0x0008      /* expect 0x0003 */
        divide  0x0000001f, 0x000f      /* expect 0x0002 */
        divide  0x0000001f, 0x0010      /* expect 0x0001 */
        divide  0x0000001f, 0x001f      /* expect 0x0001 */
        divide  0x0000001f, 0x0020      /* expect 0x0000 */
        divide  0x0000001f, 0x003f      /* expect 0x0000 */
        divide  0x0000001f, 0x0040      /* expect 0x0000 */
        divide  0x0000001f, 0x007f      /* expect 0x0000 */
        divide  0x0000001f, 0x0080      /* expect 0x0000 */
        divide  0x0000001f, 0x00ff      /* expect 0x0000 */
        divide  0x0000001f, 0x0100      /* expect 0x0000 */
        divide  0x0000001f, 0x01ff      /* expect 0x0000 */
        divide  0x0000001f, 0x0200      /* expect 0x0000 */
        divide  0x0000001f, 0x03ff      /* expect 0x0000 */
        divide  0x0000001f, 0x0400      /* expect 0x0000 */
        divide  0x0000001f, 0x07ff      /* expect 0x0000 */
        divide  0x0000001f, 0x0800      /* expect 0x0000 */
        divide  0x0000001f, 0x0fff      /* expect 0x0000 */
        divide  0x0000001f, 0x1000      /* expect 0x0000 */
        divide  0x0000001f, 0x1fff      /* expect 0x0000 */
        divide  0x0000001f, 0x2000      /* expect 0x0000 */
        divide  0x0000001f, 0x3fff      /* expect 0x0000 */
        divide  0x0000001f, 0x4000      /* expect 0x0000 */
        divide  0x0000001f, 0x7fff      /* expect 0x0000 */
        divide  0x00000020, 0x0001      /* expect 0x0020 */
        divide  0x00000020, 0x0002      /* expect 0x0010 */
        divide  0x00000020, 0x0003      /* expect 0x000a */
        divide  0x00000020, 0x0004      /* expect 0x0008 */
        divide  0x00000020, 0x0007      /* expect 0x0004 */
        divide  0x00000020, 0x0008      /* expect 0x0004 */
        divide  0x00000020, 0x000f      /* expect 0x0002 */
        divide  0x00000020, 0x0010      /* expect 0x0002 */
        divide  0x00000020, 0x001f      /* expect 0x0001 */
        divide  0x00000020, 0x0020      /* expect 0x0001 */
        divide  0x00000020, 0x003f      /* expect 0x0000 */
        divide  0x00000020, 0x0040      /* expect 0x0000 */
        divide  0x00000020, 0x007f      /* expect 0x0000 */
        divide  0x00000020, 0x0080      /* expect 0x0000 */
        divide  0x00000020, 0x00ff      /* expect 0x0000 */
        divide  0x00000020, 0x0100      /* expect 0x0000 */
        divide  0x00000020, 0x01ff      /* expect 0x0000 */
        divide  0x00000020, 0x0200      /* expect 0x0000 */
        divide  0x00000020, 0x03ff      /* expect 0x0000 */
        divide  0x00000020, 0x0400      /* expect 0x0000 */
        divide  0x00000020, 0x07ff      /* expect 0x0000 */
        divide  0x00000020, 0x0800      /* expect 0x0000 */
        divide  0x00000020, 0x0fff      /* expect 0x0000 */
        divide  0x00000020, 0x1000      /* expect 0x0000 */
        divide  0x00000020, 0x1fff      /* expect 0x0000 */
        divide  0x00000020, 0x2000      /* expect 0x0000 */
        divide  0x00000020, 0x3fff      /* expect 0x0000 */
        divide  0x00000020, 0x4000      /* expect 0x0000 */
        divide  0x00000020, 0x7fff      /* expect 0x0000 */
        divide  0x0000003f, 0x0001      /* expect 0x003f */
        divide  0x0000003f, 0x0002      /* expect 0x001f */
        divide  0x0000003f, 0x0003      /* expect 0x0015 */
        divide  0x0000003f, 0x0004      /* expect 0x000f */
        divide  0x0000003f, 0x0007      /* expect 0x0009 */
        divide  0x0000003f, 0x0008      /* expect 0x0007 */
        divide  0x0000003f, 0x000f      /* expect 0x0004 */
        divide  0x0000003f, 0x0010      /* expect 0x0003 */
        divide  0x0000003f, 0x001f      /* expect 0x0002 */
        divide  0x0000003f, 0x0020      /* expect 0x0001 */
        divide  0x0000003f, 0x003f      /* expect 0x0001 */
        divide  0x0000003f, 0x0040      /* expect 0x0000 */
        divide  0x0000003f, 0x007f      /* expect 0x0000 */
        divide  0x0000003f, 0x0080      /* expect 0x0000 */
        divide  0x0000003f, 0x00ff      /* expect 0x0000 */
        divide  0x0000003f, 0x0100      /* expect 0x0000 */
        divide  0x0000003f, 0x01ff      /* expect 0x0000 */
        divide  0x0000003f, 0x0200      /* expect 0x0000 */
        divide  0x0000003f, 0x03ff      /* expect 0x0000 */
        divide  0x0000003f, 0x0400      /* expect 0x0000 */
        divide  0x0000003f, 0x07ff      /* expect 0x0000 */
        divide  0x0000003f, 0x0800      /* expect 0x0000 */
        divide  0x0000003f, 0x0fff      /* expect 0x0000 */
        divide  0x0000003f, 0x1000      /* expect 0x0000 */
        divide  0x0000003f, 0x1fff      /* expect 0x0000 */
        divide  0x0000003f, 0x2000      /* expect 0x0000 */
        divide  0x0000003f, 0x3fff      /* expect 0x0000 */
        divide  0x0000003f, 0x4000      /* expect 0x0000 */
        divide  0x0000003f, 0x7fff      /* expect 0x0000 */
        divide  0x00000040, 0x0001      /* expect 0x0040 */
        divide  0x00000040, 0x0002      /* expect 0x0020 */
        divide  0x00000040, 0x0003      /* expect 0x0015 */
        divide  0x00000040, 0x0004      /* expect 0x0010 */
        divide  0x00000040, 0x0007      /* expect 0x0009 */
        divide  0x00000040, 0x0008      /* expect 0x0008 */
        divide  0x00000040, 0x000f      /* expect 0x0004 */
        divide  0x00000040, 0x0010      /* expect 0x0004 */
        divide  0x00000040, 0x001f      /* expect 0x0002 */
        divide  0x00000040, 0x0020      /* expect 0x0002 */
        divide  0x00000040, 0x003f      /* expect 0x0001 */
        divide  0x00000040, 0x0040      /* expect 0x0001 */
        divide  0x00000040, 0x007f      /* expect 0x0000 */
        divide  0x00000040, 0x0080      /* expect 0x0000 */
        divide  0x00000040, 0x00ff      /* expect 0x0000 */
        divide  0x00000040, 0x0100      /* expect 0x0000 */
        divide  0x00000040, 0x01ff      /* expect 0x0000 */
        divide  0x00000040, 0x0200      /* expect 0x0000 */
        divide  0x00000040, 0x03ff      /* expect 0x0000 */
        divide  0x00000040, 0x0400      /* expect 0x0000 */
        divide  0x00000040, 0x07ff      /* expect 0x0000 */
        divide  0x00000040, 0x0800      /* expect 0x0000 */
        divide  0x00000040, 0x0fff      /* expect 0x0000 */
        divide  0x00000040, 0x1000      /* expect 0x0000 */
        divide  0x00000040, 0x1fff      /* expect 0x0000 */
        divide  0x00000040, 0x2000      /* expect 0x0000 */
        divide  0x00000040, 0x3fff      /* expect 0x0000 */
        divide  0x00000040, 0x4000      /* expect 0x0000 */
        divide  0x00000040, 0x7fff      /* expect 0x0000 */
        divide  0x0000007f, 0x0001      /* expect 0x007f */
        divide  0x0000007f, 0x0002      /* expect 0x003f */
        divide  0x0000007f, 0x0003      /* expect 0x002a */
        divide  0x0000007f, 0x0004      /* expect 0x001f */
        divide  0x0000007f, 0x0007      /* expect 0x0012 */
        divide  0x0000007f, 0x0008      /* expect 0x000f */
        divide  0x0000007f, 0x000f      /* expect 0x0008 */
        divide  0x0000007f, 0x0010      /* expect 0x0007 */
        divide  0x0000007f, 0x001f      /* expect 0x0004 */
        divide  0x0000007f, 0x0020      /* expect 0x0003 */
        divide  0x0000007f, 0x003f      /* expect 0x0002 */
        divide  0x0000007f, 0x0040      /* expect 0x0001 */
        divide  0x0000007f, 0x007f      /* expect 0x0001 */
        divide  0x0000007f, 0x0080      /* expect 0x0000 */
        divide  0x0000007f, 0x00ff      /* expect 0x0000 */
        divide  0x0000007f, 0x0100      /* expect 0x0000 */
        divide  0x0000007f, 0x01ff      /* expect 0x0000 */
        divide  0x0000007f, 0x0200      /* expect 0x0000 */
        divide  0x0000007f, 0x03ff      /* expect 0x0000 */
        divide  0x0000007f, 0x0400      /* expect 0x0000 */
        divide  0x0000007f, 0x07ff      /* expect 0x0000 */
        divide  0x0000007f, 0x0800      /* expect 0x0000 */
        divide  0x0000007f, 0x0fff      /* expect 0x0000 */
        divide  0x0000007f, 0x1000      /* expect 0x0000 */
        divide  0x0000007f, 0x1fff      /* expect 0x0000 */
        divide  0x0000007f, 0x2000      /* expect 0x0000 */
        divide  0x0000007f, 0x3fff      /* expect 0x0000 */
        divide  0x0000007f, 0x4000      /* expect 0x0000 */
        divide  0x0000007f, 0x7fff      /* expect 0x0000 */
        divide  0x00000080, 0x0001      /* expect 0x0080 */
        divide  0x00000080, 0x0002      /* expect 0x0040 */
        divide  0x00000080, 0x0003      /* expect 0x002a */
        divide  0x00000080, 0x0004      /* expect 0x0020 */
        divide  0x00000080, 0x0007      /* expect 0x0012 */
        divide  0x00000080, 0x0008      /* expect 0x0010 */
        divide  0x00000080, 0x000f      /* expect 0x0008 */
        divide  0x00000080, 0x0010      /* expect 0x0008 */
        divide  0x00000080, 0x001f      /* expect 0x0004 */
        divide  0x00000080, 0x0020      /* expect 0x0004 */
        divide  0x00000080, 0x003f      /* expect 0x0002 */
        divide  0x00000080, 0x0040      /* expect 0x0002 */
        divide  0x00000080, 0x007f      /* expect 0x0001 */
        divide  0x00000080, 0x0080      /* expect 0x0001 */
        divide  0x00000080, 0x00ff      /* expect 0x0000 */
        divide  0x00000080, 0x0100      /* expect 0x0000 */
        divide  0x00000080, 0x01ff      /* expect 0x0000 */
        divide  0x00000080, 0x0200      /* expect 0x0000 */
        divide  0x00000080, 0x03ff      /* expect 0x0000 */
        divide  0x00000080, 0x0400      /* expect 0x0000 */
        divide  0x00000080, 0x07ff      /* expect 0x0000 */
        divide  0x00000080, 0x0800      /* expect 0x0000 */
        divide  0x00000080, 0x0fff      /* expect 0x0000 */
        divide  0x00000080, 0x1000      /* expect 0x0000 */
        divide  0x00000080, 0x1fff      /* expect 0x0000 */
        divide  0x00000080, 0x2000      /* expect 0x0000 */
        divide  0x00000080, 0x3fff      /* expect 0x0000 */
        divide  0x00000080, 0x4000      /* expect 0x0000 */
        divide  0x00000080, 0x7fff      /* expect 0x0000 */
        divide  0x000000ff, 0x0001      /* expect 0x00ff */
        divide  0x000000ff, 0x0002      /* expect 0x007f */
        divide  0x000000ff, 0x0003      /* expect 0x0055 */
        divide  0x000000ff, 0x0004      /* expect 0x003f */
        divide  0x000000ff, 0x0007      /* expect 0x0024 */
        divide  0x000000ff, 0x0008      /* expect 0x001f */
        divide  0x000000ff, 0x000f      /* expect 0x0011 */
        divide  0x000000ff, 0x0010      /* expect 0x000f */
        divide  0x000000ff, 0x001f      /* expect 0x0008 */
        divide  0x000000ff, 0x0020      /* expect 0x0007 */
        divide  0x000000ff, 0x003f      /* expect 0x0004 */
        divide  0x000000ff, 0x0040      /* expect 0x0003 */
        divide  0x000000ff, 0x007f      /* expect 0x0002 */
        divide  0x000000ff, 0x0080      /* expect 0x0001 */
        divide  0x000000ff, 0x00ff      /* expect 0x0001 */
        divide  0x000000ff, 0x0100      /* expect 0x0000 */
        divide  0x000000ff, 0x01ff      /* expect 0x0000 */
        divide  0x000000ff, 0x0200      /* expect 0x0000 */
        divide  0x000000ff, 0x03ff      /* expect 0x0000 */
        divide  0x000000ff, 0x0400      /* expect 0x0000 */
        divide  0x000000ff, 0x07ff      /* expect 0x0000 */
        divide  0x000000ff, 0x0800      /* expect 0x0000 */
        divide  0x000000ff, 0x0fff      /* expect 0x0000 */
        divide  0x000000ff, 0x1000      /* expect 0x0000 */
        divide  0x000000ff, 0x1fff      /* expect 0x0000 */
        divide  0x000000ff, 0x2000      /* expect 0x0000 */
        divide  0x000000ff, 0x3fff      /* expect 0x0000 */
        divide  0x000000ff, 0x4000      /* expect 0x0000 */
        divide  0x000000ff, 0x7fff      /* expect 0x0000 */
        divide  0x00000100, 0x0001      /* expect 0x0100 */
        divide  0x00000100, 0x0002      /* expect 0x0080 */
        divide  0x00000100, 0x0003      /* expect 0x0055 */
        divide  0x00000100, 0x0004      /* expect 0x0040 */
        divide  0x00000100, 0x0007      /* expect 0x0024 */
        divide  0x00000100, 0x0008      /* expect 0x0020 */
        divide  0x00000100, 0x000f      /* expect 0x0011 */
        divide  0x00000100, 0x0010      /* expect 0x0010 */
        divide  0x00000100, 0x001f      /* expect 0x0008 */
        divide  0x00000100, 0x0020      /* expect 0x0008 */
        divide  0x00000100, 0x003f      /* expect 0x0004 */
        divide  0x00000100, 0x0040      /* expect 0x0004 */
        divide  0x00000100, 0x007f      /* expect 0x0002 */
        divide  0x00000100, 0x0080      /* expect 0x0002 */
        divide  0x00000100, 0x00ff      /* expect 0x0001 */
        divide  0x00000100, 0x0100      /* expect 0x0001 */
        divide  0x00000100, 0x01ff      /* expect 0x0000 */
        divide  0x00000100, 0x0200      /* expect 0x0000 */
        divide  0x00000100, 0x03ff      /* expect 0x0000 */
        divide  0x00000100, 0x0400      /* expect 0x0000 */
        divide  0x00000100, 0x07ff      /* expect 0x0000 */
        divide  0x00000100, 0x0800      /* expect 0x0000 */
        divide  0x00000100, 0x0fff      /* expect 0x0000 */
        divide  0x00000100, 0x1000      /* expect 0x0000 */
        divide  0x00000100, 0x1fff      /* expect 0x0000 */
        divide  0x00000100, 0x2000      /* expect 0x0000 */
        divide  0x00000100, 0x3fff      /* expect 0x0000 */
        divide  0x00000100, 0x4000      /* expect 0x0000 */
        divide  0x00000100, 0x7fff      /* expect 0x0000 */
        divide  0x000001ff, 0x0001      /* expect 0x01ff */
        divide  0x000001ff, 0x0002      /* expect 0x00ff */
        divide  0x000001ff, 0x0003      /* expect 0x00aa */
        divide  0x000001ff, 0x0004      /* expect 0x007f */
        divide  0x000001ff, 0x0007      /* expect 0x0049 */
        divide  0x000001ff, 0x0008      /* expect 0x003f */
        divide  0x000001ff, 0x000f      /* expect 0x0022 */
        divide  0x000001ff, 0x0010      /* expect 0x001f */
        divide  0x000001ff, 0x001f      /* expect 0x0010 */
        divide  0x000001ff, 0x0020      /* expect 0x000f */
        divide  0x000001ff, 0x003f      /* expect 0x0008 */
        divide  0x000001ff, 0x0040      /* expect 0x0007 */
        divide  0x000001ff, 0x007f      /* expect 0x0004 */
        divide  0x000001ff, 0x0080      /* expect 0x0003 */
        divide  0x000001ff, 0x00ff      /* expect 0x0002 */
        divide  0x000001ff, 0x0100      /* expect 0x0001 */
        divide  0x000001ff, 0x01ff      /* expect 0x0001 */
        divide  0x000001ff, 0x0200      /* expect 0x0000 */
        divide  0x000001ff, 0x03ff      /* expect 0x0000 */
        divide  0x000001ff, 0x0400      /* expect 0x0000 */
        divide  0x000001ff, 0x07ff      /* expect 0x0000 */
        divide  0x000001ff, 0x0800      /* expect 0x0000 */
        divide  0x000001ff, 0x0fff      /* expect 0x0000 */
        divide  0x000001ff, 0x1000      /* expect 0x0000 */
        divide  0x000001ff, 0x1fff      /* expect 0x0000 */
        divide  0x000001ff, 0x2000      /* expect 0x0000 */
        divide  0x000001ff, 0x3fff      /* expect 0x0000 */
        divide  0x000001ff, 0x4000      /* expect 0x0000 */
        divide  0x000001ff, 0x7fff      /* expect 0x0000 */
        divide  0x00000200, 0x0001      /* expect 0x0200 */
        divide  0x00000200, 0x0002      /* expect 0x0100 */
        divide  0x00000200, 0x0003      /* expect 0x00aa */
        divide  0x00000200, 0x0004      /* expect 0x0080 */
        divide  0x00000200, 0x0007      /* expect 0x0049 */
        divide  0x00000200, 0x0008      /* expect 0x0040 */
        divide  0x00000200, 0x000f      /* expect 0x0022 */
        divide  0x00000200, 0x0010      /* expect 0x0020 */
        divide  0x00000200, 0x001f      /* expect 0x0010 */
        divide  0x00000200, 0x0020      /* expect 0x0010 */
        divide  0x00000200, 0x003f      /* expect 0x0008 */
        divide  0x00000200, 0x0040      /* expect 0x0008 */
        divide  0x00000200, 0x007f      /* expect 0x0004 */
        divide  0x00000200, 0x0080      /* expect 0x0004 */
        divide  0x00000200, 0x00ff      /* expect 0x0002 */
        divide  0x00000200, 0x0100      /* expect 0x0002 */
        divide  0x00000200, 0x01ff      /* expect 0x0001 */
        divide  0x00000200, 0x0200      /* expect 0x0001 */
        divide  0x00000200, 0x03ff      /* expect 0x0000 */
        divide  0x00000200, 0x0400      /* expect 0x0000 */
        divide  0x00000200, 0x07ff      /* expect 0x0000 */
        divide  0x00000200, 0x0800      /* expect 0x0000 */
        divide  0x00000200, 0x0fff      /* expect 0x0000 */
        divide  0x00000200, 0x1000      /* expect 0x0000 */
        divide  0x00000200, 0x1fff      /* expect 0x0000 */
        divide  0x00000200, 0x2000      /* expect 0x0000 */
        divide  0x00000200, 0x3fff      /* expect 0x0000 */
        divide  0x00000200, 0x4000      /* expect 0x0000 */
        divide  0x00000200, 0x7fff      /* expect 0x0000 */
        divide  0x000003ff, 0x0001      /* expect 0x03ff */
        divide  0x000003ff, 0x0002      /* expect 0x01ff */
        divide  0x000003ff, 0x0003      /* expect 0x0155 */
        divide  0x000003ff, 0x0004      /* expect 0x00ff */
        divide  0x000003ff, 0x0007      /* expect 0x0092 */
        divide  0x000003ff, 0x0008      /* expect 0x007f */
        divide  0x000003ff, 0x000f      /* expect 0x0044 */
        divide  0x000003ff, 0x0010      /* expect 0x003f */
        divide  0x000003ff, 0x001f      /* expect 0x0021 */
        divide  0x000003ff, 0x0020      /* expect 0x001f */
        divide  0x000003ff, 0x003f      /* expect 0x0010 */
        divide  0x000003ff, 0x0040      /* expect 0x000f */
        divide  0x000003ff, 0x007f      /* expect 0x0008 */
        divide  0x000003ff, 0x0080      /* expect 0x0007 */
        divide  0x000003ff, 0x00ff      /* expect 0x0004 */
        divide  0x000003ff, 0x0100      /* expect 0x0003 */
        divide  0x000003ff, 0x01ff      /* expect 0x0002 */
        divide  0x000003ff, 0x0200      /* expect 0x0001 */
        divide  0x000003ff, 0x03ff      /* expect 0x0001 */
        divide  0x000003ff, 0x0400      /* expect 0x0000 */
        divide  0x000003ff, 0x07ff      /* expect 0x0000 */
        divide  0x000003ff, 0x0800      /* expect 0x0000 */
        divide  0x000003ff, 0x0fff      /* expect 0x0000 */
        divide  0x000003ff, 0x1000      /* expect 0x0000 */
        divide  0x000003ff, 0x1fff      /* expect 0x0000 */
        divide  0x000003ff, 0x2000      /* expect 0x0000 */
        divide  0x000003ff, 0x3fff      /* expect 0x0000 */
        divide  0x000003ff, 0x4000      /* expect 0x0000 */
        divide  0x000003ff, 0x7fff      /* expect 0x0000 */
        divide  0x00000400, 0x0001      /* expect 0x0400 */
        divide  0x00000400, 0x0002      /* expect 0x0200 */
        divide  0x00000400, 0x0003      /* expect 0x0155 */
        divide  0x00000400, 0x0004      /* expect 0x0100 */
        divide  0x00000400, 0x0007      /* expect 0x0092 */
        divide  0x00000400, 0x0008      /* expect 0x0080 */
        divide  0x00000400, 0x000f      /* expect 0x0044 */
        divide  0x00000400, 0x0010      /* expect 0x0040 */
        divide  0x00000400, 0x001f      /* expect 0x0021 */
        divide  0x00000400, 0x0020      /* expect 0x0020 */
        divide  0x00000400, 0x003f      /* expect 0x0010 */
        divide  0x00000400, 0x0040      /* expect 0x0010 */
        divide  0x00000400, 0x007f      /* expect 0x0008 */
        divide  0x00000400, 0x0080      /* expect 0x0008 */
        divide  0x00000400, 0x00ff      /* expect 0x0004 */
        divide  0x00000400, 0x0100      /* expect 0x0004 */
        divide  0x00000400, 0x01ff      /* expect 0x0002 */
        divide  0x00000400, 0x0200      /* expect 0x0002 */
        divide  0x00000400, 0x03ff      /* expect 0x0001 */
        divide  0x00000400, 0x0400      /* expect 0x0001 */
        divide  0x00000400, 0x07ff      /* expect 0x0000 */
        divide  0x00000400, 0x0800      /* expect 0x0000 */
        divide  0x00000400, 0x0fff      /* expect 0x0000 */
        divide  0x00000400, 0x1000      /* expect 0x0000 */
        divide  0x00000400, 0x1fff      /* expect 0x0000 */
        divide  0x00000400, 0x2000      /* expect 0x0000 */
        divide  0x00000400, 0x3fff      /* expect 0x0000 */
        divide  0x00000400, 0x4000      /* expect 0x0000 */
        divide  0x00000400, 0x7fff      /* expect 0x0000 */
        divide  0x000007ff, 0x0001      /* expect 0x07ff */
        divide  0x000007ff, 0x0002      /* expect 0x03ff */
        divide  0x000007ff, 0x0003      /* expect 0x02aa */
        divide  0x000007ff, 0x0004      /* expect 0x01ff */
        divide  0x000007ff, 0x0007      /* expect 0x0124 */
        divide  0x000007ff, 0x0008      /* expect 0x00ff */
        divide  0x000007ff, 0x000f      /* expect 0x0088 */
        divide  0x000007ff, 0x0010      /* expect 0x007f */
        divide  0x000007ff, 0x001f      /* expect 0x0042 */
        divide  0x000007ff, 0x0020      /* expect 0x003f */
        divide  0x000007ff, 0x003f      /* expect 0x0020 */
        divide  0x000007ff, 0x0040      /* expect 0x001f */
        divide  0x000007ff, 0x007f      /* expect 0x0010 */
        divide  0x000007ff, 0x0080      /* expect 0x000f */
        divide  0x000007ff, 0x00ff      /* expect 0x0008 */
        divide  0x000007ff, 0x0100      /* expect 0x0007 */
        divide  0x000007ff, 0x01ff      /* expect 0x0004 */
        divide  0x000007ff, 0x0200      /* expect 0x0003 */
        divide  0x000007ff, 0x03ff      /* expect 0x0002 */
        divide  0x000007ff, 0x0400      /* expect 0x0001 */
        divide  0x000007ff, 0x07ff      /* expect 0x0001 */
        divide  0x000007ff, 0x0800      /* expect 0x0000 */
        divide  0x000007ff, 0x0fff      /* expect 0x0000 */
        divide  0x000007ff, 0x1000      /* expect 0x0000 */
        divide  0x000007ff, 0x1fff      /* expect 0x0000 */
        divide  0x000007ff, 0x2000      /* expect 0x0000 */
        divide  0x000007ff, 0x3fff      /* expect 0x0000 */
        divide  0x000007ff, 0x4000      /* expect 0x0000 */
        divide  0x000007ff, 0x7fff      /* expect 0x0000 */
        divide  0x00000800, 0x0001      /* expect 0x0800 */
        divide  0x00000800, 0x0002      /* expect 0x0400 */
        divide  0x00000800, 0x0003      /* expect 0x02aa */
        divide  0x00000800, 0x0004      /* expect 0x0200 */
        divide  0x00000800, 0x0007      /* expect 0x0124 */
        divide  0x00000800, 0x0008      /* expect 0x0100 */
        divide  0x00000800, 0x000f      /* expect 0x0088 */
        divide  0x00000800, 0x0010      /* expect 0x0080 */
        divide  0x00000800, 0x001f      /* expect 0x0042 */
        divide  0x00000800, 0x0020      /* expect 0x0040 */
        divide  0x00000800, 0x003f      /* expect 0x0020 */
        divide  0x00000800, 0x0040      /* expect 0x0020 */
        divide  0x00000800, 0x007f      /* expect 0x0010 */
        divide  0x00000800, 0x0080      /* expect 0x0010 */
        divide  0x00000800, 0x00ff      /* expect 0x0008 */
        divide  0x00000800, 0x0100      /* expect 0x0008 */
        divide  0x00000800, 0x01ff      /* expect 0x0004 */
        divide  0x00000800, 0x0200      /* expect 0x0004 */
        divide  0x00000800, 0x03ff      /* expect 0x0002 */
        divide  0x00000800, 0x0400      /* expect 0x0002 */
        divide  0x00000800, 0x07ff      /* expect 0x0001 */
        divide  0x00000800, 0x0800      /* expect 0x0001 */
        divide  0x00000800, 0x0fff      /* expect 0x0000 */
        divide  0x00000800, 0x1000      /* expect 0x0000 */
        divide  0x00000800, 0x1fff      /* expect 0x0000 */
        divide  0x00000800, 0x2000      /* expect 0x0000 */
        divide  0x00000800, 0x3fff      /* expect 0x0000 */
        divide  0x00000800, 0x4000      /* expect 0x0000 */
        divide  0x00000800, 0x7fff      /* expect 0x0000 */
        divide  0x00000fff, 0x0001      /* expect 0x0fff */
        divide  0x00000fff, 0x0002      /* expect 0x07ff */
        divide  0x00000fff, 0x0003      /* expect 0x0555 */
        divide  0x00000fff, 0x0004      /* expect 0x03ff */
        divide  0x00000fff, 0x0007      /* expect 0x0249 */
        divide  0x00000fff, 0x0008      /* expect 0x01ff */
        divide  0x00000fff, 0x000f      /* expect 0x0111 */
        divide  0x00000fff, 0x0010      /* expect 0x00ff */
        divide  0x00000fff, 0x001f      /* expect 0x0084 */
        divide  0x00000fff, 0x0020      /* expect 0x007f */
        divide  0x00000fff, 0x003f      /* expect 0x0041 */
        divide  0x00000fff, 0x0040      /* expect 0x003f */
        divide  0x00000fff, 0x007f      /* expect 0x0020 */
        divide  0x00000fff, 0x0080      /* expect 0x001f */
        divide  0x00000fff, 0x00ff      /* expect 0x0010 */
        divide  0x00000fff, 0x0100      /* expect 0x000f */
        divide  0x00000fff, 0x01ff      /* expect 0x0008 */
        divide  0x00000fff, 0x0200      /* expect 0x0007 */
        divide  0x00000fff, 0x03ff      /* expect 0x0004 */
        divide  0x00000fff, 0x0400      /* expect 0x0003 */
        divide  0x00000fff, 0x07ff      /* expect 0x0002 */
        divide  0x00000fff, 0x0800      /* expect 0x0001 */
        divide  0x00000fff, 0x0fff      /* expect 0x0001 */
        divide  0x00000fff, 0x1000      /* expect 0x0000 */
        divide  0x00000fff, 0x1fff      /* expect 0x0000 */
        divide  0x00000fff, 0x2000      /* expect 0x0000 */
        divide  0x00000fff, 0x3fff      /* expect 0x0000 */
        divide  0x00000fff, 0x4000      /* expect 0x0000 */
        divide  0x00000fff, 0x7fff      /* expect 0x0000 */
        divide  0x00001000, 0x0001      /* expect 0x1000 */
        divide  0x00001000, 0x0002      /* expect 0x0800 */
        divide  0x00001000, 0x0003      /* expect 0x0555 */
        divide  0x00001000, 0x0004      /* expect 0x0400 */
        divide  0x00001000, 0x0007      /* expect 0x0249 */
        divide  0x00001000, 0x0008      /* expect 0x0200 */
        divide  0x00001000, 0x000f      /* expect 0x0111 */
        divide  0x00001000, 0x0010      /* expect 0x0100 */
        divide  0x00001000, 0x001f      /* expect 0x0084 */
        divide  0x00001000, 0x0020      /* expect 0x0080 */
        divide  0x00001000, 0x003f      /* expect 0x0041 */
        divide  0x00001000, 0x0040      /* expect 0x0040 */
        divide  0x00001000, 0x007f      /* expect 0x0020 */
        divide  0x00001000, 0x0080      /* expect 0x0020 */
        divide  0x00001000, 0x00ff      /* expect 0x0010 */
        divide  0x00001000, 0x0100      /* expect 0x0010 */
        divide  0x00001000, 0x01ff      /* expect 0x0008 */
        divide  0x00001000, 0x0200      /* expect 0x0008 */
        divide  0x00001000, 0x03ff      /* expect 0x0004 */
        divide  0x00001000, 0x0400      /* expect 0x0004 */
        divide  0x00001000, 0x07ff      /* expect 0x0002 */
        divide  0x00001000, 0x0800      /* expect 0x0002 */
        divide  0x00001000, 0x0fff      /* expect 0x0001 */
        divide  0x00001000, 0x1000      /* expect 0x0001 */
        divide  0x00001000, 0x1fff      /* expect 0x0000 */
        divide  0x00001000, 0x2000      /* expect 0x0000 */
        divide  0x00001000, 0x3fff      /* expect 0x0000 */
        divide  0x00001000, 0x4000      /* expect 0x0000 */
        divide  0x00001000, 0x7fff      /* expect 0x0000 */
        divide  0x00001fff, 0x0001      /* expect 0x1fff */
        divide  0x00001fff, 0x0002      /* expect 0x0fff */
        divide  0x00001fff, 0x0003      /* expect 0x0aaa */
        divide  0x00001fff, 0x0004      /* expect 0x07ff */
        divide  0x00001fff, 0x0007      /* expect 0x0492 */
        divide  0x00001fff, 0x0008      /* expect 0x03ff */
        divide  0x00001fff, 0x000f      /* expect 0x0222 */
        divide  0x00001fff, 0x0010      /* expect 0x01ff */
        divide  0x00001fff, 0x001f      /* expect 0x0108 */
        divide  0x00001fff, 0x0020      /* expect 0x00ff */
        divide  0x00001fff, 0x003f      /* expect 0x0082 */
        divide  0x00001fff, 0x0040      /* expect 0x007f */
        divide  0x00001fff, 0x007f      /* expect 0x0040 */
        divide  0x00001fff, 0x0080      /* expect 0x003f */
        divide  0x00001fff, 0x00ff      /* expect 0x0020 */
        divide  0x00001fff, 0x0100      /* expect 0x001f */
        divide  0x00001fff, 0x01ff      /* expect 0x0010 */
        divide  0x00001fff, 0x0200      /* expect 0x000f */
        divide  0x00001fff, 0x03ff      /* expect 0x0008 */
        divide  0x00001fff, 0x0400      /* expect 0x0007 */
        divide  0x00001fff, 0x07ff      /* expect 0x0004 */
        divide  0x00001fff, 0x0800      /* expect 0x0003 */
        divide  0x00001fff, 0x0fff      /* expect 0x0002 */
        divide  0x00001fff, 0x1000      /* expect 0x0001 */
        divide  0x00001fff, 0x1fff      /* expect 0x0001 */
        divide  0x00001fff, 0x2000      /* expect 0x0000 */
        divide  0x00001fff, 0x3fff      /* expect 0x0000 */
        divide  0x00001fff, 0x4000      /* expect 0x0000 */
        divide  0x00001fff, 0x7fff      /* expect 0x0000 */
        divide  0x00002000, 0x0001      /* expect 0x2000 */
        divide  0x00002000, 0x0002      /* expect 0x1000 */
        divide  0x00002000, 0x0003      /* expect 0x0aaa */
        divide  0x00002000, 0x0004      /* expect 0x0800 */
        divide  0x00002000, 0x0007      /* expect 0x0492 */
        divide  0x00002000, 0x0008      /* expect 0x0400 */
        divide  0x00002000, 0x000f      /* expect 0x0222 */
        divide  0x00002000, 0x0010      /* expect 0x0200 */
        divide  0x00002000, 0x001f      /* expect 0x0108 */
        divide  0x00002000, 0x0020      /* expect 0x0100 */
        divide  0x00002000, 0x003f      /* expect 0x0082 */
        divide  0x00002000, 0x0040      /* expect 0x0080 */
        divide  0x00002000, 0x007f      /* expect 0x0040 */
        divide  0x00002000, 0x0080      /* expect 0x0040 */
        divide  0x00002000, 0x00ff      /* expect 0x0020 */
        divide  0x00002000, 0x0100      /* expect 0x0020 */
        divide  0x00002000, 0x01ff      /* expect 0x0010 */
        divide  0x00002000, 0x0200      /* expect 0x0010 */
        divide  0x00002000, 0x03ff      /* expect 0x0008 */
        divide  0x00002000, 0x0400      /* expect 0x0008 */
        divide  0x00002000, 0x07ff      /* expect 0x0004 */
        divide  0x00002000, 0x0800      /* expect 0x0004 */
        divide  0x00002000, 0x0fff      /* expect 0x0002 */
        divide  0x00002000, 0x1000      /* expect 0x0002 */
        divide  0x00002000, 0x1fff      /* expect 0x0001 */
        divide  0x00002000, 0x2000      /* expect 0x0001 */
        divide  0x00002000, 0x3fff      /* expect 0x0000 */
        divide  0x00002000, 0x4000      /* expect 0x0000 */
        divide  0x00002000, 0x7fff      /* expect 0x0000 */
        divide  0x00003fff, 0x0001      /* expect 0x3fff */
        divide  0x00003fff, 0x0002      /* expect 0x1fff */
        divide  0x00003fff, 0x0003      /* expect 0x1555 */
        divide  0x00003fff, 0x0004      /* expect 0x0fff */
        divide  0x00003fff, 0x0007      /* expect 0x0924 */
        divide  0x00003fff, 0x0008      /* expect 0x07ff */
        divide  0x00003fff, 0x000f      /* expect 0x0444 */
        divide  0x00003fff, 0x0010      /* expect 0x03ff */
        divide  0x00003fff, 0x001f      /* expect 0x0210 */
        divide  0x00003fff, 0x0020      /* expect 0x01ff */
        divide  0x00003fff, 0x003f      /* expect 0x0104 */
        divide  0x00003fff, 0x0040      /* expect 0x00ff */
        divide  0x00003fff, 0x007f      /* expect 0x0081 */
        divide  0x00003fff, 0x0080      /* expect 0x007f */
        divide  0x00003fff, 0x00ff      /* expect 0x0040 */
        divide  0x00003fff, 0x0100      /* expect 0x003f */
        divide  0x00003fff, 0x01ff      /* expect 0x0020 */
        divide  0x00003fff, 0x0200      /* expect 0x001f */
        divide  0x00003fff, 0x03ff      /* expect 0x0010 */
        divide  0x00003fff, 0x0400      /* expect 0x000f */
        divide  0x00003fff, 0x07ff      /* expect 0x0008 */
        divide  0x00003fff, 0x0800      /* expect 0x0007 */
        divide  0x00003fff, 0x0fff      /* expect 0x0004 */
        divide  0x00003fff, 0x1000      /* expect 0x0003 */
        divide  0x00003fff, 0x1fff      /* expect 0x0002 */
        divide  0x00003fff, 0x2000      /* expect 0x0001 */
        divide  0x00003fff, 0x3fff      /* expect 0x0001 */
        divide  0x00003fff, 0x4000      /* expect 0x0000 */
        divide  0x00003fff, 0x7fff      /* expect 0x0000 */
        divide  0x00004000, 0x0001      /* expect 0x4000 */
        divide  0x00004000, 0x0002      /* expect 0x2000 */
        divide  0x00004000, 0x0003      /* expect 0x1555 */
        divide  0x00004000, 0x0004      /* expect 0x1000 */
        divide  0x00004000, 0x0007      /* expect 0x0924 */
        divide  0x00004000, 0x0008      /* expect 0x0800 */
        divide  0x00004000, 0x000f      /* expect 0x0444 */
        divide  0x00004000, 0x0010      /* expect 0x0400 */
        divide  0x00004000, 0x001f      /* expect 0x0210 */
        divide  0x00004000, 0x0020      /* expect 0x0200 */
        divide  0x00004000, 0x003f      /* expect 0x0104 */
        divide  0x00004000, 0x0040      /* expect 0x0100 */
        divide  0x00004000, 0x007f      /* expect 0x0081 */
        divide  0x00004000, 0x0080      /* expect 0x0080 */
        divide  0x00004000, 0x00ff      /* expect 0x0040 */
        divide  0x00004000, 0x0100      /* expect 0x0040 */
        divide  0x00004000, 0x01ff      /* expect 0x0020 */
        divide  0x00004000, 0x0200      /* expect 0x0020 */
        divide  0x00004000, 0x03ff      /* expect 0x0010 */
        divide  0x00004000, 0x0400      /* expect 0x0010 */
        divide  0x00004000, 0x07ff      /* expect 0x0008 */
        divide  0x00004000, 0x0800      /* expect 0x0008 */
        divide  0x00004000, 0x0fff      /* expect 0x0004 */
        divide  0x00004000, 0x1000      /* expect 0x0004 */
        divide  0x00004000, 0x1fff      /* expect 0x0002 */
        divide  0x00004000, 0x2000      /* expect 0x0002 */
        divide  0x00004000, 0x3fff      /* expect 0x0001 */
        divide  0x00004000, 0x4000      /* expect 0x0001 */
        divide  0x00004000, 0x7fff      /* expect 0x0000 */
        divide  0x00007fff, 0x0001      /* expect 0x7fff */
        divide  0x00007fff, 0x0002      /* expect 0x3fff */
        divide  0x00007fff, 0x0003      /* expect 0x2aaa */
        divide  0x00007fff, 0x0004      /* expect 0x1fff */
        divide  0x00007fff, 0x0007      /* expect 0x1249 */
        divide  0x00007fff, 0x0008      /* expect 0x0fff */
        divide  0x00007fff, 0x000f      /* expect 0x0888 */
        divide  0x00007fff, 0x0010      /* expect 0x07ff */
        divide  0x00007fff, 0x001f      /* expect 0x0421 */
        divide  0x00007fff, 0x0020      /* expect 0x03ff */
        divide  0x00007fff, 0x003f      /* expect 0x0208 */
        divide  0x00007fff, 0x0040      /* expect 0x01ff */
        divide  0x00007fff, 0x007f      /* expect 0x0102 */
        divide  0x00007fff, 0x0080      /* expect 0x00ff */
        divide  0x00007fff, 0x00ff      /* expect 0x0080 */
        divide  0x00007fff, 0x0100      /* expect 0x007f */
        divide  0x00007fff, 0x01ff      /* expect 0x0040 */
        divide  0x00007fff, 0x0200      /* expect 0x003f */
        divide  0x00007fff, 0x03ff      /* expect 0x0020 */
        divide  0x00007fff, 0x0400      /* expect 0x001f */
        divide  0x00007fff, 0x07ff      /* expect 0x0010 */
        divide  0x00007fff, 0x0800      /* expect 0x000f */
        divide  0x00007fff, 0x0fff      /* expect 0x0008 */
        divide  0x00007fff, 0x1000      /* expect 0x0007 */
        divide  0x00007fff, 0x1fff      /* expect 0x0004 */
        divide  0x00007fff, 0x2000      /* expect 0x0003 */
        divide  0x00007fff, 0x3fff      /* expect 0x0002 */
        divide  0x00007fff, 0x4000      /* expect 0x0001 */
        divide  0x00007fff, 0x7fff      /* expect 0x0001 */
        divide  0x00008000, 0x0002      /* expect 0x4000 */
        divide  0x00008000, 0x0003      /* expect 0x2aaa */
        divide  0x00008000, 0x0004      /* expect 0x2000 */
        divide  0x00008000, 0x0007      /* expect 0x1249 */
        divide  0x00008000, 0x0008      /* expect 0x1000 */
        divide  0x00008000, 0x000f      /* expect 0x0888 */
        divide  0x00008000, 0x0010      /* expect 0x0800 */
        divide  0x00008000, 0x001f      /* expect 0x0421 */
        divide  0x00008000, 0x0020      /* expect 0x0400 */
        divide  0x00008000, 0x003f      /* expect 0x0208 */
        divide  0x00008000, 0x0040      /* expect 0x0200 */
        divide  0x00008000, 0x007f      /* expect 0x0102 */
        divide  0x00008000, 0x0080      /* expect 0x0100 */
        divide  0x00008000, 0x00ff      /* expect 0x0080 */
        divide  0x00008000, 0x0100      /* expect 0x0080 */
        divide  0x00008000, 0x01ff      /* expect 0x0040 */
        divide  0x00008000, 0x0200      /* expect 0x0040 */
        divide  0x00008000, 0x03ff      /* expect 0x0020 */
        divide  0x00008000, 0x0400      /* expect 0x0020 */
        divide  0x00008000, 0x07ff      /* expect 0x0010 */
        divide  0x00008000, 0x0800      /* expect 0x0010 */
        divide  0x00008000, 0x0fff      /* expect 0x0008 */
        divide  0x00008000, 0x1000      /* expect 0x0008 */
        divide  0x00008000, 0x1fff      /* expect 0x0004 */
        divide  0x00008000, 0x2000      /* expect 0x0004 */
        divide  0x00008000, 0x3fff      /* expect 0x0002 */
        divide  0x00008000, 0x4000      /* expect 0x0002 */
        divide  0x00008000, 0x7fff      /* expect 0x0001 */
        divide  0x0000ffff, 0x0002      /* expect 0x7fff */
        divide  0x0000ffff, 0x0003      /* expect 0x5555 */
        divide  0x0000ffff, 0x0004      /* expect 0x3fff */
        divide  0x0000ffff, 0x0007      /* expect 0x2492 */
        divide  0x0000ffff, 0x0008      /* expect 0x1fff */
        divide  0x0000ffff, 0x000f      /* expect 0x1111 */
        divide  0x0000ffff, 0x0010      /* expect 0x0fff */
        divide  0x0000ffff, 0x001f      /* expect 0x0842 */
        divide  0x0000ffff, 0x0020      /* expect 0x07ff */
        divide  0x0000ffff, 0x003f      /* expect 0x0410 */
        divide  0x0000ffff, 0x0040      /* expect 0x03ff */
        divide  0x0000ffff, 0x007f      /* expect 0x0204 */
        divide  0x0000ffff, 0x0080      /* expect 0x01ff */
        divide  0x0000ffff, 0x00ff      /* expect 0x0101 */
        divide  0x0000ffff, 0x0100      /* expect 0x00ff */
        divide  0x0000ffff, 0x01ff      /* expect 0x0080 */
        divide  0x0000ffff, 0x0200      /* expect 0x007f */
        divide  0x0000ffff, 0x03ff      /* expect 0x0040 */
        divide  0x0000ffff, 0x0400      /* expect 0x003f */
        divide  0x0000ffff, 0x07ff      /* expect 0x0020 */
        divide  0x0000ffff, 0x0800      /* expect 0x001f */
        divide  0x0000ffff, 0x0fff      /* expect 0x0010 */
        divide  0x0000ffff, 0x1000      /* expect 0x000f */
        divide  0x0000ffff, 0x1fff      /* expect 0x0008 */
        divide  0x0000ffff, 0x2000      /* expect 0x0007 */
        divide  0x0000ffff, 0x3fff      /* expect 0x0004 */
        divide  0x0000ffff, 0x4000      /* expect 0x0003 */
        divide  0x0000ffff, 0x7fff      /* expect 0x0002 */
        divide  0x00010000, 0x0003      /* expect 0x5555 */
        divide  0x00010000, 0x0004      /* expect 0x4000 */
        divide  0x00010000, 0x0007      /* expect 0x2492 */
        divide  0x00010000, 0x0008      /* expect 0x2000 */
        divide  0x00010000, 0x000f      /* expect 0x1111 */
        divide  0x00010000, 0x0010      /* expect 0x1000 */
        divide  0x00010000, 0x001f      /* expect 0x0842 */
        divide  0x00010000, 0x0020      /* expect 0x0800 */
        divide  0x00010000, 0x003f      /* expect 0x0410 */
        divide  0x00010000, 0x0040      /* expect 0x0400 */
        divide  0x00010000, 0x007f      /* expect 0x0204 */
        divide  0x00010000, 0x0080      /* expect 0x0200 */
        divide  0x00010000, 0x00ff      /* expect 0x0101 */
        divide  0x00010000, 0x0100      /* expect 0x0100 */
        divide  0x00010000, 0x01ff      /* expect 0x0080 */
        divide  0x00010000, 0x0200      /* expect 0x0080 */
        divide  0x00010000, 0x03ff      /* expect 0x0040 */
        divide  0x00010000, 0x0400      /* expect 0x0040 */
        divide  0x00010000, 0x07ff      /* expect 0x0020 */
        divide  0x00010000, 0x0800      /* expect 0x0020 */
        divide  0x00010000, 0x0fff      /* expect 0x0010 */
        divide  0x00010000, 0x1000      /* expect 0x0010 */
        divide  0x00010000, 0x1fff      /* expect 0x0008 */
        divide  0x00010000, 0x2000      /* expect 0x0008 */
        divide  0x00010000, 0x3fff      /* expect 0x0004 */
        divide  0x00010000, 0x4000      /* expect 0x0004 */
        divide  0x00010000, 0x7fff      /* expect 0x0002 */
        divide  0x0001ffff, 0x0004      /* expect 0x7fff */
        divide  0x0001ffff, 0x0007      /* expect 0x4924 */
        divide  0x0001ffff, 0x0008      /* expect 0x3fff */
        divide  0x0001ffff, 0x000f      /* expect 0x2222 */
        divide  0x0001ffff, 0x0010      /* expect 0x1fff */
        divide  0x0001ffff, 0x001f      /* expect 0x1084 */
        divide  0x0001ffff, 0x0020      /* expect 0x0fff */
        divide  0x0001ffff, 0x003f      /* expect 0x0820 */
        divide  0x0001ffff, 0x0040      /* expect 0x07ff */
        divide  0x0001ffff, 0x007f      /* expect 0x0408 */
        divide  0x0001ffff, 0x0080      /* expect 0x03ff */
        divide  0x0001ffff, 0x00ff      /* expect 0x0202 */
        divide  0x0001ffff, 0x0100      /* expect 0x01ff */
        divide  0x0001ffff, 0x01ff      /* expect 0x0100 */
        divide  0x0001ffff, 0x0200      /* expect 0x00ff */
        divide  0x0001ffff, 0x03ff      /* expect 0x0080 */
        divide  0x0001ffff, 0x0400      /* expect 0x007f */
        divide  0x0001ffff, 0x07ff      /* expect 0x0040 */
        divide  0x0001ffff, 0x0800      /* expect 0x003f */
        divide  0x0001ffff, 0x0fff      /* expect 0x0020 */
        divide  0x0001ffff, 0x1000      /* expect 0x001f */
        divide  0x0001ffff, 0x1fff      /* expect 0x0010 */
        divide  0x0001ffff, 0x2000      /* expect 0x000f */
        divide  0x0001ffff, 0x3fff      /* expect 0x0008 */
        divide  0x0001ffff, 0x4000      /* expect 0x0007 */
        divide  0x0001ffff, 0x7fff      /* expect 0x0004 */
        divide  0x00020000, 0x0007      /* expect 0x4924 */
        divide  0x00020000, 0x0008      /* expect 0x4000 */
        divide  0x00020000, 0x000f      /* expect 0x2222 */
        divide  0x00020000, 0x0010      /* expect 0x2000 */
        divide  0x00020000, 0x001f      /* expect 0x1084 */
        divide  0x00020000, 0x0020      /* expect 0x1000 */
        divide  0x00020000, 0x003f      /* expect 0x0820 */
        divide  0x00020000, 0x0040      /* expect 0x0800 */
        divide  0x00020000, 0x007f      /* expect 0x0408 */
        divide  0x00020000, 0x0080      /* expect 0x0400 */
        divide  0x00020000, 0x00ff      /* expect 0x0202 */
        divide  0x00020000, 0x0100      /* expect 0x0200 */
        divide  0x00020000, 0x01ff      /* expect 0x0100 */
        divide  0x00020000, 0x0200      /* expect 0x0100 */
        divide  0x00020000, 0x03ff      /* expect 0x0080 */
        divide  0x00020000, 0x0400      /* expect 0x0080 */
        divide  0x00020000, 0x07ff      /* expect 0x0040 */
        divide  0x00020000, 0x0800      /* expect 0x0040 */
        divide  0x00020000, 0x0fff      /* expect 0x0020 */
        divide  0x00020000, 0x1000      /* expect 0x0020 */
        divide  0x00020000, 0x1fff      /* expect 0x0010 */
        divide  0x00020000, 0x2000      /* expect 0x0010 */
        divide  0x00020000, 0x3fff      /* expect 0x0008 */
        divide  0x00020000, 0x4000      /* expect 0x0008 */
        divide  0x00020000, 0x7fff      /* expect 0x0004 */
        divide  0x0003ffff, 0x0008      /* expect 0x7fff */
        divide  0x0003ffff, 0x000f      /* expect 0x4444 */
        divide  0x0003ffff, 0x0010      /* expect 0x3fff */
        divide  0x0003ffff, 0x001f      /* expect 0x2108 */
        divide  0x0003ffff, 0x0020      /* expect 0x1fff */
        divide  0x0003ffff, 0x003f      /* expect 0x1041 */
        divide  0x0003ffff, 0x0040      /* expect 0x0fff */
        divide  0x0003ffff, 0x007f      /* expect 0x0810 */
        divide  0x0003ffff, 0x0080      /* expect 0x07ff */
        divide  0x0003ffff, 0x00ff      /* expect 0x0404 */
        divide  0x0003ffff, 0x0100      /* expect 0x03ff */
        divide  0x0003ffff, 0x01ff      /* expect 0x0201 */
        divide  0x0003ffff, 0x0200      /* expect 0x01ff */
        divide  0x0003ffff, 0x03ff      /* expect 0x0100 */
        divide  0x0003ffff, 0x0400      /* expect 0x00ff */
        divide  0x0003ffff, 0x07ff      /* expect 0x0080 */
        divide  0x0003ffff, 0x0800      /* expect 0x007f */
        divide  0x0003ffff, 0x0fff      /* expect 0x0040 */
        divide  0x0003ffff, 0x1000      /* expect 0x003f */
        divide  0x0003ffff, 0x1fff      /* expect 0x0020 */
        divide  0x0003ffff, 0x2000      /* expect 0x001f */
        divide  0x0003ffff, 0x3fff      /* expect 0x0010 */
        divide  0x0003ffff, 0x4000      /* expect 0x000f */
        divide  0x0003ffff, 0x7fff      /* expect 0x0008 */
        divide  0x00040000, 0x000f      /* expect 0x4444 */
        divide  0x00040000, 0x0010      /* expect 0x4000 */
        divide  0x00040000, 0x001f      /* expect 0x2108 */
        divide  0x00040000, 0x0020      /* expect 0x2000 */
        divide  0x00040000, 0x003f      /* expect 0x1041 */
        divide  0x00040000, 0x0040      /* expect 0x1000 */
        divide  0x00040000, 0x007f      /* expect 0x0810 */
        divide  0x00040000, 0x0080      /* expect 0x0800 */
        divide  0x00040000, 0x00ff      /* expect 0x0404 */
        divide  0x00040000, 0x0100      /* expect 0x0400 */
        divide  0x00040000, 0x01ff      /* expect 0x0201 */
        divide  0x00040000, 0x0200      /* expect 0x0200 */
        divide  0x00040000, 0x03ff      /* expect 0x0100 */
        divide  0x00040000, 0x0400      /* expect 0x0100 */
        divide  0x00040000, 0x07ff      /* expect 0x0080 */
        divide  0x00040000, 0x0800      /* expect 0x0080 */
        divide  0x00040000, 0x0fff      /* expect 0x0040 */
        divide  0x00040000, 0x1000      /* expect 0x0040 */
        divide  0x00040000, 0x1fff      /* expect 0x0020 */
        divide  0x00040000, 0x2000      /* expect 0x0020 */
        divide  0x00040000, 0x3fff      /* expect 0x0010 */
        divide  0x00040000, 0x4000      /* expect 0x0010 */
        divide  0x00040000, 0x7fff      /* expect 0x0008 */
        divide  0x0007ffff, 0x0010      /* expect 0x7fff */
        divide  0x0007ffff, 0x001f      /* expect 0x4210 */
        divide  0x0007ffff, 0x0020      /* expect 0x3fff */
        divide  0x0007ffff, 0x003f      /* expect 0x2082 */
        divide  0x0007ffff, 0x0040      /* expect 0x1fff */
        divide  0x0007ffff, 0x007f      /* expect 0x1020 */
        divide  0x0007ffff, 0x0080      /* expect 0x0fff */
        divide  0x0007ffff, 0x00ff      /* expect 0x0808 */
        divide  0x0007ffff, 0x0100      /* expect 0x07ff */
        divide  0x0007ffff, 0x01ff      /* expect 0x0402 */
        divide  0x0007ffff, 0x0200      /* expect 0x03ff */
        divide  0x0007ffff, 0x03ff      /* expect 0x0200 */
        divide  0x0007ffff, 0x0400      /* expect 0x01ff */
        divide  0x0007ffff, 0x07ff      /* expect 0x0100 */
        divide  0x0007ffff, 0x0800      /* expect 0x00ff */
        divide  0x0007ffff, 0x0fff      /* expect 0x0080 */
        divide  0x0007ffff, 0x1000      /* expect 0x007f */
        divide  0x0007ffff, 0x1fff      /* expect 0x0040 */
        divide  0x0007ffff, 0x2000      /* expect 0x003f */
        divide  0x0007ffff, 0x3fff      /* expect 0x0020 */
        divide  0x0007ffff, 0x4000      /* expect 0x001f */
        divide  0x0007ffff, 0x7fff      /* expect 0x0010 */
        divide  0x00080000, 0x001f      /* expect 0x4210 */
        divide  0x00080000, 0x0020      /* expect 0x4000 */
        divide  0x00080000, 0x003f      /* expect 0x2082 */
        divide  0x00080000, 0x0040      /* expect 0x2000 */
        divide  0x00080000, 0x007f      /* expect 0x1020 */
        divide  0x00080000, 0x0080      /* expect 0x1000 */
        divide  0x00080000, 0x00ff      /* expect 0x0808 */
        divide  0x00080000, 0x0100      /* expect 0x0800 */
        divide  0x00080000, 0x01ff      /* expect 0x0402 */
        divide  0x00080000, 0x0200      /* expect 0x0400 */
        divide  0x00080000, 0x03ff      /* expect 0x0200 */
        divide  0x00080000, 0x0400      /* expect 0x0200 */
        divide  0x00080000, 0x07ff      /* expect 0x0100 */
        divide  0x00080000, 0x0800      /* expect 0x0100 */
        divide  0x00080000, 0x0fff      /* expect 0x0080 */
        divide  0x00080000, 0x1000      /* expect 0x0080 */
        divide  0x00080000, 0x1fff      /* expect 0x0040 */
        divide  0x00080000, 0x2000      /* expect 0x0040 */
        divide  0x00080000, 0x3fff      /* expect 0x0020 */
        divide  0x00080000, 0x4000      /* expect 0x0020 */
        divide  0x00080000, 0x7fff      /* expect 0x0010 */
        divide  0x000fffff, 0x0020      /* expect 0x7fff */
        divide  0x000fffff, 0x003f      /* expect 0x4104 */
        divide  0x000fffff, 0x0040      /* expect 0x3fff */
        divide  0x000fffff, 0x007f      /* expect 0x2040 */
        divide  0x000fffff, 0x0080      /* expect 0x1fff */
        divide  0x000fffff, 0x00ff      /* expect 0x1010 */
        divide  0x000fffff, 0x0100      /* expect 0x0fff */
        divide  0x000fffff, 0x01ff      /* expect 0x0804 */
        divide  0x000fffff, 0x0200      /* expect 0x07ff */
        divide  0x000fffff, 0x03ff      /* expect 0x0401 */
        divide  0x000fffff, 0x0400      /* expect 0x03ff */
        divide  0x000fffff, 0x07ff      /* expect 0x0200 */
        divide  0x000fffff, 0x0800      /* expect 0x01ff */
        divide  0x000fffff, 0x0fff      /* expect 0x0100 */
        divide  0x000fffff, 0x1000      /* expect 0x00ff */
        divide  0x000fffff, 0x1fff      /* expect 0x0080 */
        divide  0x000fffff, 0x2000      /* expect 0x007f */
        divide  0x000fffff, 0x3fff      /* expect 0x0040 */
        divide  0x000fffff, 0x4000      /* expect 0x003f */
        divide  0x000fffff, 0x7fff      /* expect 0x0020 */
        divide  0x00100000, 0x003f      /* expect 0x4104 */
        divide  0x00100000, 0x0040      /* expect 0x4000 */
        divide  0x00100000, 0x007f      /* expect 0x2040 */
        divide  0x00100000, 0x0080      /* expect 0x2000 */
        divide  0x00100000, 0x00ff      /* expect 0x1010 */
        divide  0x00100000, 0x0100      /* expect 0x1000 */
        divide  0x00100000, 0x01ff      /* expect 0x0804 */
        divide  0x00100000, 0x0200      /* expect 0x0800 */
        divide  0x00100000, 0x03ff      /* expect 0x0401 */
        divide  0x00100000, 0x0400      /* expect 0x0400 */
        divide  0x00100000, 0x07ff      /* expect 0x0200 */
        divide  0x00100000, 0x0800      /* expect 0x0200 */
        divide  0x00100000, 0x0fff      /* expect 0x0100 */
        divide  0x00100000, 0x1000      /* expect 0x0100 */
        divide  0x00100000, 0x1fff      /* expect 0x0080 */
        divide  0x00100000, 0x2000      /* expect 0x0080 */
        divide  0x00100000, 0x3fff      /* expect 0x0040 */
        divide  0x00100000, 0x4000      /* expect 0x0040 */
        divide  0x00100000, 0x7fff      /* expect 0x0020 */
        divide  0x001fffff, 0x0040      /* expect 0x7fff */
        divide  0x001fffff, 0x007f      /* expect 0x4081 */
        divide  0x001fffff, 0x0080      /* expect 0x3fff */
        divide  0x001fffff, 0x00ff      /* expect 0x2020 */
        divide  0x001fffff, 0x0100      /* expect 0x1fff */
        divide  0x001fffff, 0x01ff      /* expect 0x1008 */
        divide  0x001fffff, 0x0200      /* expect 0x0fff */
        divide  0x001fffff, 0x03ff      /* expect 0x0802 */
        divide  0x001fffff, 0x0400      /* expect 0x07ff */
        divide  0x001fffff, 0x07ff      /* expect 0x0400 */
        divide  0x001fffff, 0x0800      /* expect 0x03ff */
        divide  0x001fffff, 0x0fff      /* expect 0x0200 */
        divide  0x001fffff, 0x1000      /* expect 0x01ff */
        divide  0x001fffff, 0x1fff      /* expect 0x0100 */
        divide  0x001fffff, 0x2000      /* expect 0x00ff */
        divide  0x001fffff, 0x3fff      /* expect 0x0080 */
        divide  0x001fffff, 0x4000      /* expect 0x007f */
        divide  0x001fffff, 0x7fff      /* expect 0x0040 */
        divide  0x00200000, 0x007f      /* expect 0x4081 */
        divide  0x00200000, 0x0080      /* expect 0x4000 */
        divide  0x00200000, 0x00ff      /* expect 0x2020 */
        divide  0x00200000, 0x0100      /* expect 0x2000 */
        divide  0x00200000, 0x01ff      /* expect 0x1008 */
        divide  0x00200000, 0x0200      /* expect 0x1000 */
        divide  0x00200000, 0x03ff      /* expect 0x0802 */
        divide  0x00200000, 0x0400      /* expect 0x0800 */
        divide  0x00200000, 0x07ff      /* expect 0x0400 */
        divide  0x00200000, 0x0800      /* expect 0x0400 */
        divide  0x00200000, 0x0fff      /* expect 0x0200 */
        divide  0x00200000, 0x1000      /* expect 0x0200 */
        divide  0x00200000, 0x1fff      /* expect 0x0100 */
        divide  0x00200000, 0x2000      /* expect 0x0100 */
        divide  0x00200000, 0x3fff      /* expect 0x0080 */
        divide  0x00200000, 0x4000      /* expect 0x0080 */
        divide  0x00200000, 0x7fff      /* expect 0x0040 */
        divide  0x003fffff, 0x0080      /* expect 0x7fff */
        divide  0x003fffff, 0x00ff      /* expect 0x4040 */
        divide  0x003fffff, 0x0100      /* expect 0x3fff */
        divide  0x003fffff, 0x01ff      /* expect 0x2010 */
        divide  0x003fffff, 0x0200      /* expect 0x1fff */
        divide  0x003fffff, 0x03ff      /* expect 0x1004 */
        divide  0x003fffff, 0x0400      /* expect 0x0fff */
        divide  0x003fffff, 0x07ff      /* expect 0x0801 */
        divide  0x003fffff, 0x0800      /* expect 0x07ff */
        divide  0x003fffff, 0x0fff      /* expect 0x0400 */
        divide  0x003fffff, 0x1000      /* expect 0x03ff */
        divide  0x003fffff, 0x1fff      /* expect 0x0200 */
        divide  0x003fffff, 0x2000      /* expect 0x01ff */
        divide  0x003fffff, 0x3fff      /* expect 0x0100 */
        divide  0x003fffff, 0x4000      /* expect 0x00ff */
        divide  0x003fffff, 0x7fff      /* expect 0x0080 */
        divide  0x00400000, 0x00ff      /* expect 0x4040 */
        divide  0x00400000, 0x0100      /* expect 0x4000 */
        divide  0x00400000, 0x01ff      /* expect 0x2010 */
        divide  0x00400000, 0x0200      /* expect 0x2000 */
        divide  0x00400000, 0x03ff      /* expect 0x1004 */
        divide  0x00400000, 0x0400      /* expect 0x1000 */
        divide  0x00400000, 0x07ff      /* expect 0x0801 */
        divide  0x00400000, 0x0800      /* expect 0x0800 */
        divide  0x00400000, 0x0fff      /* expect 0x0400 */
        divide  0x00400000, 0x1000      /* expect 0x0400 */
        divide  0x00400000, 0x1fff      /* expect 0x0200 */
        divide  0x00400000, 0x2000      /* expect 0x0200 */
        divide  0x00400000, 0x3fff      /* expect 0x0100 */
        divide  0x00400000, 0x4000      /* expect 0x0100 */
        divide  0x00400000, 0x7fff      /* expect 0x0080 */
        divide  0x007fffff, 0x0100      /* expect 0x7fff */
        divide  0x007fffff, 0x01ff      /* expect 0x4020 */
        divide  0x007fffff, 0x0200      /* expect 0x3fff */
        divide  0x007fffff, 0x03ff      /* expect 0x2008 */
        divide  0x007fffff, 0x0400      /* expect 0x1fff */
        divide  0x007fffff, 0x07ff      /* expect 0x1002 */
        divide  0x007fffff, 0x0800      /* expect 0x0fff */
        divide  0x007fffff, 0x0fff      /* expect 0x0800 */
        divide  0x007fffff, 0x1000      /* expect 0x07ff */
        divide  0x007fffff, 0x1fff      /* expect 0x0400 */
        divide  0x007fffff, 0x2000      /* expect 0x03ff */
        divide  0x007fffff, 0x3fff      /* expect 0x0200 */
        divide  0x007fffff, 0x4000      /* expect 0x01ff */
        divide  0x007fffff, 0x7fff      /* expect 0x0100 */
        divide  0x00800000, 0x01ff      /* expect 0x4020 */
        divide  0x00800000, 0x0200      /* expect 0x4000 */
        divide  0x00800000, 0x03ff      /* expect 0x2008 */
        divide  0x00800000, 0x0400      /* expect 0x2000 */
        divide  0x00800000, 0x07ff      /* expect 0x1002 */
        divide  0x00800000, 0x0800      /* expect 0x1000 */
        divide  0x00800000, 0x0fff      /* expect 0x0800 */
        divide  0x00800000, 0x1000      /* expect 0x0800 */
        divide  0x00800000, 0x1fff      /* expect 0x0400 */
        divide  0x00800000, 0x2000      /* expect 0x0400 */
        divide  0x00800000, 0x3fff      /* expect 0x0200 */
        divide  0x00800000, 0x4000      /* expect 0x0200 */
        divide  0x00800000, 0x7fff      /* expect 0x0100 */
        divide  0x00ffffff, 0x0200      /* expect 0x7fff */
        divide  0x00ffffff, 0x03ff      /* expect 0x4010 */
        divide  0x00ffffff, 0x0400      /* expect 0x3fff */
        divide  0x00ffffff, 0x07ff      /* expect 0x2004 */
        divide  0x00ffffff, 0x0800      /* expect 0x1fff */
        divide  0x00ffffff, 0x0fff      /* expect 0x1001 */
        divide  0x00ffffff, 0x1000      /* expect 0x0fff */
        divide  0x00ffffff, 0x1fff      /* expect 0x0800 */
        divide  0x00ffffff, 0x2000      /* expect 0x07ff */
        divide  0x00ffffff, 0x3fff      /* expect 0x0400 */
        divide  0x00ffffff, 0x4000      /* expect 0x03ff */
        divide  0x00ffffff, 0x7fff      /* expect 0x0200 */
        divide  0x01000000, 0x03ff      /* expect 0x4010 */
        divide  0x01000000, 0x0400      /* expect 0x4000 */
        divide  0x01000000, 0x07ff      /* expect 0x2004 */
        divide  0x01000000, 0x0800      /* expect 0x2000 */
        divide  0x01000000, 0x0fff      /* expect 0x1001 */
        divide  0x01000000, 0x1000      /* expect 0x1000 */
        divide  0x01000000, 0x1fff      /* expect 0x0800 */
        divide  0x01000000, 0x2000      /* expect 0x0800 */
        divide  0x01000000, 0x3fff      /* expect 0x0400 */
        divide  0x01000000, 0x4000      /* expect 0x0400 */
        divide  0x01000000, 0x7fff      /* expect 0x0200 */
        divide  0x01ffffff, 0x0400      /* expect 0x7fff */
        divide  0x01ffffff, 0x07ff      /* expect 0x4008 */
        divide  0x01ffffff, 0x0800      /* expect 0x3fff */
        divide  0x01ffffff, 0x0fff      /* expect 0x2002 */
        divide  0x01ffffff, 0x1000      /* expect 0x1fff */
        divide  0x01ffffff, 0x1fff      /* expect 0x1000 */
        divide  0x01ffffff, 0x2000      /* expect 0x0fff */
        divide  0x01ffffff, 0x3fff      /* expect 0x0800 */
        divide  0x01ffffff, 0x4000      /* expect 0x07ff */
        divide  0x01ffffff, 0x7fff      /* expect 0x0400 */
        divide  0x02000000, 0x07ff      /* expect 0x4008 */
        divide  0x02000000, 0x0800      /* expect 0x4000 */
        divide  0x02000000, 0x0fff      /* expect 0x2002 */
        divide  0x02000000, 0x1000      /* expect 0x2000 */
        divide  0x02000000, 0x1fff      /* expect 0x1000 */
        divide  0x02000000, 0x2000      /* expect 0x1000 */
        divide  0x02000000, 0x3fff      /* expect 0x0800 */
        divide  0x02000000, 0x4000      /* expect 0x0800 */
        divide  0x02000000, 0x7fff      /* expect 0x0400 */
        divide  0x03ffffff, 0x0800      /* expect 0x7fff */
        divide  0x03ffffff, 0x0fff      /* expect 0x4004 */
        divide  0x03ffffff, 0x1000      /* expect 0x3fff */
        divide  0x03ffffff, 0x1fff      /* expect 0x2001 */
        divide  0x03ffffff, 0x2000      /* expect 0x1fff */
        divide  0x03ffffff, 0x3fff      /* expect 0x1000 */
        divide  0x03ffffff, 0x4000      /* expect 0x0fff */
        divide  0x03ffffff, 0x7fff      /* expect 0x0800 */
        divide  0x04000000, 0x0fff      /* expect 0x4004 */
        divide  0x04000000, 0x1000      /* expect 0x4000 */
        divide  0x04000000, 0x1fff      /* expect 0x2001 */
        divide  0x04000000, 0x2000      /* expect 0x2000 */
        divide  0x04000000, 0x3fff      /* expect 0x1000 */
        divide  0x04000000, 0x4000      /* expect 0x1000 */
        divide  0x04000000, 0x7fff      /* expect 0x0800 */
        divide  0x07ffffff, 0x1000      /* expect 0x7fff */
        divide  0x07ffffff, 0x1fff      /* expect 0x4002 */
        divide  0x07ffffff, 0x2000      /* expect 0x3fff */
        divide  0x07ffffff, 0x3fff      /* expect 0x2000 */
        divide  0x07ffffff, 0x4000      /* expect 0x1fff */
        divide  0x07ffffff, 0x7fff      /* expect 0x1000 */
        divide  0x08000000, 0x1fff      /* expect 0x4002 */
        divide  0x08000000, 0x2000      /* expect 0x4000 */
        divide  0x08000000, 0x3fff      /* expect 0x2000 */
        divide  0x08000000, 0x4000      /* expect 0x2000 */
        divide  0x08000000, 0x7fff      /* expect 0x1000 */
        divide  0x0fffffff, 0x2000      /* expect 0x7fff */
        divide  0x0fffffff, 0x3fff      /* expect 0x4001 */
        divide  0x0fffffff, 0x4000      /* expect 0x3fff */
        divide  0x0fffffff, 0x7fff      /* expect 0x2000 */
        divide  0x10000000, 0x3fff      /* expect 0x4001 */
        divide  0x10000000, 0x4000      /* expect 0x4000 */
        divide  0x10000000, 0x7fff      /* expect 0x2000 */
        divide  0x1fffffff, 0x4000      /* expect 0x7fff */
        divide  0x1fffffff, 0x7fff      /* expect 0x4000 */
        divide  0x20000000, 0x7fff      /* expect 0x4000 */

	pass
