// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms.
//! Type definitions for the basic types.
use ctypes::{
    __int64, __uint64, c_char, c_double, c_int, c_long, c_schar, c_short, c_uchar, c_ulong,
    c_ushort, c_void, wchar_t
};
use shared::basetsd::{KAFFINITY, LONG_PTR, ULONG64, ULONG_PTR};
use shared::guiddef::GUID;
#[cfg(target_arch = "x86_64")]
IFDEF!{
pub const MAX_NATURAL_ALIGNMENT: usize = 8;
pub const MEMORY_ALLOCATION_ALIGNMENT: usize = 16;
}
#[cfg(not(target_arch = "x86_64"))]
IFDEF!{
pub const MAX_NATURAL_ALIGNMENT: usize = 4;
pub const MEMORY_ALLOCATION_ALIGNMENT: usize = 8;
}
#[cfg(any(target_arch = "x86_64", target_arch = "x86"))]
pub const SYSTEM_CACHE_ALIGNMENT_SIZE: usize = 64;
#[cfg(not(any(target_arch = "x86_64", target_arch = "x86")))]
pub const SYSTEM_CACHE_ALIGNMENT_SIZE: usize = 128;
pub type PVOID = *mut c_void;
pub type PVOID64 = u64; // This is a 64-bit pointer, even when in 32-bit
pub type VOID = c_void;
pub type CHAR = c_char;
pub type SHORT = c_short;
pub type LONG = c_long;
pub type INT = c_int;
pub type WCHAR = wchar_t;
pub type PWCHAR = *mut WCHAR;
pub type LPWCH = *mut WCHAR;
pub type PWCH = *mut WCHAR;
pub type LPCWCH = *const WCHAR;
pub type PCWCH = *const WCHAR;
pub type NWPSTR = *mut WCHAR;
pub type LPWSTR = *mut WCHAR;
pub type LPTSTR = LPSTR;
pub type PWSTR = *mut WCHAR;
pub type PZPWSTR = *mut PWSTR;
pub type PCZPWSTR = *const PWSTR;
pub type LPUWSTR = *mut WCHAR; // Unaligned pointer
pub type PUWSTR = *mut WCHAR; // Unaligned pointer
pub type LPCWSTR = *const WCHAR;
pub type PCWSTR = *const WCHAR;
pub type PZPCWSTR = *mut PCWSTR;
pub type PCZPCWSTR = *const PCWSTR;
pub type LPCUWSTR = *const WCHAR; // Unaligned pointer
pub type PCUWSTR = *const WCHAR; // Unaligned pointer
pub type PZZWSTR = *mut WCHAR;
pub type PCZZWSTR = *const WCHAR;
pub type PUZZWSTR = *mut WCHAR; // Unaligned pointer
pub type PCUZZWSTR = *const WCHAR; // Unaligned pointer
pub type PNZWCH = *mut WCHAR;
pub type PCNZWCH = *const WCHAR;
pub type PUNZWCH = *mut WCHAR; // Unaligned pointer
pub type PCUNZWCH = *const WCHAR; // Unaligned pointer
pub type LPCWCHAR = *const WCHAR;
pub type PCWCHAR = *const WCHAR;
pub type LPCUWCHAR = *const WCHAR; // Unaligned pointer
pub type PCUWCHAR = *const WCHAR; // Unaligned pointer
pub type UCSCHAR = c_ulong;
pub const UCSCHAR_INVALID_CHARACTER: UCSCHAR = 0xffffffff;
pub const MIN_UCSCHAR: UCSCHAR = 0;
pub const MAX_UCSCHAR: UCSCHAR = 0x0010FFFF;
pub type PUCSCHAR = *mut UCSCHAR;
pub type PCUCSCHAR = *const UCSCHAR;
pub type PUCSSTR = *mut UCSCHAR;
pub type PUUCSSTR = *mut UCSCHAR; // Unaligned pointer
pub type PCUCSSTR = *const UCSCHAR;
pub type PCUUCSSTR = *const UCSCHAR; // Unaligned pointer
pub type PUUCSCHAR = *mut UCSCHAR; // Unaligned pointer
pub type PCUUCSCHAR = *const UCSCHAR; // Unaligned pointer
pub type PCHAR = *mut CHAR;
pub type LPCH = *mut CHAR;
pub type PCH = *mut CHAR;
pub type LPCCH = *const CHAR;
pub type PCCH = *const CHAR;
pub type NPSTR = *mut CHAR;
pub type LPSTR = *mut CHAR;
pub type PSTR = *mut CHAR;
pub type PZPSTR = *mut PSTR;
pub type PCZPSTR = *const PSTR;
pub type LPCSTR = *const CHAR;
pub type PCSTR = *const CHAR;
pub type PZPCSTR = *mut PCSTR;
pub type PCZPCSTR = *const PCSTR;
pub type PZZSTR = *mut CHAR;
pub type PCZZSTR = *const CHAR;
pub type PNZCH = *mut CHAR;
pub type PCNZCH = *const CHAR;
// Skipping TCHAR things
pub type DOUBLE = c_double;
STRUCT!{struct QUAD {
    UseThisFieldToCopy: __int64,
}}
pub type PSHORT = *mut SHORT;
pub type PLONG = *mut LONG;
pub type PQUAD = *mut QUAD;
pub type UCHAR = c_uchar;
pub type USHORT = c_ushort;
pub type ULONG = c_ulong;
pub type UQUAD = QUAD;
pub type PUCHAR = *mut UCHAR;
pub type PUSHORT = *mut USHORT;
pub type PULONG = *mut ULONG;
pub type PUQUAD = *mut UQUAD;
pub type PCUCHAR = *const UCHAR;
pub type PCUSHORT = *const USHORT;
pub type PCULONG = *const ULONG;
pub type PCUQUAD = *const UQUAD;
pub type SCHAR = c_schar;
pub type PSCHAR = *mut SCHAR;
pub type PCSCHAR = *const SCHAR;
pub const ALL_PROCESSOR_GROUPS: USHORT = 0xffff;
STRUCT!{struct PROCESSOR_NUMBER {
    Group: USHORT,
    Number: UCHAR,
    Reserved: UCHAR,
}}
pub type PPROCESSOR_NUMBER = *mut PROCESSOR_NUMBER;
STRUCT!{struct GROUP_AFFINITY {
    Mask: KAFFINITY,
    Group: USHORT,
    Reserved: [USHORT; 3],
}}
pub type PGROUP_AFFINITY = *mut GROUP_AFFINITY;
#[cfg(target_arch = "x86_64")]
pub const MAXIMUM_PROC_PER_GROUP: UCHAR = 64;
#[cfg(not(target_arch = "x86_64"))]
pub const MAXIMUM_PROC_PER_GROUP: UCHAR = 32;
pub const MAXIMUM_PROCESSORS: UCHAR = MAXIMUM_PROC_PER_GROUP;
pub type HANDLE = *mut c_void;
pub type PHANDLE = *mut HANDLE;
pub type FCHAR = UCHAR;
pub type FSHORT = USHORT;
pub type FLONG = ULONG;
pub type HRESULT = c_long;
pub const OBJ_HANDLE_TAGBITS: usize = 0x00000003;
pub type CCHAR = c_char;
pub type CSHORT = c_short;
pub type CLONG = ULONG;
pub type PCCHAR = *mut CCHAR;
pub type PCSHORT = *mut CSHORT;
pub type PCLONG = *mut CLONG;
pub type LCID = ULONG;
pub type PLCID = PULONG;
pub type LANGID = USHORT;
ENUM!{enum COMPARTMENT_ID {
    UNSPECIFIED_COMPARTMENT_ID = 0,
    DEFAULT_COMPARTMENT_ID,
}}
pub type PCOMPARTMENT_ID = *mut COMPARTMENT_ID;
pub type LOGICAL = ULONG;
pub type PLOGICAL = *mut ULONG;
pub type NTSTATUS = LONG;
pub type PNTSTATUS = *mut NTSTATUS;
pub type PCNTSTATUS = *const NTSTATUS;
#[inline]
pub fn NT_SUCCESS(Status: NTSTATUS) -> bool {
    Status >= 0
}
#[inline]
pub fn NT_INFORMATION(Status: NTSTATUS) -> bool {
    ((Status as ULONG) >> 30) == 1
}
#[inline]
pub fn NT_WARNING(Status: NTSTATUS) -> bool {
    ((Status as ULONG) >> 30) == 2
}
#[inline]
pub fn NT_ERROR(Status: NTSTATUS) -> bool {
    ((Status as ULONG) >> 30) == 3
}
pub const APPLICATION_ERROR_MASK: ULONG = 0x20000000;
pub const ERROR_SEVERITY_SUCCESS: ULONG = 0x00000000;
pub const ERROR_SEVERITY_INFORMATIONAL: ULONG = 0x40000000;
pub const ERROR_SEVERITY_WARNING: ULONG = 0x80000000;
pub const ERROR_SEVERITY_ERROR: ULONG = 0xC0000000;
pub type SECURITY_STATUS = c_long;
pub type TIME = LARGE_INTEGER;
pub type PTIME = *mut TIME;
STRUCT!{struct FLOAT128 {
    LowPart: __int64,
    HighPart: __int64,
}}
pub type PFLOAT128 = *mut FLOAT128;
pub type LONGLONG = __int64;
pub type ULONGLONG = __uint64;
pub const MAXLONGLONG: LONGLONG = 0x7fffffffffffffff;
pub type PLONGLONG = *mut LONGLONG;
pub type PULONGLONG = *mut ULONGLONG;
pub type USN = LONGLONG;
UNION!{union LARGE_INTEGER {
    [i64; 1],
    s s_mut: LARGE_INTEGER_s,
    QuadPart QuadPart_mut: LONGLONG,
}}
STRUCT!{struct LARGE_INTEGER_s {
    LowPart: ULONG,
    HighPart: LONG,
}}
pub type PLARGE_INTEGER = *mut LARGE_INTEGER;
UNION!{union ULARGE_INTEGER {
    [u64; 1],
    s s_mut: ULARGE_INTEGER_s,
    QuadPart QuadPart_mut: ULONGLONG,
}}
STRUCT!{struct ULARGE_INTEGER_s {
    LowPart: ULONG,
    HighPart: ULONG,
}}
pub type PULARGE_INTEGER = *mut ULARGE_INTEGER;
pub type RTL_REFERENCE_COUNT = LONG_PTR;
pub type PRTL_REFERENCE_COUNT = *mut RTL_REFERENCE_COUNT;
STRUCT!{struct LUID {
    LowPart: ULONG,
    HighPart: LONG,
}}
pub type PLUID = *mut LUID;
pub type DWORDLONG = ULONGLONG;
pub type PDWORDLONG = *mut DWORDLONG;
pub type PHYSICAL_ADDRESS = LARGE_INTEGER;
pub type PPHYSICAL_ADDRESS = *mut PHYSICAL_ADDRESS;
ENUM!{enum EVENT_TYPE {
    NotificationEvent,
    SynchronizationEvent,
}}
ENUM!{enum TIMER_TYPE {
    NotificationTimer,
    SynchronizationTimer,
}}
ENUM!{enum WAIT_TYPE {
    WaitAll,
    WaitAny,
    WaitNotification,
    WaitDequeue,
}}
pub type PSZ = *mut CHAR;
pub type PCSZ = *const c_char;
pub type RTL_STRING_LENGTH_TYPE = USHORT;
STRUCT!{struct STRING {
    Length: USHORT,
    MaximumLength: USHORT,
    Buffer: PCHAR,
}}
pub type PSTRING = *mut STRING;
pub type ANSI_STRING = STRING;
pub type PANSI_STRING = PSTRING;
pub type OEM_STRING = STRING;
pub type POEM_STRING = PSTRING;
pub type PCOEM_STRING = *const STRING;
STRUCT!{struct CSTRING {
    Length: USHORT,
    MaximumLength: USHORT,
    Buffer: *const c_char,
}}
pub type PCSTRING = *mut CSTRING;
pub const ANSI_NULL: CHAR = 0;
pub type CANSI_STRING = STRING;
pub type PCANSI_STRING = PSTRING;
STRUCT!{struct UNICODE_STRING {
    Length: USHORT,
    MaximumLength: USHORT,
    Buffer: PWCH,
}}
pub type PUNICODE_STRING = *mut UNICODE_STRING;
pub type PCUNICODE_STRING = *const UNICODE_STRING;
pub const UNICODE_NULL: WCHAR = 0;
pub const UNICODE_STRING_MAX_BYTES: USHORT = 65534;
pub const UNICODE_STRING_MAX_CHARS: usize = 32767;
pub type BOOLEAN = UCHAR;
pub type PBOOLEAN = *mut BOOLEAN;
STRUCT!{struct LIST_ENTRY {
    Flink: *mut LIST_ENTRY,
    Blink: *mut LIST_ENTRY,
}}
pub type PLIST_ENTRY = *mut LIST_ENTRY;
pub type PRLIST_ENTRY = *mut LIST_ENTRY; // Restricted pointer
STRUCT!{struct SINGLE_LIST_ENTRY {
    Next: *mut SINGLE_LIST_ENTRY,
}}
pub type PSINGLE_LIST_ENTRY = *mut SINGLE_LIST_ENTRY;
STRUCT!{struct RTL_BALANCED_NODE {
    u: RTL_BALANCED_NODE_u,
    ParentValue: ULONG_PTR,
}}
UNION!{union RTL_BALANCED_NODE_u {
    [usize; 2],
    Children Children_mut: [*mut RTL_BALANCED_NODE; 2],
    s s_mut: RTL_BALANCED_NODE_s,
}}
STRUCT!{struct RTL_BALANCED_NODE_s {
    Left: *mut RTL_BALANCED_NODE,
    Right: *mut RTL_BALANCED_NODE,
}}
pub const RTL_BALANCED_NODE_RESERVED_PARENT_MASK: ULONG_PTR = 3;
pub type PRTL_BALANCED_NODE = *mut RTL_BALANCED_NODE;
#[inline]
pub unsafe fn RTL_BALANCED_NODE_GET_PARENT_POINTER(
    Node: PRTL_BALANCED_NODE,
) -> PRTL_BALANCED_NODE {
    ((*Node).ParentValue & !RTL_BALANCED_NODE_RESERVED_PARENT_MASK) as *mut RTL_BALANCED_NODE
}
STRUCT!{struct LIST_ENTRY32 {
    Flink: ULONG,
    Blink: ULONG,
}}
pub type PLIST_ENTRY32 = *mut LIST_ENTRY32;
STRUCT!{struct LIST_ENTRY64 {
    Flink: ULONGLONG,
    Blink: ULONGLONG,
}}
pub type PLIST_ENTRY64 = *mut LIST_ENTRY64;
STRUCT!{struct SINGLE_LIST_ENTRY32 {
    Next: ULONG,
}}
pub type PSINGLE_LIST_ENTRY32 = *mut SINGLE_LIST_ENTRY32;
#[inline]
pub unsafe fn ListEntry32To64(l32: PLIST_ENTRY32, l64: PLIST_ENTRY64) {
    (*l64).Flink = (*l32).Flink as ULONGLONG;
    (*l64).Blink = (*l32).Blink as ULONGLONG;
}
#[inline]
pub unsafe fn ListEntry64To32(l64: PLIST_ENTRY64, l32: PLIST_ENTRY32) {
    (*l32).Flink = (*l64).Flink as ULONG;
    (*l32).Blink = (*l64).Blink as ULONG;
}
STRUCT!{struct WNF_STATE_NAME {
    Data: [ULONG; 2],
}}
pub type PWNF_STATE_NAME = *mut WNF_STATE_NAME;
pub type PCWNF_STATE_NAME = *const WNF_STATE_NAME;
STRUCT!{struct STRING32 {
    Length: USHORT,
    MaximumLength: USHORT,
    Buffer: ULONG,
}}
pub type PSTRING32 = *mut STRING32;
pub type UNICODE_STRING32 = STRING32;
pub type PUNICODE_STRING32 = *mut UNICODE_STRING32;
pub type ANSI_STRING32 = STRING32;
pub type PANSI_STRING32 = *mut ANSI_STRING32;
STRUCT!{struct STRING64 {
    Length: USHORT,
    MaximumLength: USHORT,
    Buffer: ULONGLONG,
}}
pub type PSTRING64 = *mut STRING64;
pub type UNICODE_STRING64 = STRING64;
pub type PUNICODE_STRING64 = *mut UNICODE_STRING64;
pub type ANSI_STRING64 = STRING64;
pub type PANSI_STRING64 = *mut ANSI_STRING64;
pub const OBJ_INHERIT: ULONG = 0x00000002;
pub const OBJ_PERMANENT: ULONG = 0x00000010;
pub const OBJ_EXCLUSIVE: ULONG = 0x00000020;
pub const OBJ_CASE_INSENSITIVE: ULONG = 0x00000040;
pub const OBJ_OPENIF: ULONG = 0x00000080;
pub const OBJ_OPENLINK: ULONG = 0x00000100;
pub const OBJ_KERNEL_HANDLE: ULONG = 0x00000200;
pub const OBJ_FORCE_ACCESS_CHECK: ULONG = 0x00000400;
pub const OBJ_IGNORE_IMPERSONATED_DEVICEMAP: ULONG = 0x00000800;
pub const OBJ_DONT_REPARSE: ULONG = 0x00001000;
pub const OBJ_VALID_ATTRIBUTES: ULONG = 0x00001FF2;
STRUCT!{struct OBJECT_ATTRIBUTES64 {
    Length: ULONG,
    RootDirectory: ULONG64,
    ObjectName: ULONG64,
    Attributes: ULONG,
    SecurityDescriptor: ULONG64,
    SecurityQualityOfService: ULONG64,
}}
pub type POBJECT_ATTRIBUTES64 = *mut OBJECT_ATTRIBUTES64;
pub type PCOBJECT_ATTRIBUTES64 = *const OBJECT_ATTRIBUTES64;
STRUCT!{struct OBJECT_ATTRIBUTES32 {
    Length: ULONG,
    RootDirectory: ULONG,
    ObjectName: ULONG,
    Attributes: ULONG,
    SecurityDescriptor: ULONG,
    SecurityQualityOfService: ULONG,
}}
pub type POBJECT_ATTRIBUTES32 = *mut OBJECT_ATTRIBUTES32;
pub type PCOBJECT_ATTRIBUTES32 = *const OBJECT_ATTRIBUTES32;
STRUCT!{struct OBJECT_ATTRIBUTES {
    Length: ULONG,
    RootDirectory: HANDLE,
    ObjectName: PUNICODE_STRING,
    Attributes: ULONG,
    SecurityDescriptor: PVOID,
    SecurityQualityOfService: PVOID,
}}
pub type POBJECT_ATTRIBUTES = *mut OBJECT_ATTRIBUTES;
pub type PCOBJECT_ATTRIBUTES = *const OBJECT_ATTRIBUTES;
#[inline]
pub unsafe fn InitializeObjectAttributes(
    p: POBJECT_ATTRIBUTES,
    n: PUNICODE_STRING,
    a: ULONG,
    r: HANDLE,
    s: PVOID,
) {
    use core::mem::size_of;
    (*p).Length = size_of::<OBJECT_ATTRIBUTES>() as ULONG;
    (*p).RootDirectory = r;
    (*p).Attributes = a;
    (*p).ObjectName = n;
    (*p).SecurityDescriptor = s;
    (*p).SecurityQualityOfService = NULL;
}
pub const FALSE: BOOLEAN = 0;
pub const TRUE: BOOLEAN = 1;
pub const NULL: PVOID = 0 as PVOID;
pub const NULL64: PVOID64 = 0;
STRUCT!{struct OBJECTID {
    Lineage: GUID,
    Uniquifier: ULONG,
}}
pub const MINCHAR: CHAR = 0x80;
pub const MAXCHAR: CHAR = 0x7f;
pub const MINSHORT: SHORT = 0x8000;
pub const MAXSHORT: SHORT = 0x7fff;
pub const MINLONG: LONG = 0x80000000;
pub const MAXLONG: LONG = 0x7fffffff;
pub const MAXUCHAR: UCHAR = 0xff;
pub const MAXUSHORT: USHORT = 0xffff;
pub const MAXULONG: ULONG = 0xffffffff;
// PEXCEPTION_ROUTINE: Can't define here, because it needs EXCEPTION_RECORD and CONTEXT.
pub type KIRQL = UCHAR;
pub type PKIRQL = *mut KIRQL;
ENUM!{enum NT_PRODUCT_TYPE {
    NtProductWinNt = 1,
    NtProductLanManNt,
    NtProductServer,
}}
pub type PNT_PRODUCT_TYPE = *mut NT_PRODUCT_TYPE;
ENUM!{enum SUITE_TYPE {
    SmallBusiness,
    Enterprise,
    BackOffice,
    CommunicationServer,
    TerminalServer,
    SmallBusinessRestricted,
    EmbeddedNT,
    DataCenter,
    SingleUserTS,
    Personal,
    Blade,
    EmbeddedRestricted,
    SecurityAppliance,
    StorageServer,
    ComputeServer,
    WHServer,
    PhoneNT,
    MaxSuiteType,
}}
pub const VER_SERVER_NT: ULONG = 0x80000000;
pub const VER_WORKSTATION_NT: ULONG = 0x40000000;
pub const VER_SUITE_SMALLBUSINESS: ULONG = 0x00000001;
pub const VER_SUITE_ENTERPRISE: ULONG = 0x00000002;
pub const VER_SUITE_BACKOFFICE: ULONG = 0x00000004;
pub const VER_SUITE_COMMUNICATIONS: ULONG = 0x00000008;
pub const VER_SUITE_TERMINAL: ULONG = 0x00000010;
pub const VER_SUITE_SMALLBUSINESS_RESTRICTED: ULONG = 0x00000020;
pub const VER_SUITE_EMBEDDEDNT: ULONG = 0x00000040;
pub const VER_SUITE_DATACENTER: ULONG = 0x00000080;
pub const VER_SUITE_SINGLEUSERTS: ULONG = 0x00000100;
pub const VER_SUITE_PERSONAL: ULONG = 0x00000200;
pub const VER_SUITE_BLADE: ULONG = 0x00000400;
pub const VER_SUITE_EMBEDDED_RESTRICTED: ULONG = 0x00000800;
pub const VER_SUITE_SECURITY_APPLIANCE: ULONG = 0x00001000;
pub const VER_SUITE_STORAGE_SERVER: ULONG = 0x00002000;
pub const VER_SUITE_COMPUTE_SERVER: ULONG = 0x00004000;
pub const VER_SUITE_WH_SERVER: ULONG = 0x00008000;
pub const PRODUCT_UNDEFINED: ULONG = 0x00000000;
pub const PRODUCT_ULTIMATE: ULONG = 0x00000001;
pub const PRODUCT_HOME_BASIC: ULONG = 0x00000002;
pub const PRODUCT_HOME_PREMIUM: ULONG = 0x00000003;
pub const PRODUCT_ENTERPRISE: ULONG = 0x00000004;
pub const PRODUCT_HOME_BASIC_N: ULONG = 0x00000005;
pub const PRODUCT_BUSINESS: ULONG = 0x00000006;
pub const PRODUCT_STANDARD_SERVER: ULONG = 0x00000007;
pub const PRODUCT_DATACENTER_SERVER: ULONG = 0x00000008;
pub const PRODUCT_SMALLBUSINESS_SERVER: ULONG = 0x00000009;
pub const PRODUCT_ENTERPRISE_SERVER: ULONG = 0x0000000A;
pub const PRODUCT_STARTER: ULONG = 0x0000000B;
pub const PRODUCT_DATACENTER_SERVER_CORE: ULONG = 0x0000000C;
pub const PRODUCT_STANDARD_SERVER_CORE: ULONG = 0x0000000D;
pub const PRODUCT_ENTERPRISE_SERVER_CORE: ULONG = 0x0000000E;
pub const PRODUCT_ENTERPRISE_SERVER_IA64: ULONG = 0x0000000F;
pub const PRODUCT_BUSINESS_N: ULONG = 0x00000010;
pub const PRODUCT_WEB_SERVER: ULONG = 0x00000011;
pub const PRODUCT_CLUSTER_SERVER: ULONG = 0x00000012;
pub const PRODUCT_HOME_SERVER: ULONG = 0x00000013;
pub const PRODUCT_STORAGE_EXPRESS_SERVER: ULONG = 0x00000014;
pub const PRODUCT_STORAGE_STANDARD_SERVER: ULONG = 0x00000015;
pub const PRODUCT_STORAGE_WORKGROUP_SERVER: ULONG = 0x00000016;
pub const PRODUCT_STORAGE_ENTERPRISE_SERVER: ULONG = 0x00000017;
pub const PRODUCT_SERVER_FOR_SMALLBUSINESS: ULONG = 0x00000018;
pub const PRODUCT_SMALLBUSINESS_SERVER_PREMIUM: ULONG = 0x00000019;
pub const PRODUCT_HOME_PREMIUM_N: ULONG = 0x0000001A;
pub const PRODUCT_ENTERPRISE_N: ULONG = 0x0000001B;
pub const PRODUCT_ULTIMATE_N: ULONG = 0x0000001C;
pub const PRODUCT_WEB_SERVER_CORE: ULONG = 0x0000001D;
pub const PRODUCT_MEDIUMBUSINESS_SERVER_MANAGEMENT: ULONG = 0x0000001E;
pub const PRODUCT_MEDIUMBUSINESS_SERVER_SECURITY: ULONG = 0x0000001F;
pub const PRODUCT_MEDIUMBUSINESS_SERVER_MESSAGING: ULONG = 0x00000020;
pub const PRODUCT_SERVER_FOUNDATION: ULONG = 0x00000021;
pub const PRODUCT_HOME_PREMIUM_SERVER: ULONG = 0x00000022;
pub const PRODUCT_SERVER_FOR_SMALLBUSINESS_V: ULONG = 0x00000023;
pub const PRODUCT_STANDARD_SERVER_V: ULONG = 0x00000024;
pub const PRODUCT_DATACENTER_SERVER_V: ULONG = 0x00000025;
pub const PRODUCT_ENTERPRISE_SERVER_V: ULONG = 0x00000026;
pub const PRODUCT_DATACENTER_SERVER_CORE_V: ULONG = 0x00000027;
pub const PRODUCT_STANDARD_SERVER_CORE_V: ULONG = 0x00000028;
pub const PRODUCT_ENTERPRISE_SERVER_CORE_V: ULONG = 0x00000029;
pub const PRODUCT_HYPERV: ULONG = 0x0000002A;
pub const PRODUCT_STORAGE_EXPRESS_SERVER_CORE: ULONG = 0x0000002B;
pub const PRODUCT_STORAGE_STANDARD_SERVER_CORE: ULONG = 0x0000002C;
pub const PRODUCT_STORAGE_WORKGROUP_SERVER_CORE: ULONG = 0x0000002D;
pub const PRODUCT_STORAGE_ENTERPRISE_SERVER_CORE: ULONG = 0x0000002E;
pub const PRODUCT_STARTER_N: ULONG = 0x0000002F;
pub const PRODUCT_PROFESSIONAL: ULONG = 0x00000030;
pub const PRODUCT_PROFESSIONAL_N: ULONG = 0x00000031;
pub const PRODUCT_SB_SOLUTION_SERVER: ULONG = 0x00000032;
pub const PRODUCT_SERVER_FOR_SB_SOLUTIONS: ULONG = 0x00000033;
pub const PRODUCT_STANDARD_SERVER_SOLUTIONS: ULONG = 0x00000034;
pub const PRODUCT_STANDARD_SERVER_SOLUTIONS_CORE: ULONG = 0x00000035;
pub const PRODUCT_SB_SOLUTION_SERVER_EM: ULONG = 0x00000036;
pub const PRODUCT_SERVER_FOR_SB_SOLUTIONS_EM: ULONG = 0x00000037;
pub const PRODUCT_SOLUTION_EMBEDDEDSERVER: ULONG = 0x00000038;
pub const PRODUCT_SOLUTION_EMBEDDEDSERVER_CORE: ULONG = 0x00000039;
pub const PRODUCT_PROFESSIONAL_EMBEDDED: ULONG = 0x0000003A;
pub const PRODUCT_ESSENTIALBUSINESS_SERVER_MGMT: ULONG = 0x0000003B;
pub const PRODUCT_ESSENTIALBUSINESS_SERVER_ADDL: ULONG = 0x0000003C;
pub const PRODUCT_ESSENTIALBUSINESS_SERVER_MGMTSVC: ULONG = 0x0000003D;
pub const PRODUCT_ESSENTIALBUSINESS_SERVER_ADDLSVC: ULONG = 0x0000003E;
pub const PRODUCT_SMALLBUSINESS_SERVER_PREMIUM_CORE: ULONG = 0x0000003F;
pub const PRODUCT_CLUSTER_SERVER_V: ULONG = 0x00000040;
pub const PRODUCT_EMBEDDED: ULONG = 0x00000041;
pub const PRODUCT_STARTER_E: ULONG = 0x00000042;
pub const PRODUCT_HOME_BASIC_E: ULONG = 0x00000043;
pub const PRODUCT_HOME_PREMIUM_E: ULONG = 0x00000044;
pub const PRODUCT_PROFESSIONAL_E: ULONG = 0x00000045;
pub const PRODUCT_ENTERPRISE_E: ULONG = 0x00000046;
pub const PRODUCT_ULTIMATE_E: ULONG = 0x00000047;
pub const PRODUCT_ENTERPRISE_EVALUATION: ULONG = 0x00000048;
pub const PRODUCT_MULTIPOINT_STANDARD_SERVER: ULONG = 0x0000004C;
pub const PRODUCT_MULTIPOINT_PREMIUM_SERVER: ULONG = 0x0000004D;
pub const PRODUCT_STANDARD_EVALUATION_SERVER: ULONG = 0x0000004F;
pub const PRODUCT_DATACENTER_EVALUATION_SERVER: ULONG = 0x00000050;
pub const PRODUCT_ENTERPRISE_N_EVALUATION: ULONG = 0x00000054;
pub const PRODUCT_EMBEDDED_AUTOMOTIVE: ULONG = 0x00000055;
pub const PRODUCT_EMBEDDED_INDUSTRY_A: ULONG = 0x00000056;
pub const PRODUCT_THINPC: ULONG = 0x00000057;
pub const PRODUCT_EMBEDDED_A: ULONG = 0x00000058;
pub const PRODUCT_EMBEDDED_INDUSTRY: ULONG = 0x00000059;
pub const PRODUCT_EMBEDDED_E: ULONG = 0x0000005A;
pub const PRODUCT_EMBEDDED_INDUSTRY_E: ULONG = 0x0000005B;
pub const PRODUCT_EMBEDDED_INDUSTRY_A_E: ULONG = 0x0000005C;
pub const PRODUCT_STORAGE_WORKGROUP_EVALUATION_SERVER: ULONG = 0x0000005F;
pub const PRODUCT_STORAGE_STANDARD_EVALUATION_SERVER: ULONG = 0x00000060;
pub const PRODUCT_CORE_ARM: ULONG = 0x00000061;
pub const PRODUCT_CORE_N: ULONG = 0x00000062;
pub const PRODUCT_CORE_COUNTRYSPECIFIC: ULONG = 0x00000063;
pub const PRODUCT_CORE_SINGLELANGUAGE: ULONG = 0x00000064;
pub const PRODUCT_CORE: ULONG = 0x00000065;
pub const PRODUCT_PROFESSIONAL_WMC: ULONG = 0x00000067;
pub const PRODUCT_MOBILE_CORE: ULONG = 0x00000068;
pub const PRODUCT_EMBEDDED_INDUSTRY_EVAL: ULONG = 0x00000069;
pub const PRODUCT_EMBEDDED_INDUSTRY_E_EVAL: ULONG = 0x0000006A;
pub const PRODUCT_EMBEDDED_EVAL: ULONG = 0x0000006B;
pub const PRODUCT_EMBEDDED_E_EVAL: ULONG = 0x0000006C;
pub const PRODUCT_NANO_SERVER: ULONG = 0x0000006D;
pub const PRODUCT_CLOUD_STORAGE_SERVER: ULONG = 0x0000006E;
pub const PRODUCT_CORE_CONNECTED: ULONG = 0x0000006F;
pub const PRODUCT_PROFESSIONAL_STUDENT: ULONG = 0x00000070;
pub const PRODUCT_CORE_CONNECTED_N: ULONG = 0x00000071;
pub const PRODUCT_PROFESSIONAL_STUDENT_N: ULONG = 0x00000072;
pub const PRODUCT_CORE_CONNECTED_SINGLELANGUAGE: ULONG = 0x00000073;
pub const PRODUCT_CORE_CONNECTED_COUNTRYSPECIFIC: ULONG = 0x00000074;
pub const PRODUCT_CONNECTED_CAR: ULONG = 0x00000075;
pub const PRODUCT_INDUSTRY_HANDHELD: ULONG = 0x00000076;
pub const PRODUCT_PPI_PRO: ULONG = 0x00000077;
pub const PRODUCT_ARM64_SERVER: ULONG = 0x00000078;
pub const PRODUCT_EDUCATION: ULONG = 0x00000079;
pub const PRODUCT_EDUCATION_N: ULONG = 0x0000007A;
pub const PRODUCT_IOTUAP: ULONG = 0x0000007B;
pub const PRODUCT_CLOUD_HOST_INFRASTRUCTURE_SERVER: ULONG = 0x0000007C;
pub const PRODUCT_ENTERPRISE_S: ULONG = 0x0000007D;
pub const PRODUCT_ENTERPRISE_S_N: ULONG = 0x0000007E;
pub const PRODUCT_PROFESSIONAL_S: ULONG = 0x0000007F;
pub const PRODUCT_PROFESSIONAL_S_N: ULONG = 0x00000080;
pub const PRODUCT_ENTERPRISE_S_EVALUATION: ULONG = 0x00000081;
pub const PRODUCT_ENTERPRISE_S_N_EVALUATION: ULONG = 0x00000082;
pub const PRODUCT_HOLOGRAPHIC: ULONG = 0x00000087;
pub const PRODUCT_PRO_SINGLE_LANGUAGE: ULONG = 0x0000008A;
pub const PRODUCT_PRO_CHINA: ULONG = 0x0000008B;
pub const PRODUCT_ENTERPRISE_SUBSCRIPTION: ULONG = 0x0000008C;
pub const PRODUCT_ENTERPRISE_SUBSCRIPTION_N: ULONG = 0x0000008D;
pub const PRODUCT_DATACENTER_NANO_SERVER: ULONG = 0x0000008F;
pub const PRODUCT_STANDARD_NANO_SERVER: ULONG = 0x00000090;
pub const PRODUCT_DATACENTER_A_SERVER_CORE: ULONG = 0x00000091;
pub const PRODUCT_STANDARD_A_SERVER_CORE: ULONG = 0x00000092;
pub const PRODUCT_DATACENTER_WS_SERVER_CORE: ULONG = 0x00000093;
pub const PRODUCT_STANDARD_WS_SERVER_CORE: ULONG = 0x00000094;
pub const PRODUCT_UTILITY_VM: ULONG = 0x00000095;
pub const PRODUCT_DATACENTER_EVALUATION_SERVER_CORE: ULONG = 0x0000009F;
pub const PRODUCT_STANDARD_EVALUATION_SERVER_CORE: ULONG = 0x000000A0;
pub const PRODUCT_PRO_WORKSTATION: ULONG = 0x000000A1;
pub const PRODUCT_PRO_WORKSTATION_N: ULONG = 0x000000A2;
pub const PRODUCT_PRO_FOR_EDUCATION: ULONG = 0x000000A4;
pub const PRODUCT_PRO_FOR_EDUCATION_N: ULONG = 0x000000A5;
pub const PRODUCT_AZURE_SERVER_CORE: ULONG = 0x000000A8;
pub const PRODUCT_AZURE_NANO_SERVER: ULONG = 0x000000A9;
pub const PRODUCT_UNLICENSED: ULONG = 0xABCDABCD;
pub const LANG_NEUTRAL: USHORT = 0x00;
pub const LANG_INVARIANT: USHORT = 0x7f;
pub const LANG_AFRIKAANS: USHORT = 0x36;
pub const LANG_ALBANIAN: USHORT = 0x1c;
pub const LANG_ALSATIAN: USHORT = 0x84;
pub const LANG_AMHARIC: USHORT = 0x5e;
pub const LANG_ARABIC: USHORT = 0x01;
pub const LANG_ARMENIAN: USHORT = 0x2b;
pub const LANG_ASSAMESE: USHORT = 0x4d;
pub const LANG_AZERI: USHORT = 0x2c;
pub const LANG_AZERBAIJANI: USHORT = 0x2c;
pub const LANG_BANGLA: USHORT = 0x45;
pub const LANG_BASHKIR: USHORT = 0x6d;
pub const LANG_BASQUE: USHORT = 0x2d;
pub const LANG_BELARUSIAN: USHORT = 0x23;
pub const LANG_BENGALI: USHORT = 0x45;
pub const LANG_BRETON: USHORT = 0x7e;
pub const LANG_BOSNIAN: USHORT = 0x1a;
pub const LANG_BOSNIAN_NEUTRAL: USHORT = 0x781a;
pub const LANG_BULGARIAN: USHORT = 0x02;
pub const LANG_CATALAN: USHORT = 0x03;
pub const LANG_CENTRAL_KURDISH: USHORT = 0x92;
pub const LANG_CHEROKEE: USHORT = 0x5c;
pub const LANG_CHINESE: USHORT = 0x04;
pub const LANG_CHINESE_SIMPLIFIED: USHORT = 0x04;
pub const LANG_CHINESE_TRADITIONAL: USHORT = 0x7c04;
pub const LANG_CORSICAN: USHORT = 0x83;
pub const LANG_CROATIAN: USHORT = 0x1a;
pub const LANG_CZECH: USHORT = 0x05;
pub const LANG_DANISH: USHORT = 0x06;
pub const LANG_DARI: USHORT = 0x8c;
pub const LANG_DIVEHI: USHORT = 0x65;
pub const LANG_DUTCH: USHORT = 0x13;
pub const LANG_ENGLISH: USHORT = 0x09;
pub const LANG_ESTONIAN: USHORT = 0x25;
pub const LANG_FAEROESE: USHORT = 0x38;
pub const LANG_FARSI: USHORT = 0x29;
pub const LANG_FILIPINO: USHORT = 0x64;
pub const LANG_FINNISH: USHORT = 0x0b;
pub const LANG_FRENCH: USHORT = 0x0c;
pub const LANG_FRISIAN: USHORT = 0x62;
pub const LANG_FULAH: USHORT = 0x67;
pub const LANG_GALICIAN: USHORT = 0x56;
pub const LANG_GEORGIAN: USHORT = 0x37;
pub const LANG_GERMAN: USHORT = 0x07;
pub const LANG_GREEK: USHORT = 0x08;
pub const LANG_GREENLANDIC: USHORT = 0x6f;
pub const LANG_GUJARATI: USHORT = 0x47;
pub const LANG_HAUSA: USHORT = 0x68;
pub const LANG_HAWAIIAN: USHORT = 0x75;
pub const LANG_HEBREW: USHORT = 0x0d;
pub const LANG_HINDI: USHORT = 0x39;
pub const LANG_HUNGARIAN: USHORT = 0x0e;
pub const LANG_ICELANDIC: USHORT = 0x0f;
pub const LANG_IGBO: USHORT = 0x70;
pub const LANG_INDONESIAN: USHORT = 0x21;
pub const LANG_INUKTITUT: USHORT = 0x5d;
pub const LANG_IRISH: USHORT = 0x3c;
pub const LANG_ITALIAN: USHORT = 0x10;
pub const LANG_JAPANESE: USHORT = 0x11;
pub const LANG_KANNADA: USHORT = 0x4b;
pub const LANG_KASHMIRI: USHORT = 0x60;
pub const LANG_KAZAK: USHORT = 0x3f;
pub const LANG_KHMER: USHORT = 0x53;
pub const LANG_KICHE: USHORT = 0x86;
pub const LANG_KINYARWANDA: USHORT = 0x87;
pub const LANG_KONKANI: USHORT = 0x57;
pub const LANG_KOREAN: USHORT = 0x12;
pub const LANG_KYRGYZ: USHORT = 0x40;
pub const LANG_LAO: USHORT = 0x54;
pub const LANG_LATVIAN: USHORT = 0x26;
pub const LANG_LITHUANIAN: USHORT = 0x27;
pub const LANG_LOWER_SORBIAN: USHORT = 0x2e;
pub const LANG_LUXEMBOURGISH: USHORT = 0x6e;
pub const LANG_MACEDONIAN: USHORT = 0x2f;
pub const LANG_MALAY: USHORT = 0x3e;
pub const LANG_MALAYALAM: USHORT = 0x4c;
pub const LANG_MALTESE: USHORT = 0x3a;
pub const LANG_MANIPURI: USHORT = 0x58;
pub const LANG_MAORI: USHORT = 0x81;
pub const LANG_MAPUDUNGUN: USHORT = 0x7a;
pub const LANG_MARATHI: USHORT = 0x4e;
pub const LANG_MOHAWK: USHORT = 0x7c;
pub const LANG_MONGOLIAN: USHORT = 0x50;
pub const LANG_NEPALI: USHORT = 0x61;
pub const LANG_NORWEGIAN: USHORT = 0x14;
pub const LANG_OCCITAN: USHORT = 0x82;
pub const LANG_ODIA: USHORT = 0x48;
pub const LANG_ORIYA: USHORT = 0x48;
pub const LANG_PASHTO: USHORT = 0x63;
pub const LANG_PERSIAN: USHORT = 0x29;
pub const LANG_POLISH: USHORT = 0x15;
pub const LANG_PORTUGUESE: USHORT = 0x16;
pub const LANG_PULAR: USHORT = 0x67;
pub const LANG_PUNJABI: USHORT = 0x46;
pub const LANG_QUECHUA: USHORT = 0x6b;
pub const LANG_ROMANIAN: USHORT = 0x18;
pub const LANG_ROMANSH: USHORT = 0x17;
pub const LANG_RUSSIAN: USHORT = 0x19;
pub const LANG_SAKHA: USHORT = 0x85;
pub const LANG_SAMI: USHORT = 0x3b;
pub const LANG_SANSKRIT: USHORT = 0x4f;
pub const LANG_SCOTTISH_GAELIC: USHORT = 0x91;
pub const LANG_SERBIAN: USHORT = 0x1a;
pub const LANG_SERBIAN_NEUTRAL: USHORT = 0x7c1a;
pub const LANG_SINDHI: USHORT = 0x59;
pub const LANG_SINHALESE: USHORT = 0x5b;
pub const LANG_SLOVAK: USHORT = 0x1b;
pub const LANG_SLOVENIAN: USHORT = 0x24;
pub const LANG_SOTHO: USHORT = 0x6c;
pub const LANG_SPANISH: USHORT = 0x0a;
pub const LANG_SWAHILI: USHORT = 0x41;
pub const LANG_SWEDISH: USHORT = 0x1d;
pub const LANG_SYRIAC: USHORT = 0x5a;
pub const LANG_TAJIK: USHORT = 0x28;
pub const LANG_TAMAZIGHT: USHORT = 0x5f;
pub const LANG_TAMIL: USHORT = 0x49;
pub const LANG_TATAR: USHORT = 0x44;
pub const LANG_TELUGU: USHORT = 0x4a;
pub const LANG_THAI: USHORT = 0x1e;
pub const LANG_TIBETAN: USHORT = 0x51;
pub const LANG_TIGRIGNA: USHORT = 0x73;
pub const LANG_TIGRINYA: USHORT = 0x73;
pub const LANG_TSWANA: USHORT = 0x32;
pub const LANG_TURKISH: USHORT = 0x1f;
pub const LANG_TURKMEN: USHORT = 0x42;
pub const LANG_UIGHUR: USHORT = 0x80;
pub const LANG_UKRAINIAN: USHORT = 0x22;
pub const LANG_UPPER_SORBIAN: USHORT = 0x2e;
pub const LANG_URDU: USHORT = 0x20;
pub const LANG_UZBEK: USHORT = 0x43;
pub const LANG_VALENCIAN: USHORT = 0x03;
pub const LANG_VIETNAMESE: USHORT = 0x2a;
pub const LANG_WELSH: USHORT = 0x52;
pub const LANG_WOLOF: USHORT = 0x88;
pub const LANG_XHOSA: USHORT = 0x34;
pub const LANG_YAKUT: USHORT = 0x85;
pub const LANG_YI: USHORT = 0x78;
pub const LANG_YORUBA: USHORT = 0x6a;
pub const LANG_ZULU: USHORT = 0x35;
pub const SUBLANG_NEUTRAL: USHORT = 0x00;
pub const SUBLANG_DEFAULT: USHORT = 0x01;
pub const SUBLANG_SYS_DEFAULT: USHORT = 0x02;
pub const SUBLANG_CUSTOM_DEFAULT: USHORT = 0x03;
pub const SUBLANG_CUSTOM_UNSPECIFIED: USHORT = 0x04;
pub const SUBLANG_UI_CUSTOM_DEFAULT: USHORT = 0x05;
pub const SUBLANG_AFRIKAANS_SOUTH_AFRICA: USHORT = 0x01;
pub const SUBLANG_ALBANIAN_ALBANIA: USHORT = 0x01;
pub const SUBLANG_ALSATIAN_FRANCE: USHORT = 0x01;
pub const SUBLANG_AMHARIC_ETHIOPIA: USHORT = 0x01;
pub const SUBLANG_ARABIC_SAUDI_ARABIA: USHORT = 0x01;
pub const SUBLANG_ARABIC_IRAQ: USHORT = 0x02;
pub const SUBLANG_ARABIC_EGYPT: USHORT = 0x03;
pub const SUBLANG_ARABIC_LIBYA: USHORT = 0x04;
pub const SUBLANG_ARABIC_ALGERIA: USHORT = 0x05;
pub const SUBLANG_ARABIC_MOROCCO: USHORT = 0x06;
pub const SUBLANG_ARABIC_TUNISIA: USHORT = 0x07;
pub const SUBLANG_ARABIC_OMAN: USHORT = 0x08;
pub const SUBLANG_ARABIC_YEMEN: USHORT = 0x09;
pub const SUBLANG_ARABIC_SYRIA: USHORT = 0x0a;
pub const SUBLANG_ARABIC_JORDAN: USHORT = 0x0b;
pub const SUBLANG_ARABIC_LEBANON: USHORT = 0x0c;
pub const SUBLANG_ARABIC_KUWAIT: USHORT = 0x0d;
pub const SUBLANG_ARABIC_UAE: USHORT = 0x0e;
pub const SUBLANG_ARABIC_BAHRAIN: USHORT = 0x0f;
pub const SUBLANG_ARABIC_QATAR: USHORT = 0x10;
pub const SUBLANG_ARMENIAN_ARMENIA: USHORT = 0x01;
pub const SUBLANG_ASSAMESE_INDIA: USHORT = 0x01;
pub const SUBLANG_AZERI_LATIN: USHORT = 0x01;
pub const SUBLANG_AZERI_CYRILLIC: USHORT = 0x02;
pub const SUBLANG_AZERBAIJANI_AZERBAIJAN_LATIN: USHORT = 0x01;
pub const SUBLANG_AZERBAIJANI_AZERBAIJAN_CYRILLIC: USHORT = 0x02;
pub const SUBLANG_BANGLA_INDIA: USHORT = 0x01;
pub const SUBLANG_BANGLA_BANGLADESH: USHORT = 0x02;
pub const SUBLANG_BASHKIR_RUSSIA: USHORT = 0x01;
pub const SUBLANG_BASQUE_BASQUE: USHORT = 0x01;
pub const SUBLANG_BELARUSIAN_BELARUS: USHORT = 0x01;
pub const SUBLANG_BENGALI_INDIA: USHORT = 0x01;
pub const SUBLANG_BENGALI_BANGLADESH: USHORT = 0x02;
pub const SUBLANG_BOSNIAN_BOSNIA_HERZEGOVINA_LATIN: USHORT = 0x05;
pub const SUBLANG_BOSNIAN_BOSNIA_HERZEGOVINA_CYRILLIC: USHORT = 0x08;
pub const SUBLANG_BRETON_FRANCE: USHORT = 0x01;
pub const SUBLANG_BULGARIAN_BULGARIA: USHORT = 0x01;
pub const SUBLANG_CATALAN_CATALAN: USHORT = 0x01;
pub const SUBLANG_CENTRAL_KURDISH_IRAQ: USHORT = 0x01;
pub const SUBLANG_CHEROKEE_CHEROKEE: USHORT = 0x01;
pub const SUBLANG_CHINESE_TRADITIONAL: USHORT = 0x01;
pub const SUBLANG_CHINESE_SIMPLIFIED: USHORT = 0x02;
pub const SUBLANG_CHINESE_HONGKONG: USHORT = 0x03;
pub const SUBLANG_CHINESE_SINGAPORE: USHORT = 0x04;
pub const SUBLANG_CHINESE_MACAU: USHORT = 0x05;
pub const SUBLANG_CORSICAN_FRANCE: USHORT = 0x01;
pub const SUBLANG_CZECH_CZECH_REPUBLIC: USHORT = 0x01;
pub const SUBLANG_CROATIAN_CROATIA: USHORT = 0x01;
pub const SUBLANG_CROATIAN_BOSNIA_HERZEGOVINA_LATIN: USHORT = 0x04;
pub const SUBLANG_DANISH_DENMARK: USHORT = 0x01;
pub const SUBLANG_DARI_AFGHANISTAN: USHORT = 0x01;
pub const SUBLANG_DIVEHI_MALDIVES: USHORT = 0x01;
pub const SUBLANG_DUTCH: USHORT = 0x01;
pub const SUBLANG_DUTCH_BELGIAN: USHORT = 0x02;
pub const SUBLANG_ENGLISH_US: USHORT = 0x01;
pub const SUBLANG_ENGLISH_UK: USHORT = 0x02;
pub const SUBLANG_ENGLISH_AUS: USHORT = 0x03;
pub const SUBLANG_ENGLISH_CAN: USHORT = 0x04;
pub const SUBLANG_ENGLISH_NZ: USHORT = 0x05;
pub const SUBLANG_ENGLISH_EIRE: USHORT = 0x06;
pub const SUBLANG_ENGLISH_SOUTH_AFRICA: USHORT = 0x07;
pub const SUBLANG_ENGLISH_JAMAICA: USHORT = 0x08;
pub const SUBLANG_ENGLISH_CARIBBEAN: USHORT = 0x09;
pub const SUBLANG_ENGLISH_BELIZE: USHORT = 0x0a;
pub const SUBLANG_ENGLISH_TRINIDAD: USHORT = 0x0b;
pub const SUBLANG_ENGLISH_ZIMBABWE: USHORT = 0x0c;
pub const SUBLANG_ENGLISH_PHILIPPINES: USHORT = 0x0d;
pub const SUBLANG_ENGLISH_INDIA: USHORT = 0x10;
pub const SUBLANG_ENGLISH_MALAYSIA: USHORT = 0x11;
pub const SUBLANG_ENGLISH_SINGAPORE: USHORT = 0x12;
pub const SUBLANG_ESTONIAN_ESTONIA: USHORT = 0x01;
pub const SUBLANG_FAEROESE_FAROE_ISLANDS: USHORT = 0x01;
pub const SUBLANG_FILIPINO_PHILIPPINES: USHORT = 0x01;
pub const SUBLANG_FINNISH_FINLAND: USHORT = 0x01;
pub const SUBLANG_FRENCH: USHORT = 0x01;
pub const SUBLANG_FRENCH_BELGIAN: USHORT = 0x02;
pub const SUBLANG_FRENCH_CANADIAN: USHORT = 0x03;
pub const SUBLANG_FRENCH_SWISS: USHORT = 0x04;
pub const SUBLANG_FRENCH_LUXEMBOURG: USHORT = 0x05;
pub const SUBLANG_FRENCH_MONACO: USHORT = 0x06;
pub const SUBLANG_FRISIAN_NETHERLANDS: USHORT = 0x01;
pub const SUBLANG_FULAH_SENEGAL: USHORT = 0x02;
pub const SUBLANG_GALICIAN_GALICIAN: USHORT = 0x01;
pub const SUBLANG_GEORGIAN_GEORGIA: USHORT = 0x01;
pub const SUBLANG_GERMAN: USHORT = 0x01;
pub const SUBLANG_GERMAN_SWISS: USHORT = 0x02;
pub const SUBLANG_GERMAN_AUSTRIAN: USHORT = 0x03;
pub const SUBLANG_GERMAN_LUXEMBOURG: USHORT = 0x04;
pub const SUBLANG_GERMAN_LIECHTENSTEIN: USHORT = 0x05;
pub const SUBLANG_GREEK_GREECE: USHORT = 0x01;
pub const SUBLANG_GREENLANDIC_GREENLAND: USHORT = 0x01;
pub const SUBLANG_GUJARATI_INDIA: USHORT = 0x01;
pub const SUBLANG_HAUSA_NIGERIA_LATIN: USHORT = 0x01;
pub const SUBLANG_HAWAIIAN_US: USHORT = 0x01;
pub const SUBLANG_HEBREW_ISRAEL: USHORT = 0x01;
pub const SUBLANG_HINDI_INDIA: USHORT = 0x01;
pub const SUBLANG_HUNGARIAN_HUNGARY: USHORT = 0x01;
pub const SUBLANG_ICELANDIC_ICELAND: USHORT = 0x01;
pub const SUBLANG_IGBO_NIGERIA: USHORT = 0x01;
pub const SUBLANG_INDONESIAN_INDONESIA: USHORT = 0x01;
pub const SUBLANG_INUKTITUT_CANADA: USHORT = 0x01;
pub const SUBLANG_INUKTITUT_CANADA_LATIN: USHORT = 0x02;
pub const SUBLANG_IRISH_IRELAND: USHORT = 0x02;
pub const SUBLANG_ITALIAN: USHORT = 0x01;
pub const SUBLANG_ITALIAN_SWISS: USHORT = 0x02;
pub const SUBLANG_JAPANESE_JAPAN: USHORT = 0x01;
pub const SUBLANG_KANNADA_INDIA: USHORT = 0x01;
pub const SUBLANG_KASHMIRI_SASIA: USHORT = 0x02;
pub const SUBLANG_KASHMIRI_INDIA: USHORT = 0x02;
pub const SUBLANG_KAZAK_KAZAKHSTAN: USHORT = 0x01;
pub const SUBLANG_KHMER_CAMBODIA: USHORT = 0x01;
pub const SUBLANG_KICHE_GUATEMALA: USHORT = 0x01;
pub const SUBLANG_KINYARWANDA_RWANDA: USHORT = 0x01;
pub const SUBLANG_KONKANI_INDIA: USHORT = 0x01;
pub const SUBLANG_KOREAN: USHORT = 0x01;
pub const SUBLANG_KYRGYZ_KYRGYZSTAN: USHORT = 0x01;
pub const SUBLANG_LAO_LAO: USHORT = 0x01;
pub const SUBLANG_LATVIAN_LATVIA: USHORT = 0x01;
pub const SUBLANG_LITHUANIAN: USHORT = 0x01;
pub const SUBLANG_LOWER_SORBIAN_GERMANY: USHORT = 0x02;
pub const SUBLANG_LUXEMBOURGISH_LUXEMBOURG: USHORT = 0x01;
pub const SUBLANG_MACEDONIAN_MACEDONIA: USHORT = 0x01;
pub const SUBLANG_MALAY_MALAYSIA: USHORT = 0x01;
pub const SUBLANG_MALAY_BRUNEI_DARUSSALAM: USHORT = 0x02;
pub const SUBLANG_MALAYALAM_INDIA: USHORT = 0x01;
pub const SUBLANG_MALTESE_MALTA: USHORT = 0x01;
pub const SUBLANG_MAORI_NEW_ZEALAND: USHORT = 0x01;
pub const SUBLANG_MAPUDUNGUN_CHILE: USHORT = 0x01;
pub const SUBLANG_MARATHI_INDIA: USHORT = 0x01;
pub const SUBLANG_MOHAWK_MOHAWK: USHORT = 0x01;
pub const SUBLANG_MONGOLIAN_CYRILLIC_MONGOLIA: USHORT = 0x01;
pub const SUBLANG_MONGOLIAN_PRC: USHORT = 0x02;
pub const SUBLANG_NEPALI_INDIA: USHORT = 0x02;
pub const SUBLANG_NEPALI_NEPAL: USHORT = 0x01;
pub const SUBLANG_NORWEGIAN_BOKMAL: USHORT = 0x01;
pub const SUBLANG_NORWEGIAN_NYNORSK: USHORT = 0x02;
pub const SUBLANG_OCCITAN_FRANCE: USHORT = 0x01;
pub const SUBLANG_ODIA_INDIA: USHORT = 0x01;
pub const SUBLANG_ORIYA_INDIA: USHORT = 0x01;
pub const SUBLANG_PASHTO_AFGHANISTAN: USHORT = 0x01;
pub const SUBLANG_PERSIAN_IRAN: USHORT = 0x01;
pub const SUBLANG_POLISH_POLAND: USHORT = 0x01;
pub const SUBLANG_PORTUGUESE: USHORT = 0x02;
pub const SUBLANG_PORTUGUESE_BRAZILIAN: USHORT = 0x01;
pub const SUBLANG_PULAR_SENEGAL: USHORT = 0x02;
pub const SUBLANG_PUNJABI_INDIA: USHORT = 0x01;
pub const SUBLANG_PUNJABI_PAKISTAN: USHORT = 0x02;
pub const SUBLANG_QUECHUA_BOLIVIA: USHORT = 0x01;
pub const SUBLANG_QUECHUA_ECUADOR: USHORT = 0x02;
pub const SUBLANG_QUECHUA_PERU: USHORT = 0x03;
pub const SUBLANG_ROMANIAN_ROMANIA: USHORT = 0x01;
pub const SUBLANG_ROMANSH_SWITZERLAND: USHORT = 0x01;
pub const SUBLANG_RUSSIAN_RUSSIA: USHORT = 0x01;
pub const SUBLANG_SAKHA_RUSSIA: USHORT = 0x01;
pub const SUBLANG_SAMI_NORTHERN_NORWAY: USHORT = 0x01;
pub const SUBLANG_SAMI_NORTHERN_SWEDEN: USHORT = 0x02;
pub const SUBLANG_SAMI_NORTHERN_FINLAND: USHORT = 0x03;
pub const SUBLANG_SAMI_LULE_NORWAY: USHORT = 0x04;
pub const SUBLANG_SAMI_LULE_SWEDEN: USHORT = 0x05;
pub const SUBLANG_SAMI_SOUTHERN_NORWAY: USHORT = 0x06;
pub const SUBLANG_SAMI_SOUTHERN_SWEDEN: USHORT = 0x07;
pub const SUBLANG_SAMI_SKOLT_FINLAND: USHORT = 0x08;
pub const SUBLANG_SAMI_INARI_FINLAND: USHORT = 0x09;
pub const SUBLANG_SANSKRIT_INDIA: USHORT = 0x01;
pub const SUBLANG_SCOTTISH_GAELIC: USHORT = 0x01;
pub const SUBLANG_SERBIAN_BOSNIA_HERZEGOVINA_LATIN: USHORT = 0x06;
pub const SUBLANG_SERBIAN_BOSNIA_HERZEGOVINA_CYRILLIC: USHORT = 0x07;
pub const SUBLANG_SERBIAN_MONTENEGRO_LATIN: USHORT = 0x0b;
pub const SUBLANG_SERBIAN_MONTENEGRO_CYRILLIC: USHORT = 0x0c;
pub const SUBLANG_SERBIAN_SERBIA_LATIN: USHORT = 0x09;
pub const SUBLANG_SERBIAN_SERBIA_CYRILLIC: USHORT = 0x0a;
pub const SUBLANG_SERBIAN_CROATIA: USHORT = 0x01;
pub const SUBLANG_SERBIAN_LATIN: USHORT = 0x02;
pub const SUBLANG_SERBIAN_CYRILLIC: USHORT = 0x03;
pub const SUBLANG_SINDHI_INDIA: USHORT = 0x01;
pub const SUBLANG_SINDHI_PAKISTAN: USHORT = 0x02;
pub const SUBLANG_SINDHI_AFGHANISTAN: USHORT = 0x02;
pub const SUBLANG_SINHALESE_SRI_LANKA: USHORT = 0x01;
pub const SUBLANG_SOTHO_NORTHERN_SOUTH_AFRICA: USHORT = 0x01;
pub const SUBLANG_SLOVAK_SLOVAKIA: USHORT = 0x01;
pub const SUBLANG_SLOVENIAN_SLOVENIA: USHORT = 0x01;
pub const SUBLANG_SPANISH: USHORT = 0x01;
pub const SUBLANG_SPANISH_MEXICAN: USHORT = 0x02;
pub const SUBLANG_SPANISH_MODERN: USHORT = 0x03;
pub const SUBLANG_SPANISH_GUATEMALA: USHORT = 0x04;
pub const SUBLANG_SPANISH_COSTA_RICA: USHORT = 0x05;
pub const SUBLANG_SPANISH_PANAMA: USHORT = 0x06;
pub const SUBLANG_SPANISH_DOMINICAN_REPUBLIC: USHORT = 0x07;
pub const SUBLANG_SPANISH_VENEZUELA: USHORT = 0x08;
pub const SUBLANG_SPANISH_COLOMBIA: USHORT = 0x09;
pub const SUBLANG_SPANISH_PERU: USHORT = 0x0a;
pub const SUBLANG_SPANISH_ARGENTINA: USHORT = 0x0b;
pub const SUBLANG_SPANISH_ECUADOR: USHORT = 0x0c;
pub const SUBLANG_SPANISH_CHILE: USHORT = 0x0d;
pub const SUBLANG_SPANISH_URUGUAY: USHORT = 0x0e;
pub const SUBLANG_SPANISH_PARAGUAY: USHORT = 0x0f;
pub const SUBLANG_SPANISH_BOLIVIA: USHORT = 0x10;
pub const SUBLANG_SPANISH_EL_SALVADOR: USHORT = 0x11;
pub const SUBLANG_SPANISH_HONDURAS: USHORT = 0x12;
pub const SUBLANG_SPANISH_NICARAGUA: USHORT = 0x13;
pub const SUBLANG_SPANISH_PUERTO_RICO: USHORT = 0x14;
pub const SUBLANG_SPANISH_US: USHORT = 0x15;
pub const SUBLANG_SWAHILI_KENYA: USHORT = 0x01;
pub const SUBLANG_SWEDISH: USHORT = 0x01;
pub const SUBLANG_SWEDISH_FINLAND: USHORT = 0x02;
pub const SUBLANG_SYRIAC_SYRIA: USHORT = 0x01;
pub const SUBLANG_TAJIK_TAJIKISTAN: USHORT = 0x01;
pub const SUBLANG_TAMAZIGHT_ALGERIA_LATIN: USHORT = 0x02;
pub const SUBLANG_TAMAZIGHT_MOROCCO_TIFINAGH: USHORT = 0x04;
pub const SUBLANG_TAMIL_INDIA: USHORT = 0x01;
pub const SUBLANG_TAMIL_SRI_LANKA: USHORT = 0x02;
pub const SUBLANG_TATAR_RUSSIA: USHORT = 0x01;
pub const SUBLANG_TELUGU_INDIA: USHORT = 0x01;
pub const SUBLANG_THAI_THAILAND: USHORT = 0x01;
pub const SUBLANG_TIBETAN_PRC: USHORT = 0x01;
pub const SUBLANG_TIGRIGNA_ERITREA: USHORT = 0x02;
pub const SUBLANG_TIGRINYA_ERITREA: USHORT = 0x02;
pub const SUBLANG_TIGRINYA_ETHIOPIA: USHORT = 0x01;
pub const SUBLANG_TSWANA_BOTSWANA: USHORT = 0x02;
pub const SUBLANG_TSWANA_SOUTH_AFRICA: USHORT = 0x01;
pub const SUBLANG_TURKISH_TURKEY: USHORT = 0x01;
pub const SUBLANG_TURKMEN_TURKMENISTAN: USHORT = 0x01;
pub const SUBLANG_UIGHUR_PRC: USHORT = 0x01;
pub const SUBLANG_UKRAINIAN_UKRAINE: USHORT = 0x01;
pub const SUBLANG_UPPER_SORBIAN_GERMANY: USHORT = 0x01;
pub const SUBLANG_URDU_PAKISTAN: USHORT = 0x01;
pub const SUBLANG_URDU_INDIA: USHORT = 0x02;
pub const SUBLANG_UZBEK_LATIN: USHORT = 0x01;
pub const SUBLANG_UZBEK_CYRILLIC: USHORT = 0x02;
pub const SUBLANG_VALENCIAN_VALENCIA: USHORT = 0x02;
pub const SUBLANG_VIETNAMESE_VIETNAM: USHORT = 0x01;
pub const SUBLANG_WELSH_UNITED_KINGDOM: USHORT = 0x01;
pub const SUBLANG_WOLOF_SENEGAL: USHORT = 0x01;
pub const SUBLANG_XHOSA_SOUTH_AFRICA: USHORT = 0x01;
pub const SUBLANG_YAKUT_RUSSIA: USHORT = 0x01;
pub const SUBLANG_YI_PRC: USHORT = 0x01;
pub const SUBLANG_YORUBA_NIGERIA: USHORT = 0x01;
pub const SUBLANG_ZULU_SOUTH_AFRICA: USHORT = 0x01;
pub const SORT_DEFAULT: USHORT = 0x0;
pub const SORT_INVARIANT_MATH: USHORT = 0x1;
pub const SORT_JAPANESE_XJIS: USHORT = 0x0;
pub const SORT_JAPANESE_UNICODE: USHORT = 0x1;
pub const SORT_JAPANESE_RADICALSTROKE: USHORT = 0x4;
pub const SORT_CHINESE_BIG5: USHORT = 0x0;
pub const SORT_CHINESE_PRCP: USHORT = 0x0;
pub const SORT_CHINESE_UNICODE: USHORT = 0x1;
pub const SORT_CHINESE_PRC: USHORT = 0x2;
pub const SORT_CHINESE_BOPOMOFO: USHORT = 0x3;
pub const SORT_CHINESE_RADICALSTROKE: USHORT = 0x4;
pub const SORT_KOREAN_KSC: USHORT = 0x0;
pub const SORT_KOREAN_UNICODE: USHORT = 0x1;
pub const SORT_GERMAN_PHONE_BOOK: USHORT = 0x1;
pub const SORT_HUNGARIAN_DEFAULT: USHORT = 0x0;
pub const SORT_HUNGARIAN_TECHNICAL: USHORT = 0x1;
pub const SORT_GEORGIAN_TRADITIONAL: USHORT = 0x0;
pub const SORT_GEORGIAN_MODERN: USHORT = 0x1;
macro_rules! MAKELANGID {
    ($p:expr, $s:expr) => {
        (($s as USHORT) << 10) | ($p as USHORT)
    }
}
#[inline]
pub fn MAKELANGID(p: USHORT, s: USHORT) -> LANGID { (s << 10) | p }
#[inline]
pub fn PRIMARYLANGID(lgid: LANGID) -> USHORT { lgid & 0x3ff }
#[inline]
pub fn SUBLANGID(lgid: LANGID) -> USHORT { lgid >> 10 }
pub const NLS_VALID_LOCALE_MASK: ULONG = 0x000fffff;
macro_rules! MAKELCID {
    ($lgid:expr, $srtid:expr) => {
        (($srtid as ULONG) << 16) | ($lgid as ULONG)
    }
}
#[inline]
pub fn MAKELCID(lgid: LANGID, srtid: USHORT) -> LCID {
    ((srtid as ULONG) << 16) | (lgid as ULONG)
}
#[inline]
pub fn MAKESORTLCID(lgid: LANGID, srtid: USHORT, ver: USHORT) -> LCID {
    MAKELCID(lgid, srtid) | ((ver as ULONG) << 20)
}
#[inline]
pub fn LANGIDFROMLCID(lcid: LCID) -> LANGID { lcid as LANGID }
#[inline]
pub fn SORTIDFROMLCID(lcid: LCID) -> USHORT { ((lcid >> 16) & 0xf) as USHORT }
#[inline]
pub fn SORTVERSIONFROMLCID(lcid: LCID) -> USHORT { ((lcid >> 16) & 0xf) as USHORT }
pub const LOCALE_NAME_MAX_LENGTH: usize = 85;
pub const LANG_SYSTEM_DEFAULT: LANGID = MAKELANGID!(LANG_NEUTRAL, SUBLANG_SYS_DEFAULT);
pub const LANG_USER_DEFAULT: LANGID = MAKELANGID!(LANG_NEUTRAL, SUBLANG_DEFAULT);
pub const LOCALE_SYSTEM_DEFAULT: LCID = MAKELCID!(LANG_SYSTEM_DEFAULT, SORT_DEFAULT);
pub const LOCALE_USER_DEFAULT: LCID = MAKELCID!(LANG_USER_DEFAULT, SORT_DEFAULT);
pub const LOCALE_CUSTOM_DEFAULT: LCID
    = MAKELCID!(MAKELANGID!(LANG_NEUTRAL, SUBLANG_CUSTOM_DEFAULT), SORT_DEFAULT);
pub const LOCALE_CUSTOM_UNSPECIFIED: LCID
    = MAKELCID!(MAKELANGID!(LANG_NEUTRAL, SUBLANG_CUSTOM_UNSPECIFIED), SORT_DEFAULT);
pub const LOCALE_CUSTOM_UI_DEFAULT: LCID
    = MAKELCID!(MAKELANGID!(LANG_NEUTRAL, SUBLANG_UI_CUSTOM_DEFAULT), SORT_DEFAULT);
pub const LOCALE_NEUTRAL: LCID
    = MAKELCID!(MAKELANGID!(LANG_NEUTRAL, SUBLANG_NEUTRAL), SORT_DEFAULT);
pub const LOCALE_INVARIANT: LCID
    = MAKELCID!(MAKELANGID!(LANG_INVARIANT, SUBLANG_NEUTRAL), SORT_DEFAULT);
pub const LOCALE_TRANSIENT_KEYBOARD1: LCID = 0x2000;
pub const LOCALE_TRANSIENT_KEYBOARD2: LCID = 0x2400;
pub const LOCALE_TRANSIENT_KEYBOARD3: LCID = 0x2800;
pub const LOCALE_TRANSIENT_KEYBOARD4: LCID = 0x2c00;
pub const LOCALE_UNASSIGNED_LCID: LCID = LOCALE_CUSTOM_UNSPECIFIED;
