#![allow(non_snake_case, non_camel_case_types, non_upper_case_globals, clashing_extern_declarations, clippy::all)]
#[link(name = "windows")]
extern "system" {
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn GetRegistryValueWithFallbackW(hkeyprimary: HKEY, pwszprimarysubkey: super::super::Foundation::PWSTR, hkeyfallback: HKEY, pwszfallbacksubkey: super::super::Foundation::PWSTR, pwszvalue: super::super::Foundation::PWSTR, dwflags: u32, pdwtype: *mut u32, pvdata: *mut ::core::ffi::c_void, cbdatain: u32, pcbdataout: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegCloseKey(hkey: HKEY) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegConnectRegistryA(lpmachinename: super::super::Foundation::PSTR, hkey: HKEY, phkresult: *mut HKEY) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegConnectRegistryExA(lpmachinename: super::super::Foundation::PSTR, hkey: HKEY, flags: u32, phkresult: *mut HKEY) -> i32;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegConnectRegistryExW(lpmachinename: super::super::Foundation::PWSTR, hkey: HKEY, flags: u32, phkresult: *mut HKEY) -> i32;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegConnectRegistryW(lpmachinename: super::super::Foundation::PWSTR, hkey: HKEY, phkresult: *mut HKEY) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegCopyTreeA(hkeysrc: HKEY, lpsubkey: super::super::Foundation::PSTR, hkeydest: HKEY) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegCopyTreeW(hkeysrc: HKEY, lpsubkey: super::super::Foundation::PWSTR, hkeydest: HKEY) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegCreateKeyA(hkey: HKEY, lpsubkey: super::super::Foundation::PSTR, phkresult: *mut HKEY) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation', 'Win32_Security'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))]
    pub fn RegCreateKeyExA(hkey: HKEY, lpsubkey: super::super::Foundation::PSTR, reserved: u32, lpclass: super::super::Foundation::PSTR, dwoptions: REG_OPEN_CREATE_OPTIONS, samdesired: REG_SAM_FLAGS, lpsecurityattributes: *const super::super::Security::SECURITY_ATTRIBUTES, phkresult: *mut HKEY, lpdwdisposition: *mut REG_CREATE_KEY_DISPOSITION) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation', 'Win32_Security'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))]
    pub fn RegCreateKeyExW(hkey: HKEY, lpsubkey: super::super::Foundation::PWSTR, reserved: u32, lpclass: super::super::Foundation::PWSTR, dwoptions: REG_OPEN_CREATE_OPTIONS, samdesired: REG_SAM_FLAGS, lpsecurityattributes: *const super::super::Security::SECURITY_ATTRIBUTES, phkresult: *mut HKEY, lpdwdisposition: *mut REG_CREATE_KEY_DISPOSITION) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation', 'Win32_Security'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))]
    pub fn RegCreateKeyTransactedA(hkey: HKEY, lpsubkey: super::super::Foundation::PSTR, reserved: u32, lpclass: super::super::Foundation::PSTR, dwoptions: REG_OPEN_CREATE_OPTIONS, samdesired: REG_SAM_FLAGS, lpsecurityattributes: *const super::super::Security::SECURITY_ATTRIBUTES, phkresult: *mut HKEY, lpdwdisposition: *mut REG_CREATE_KEY_DISPOSITION, htransaction: super::super::Foundation::HANDLE, pextendedparemeter: *mut ::core::ffi::c_void) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation', 'Win32_Security'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))]
    pub fn RegCreateKeyTransactedW(hkey: HKEY, lpsubkey: super::super::Foundation::PWSTR, reserved: u32, lpclass: super::super::Foundation::PWSTR, dwoptions: REG_OPEN_CREATE_OPTIONS, samdesired: REG_SAM_FLAGS, lpsecurityattributes: *const super::super::Security::SECURITY_ATTRIBUTES, phkresult: *mut HKEY, lpdwdisposition: *mut REG_CREATE_KEY_DISPOSITION, htransaction: super::super::Foundation::HANDLE, pextendedparemeter: *mut ::core::ffi::c_void) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegCreateKeyW(hkey: HKEY, lpsubkey: super::super::Foundation::PWSTR, phkresult: *mut HKEY) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegDeleteKeyA(hkey: HKEY, lpsubkey: super::super::Foundation::PSTR) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegDeleteKeyExA(hkey: HKEY, lpsubkey: super::super::Foundation::PSTR, samdesired: u32, reserved: u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegDeleteKeyExW(hkey: HKEY, lpsubkey: super::super::Foundation::PWSTR, samdesired: u32, reserved: u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegDeleteKeyTransactedA(hkey: HKEY, lpsubkey: super::super::Foundation::PSTR, samdesired: u32, reserved: u32, htransaction: super::super::Foundation::HANDLE, pextendedparameter: *mut ::core::ffi::c_void) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegDeleteKeyTransactedW(hkey: HKEY, lpsubkey: super::super::Foundation::PWSTR, samdesired: u32, reserved: u32, htransaction: super::super::Foundation::HANDLE, pextendedparameter: *mut ::core::ffi::c_void) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegDeleteKeyValueA(hkey: HKEY, lpsubkey: super::super::Foundation::PSTR, lpvaluename: super::super::Foundation::PSTR) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegDeleteKeyValueW(hkey: HKEY, lpsubkey: super::super::Foundation::PWSTR, lpvaluename: super::super::Foundation::PWSTR) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegDeleteKeyW(hkey: HKEY, lpsubkey: super::super::Foundation::PWSTR) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegDeleteTreeA(hkey: HKEY, lpsubkey: super::super::Foundation::PSTR) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegDeleteTreeW(hkey: HKEY, lpsubkey: super::super::Foundation::PWSTR) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegDeleteValueA(hkey: HKEY, lpvaluename: super::super::Foundation::PSTR) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegDeleteValueW(hkey: HKEY, lpvaluename: super::super::Foundation::PWSTR) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegDisablePredefinedCache() -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegDisablePredefinedCacheEx() -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegDisableReflectionKey(hbase: HKEY) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegEnableReflectionKey(hbase: HKEY) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegEnumKeyA(hkey: HKEY, dwindex: u32, lpname: super::super::Foundation::PSTR, cchname: u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegEnumKeyExA(hkey: HKEY, dwindex: u32, lpname: super::super::Foundation::PSTR, lpcchname: *mut u32, lpreserved: *mut u32, lpclass: super::super::Foundation::PSTR, lpcchclass: *mut u32, lpftlastwritetime: *mut super::super::Foundation::FILETIME) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegEnumKeyExW(hkey: HKEY, dwindex: u32, lpname: super::super::Foundation::PWSTR, lpcchname: *mut u32, lpreserved: *mut u32, lpclass: super::super::Foundation::PWSTR, lpcchclass: *mut u32, lpftlastwritetime: *mut super::super::Foundation::FILETIME) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegEnumKeyW(hkey: HKEY, dwindex: u32, lpname: super::super::Foundation::PWSTR, cchname: u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegEnumValueA(hkey: HKEY, dwindex: u32, lpvaluename: super::super::Foundation::PSTR, lpcchvaluename: *mut u32, lpreserved: *mut u32, lptype: *mut u32, lpdata: *mut u8, lpcbdata: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegEnumValueW(hkey: HKEY, dwindex: u32, lpvaluename: super::super::Foundation::PWSTR, lpcchvaluename: *mut u32, lpreserved: *mut u32, lptype: *mut u32, lpdata: *mut u8, lpcbdata: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegFlushKey(hkey: HKEY) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation', 'Win32_Security'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))]
    pub fn RegGetKeySecurity(hkey: HKEY, securityinformation: u32, psecuritydescriptor: *mut super::super::Security::SECURITY_DESCRIPTOR, lpcbsecuritydescriptor: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegGetValueA(hkey: HKEY, lpsubkey: super::super::Foundation::PSTR, lpvalue: super::super::Foundation::PSTR, dwflags: RRF_RT, pdwtype: *mut u32, pvdata: *mut ::core::ffi::c_void, pcbdata: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegGetValueW(hkey: HKEY, lpsubkey: super::super::Foundation::PWSTR, lpvalue: super::super::Foundation::PWSTR, dwflags: RRF_RT, pdwtype: *mut u32, pvdata: *mut ::core::ffi::c_void, pcbdata: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegLoadAppKeyA(lpfile: super::super::Foundation::PSTR, phkresult: *mut HKEY, samdesired: u32, dwoptions: u32, reserved: u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegLoadAppKeyW(lpfile: super::super::Foundation::PWSTR, phkresult: *mut HKEY, samdesired: u32, dwoptions: u32, reserved: u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegLoadKeyA(hkey: HKEY, lpsubkey: super::super::Foundation::PSTR, lpfile: super::super::Foundation::PSTR) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegLoadKeyW(hkey: HKEY, lpsubkey: super::super::Foundation::PWSTR, lpfile: super::super::Foundation::PWSTR) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegLoadMUIStringA(hkey: HKEY, pszvalue: super::super::Foundation::PSTR, pszoutbuf: super::super::Foundation::PSTR, cboutbuf: u32, pcbdata: *mut u32, flags: u32, pszdirectory: super::super::Foundation::PSTR) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegLoadMUIStringW(hkey: HKEY, pszvalue: super::super::Foundation::PWSTR, pszoutbuf: super::super::Foundation::PWSTR, cboutbuf: u32, pcbdata: *mut u32, flags: u32, pszdirectory: super::super::Foundation::PWSTR) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegNotifyChangeKeyValue(hkey: HKEY, bwatchsubtree: super::super::Foundation::BOOL, dwnotifyfilter: REG_NOTIFY_FILTER, hevent: super::super::Foundation::HANDLE, fasynchronous: super::super::Foundation::BOOL) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegOpenCurrentUser(samdesired: u32, phkresult: *mut HKEY) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegOpenKeyA(hkey: HKEY, lpsubkey: super::super::Foundation::PSTR, phkresult: *mut HKEY) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegOpenKeyExA(hkey: HKEY, lpsubkey: super::super::Foundation::PSTR, uloptions: u32, samdesired: REG_SAM_FLAGS, phkresult: *mut HKEY) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegOpenKeyExW(hkey: HKEY, lpsubkey: super::super::Foundation::PWSTR, uloptions: u32, samdesired: REG_SAM_FLAGS, phkresult: *mut HKEY) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegOpenKeyTransactedA(hkey: HKEY, lpsubkey: super::super::Foundation::PSTR, uloptions: u32, samdesired: REG_SAM_FLAGS, phkresult: *mut HKEY, htransaction: super::super::Foundation::HANDLE, pextendedparemeter: *mut ::core::ffi::c_void) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegOpenKeyTransactedW(hkey: HKEY, lpsubkey: super::super::Foundation::PWSTR, uloptions: u32, samdesired: REG_SAM_FLAGS, phkresult: *mut HKEY, htransaction: super::super::Foundation::HANDLE, pextendedparemeter: *mut ::core::ffi::c_void) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegOpenKeyW(hkey: HKEY, lpsubkey: super::super::Foundation::PWSTR, phkresult: *mut HKEY) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegOpenUserClassesRoot(htoken: super::super::Foundation::HANDLE, dwoptions: u32, samdesired: u32, phkresult: *mut HKEY) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegOverridePredefKey(hkey: HKEY, hnewhkey: HKEY) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegQueryInfoKeyA(hkey: HKEY, lpclass: super::super::Foundation::PSTR, lpcchclass: *mut u32, lpreserved: *mut u32, lpcsubkeys: *mut u32, lpcbmaxsubkeylen: *mut u32, lpcbmaxclasslen: *mut u32, lpcvalues: *mut u32, lpcbmaxvaluenamelen: *mut u32, lpcbmaxvaluelen: *mut u32, lpcbsecuritydescriptor: *mut u32, lpftlastwritetime: *mut super::super::Foundation::FILETIME) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegQueryInfoKeyW(hkey: HKEY, lpclass: super::super::Foundation::PWSTR, lpcchclass: *mut u32, lpreserved: *mut u32, lpcsubkeys: *mut u32, lpcbmaxsubkeylen: *mut u32, lpcbmaxclasslen: *mut u32, lpcvalues: *mut u32, lpcbmaxvaluenamelen: *mut u32, lpcbmaxvaluelen: *mut u32, lpcbsecuritydescriptor: *mut u32, lpftlastwritetime: *mut super::super::Foundation::FILETIME) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegQueryMultipleValuesA(hkey: HKEY, val_list: *mut VALENTA, num_vals: u32, lpvaluebuf: super::super::Foundation::PSTR, ldwtotsize: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegQueryMultipleValuesW(hkey: HKEY, val_list: *mut VALENTW, num_vals: u32, lpvaluebuf: super::super::Foundation::PWSTR, ldwtotsize: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegQueryReflectionKey(hbase: HKEY, bisreflectiondisabled: *mut super::super::Foundation::BOOL) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegQueryValueA(hkey: HKEY, lpsubkey: super::super::Foundation::PSTR, lpdata: super::super::Foundation::PSTR, lpcbdata: *mut i32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegQueryValueExA(hkey: HKEY, lpvaluename: super::super::Foundation::PSTR, lpreserved: *mut u32, lptype: *mut REG_VALUE_TYPE, lpdata: *mut u8, lpcbdata: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegQueryValueExW(hkey: HKEY, lpvaluename: super::super::Foundation::PWSTR, lpreserved: *mut u32, lptype: *mut REG_VALUE_TYPE, lpdata: *mut u8, lpcbdata: *mut u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegQueryValueW(hkey: HKEY, lpsubkey: super::super::Foundation::PWSTR, lpdata: super::super::Foundation::PWSTR, lpcbdata: *mut i32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegRenameKey(hkey: HKEY, lpsubkeyname: super::super::Foundation::PWSTR, lpnewkeyname: super::super::Foundation::PWSTR) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegReplaceKeyA(hkey: HKEY, lpsubkey: super::super::Foundation::PSTR, lpnewfile: super::super::Foundation::PSTR, lpoldfile: super::super::Foundation::PSTR) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegReplaceKeyW(hkey: HKEY, lpsubkey: super::super::Foundation::PWSTR, lpnewfile: super::super::Foundation::PWSTR, lpoldfile: super::super::Foundation::PWSTR) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegRestoreKeyA(hkey: HKEY, lpfile: super::super::Foundation::PSTR, dwflags: REG_RESTORE_KEY_FLAGS) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegRestoreKeyW(hkey: HKEY, lpfile: super::super::Foundation::PWSTR, dwflags: REG_RESTORE_KEY_FLAGS) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation', 'Win32_Security'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))]
    pub fn RegSaveKeyA(hkey: HKEY, lpfile: super::super::Foundation::PSTR, lpsecurityattributes: *const super::super::Security::SECURITY_ATTRIBUTES) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation', 'Win32_Security'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))]
    pub fn RegSaveKeyExA(hkey: HKEY, lpfile: super::super::Foundation::PSTR, lpsecurityattributes: *const super::super::Security::SECURITY_ATTRIBUTES, flags: REG_SAVE_FORMAT) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation', 'Win32_Security'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))]
    pub fn RegSaveKeyExW(hkey: HKEY, lpfile: super::super::Foundation::PWSTR, lpsecurityattributes: *const super::super::Security::SECURITY_ATTRIBUTES, flags: REG_SAVE_FORMAT) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation', 'Win32_Security'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))]
    pub fn RegSaveKeyW(hkey: HKEY, lpfile: super::super::Foundation::PWSTR, lpsecurityattributes: *const super::super::Security::SECURITY_ATTRIBUTES) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation', 'Win32_Security'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))]
    pub fn RegSetKeySecurity(hkey: HKEY, securityinformation: u32, psecuritydescriptor: *const super::super::Security::SECURITY_DESCRIPTOR) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegSetKeyValueA(hkey: HKEY, lpsubkey: super::super::Foundation::PSTR, lpvaluename: super::super::Foundation::PSTR, dwtype: u32, lpdata: *const ::core::ffi::c_void, cbdata: u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegSetKeyValueW(hkey: HKEY, lpsubkey: super::super::Foundation::PWSTR, lpvaluename: super::super::Foundation::PWSTR, dwtype: u32, lpdata: *const ::core::ffi::c_void, cbdata: u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegSetValueA(hkey: HKEY, lpsubkey: super::super::Foundation::PSTR, dwtype: REG_VALUE_TYPE, lpdata: super::super::Foundation::PSTR, cbdata: u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegSetValueExA(hkey: HKEY, lpvaluename: super::super::Foundation::PSTR, reserved: u32, dwtype: REG_VALUE_TYPE, lpdata: *const u8, cbdata: u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegSetValueExW(hkey: HKEY, lpvaluename: super::super::Foundation::PWSTR, reserved: u32, dwtype: REG_VALUE_TYPE, lpdata: *const u8, cbdata: u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegSetValueW(hkey: HKEY, lpsubkey: super::super::Foundation::PWSTR, dwtype: REG_VALUE_TYPE, lpdata: super::super::Foundation::PWSTR, cbdata: u32) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegUnLoadKeyA(hkey: HKEY, lpsubkey: super::super::Foundation::PSTR) -> super::super::Foundation::WIN32_ERROR;
    #[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub fn RegUnLoadKeyW(hkey: HKEY, lpsubkey: super::super::Foundation::PWSTR) -> super::super::Foundation::WIN32_ERROR;
}
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const AGP_FLAG_NO_1X_RATE: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const AGP_FLAG_NO_2X_RATE: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const AGP_FLAG_NO_4X_RATE: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const AGP_FLAG_NO_8X_RATE: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const AGP_FLAG_NO_FW_ENABLE: i32 = 512i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const AGP_FLAG_NO_SBA_ENABLE: i32 = 256i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const AGP_FLAG_REVERSE_INITIALIZATION: i32 = 128i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const AGP_FLAG_SPECIAL_RESERVE: i32 = 1015808i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const AGP_FLAG_SPECIAL_TARGET: i32 = 1048575i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const APMMENUSUSPEND_DISABLED: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const APMMENUSUSPEND_ENABLED: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const APMMENUSUSPEND_NOCHANGE: u32 = 128u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const APMMENUSUSPEND_UNDOCKED: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const APMTIMEOUT_DISABLED: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const BIF_RAWDEVICENEEDSDRIVER: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const BIF_SHOWSIMILARDRIVERS: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_BOOT_DEVICE: u32 = 262144u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_CANTSTOPACHILD: u32 = 128u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_DISABLED: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_FAILEDINSTALL: u32 = 64u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_FINISHINSTALL_ACTION: u32 = 131072u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_FINISHINSTALL_UI: u32 = 65536u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_FINISH_INSTALL: u32 = 1024u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_IGNORE_BOOT_LC: u32 = 8u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_MANUAL_INSTALL: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_NEEDS_CLASS_CONFIG: u32 = 524288u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_NEEDS_FORCED_CONFIG: u32 = 2048u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_NETBOOT_CARD: u32 = 4096u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_NET_BOOT: u32 = 16u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_NOREMOVEEXIT: u32 = 512u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_OKREMOVEROM: u32 = 256u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_PARTIAL_LOG_CONF: u32 = 8192u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_REINSTALL: u32 = 32u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_REMOVED: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_SUPPRESS_SURPRISE: u32 = 16384u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CONFIGFLAG_VERIFY_HARDWARE: u32 = 32768u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CSCONFIGFLAG_BITS: u32 = 7u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CSCONFIGFLAG_DISABLED: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CSCONFIGFLAG_DO_NOT_CREATE: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const CSCONFIGFLAG_DO_NOT_START: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const DMSTATEFLAG_APPLYTOALL: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const DOSOPTF_ALWAYSUSE: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const DOSOPTF_DEFAULT: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const DOSOPTF_INDOSSTART: i32 = 64i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const DOSOPTF_MULTIPLE: i32 = 128i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const DOSOPTF_NEEDSETUP: i32 = 32i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const DOSOPTF_PROVIDESUMB: i32 = 16i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const DOSOPTF_SUPPORTED: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const DOSOPTF_USESPMODE: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const DOSOPTGF_DEFCLEAN: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const DRIVERSIGN_BLOCKING: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const DRIVERSIGN_NONE: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const DRIVERSIGN_WARNING: u32 = 1u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub struct DSKTLSYSTEMTIME {
    pub wYear: u16,
    pub wMonth: u16,
    pub wDayOfWeek: u16,
    pub wDay: u16,
    pub wHour: u16,
    pub wMinute: u16,
    pub wSecond: u16,
    pub wMilliseconds: u16,
    pub wResult: u16,
}
impl ::core::marker::Copy for DSKTLSYSTEMTIME {}
impl ::core::clone::Clone for DSKTLSYSTEMTIME {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const DTRESULTFIX: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const DTRESULTOK: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const DTRESULTPART: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const DTRESULTPROB: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const EISAFLAG_NO_IO_MERGE: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const EISAFLAG_SLOT_IO_FIRST: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const EISA_NO_MAX_FUNCTION: u32 = 255u32;
pub type HKEY = isize;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const HKEY_CLASSES_ROOT: HKEY = -2147483648i32 as _;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const HKEY_CURRENT_CONFIG: HKEY = -2147483643i32 as _;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const HKEY_CURRENT_USER: HKEY = -2147483647i32 as _;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const HKEY_CURRENT_USER_LOCAL_SETTINGS: HKEY = -2147483641i32 as _;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const HKEY_DYN_DATA: HKEY = -2147483642i32 as _;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const HKEY_LOCAL_MACHINE: HKEY = -2147483646i32 as _;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const HKEY_PERFORMANCE_DATA: HKEY = -2147483644i32 as _;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const HKEY_PERFORMANCE_NLSTEXT: HKEY = -2147483552i32 as _;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const HKEY_PERFORMANCE_TEXT: HKEY = -2147483568i32 as _;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const HKEY_USERS: HKEY = -2147483645i32 as _;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const IT_COMPACT: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const IT_CUSTOM: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const IT_PORTABLE: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const IT_TYPICAL: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const LASTGOOD_OPERATION: u32 = 255u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const LASTGOOD_OPERATION_DELETE: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const LASTGOOD_OPERATION_NOPOSTPROC: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const MF_FLAGS_CREATE_BUT_NO_SHOW_DISABLED: u32 = 8u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const MF_FLAGS_EVEN_IF_NO_RESOURCE: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const MF_FLAGS_FILL_IN_UNKNOWN_RESOURCE: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const MF_FLAGS_NO_CREATE_IF_NO_RESOURCE: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const NUM_EISA_RANGES: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const NUM_RESOURCE_MAP: u32 = 256u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PCIC_DEFAULT_IRQMASK: u32 = 20152u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PCIC_DEFAULT_NUMSOCKETS: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PCI_OPTIONS_USE_BIOS: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PCI_OPTIONS_USE_IRQ_STEERING: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PCMCIA_DEF_MEMBEGIN: u32 = 786432u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PCMCIA_DEF_MEMEND: u32 = 16777215u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PCMCIA_DEF_MEMLEN: u32 = 4096u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PCMCIA_DEF_MIN_REGION: u32 = 65536u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PCMCIA_OPT_AUTOMEM: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PCMCIA_OPT_HAVE_SOCKET: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PCMCIA_OPT_NO_APMREMOVE: i32 = 32i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PCMCIA_OPT_NO_AUDIO: i32 = 16i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PCMCIA_OPT_NO_SOUND: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_OPTION_DEFAULT: u32 = 15u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_OPTION_ENABLED: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_OPTION_MSSPEC: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_OPTION_REALMODE: u32 = 8u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_OPTION_REGISTRY: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_DISABLED: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_ENABLED: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_ERROR: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_MAX: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_MINIPORT_COMPATIBLE: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_MINIPORT_ERROR: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_MINIPORT_INVALID: u32 = 7u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_MINIPORT_MAX: u32 = 8u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_MINIPORT_NOKEY: u32 = 5u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_MINIPORT_NONE: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_MINIPORT_NORMAL: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_MINIPORT_OVERRIDE: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_MINIPORT_SUCCESS: u32 = 6u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_TABLE_BAD: u32 = 5u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_TABLE_ERROR: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_TABLE_MAX: u32 = 7u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_TABLE_MSSPEC: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_TABLE_NONE: u32 = 3u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_TABLE_REALMODE: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_TABLE_REGISTRY: u32 = 0u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PIR_STATUS_TABLE_SUCCESS: u32 = 6u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub type PQUERYHANDLER = ::core::option::Option<unsafe extern "system" fn(keycontext: *mut ::core::ffi::c_void, val_list: *mut val_context, num_vals: u32, outputbuffer: *mut ::core::ffi::c_void, total_outlen: *mut u32, input_blen: u32) -> u32>;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const PROVIDER_KEEPS_VALUE_LENGTH: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGDF_CONFLICTDMA: u32 = 524288u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGDF_CONFLICTIO: u32 = 65536u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGDF_CONFLICTIRQ: u32 = 262144u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGDF_CONFLICTMEM: u32 = 131072u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGDF_GENFORCEDCONFIG: u32 = 32u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGDF_MAPIRQ2TO9: u32 = 1048576u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGDF_NEEDFULLCONFIG: u32 = 16u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGDF_NODETCONFIG: u32 = 32768u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGDF_NOTDETDMA: u32 = 8u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGDF_NOTDETIO: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGDF_NOTDETIRQ: u32 = 4u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGDF_NOTDETMEM: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGDF_NOTVERIFIED: u32 = 2147483648u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_DATA_NETOS_IPX: &'static str = "IPX";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_DATA_NETOS_NDIS: &'static str = "NDIS";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_DATA_NETOS_ODI: &'static str = "ODI";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_DEFAULT_INSTANCE: &'static str = "0000";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_ACPIENUM: &'static str = "ACPI";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_APM: &'static str = "*PNP0C05";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_BIOSENUM: &'static str = "BIOS";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_CLASS: &'static str = "Class";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_CONFIG: &'static str = "Config";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_CONTROL: &'static str = "Control";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_CRASHES: &'static str = "Crashes";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_CURRENT: &'static str = "Current";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_CURRENT_ENV: &'static str = "\\Windows 4.0";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_DANGERS: &'static str = "Dangers";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_DEFAULT: &'static str = "Default";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_DETMODVARS: &'static str = "DetModVars";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_DEVICEPARAMETERS: &'static str = "Device Parameters";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_DEVICE_PROPERTIES: &'static str = "Properties";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_DISPLAY_CLASS: &'static str = "Display";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_DOSOPTCDROM: &'static str = "CD-ROM";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_DOSOPTMOUSE: &'static str = "MOUSE";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_DRIVERPARAMETERS: &'static str = "Driver Parameters";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_DRIVERS: &'static str = "\\Drivers";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_EBDAUTOEXECBATKEYBOARD: &'static str = "EBDAutoexecBatKeyboard";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_EBDAUTOEXECBATLOCAL: &'static str = "EBDAutoexecBatLocale";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_EBDCONFIGSYSKEYBOARD: &'static str = "EBDConfigSysKeyboard";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_EBDCONFIGSYSLOCAL: &'static str = "EBDConfigSysLocale";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_EBDFILESKEYBOARD: &'static str = "EBDFilesKeyboard";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_EBDFILESLOCAL: &'static str = "EBDFilesLocale";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_EISAENUM: &'static str = "EISA";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_ENUM: &'static str = "Enum";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_EXPLORER: &'static str = "Explorer";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_FILTERS: &'static str = "Filters";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_INIUPDATE: &'static str = "IniUpdate";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_ISAENUM: &'static str = "ISAPnP";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_JOYCURR: &'static str = "CurrentJoystickSettings";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_JOYSETTINGS: &'static str = "JoystickSettings";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_KEYBOARD_CLASS: &'static str = "Keyboard";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_KNOWNDOCKINGSTATES: &'static str = "Hardware Profiles";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_LOGCONFIG: &'static str = "LogConfig";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_LOGON: &'static str = "\\Logon";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_LOWER_FILTER_LEVEL_DEFAULT: &'static str = "*Lower";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_MEDIA_CLASS: &'static str = "MEDIA";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_MODEM_CLASS: &'static str = "Modem";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_MODES: &'static str = "Modes";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_MONITOR_CLASS: &'static str = "Monitor";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_MOUSE_CLASS: &'static str = "Mouse";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_NDISINFO: &'static str = "NDISInfo";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_NETWORK: &'static str = "Network";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_NETWORKPROVIDER: &'static str = "\\NetworkProvider";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_NETWORK_PERSISTENT: &'static str = "\\Persistent";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_NETWORK_RECENT: &'static str = "\\Recent";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_OVERRIDE: &'static str = "Override";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_PCIENUM: &'static str = "PCI";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_PCMCIA: &'static str = "PCMCIA\\";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_PCMCIAENUM: &'static str = "PCMCIA";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_PCMCIA_CLASS: &'static str = "PCMCIA";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_PCMTD: &'static str = "MTD-";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_PCUNKNOWN: &'static str = "UNKNOWN_MANUFACTURER";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_POL_COMPUTERS: &'static str = "Computers";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_POL_DEFAULT: &'static str = ".default";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_POL_USERGROUPDATA: &'static str = "GroupData\\UserGroups\\Priority";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_POL_USERGROUPS: &'static str = "UserGroups";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_POL_USERS: &'static str = "Users";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_PORTS_CLASS: &'static str = "ports";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_PRINTERS: &'static str = "Printers";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_PRINT_PROC: &'static str = "\\Print Processors";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_ROOTENUM: &'static str = "Root";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_RUNHISTORY: &'static str = "RunHistory";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_SCSI_CLASS: &'static str = "SCSIAdapter";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_SETUP: &'static str = "\\Setup";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_SHARES: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Network\\LanMan";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_SYSTEM: &'static str = "System";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_SYSTEMBOARD: &'static str = "*PNP0C01";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_UPPER_FILTER_LEVEL_DEFAULT: &'static str = "*Upper";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_USER: &'static str = "User";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_VPOWERDENUM: &'static str = "VPOWERD";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_KEY_WINOLDAPP: &'static str = "WinOldApp";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_ATT_PC: &'static str = "AT&T PC";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_HP_VECTRA: &'static str = "HP Vectra";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPC: &'static str = "IBM PC";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPCAT: &'static str = "IBM PC/AT";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPCCONV: &'static str = "IBM PC Convertible";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPCJR: &'static str = "IBM PCjr";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPCXT: &'static str = "IBM PC/XT";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPCXT_286: &'static str = "IBM PC/XT 286";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPS1: &'static str = "IBM PS/1";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPS2_25: &'static str = "IBM PS/2-25";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPS2_30: &'static str = "IBM PS/2-30";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPS2_30_286: &'static str = "IBM PS/2-30 286";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPS2_50: &'static str = "IBM PS/2-50";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPS2_50Z: &'static str = "IBM PS/2-50Z";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPS2_55SX: &'static str = "IBM PS/2-55SX";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPS2_60: &'static str = "IBM PS/2-60";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPS2_65SX: &'static str = "IBM PS/2-65SX";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPS2_70: &'static str = "IBM PS/2-70";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPS2_70_80: &'static str = "IBM PS/2-70/80";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPS2_80: &'static str = "IBM PS/2-80";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPS2_90: &'static str = "IBM PS/2-90";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_IBMPS2_P70: &'static str = "IBM PS/2-P70";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_PHOENIX_PCAT: &'static str = "Phoenix PC/AT Compatible";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_UNKNOWN: &'static str = "Unknown";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MACHTYPE_ZENITH_PC: &'static str = "Zenith PC";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_MAX_VALUE_LENGTH: u32 = 256u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_ADDRARB: &'static str = "System\\CurrentControlSet\\Services\\Arbitrators\\AddrArb";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_AEDEBUG: &'static str = "Software\\Microsoft\\Windows NT\\CurrentVersion\\AeDebug";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_APPEARANCE: &'static str = "Control Panel\\Appearance";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_APPPATCH: &'static str = "System\\CurrentControlSet\\Control\\SessionManager\\AppPatches";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_APPPATHS: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\App Paths";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_BIOSINFO: &'static str = "System\\CurrentControlSet\\Control\\BiosInfo";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_BUSINFORMATION: &'static str = "System\\CurrentControlSet\\Control\\PnP\\BusInformation";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CDFS: &'static str = "System\\CurrentControlSet\\Control\\FileSystem\\CDFS";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CHECKBADAPPS: &'static str = "System\\CurrentControlSet\\Control\\SessionManager\\CheckBadApps";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CHECKBADAPPS400: &'static str = "System\\CurrentControlSet\\Control\\SessionManager\\CheckBadApps400";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CHECKDISK: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Applets\\Check Drive";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CHECKDISKSET: &'static str = "Settings";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CHECKDISKUDRVS: &'static str = "NoUnknownDDErrDrvs";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CHECKVERDLLS: &'static str = "System\\CurrentControlSet\\Control\\SessionManager\\CheckVerDLLs";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CHILD_PREFIX: &'static str = "Child";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CHKLASTCHECK: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Applets\\Check Drive\\LastCheck";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CHKLASTSURFAN: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Applets\\Check Drive\\LastSurfaceAnalysis";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CLASS: &'static str = "System\\CurrentControlSet\\Services\\Class";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CLASS_NT: &'static str = "System\\CurrentControlSet\\Control\\Class";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CODEPAGE: &'static str = "System\\CurrentControlSet\\Control\\Nls\\Codepage";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CODEVICEINSTALLERS: &'static str = "System\\CurrentControlSet\\Control\\CoDeviceInstallers";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_COLORS: &'static str = "Control Panel\\Colors";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_COMPUTRNAME: &'static str = "System\\CurrentControlSet\\Control\\ComputerName\\ComputerName";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CONTROLPANEL: &'static str = "Control Panel";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CONTROLSFOLDER: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Controls Folder";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CRITICALDEVICEDATABASE: &'static str = "System\\CurrentControlSet\\Control\\CriticalDeviceDatabase";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CURRENTCONTROLSET: &'static str = "System\\CurrentControlSet";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CURRENT_CONTROL_SET: &'static str = "System\\CurrentControlSet\\Control";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CURSORS: &'static str = "Control Panel\\Cursors";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_CVNETWORK: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Network";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_DESKTOP: &'static str = "Control Panel\\Desktop";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_DETECT: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Detect";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_DEVICEINSTALLER: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Device Installer";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_DEVICE_CLASSES: &'static str = "System\\CurrentControlSet\\Control\\DeviceClasses";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_DIFX: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\DIFX";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_DISPLAYSETTINGS: &'static str = "Display\\Settings";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_DMAARB: &'static str = "System\\CurrentControlSet\\Services\\Arbitrators\\DMAArb";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_DRIVERSIGN: &'static str = "Software\\Microsoft\\Driver Signing";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_DRIVERSIGN_POLICY: &'static str = "Software\\Policies\\Microsoft\\Windows NT\\Driver Signing";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_ENUM: &'static str = "Enum";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_ENVIRONMENTS: &'static str = "System\\CurrentControlSet\\Control\\Print\\Environments";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_EVENTLABELS: &'static str = "AppEvents\\EventLabels";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_EXPLORER: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_FAULT: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Fault";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_FILESYSTEM: &'static str = "System\\CurrentControlSet\\Control\\FileSystem";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_FILESYSTEM_NOVOLTRACK: &'static str = "System\\CurrentControlSet\\Control\\FileSystem\\NoVolTrack";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_FLOATINGPOINTPROCESSOR: &'static str = "HARDWARE\\DESCRIPTION\\System\\FloatingPointProcessor";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_FLOATINGPOINTPROCESSOR0: &'static str = "HARDWARE\\DESCRIPTION\\System\\FloatingPointProcessor\\0";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_FONTS: &'static str = "Display\\Fonts";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_GRPCONV: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\GrpConv";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_HACKINIFILE: &'static str = "System\\CurrentControlSet\\Control\\SessionManager\\HackIniFiles";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_HWPROFILES: &'static str = "System\\CurrentControlSet\\Hardware Profiles";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_HWPROFILESCURRENT: &'static str = "System\\CurrentControlSet\\Hardware Profiles\\Current";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_ICONS: &'static str = "Control Panel\\Icons";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_IDCONFIGDB: &'static str = "System\\CurrentControlSet\\Control\\IDConfigDB";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_INSTALLEDFILES: &'static str = "System\\CurrentControlSet\\Control\\InstalledFiles";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_IOARB: &'static str = "System\\CurrentControlSet\\Services\\Arbitrators\\IOArb";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_IOS: &'static str = "System\\CurrentControlSet\\Services\\VxD\\IOS";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_IRQARB: &'static str = "System\\CurrentControlSet\\Services\\Arbitrators\\IRQArb";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_KEYBOARD: &'static str = "Control Panel\\Keyboard";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_KNOWN16DLLS: &'static str = "System\\CurrentControlSet\\Control\\SessionManager\\Known16DLLs";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_KNOWNDLLS: &'static str = "System\\CurrentControlSet\\Control\\SessionManager\\KnownDLLs";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_KNOWNVXDS: &'static str = "System\\CurrentControlSet\\Control\\SessionManager\\KnownVxDs";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_LASTBACKUP: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\LastBackup";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_LASTCHECK: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\LastCheck";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_LASTGOOD: &'static str = "System\\LastKnownGoodRecovery\\LastGood";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_LASTGOODTMP: &'static str = "System\\LastKnownGoodRecovery\\LastGood.Tmp";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_LASTOPTIMIZE: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\LastOptimize";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_LOOKSCHEMES: &'static str = "Control Panel\\Appearance\\Schemes";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_METRICS: &'static str = "Control Panel\\Desktop\\WindowMetrics";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_MONITORS: &'static str = "System\\CurrentControlSet\\Control\\Print\\Monitors";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_MOUSE: &'static str = "Control Panel\\Mouse";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_MSDOSOPTS: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\MS-DOSOptions";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_MULTIMEDIA_AUDIO: &'static str = "Software\\Microsoft\\Multimedia\\Audio";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_MULTI_FUNCTION: &'static str = "MF";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_NCPSERVER: &'static str = "System\\CurrentControlSet\\Services\\NcpServer\\Parameters";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_NETEQUIV: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Network\\Equivalent";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_NETWORK_USERSETTINGS: &'static str = "Network";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_NEWDOSBOX: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\MS-DOSSpecialConfig";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_NONDRIVERSIGN: &'static str = "Software\\Microsoft\\Non-Driver Signing";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_NONDRIVERSIGN_POLICY: &'static str = "Software\\Policies\\Microsoft\\Windows NT\\Non-Driver Signing";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_NOSUGGMSDOS: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\NoMSDOSWarn";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_NT_CURRENTVERSION: &'static str = "Software\\Microsoft\\Windows NT\\CurrentVersion";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_NWREDIR: &'static str = "System\\CurrentControlSet\\Services\\VxD\\NWREDIR";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_PCIIR: &'static str = "System\\CurrentControlSet\\Control\\Pnp\\PciIrqRouting";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_PER_HW_ID_STORAGE: &'static str = "Software\\Microsoft\\Windows NT\\CurrentVersion\\PerHwIdStorage";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_PIFCONVERT: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\PIFConvert";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_POLICIES: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Policies";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_PRINT: &'static str = "System\\CurrentControlSet\\Control\\Print";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_PRINTERS: &'static str = "System\\CurrentControlSet\\Control\\Print\\Printers";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_PROPERTYSYSTEM: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\PropertySystem";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_PROVIDERS: &'static str = "System\\CurrentControlSet\\Control\\Print\\Providers";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_PWDPROVIDER: &'static str = "System\\CurrentControlSet\\Control\\PwdProvider";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_REALMODENET: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Network\\Real Mode Net";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_REINSTALL: &'static str = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Reinstall";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_RELIABILITY: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Reliability";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_RELIABILITY_POLICY: &'static str = "Software\\Policies\\Microsoft\\Windows NT\\Reliability";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_RELIABILITY_POLICY_REPORTSNAPSHOT: &'static str = "ReportSnapshot";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_RELIABILITY_POLICY_SHUTDOWNREASONUI: &'static str = "ShutdownReasonUI";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_RELIABILITY_POLICY_SNAPSHOT: &'static str = "Snapshot";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_ROOT: &'static str = "Enum\\Root";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_RUN: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Run";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_RUNONCE: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\RunOnce";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_RUNONCEEX: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\RunOnceEx";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_RUNSERVICES: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\RunServices";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_RUNSERVICESONCE: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\RunServicesOnce";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_SCHEMES: &'static str = "AppEvents\\Schemes";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_SCREENSAVE: &'static str = "Control Panel\\Desktop";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_SERVICES: &'static str = "System\\CurrentControlSet\\Services";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_SETUP: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_SHUTDOWN: &'static str = "System\\CurrentControlSet\\Control\\Shutdown";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_SOUND: &'static str = "Control Panel\\Sound";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_SYSTEMENUM: &'static str = "System\\CurrentControlSet\\Enum";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_SYSTRAY: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Applets\\SysTray";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_TIMEZONE: &'static str = "System\\CurrentControlSet\\Control\\TimeZoneInformation";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_UNINSTALL: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_UPDATE: &'static str = "System\\CurrentControlSet\\Control\\Update";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_VCOMM: &'static str = "System\\CurrentControlSet\\Services\\VxD\\VCOMM";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_VMM: &'static str = "System\\CurrentControlSet\\Services\\VxD\\VMM";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_VMM32FILES: &'static str = "System\\CurrentControlSet\\Control\\VMM32Files";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_VNETSUP: &'static str = "System\\CurrentControlSet\\Services\\VxD\\VNETSUP";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_VOLUMECACHE: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\VolumeCaches";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_VPOWERD: &'static str = "System\\CurrentControlSet\\Services\\VxD\\VPOWERD";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_VXD: &'static str = "System\\CurrentControlSet\\Services\\VxD";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_WARNVERDLLS: &'static str = "System\\CurrentControlSet\\Control\\SessionManager\\WarnVerDLLs";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_WINBOOT: &'static str = "System\\CurrentControlSet\\Control\\WinBoot";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_WINDOWSAPPLETS: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Applets";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_WINLOGON: &'static str = "Software\\Microsoft\\Windows\\CurrentVersion\\Winlogon";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PATH_WMI_SECURITY: &'static str = "System\\CurrentControlSet\\Control\\Wmi\\Security";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PCI_DUAL_IDE: &'static str = "PCIDualIDE";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_PCI_OPTIONS: &'static str = "Options";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VALUE_DEFAULTLOC: &'static str = "UseDefaultNetLocation";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VALUE_ENABLE: &'static str = "Enable";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VALUE_LOWPOWERACTIVE: &'static str = "ScreenSaveLowPowerActive";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VALUE_LOWPOWERTIMEOUT: &'static str = "ScreenSaveLowPowerTimeout";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VALUE_NETPATH: &'static str = "NetworkPath";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VALUE_POWEROFFACTIVE: &'static str = "ScreenSavePowerOffActive";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VALUE_POWEROFFTIMEOUT: &'static str = "ScreenSavePowerOffTimeout";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VALUE_SCRPASSWORD: &'static str = "ScreenSave_Data";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VALUE_USESCRPASSWORD: &'static str = "ScreenSaveUsePassword";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VALUE_VERBOSE: &'static str = "Verbose";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_ACDRIVESPINDOWN: &'static str = "ACDriveSpinDown";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_ACSPINDOWNPREVIOUS: &'static str = "ACSpinDownPrevious";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_ACTIVESERVICE: &'static str = "ActiveService";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_ADDRESS: &'static str = "Address";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_AEDEBUG_AUTO: &'static str = "Auto";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_AEDEBUG_DEBUGGER: &'static str = "Debugger";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_ALPHANUMPWDS: &'static str = "AlphanumPwds";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_APISUPPORT: &'static str = "APISupport";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_APMACTIMEOUT: &'static str = "APMACTimeout";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_APMBATTIMEOUT: &'static str = "APMBatTimeout";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_APMBIOSVER: &'static str = "APMBiosVer";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_APMFLAGS: &'static str = "APMFlags";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_APMMENUSUSPEND: &'static str = "APMMenuSuspend";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_APMSHUTDOWNPOWER: &'static str = "APMShutDownPower";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_APPINSTPATH: &'static str = "AppInstallPath";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_ASKFORCONFIG: &'static str = "AskForConfig";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_ASKFORCONFIGFUNC: &'static str = "AskForConfigFunc";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_ASYNCFILECOMMIT: &'static str = "AsyncFileCommit";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_AUDIO_BITMAP: &'static str = "bitmap";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_AUDIO_ICON: &'static str = "icon";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_AUTHENT_AGENT: &'static str = "AuthenticatingAgent";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_AUTOEXEC: &'static str = "Autoexec.Bat";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_AUTOINSNOTE: &'static str = "AutoInsertNotification";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_AUTOLOGON: &'static str = "AutoLogon";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_AUTOMOUNT: &'static str = "AutoMountDrives";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_AUTOSTART: &'static str = "AutoStart";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_BASICPROPERTIES: &'static str = "BasicProperties";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_BASICPROPERTIES_32: &'static str = "BasicProperties32";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_BATDRIVESPINDOWN: &'static str = "BatDriveSpinDown";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_BATSPINDOWNPREVIOUS: &'static str = "BatSpinDownPrevious";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_BEHAVIOR_ON_FAILED_VERIFY: &'static str = "BehaviorOnFailedVerify";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_BIOSDATE: &'static str = "BIOSDate";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_BIOSNAME: &'static str = "BIOSName";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_BIOSVERSION: &'static str = "BIOSVersion";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_BITSPERPIXEL: &'static str = "BitsPerPixel";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_BOOTCONFIG: &'static str = "BootConfig";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_BOOTCOUNT: &'static str = "BootCount";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_BOOTDIR: &'static str = "BootDir";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_BPP: &'static str = "BPP";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_BT: &'static str = "6005BT";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_BUFFAGETIMEOUT: &'static str = "BufferAgeTimeout";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_BUFFIDLETIMEOUT: &'static str = "BufferIdleTimeout";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_BUSTYPE: &'static str = "BusType";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CAPABILITIES: &'static str = "Capabilities";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CARDSPECIFIC: &'static str = "CardSpecific";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CDCACHESIZE: &'static str = "CacheSize";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CDCOMPATNAMES: &'static str = "MSCDEXCompatNames";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CDEXTERRORS: &'static str = "ExtendedErrors";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CDNOREADAHEAD: &'static str = "NoReadAhead";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CDPREFETCH: &'static str = "Prefetch";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CDPREFETCHTAIL: &'static str = "PrefetchTail";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CDRAWCACHE: &'static str = "RawCache";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CDROM: &'static str = "GenCD";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CDROMCLASSNAME: &'static str = "CDROM";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CDSHOWVERSIONS: &'static str = "ShowVersions";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CDSVDSENSE: &'static str = "SVDSense";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CHECKSUM: &'static str = "CurrentChecksum";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CLASS: &'static str = "Class";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CLASSDESC: &'static str = "ClassDesc";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CLASSGUID: &'static str = "ClassGUID";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CMDRIVFLAGS: &'static str = "CMDrivFlags";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CMENUMFLAGS: &'static str = "CMEnumFlags";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_COINSTALLERS_32: &'static str = "CoInstallers32";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_COMINFO: &'static str = "ComInfo";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_COMMENT: &'static str = "Comment";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_COMPATIBLEIDS: &'static str = "CompatibleIDs";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_COMPRESSIONMETHOD: &'static str = "CompressionAlgorithm";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_COMPRESSIONTHRESHOLD: &'static str = "CompressionThreshold";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_COMPUTERNAME: &'static str = "ComputerName";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_COMPUTRNAME: &'static str = "ComputerName";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_COMVERIFYBASE: &'static str = "COMVerifyBase";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CONFIG: &'static str = "ConfigPath";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CONFIGFLAGS: &'static str = "ConfigFlags";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CONFIGMG: &'static str = "CONFIGMG";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CONFIGSYS: &'static str = "Config.Sys";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CONNECTION_TYPE: &'static str = "ConnectionType";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CONTAINERID: &'static str = "ContainerID";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CONTIGFILEALLOC: &'static str = "ContigFileAllocSize";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CONVMEM: &'static str = "ConvMem";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CPU: &'static str = "CPU";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CRASHFUNCS: &'static str = "CrashFuncs";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CSCONFIGFLAGS: &'static str = "CSConfigFlags";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CURCONFIG: &'static str = "CurrentConfig";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CURDRVLET: &'static str = "CurrentDriveLetterAssignment";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CURRENTCONFIG: &'static str = "CurrentConfig";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CURRENT_BUILD: &'static str = "CurrentBuildNumber";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CURRENT_CSDVERSION: &'static str = "CSDVersion";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CURRENT_TYPE: &'static str = "CurrentType";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CURRENT_USER: &'static str = "Current User";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CURRENT_VERSION: &'static str = "CurrentVersion";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CUSTOMCOLORS: &'static str = "CustomColors";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CUSTOM_PROPERTY_CACHE_DATE: &'static str = "CustomPropertyCacheDate";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_CUSTOM_PROPERTY_HW_ID_KEY: &'static str = "CustomPropertyHwIdKey";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DEFAULT: &'static str = "Default";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DETCONFIG: &'static str = "DetConfig";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DETECT: &'static str = "Detect";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DETECTFUNC: &'static str = "DetectFunc";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DETFLAGS: &'static str = "DetFlags";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DETFUNC: &'static str = "DetFunc";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DEVDESC: &'static str = "DeviceDesc";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DEVICEDRIVER: &'static str = "DeviceDriver";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DEVICEPATH: &'static str = "DevicePath";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DEVICE_CHARACTERISTICS: &'static str = "DeviceCharacteristics";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DEVICE_EXCLUSIVE: &'static str = "Exclusive";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DEVICE_INSTANCE: &'static str = "DeviceInstance";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DEVICE_SECURITY_DESCRIPTOR: &'static str = "Security";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DEVICE_TYPE: &'static str = "DeviceType";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DEVLOADER: &'static str = "DevLoader";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DEVTYPE: &'static str = "DeviceType";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DIRECTHOST: &'static str = "DirectHost";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DIRTYSHUTDOWN: &'static str = "DirtyShutdown";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DIRTYSHUTDOWNTIME: &'static str = "DirtyShutdownTime";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DISABLECOUNT: &'static str = "DisableCount";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DISABLEPWDCACHING: &'static str = "DisablePwdCaching";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DISABLEREGTOOLS: &'static str = "DisableRegistryTools";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DISCONNECT: &'static str = "Disconnect";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DISK: &'static str = "GenDisk";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DISKCLASSNAME: &'static str = "DiskDrive";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DISPCPL_NOAPPEARANCEPAGE: &'static str = "NoDispAppearancePage";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DISPCPL_NOBACKGROUNDPAGE: &'static str = "NoDispBackgroundPage";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DISPCPL_NODISPCPL: &'static str = "NoDispCPL";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DISPCPL_NOSCRSAVPAGE: &'static str = "NoDispScrSavPage";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DISPCPL_NOSETTINGSPAGE: &'static str = "NoDispSettingsPage";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DISPLAY: &'static str = "display";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DISPLAYFLAGS: &'static str = "DisplayFlags";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DOCKED: &'static str = "CurrentDockedState";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DOCKSTATE: &'static str = "DockState";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DOES_POLLING: &'static str = "PollingSupportNeeded";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DONTLOADIFCONFLICT: &'static str = "DontLoadIfConflict";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DONTUSEMEM: &'static str = "DontAllocLastMem";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DOSCP: &'static str = "OEMCP";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DOSOPTFLAGS: &'static str = "Flags";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DOSOPTGLOBALFLAGS: &'static str = "GlobalFlags";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DOSOPTTIP: &'static str = "TipText";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DOSPAGER: &'static str = "DOSPager";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DOS_SPOOL_MASK: &'static str = "DOSSpoolMask";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DOUBLEBUFFER: &'static str = "DoubleBuffer";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DPI: &'static str = "dpi";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DPILOGICALX: &'static str = "DPILogicalX";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DPILOGICALY: &'static str = "DPILogicalY";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DPIPHYSICALX: &'static str = "DPIPhysicalX";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DPIPHYSICALY: &'static str = "DPIPhysicalY";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DPMS: &'static str = "DPMS";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DRIVER: &'static str = "Driver";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DRIVERCACHEPATH: &'static str = "DriverCachePath";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DRIVERDATE: &'static str = "DriverDate";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DRIVERDATEDATA: &'static str = "DriverDateData";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DRIVERVERSION: &'static str = "DriverVersion";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DRIVESPINDOWN: &'static str = "DriveSpinDown";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DRIVEWRITEBEHIND: &'static str = "DriveWriteBehind";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DRIVE_SPINDOWN: &'static str = "NoDispSpinDown";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DRV: &'static str = "drv";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DRVDESC: &'static str = "DriverDesc";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_DYNAMIC: &'static str = "Dynamic";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_EISA_FLAGS: &'static str = "EISAFlags";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_EISA_FUNCTIONS: &'static str = "EISAFunctions";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_EISA_FUNCTIONS_MASK: &'static str = "EISAFunctionsMask";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_EISA_RANGES: &'static str = "EISARanges";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_EISA_SIMULATE_INT15: &'static str = "EISASimulateInt15";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_EJECT_PRIORITY: &'static str = "EjectPriority";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_ENABLEINTS: &'static str = "EnableInts";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_ENUMERATOR: &'static str = "Enumerator";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_ENUMPROPPAGES: &'static str = "EnumPropPages";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_ENUMPROPPAGES_32: &'static str = "EnumPropPages32";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_ESDI: &'static str = "ESDI\\";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_EXISTS: &'static str = "Exists";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_EXTMEM: &'static str = "ExtMem";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FAULT_LOGFILE: &'static str = "LogFile";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FIFODEPTH: &'static str = "FIFODepth";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FILESHARING: &'static str = "FileSharing";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FIRSTINSTALLDATETIME: &'static str = "FirstInstallDateTime";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FIRSTNETDRIVE: &'static str = "FirstNetworkDrive";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FLOP: &'static str = "FLOP\\";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FLOPPY: &'static str = "FLOPPY";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FONTSIZE: &'static str = "FontSize";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FORCECL: &'static str = "ForceChangeLine";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FORCEDCONFIG: &'static str = "ForcedConfig";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FORCEFIFO: &'static str = "ForceFIFO";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FORCELOAD: &'static str = "ForceLoadPD";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FORCEPMIO: &'static str = "ForcePMIO";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FORCEREBOOT: &'static str = "ForceReboot";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FORCERMIO: &'static str = "ForceRMIO";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FREESPACERATIO: &'static str = "FreeSpaceRatio";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FRIENDLYNAME: &'static str = "FriendlyName";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FSFILTERCLASS: &'static str = "FSFilterClass";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FULLTRACE: &'static str = "FullTrace";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_FUNCDESC: &'static str = "FunctionDesc";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_GAPTIME: &'static str = "GapTime";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_GRB: &'static str = "grb";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_HARDWAREID: &'static str = "HardwareID";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_HIDESHAREPWDS: &'static str = "HideSharePwds";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_HRES: &'static str = "HRes";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_HWDETECT: &'static str = "HardwareDetect";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_HWMECHANISM: &'static str = "HWMechanism";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_HWREV: &'static str = "HWRevision";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_ID: &'static str = "CurrentID";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_IDE_FORCE_SERIALIZE: &'static str = "ForceSerialization";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_IDE_NO_SERIALIZE: &'static str = "IDENoSerialize";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_INFNAME: &'static str = "InfName";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_INFPATH: &'static str = "InfPath";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_INFSECTION: &'static str = "InfSection";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_INFSECTIONEXT: &'static str = "InfSectionExt";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_INHIBITRESULTS: &'static str = "InhibitResults";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_INSICON: &'static str = "Icon";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_INSTALLER: &'static str = "Installer";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_INSTALLER_32: &'static str = "Installer32";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_INSTALLTYPE: &'static str = "InstallType";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_INT13: &'static str = "Int13";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_ISAPNP: &'static str = "ISAPNP";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_ISAPNP_RDP_OVERRIDE: &'static str = "RDPOverRide";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYCALLOUT: &'static str = "JoystickCallout";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYNCONFIG: &'static str = "Joystick%dConfiguration";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYNOEMCALLOUT: &'static str = "Joystick%dOEMCallout";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYNOEMNAME: &'static str = "Joystick%dOEMName";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMCAL1: &'static str = "OEMCal1";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMCAL10: &'static str = "OEMCal10";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMCAL11: &'static str = "OEMCal11";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMCAL12: &'static str = "OEMCal12";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMCAL2: &'static str = "OEMCal2";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMCAL3: &'static str = "OEMCal3";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMCAL4: &'static str = "OEMCal4";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMCAL5: &'static str = "OEMCal5";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMCAL6: &'static str = "OEMCal6";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMCAL7: &'static str = "OEMCal7";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMCAL8: &'static str = "OEMCal8";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMCAL9: &'static str = "OEMCal9";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMCALCAP: &'static str = "OEMCalCap";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMCALLOUT: &'static str = "OEMCallout";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMCALWINCAP: &'static str = "OEMCalWinCap";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMDATA: &'static str = "OEMData";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMNAME: &'static str = "OEMName";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMPOVLABEL: &'static str = "OEMPOVLabel";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMRLABEL: &'static str = "OEMRLabel";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMTESTBUTTONCAP: &'static str = "OEMTestButtonCap";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMTESTBUTTONDESC: &'static str = "OEMTestButtonDesc";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMTESTMOVECAP: &'static str = "OEMTestMoveCap";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMTESTMOVEDESC: &'static str = "OEMTestMoveDesc";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMTESTWINCAP: &'static str = "OEMTestWinCap";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMULABEL: &'static str = "OEMULabel";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMVLABEL: &'static str = "OEMVLabel";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMXYLABEL: &'static str = "OEMXYLabel";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYOEMZLABEL: &'static str = "OEMZLabel";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_JOYUSERVALUES: &'static str = "JoystickUserValues";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LASTALIVEBT: &'static str = "LastAliveBT";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LASTALIVEINTERVAL: &'static str = "TimeStampInterval";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LASTALIVEPMPOLICY: &'static str = "LastAlivePMPolicy";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LASTALIVESTAMP: &'static str = "LastAliveStamp";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LASTALIVESTAMPFORCED: &'static str = "LastAliveStampForced";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LASTALIVESTAMPINTERVAL: &'static str = "LastAliveStampInterval";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LASTALIVESTAMPPOLICYINTERVAL: &'static str = "LastAliveStampPolicyInterval";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LASTALIVEUPTIME: &'static str = "LastAliveUptime";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LASTBOOTPMDRVS: &'static str = "LastBootPMDrvs";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LASTCOMPUTERNAME: &'static str = "LastComputerName";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LASTPCIBUSNUM: &'static str = "LastPCIBusNum";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LAST_UPDATE_TIME: &'static str = "LastUpdateTime";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LEGALNOTICECAPTION: &'static str = "LegalNoticeCaption";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LEGALNOTICETEXT: &'static str = "LegalNoticeText";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LICENSINGINFO: &'static str = "LicensingInfo";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LINKED: &'static str = "Linked";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LOADHI: &'static str = "LoadHi";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LOADRMDRIVERS: &'static str = "LoadRMDrivers";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LOCATION_INFORMATION: &'static str = "LocationInformation";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LOCATION_INFORMATION_OVERRIDE: &'static str = "LocationInformationOverride";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LOWERFILTERS: &'static str = "LowerFilters";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LOWER_FILTER_DEFAULT_LEVEL: &'static str = "LowerFilterDefaultLevel";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_LOWER_FILTER_LEVELS: &'static str = "LowerFilterLevels";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MACHINETYPE: &'static str = "MachineType";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MANUFACTURER: &'static str = "Manufacturer";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MAP: &'static str = "Map";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MATCHINGDEVID: &'static str = "MatchingDeviceId";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MAXCONNECTIONS: &'static str = "MaxConnections";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MAXLIP: &'static str = "MaxLIP";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MAXRES: &'static str = "MaxResolution";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MAXRETRY: &'static str = "MaxRetry";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MAX_HCID_LEN: u32 = 1024u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MEDIA: &'static str = "MediaPath";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MFG: &'static str = "Mfg";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MF_FLAGS: &'static str = "MFFlags";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MINIPORT_STAT: &'static str = "MiniportStatus";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MINPWDLEN: &'static str = "MinPwdLen";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MINRETRY: &'static str = "MinRetry";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MODE: &'static str = "Mode";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MODEL: &'static str = "Model";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MSDOSMODE: &'static str = "MSDOSMode";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MSDOSMODEDISCARD: &'static str = "Discard";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_MUSTBEVALIDATED: &'static str = "MustBeValidated";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NAMECACHECOUNT: &'static str = "NameCache";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NAMENUMERICTAIL: &'static str = "NameNumericTail";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NCP_BROWSEMASTER: &'static str = "BrowseMaster";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NCP_USEPEERBROWSING: &'static str = "Use_PeerBrowsing";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NCP_USESAP: &'static str = "Use_Sap";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NDP: &'static str = "NDP";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NETCARD: &'static str = "Netcard";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NETCLEAN: &'static str = "NetClean";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NETOSTYPE: &'static str = "NetOSType";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NETSETUP_DISABLE: &'static str = "NoNetSetup";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NETSETUP_NOCONFIGPAGE: &'static str = "NoNetSetupConfigPage";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NETSETUP_NOIDPAGE: &'static str = "NoNetSetupIDPage";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NETSETUP_NOSECURITYPAGE: &'static str = "NoNetSetupSecurityPage";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NOCMOSORFDPT: &'static str = "NoCMOSorFDPT";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NODISPLAYCLASS: &'static str = "NoDisplayClass";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NOENTIRENETWORK: &'static str = "NoEntireNetwork";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NOFILESHARING: &'static str = "NoFileSharing";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NOFILESHARINGCTRL: &'static str = "NoFileSharingControl";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NOIDE: &'static str = "NoIDE";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NOINSTALLCLASS: &'static str = "NoInstallClass";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NONSTANDARD_ATAPI: &'static str = "NonStandardATAPI";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NOPRINTSHARING: &'static str = "NoPrintSharing";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NOPRINTSHARINGCTRL: &'static str = "NoPrintSharingControl";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NOUSECLASS: &'static str = "NoUseClass";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_NOWORKGROUPCONTENTS: &'static str = "NoWorkgroupContents";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_OLDMSDOSVER: &'static str = "OldMSDOSVer";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_OLDWINDIR: &'static str = "OldWinDir";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_OPTIMIZESFN: &'static str = "OptimizeSFN";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_OPTIONS: &'static str = "Options";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_OPTORDER: &'static str = "Order";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_P1284MDL: &'static str = "Model";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_P1284MFG: &'static str = "Manufacturer";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PATHCACHECOUNT: &'static str = "PathCache";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PCCARD_POWER: &'static str = "EnablePowerManagement";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PCI: &'static str = "PCI";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PCIBIOSVER: &'static str = "PCIBIOSVer";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PCICIRQMAP: &'static str = "PCICIRQMap";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PCICOPTIONS: &'static str = "PCICOptions";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PCMCIA_ALLOC: &'static str = "AllocMemWin";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PCMCIA_ATAD: &'static str = "ATADelay";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PCMCIA_MEM: &'static str = "Memory";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PCMCIA_OPT: &'static str = "Options";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PCMCIA_SIZ: &'static str = "MinRegionSize";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PCMTDRIVER: &'static str = "MTD";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PCSSDRIVER: &'static str = "Driver";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PHYSICALDEVICEOBJECT: &'static str = "PhysicalDeviceObject";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PMODE_INT13: &'static str = "PModeInt13";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PNPBIOSVER: &'static str = "PnPBIOSVer";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PNPSTRUCOFFSET: &'static str = "PnPStrucOffset";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_POLICY: &'static str = "Policy";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_POLLING: &'static str = "Polling";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PORTNAME: &'static str = "PortName";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PORTSUBCLASS: &'static str = "PortSubClass";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PREFREDIR: &'static str = "PreferredRedir";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PRESERVECASE: &'static str = "PreserveCase";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PRESERVELONGNAMES: &'static str = "PreserveLongNames";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PRINTERS_HIDETABS: &'static str = "NoPrinterTabs";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PRINTERS_MASK: &'static str = "PrintersMask";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PRINTERS_NOADD: &'static str = "NoAddPrinter";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PRINTERS_NODELETE: &'static str = "NoDeletePrinter";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PRINTSHARING: &'static str = "PrintSharing";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PRIORITY: &'static str = "Priority";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PRIVATE: &'static str = "Private";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PRIVATEFUNC: &'static str = "PrivateFunc";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PRIVATEPROBLEM: &'static str = "PrivateProblem";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PRODUCTID: &'static str = "ProductId";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PRODUCTTYPE: &'static str = "ProductType";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PROFILEFLAGS: &'static str = "ProfileFlags";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PROPERTIES: &'static str = "Properties";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PROTINIPATH: &'static str = "ProtIniPath";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PROVIDER_NAME: &'static str = "ProviderName";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PWDEXPIRATION: &'static str = "PwdExpiration";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PWDPROVIDER_CHANGEORDER: &'static str = "ChangeOrder";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PWDPROVIDER_CHANGEPWD: &'static str = "ChangePassword";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PWDPROVIDER_CHANGEPWDHWND: &'static str = "ChangePasswordHwnd";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PWDPROVIDER_DESC: &'static str = "Description";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PWDPROVIDER_GETPWDSTATUS: &'static str = "GetPasswordStatus";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PWDPROVIDER_ISNP: &'static str = "NetworkProvider";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_PWDPROVIDER_PATH: &'static str = "ProviderPath";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_RDINTTHRESHOLD: &'static str = "RDIntThreshold";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_READAHEADTHRESHOLD: &'static str = "ReadAheadThreshold";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_READCACHING: &'static str = "ReadCaching";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_REALNETSTART: &'static str = "RealNetStart";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_REASONCODE: &'static str = "ReasonCode";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_REFRESHRATE: &'static str = "RefreshRate";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_REGITEMDELETEMESSAGE: &'static str = "Removal Message";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_REGORGANIZATION: &'static str = "RegisteredOrganization";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_REGOWNER: &'static str = "RegisteredOwner";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_REINSTALL_DEVICEINSTANCEIDS: &'static str = "DeviceInstanceIds";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_REINSTALL_DISPLAYNAME: &'static str = "DisplayName";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_REINSTALL_STRING: &'static str = "ReinstallString";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_REMOTE_PATH: &'static str = "RemotePath";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_REMOVABLE: &'static str = "Removable";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_REMOVAL_POLICY: &'static str = "RemovalPolicy";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_REMOVEROMOKAY: &'static str = "RemoveRomOkay";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_REMOVEROMOKAYFUNC: &'static str = "RemoveRomOkayFunc";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_RESERVED_DEVNODE: &'static str = "HTREE\\RESERVED\\0";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_RESOLUTION: &'static str = "Resolution";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_RESOURCES: &'static str = "Resources";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_RESOURCE_MAP: &'static str = "ResourceMap";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_RESOURCE_PICKER_EXCEPTIONS: &'static str = "ResourcePickerExceptions";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_RESOURCE_PICKER_TAGS: &'static str = "ResourcePickerTags";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_RESTRICTRUN: &'static str = "RestrictRun";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_RESUMERESET: &'static str = "ResumeReset";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_REVISION: &'static str = "Revision";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_REVLEVEL: &'static str = "RevisionLevel";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_ROOT_DEVNODE: &'static str = "HTREE\\ROOT\\0";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_RUNLOGINSCRIPT: &'static str = "ProcessLoginScript";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SCANNER: &'static str = "SCANNER";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SCAN_ONLY_FIRST: &'static str = "ScanOnlyFirstDrive";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SCSI: &'static str = "SCSI\\";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SCSILUN: &'static str = "SCSILUN";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SCSITID: &'static str = "SCSITargetID";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SEARCHMODE: &'static str = "SearchMode";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SEARCHOPTIONS: &'static str = "SearchOptions";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SECCPL_NOADMINPAGE: &'static str = "NoAdminPage";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SECCPL_NOPROFILEPAGE: &'static str = "NoProfilePage";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SECCPL_NOPWDPAGE: &'static str = "NoPwdPage";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SECCPL_NOSECCPL: &'static str = "NoSecCPL";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SERVICE: &'static str = "Service";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SETUPFLAGS: &'static str = "SetupFlags";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SETUPMACHINETYPE: &'static str = "SetupMachineType";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SETUPN: &'static str = "SetupN";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SETUPNPATH: &'static str = "SetupNPath";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SETUPPROGRAMRAN: &'static str = "SetupProgramRan";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SHARES_FLAGS: &'static str = "Flags";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SHARES_PATH: &'static str = "Path";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SHARES_REMARK: &'static str = "Remark";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SHARES_RO_PASS: &'static str = "Parm2";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SHARES_RW_PASS: &'static str = "Parm1";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SHARES_TYPE: &'static str = "Type";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SHARE_IRQ: &'static str = "ForceIRQSharing";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SHELLVERSION: &'static str = "ShellVersion";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SHOWDOTS: &'static str = "ShowDots";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SHOWREASONUI: &'static str = "ShutdownReasonUI";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SHUTDOWNREASON: &'static str = "ShutdownReason";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SHUTDOWNREASON_CODE: &'static str = "ShutdownReasonCode";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SHUTDOWNREASON_COMMENT: &'static str = "ShutdownReasonComment";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SHUTDOWNREASON_PROCESS: &'static str = "ShutdownReasonProcess";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SHUTDOWNREASON_USERNAME: &'static str = "ShutdownReasonUserName";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SHUTDOWN_FLAGS: &'static str = "ShutdownFlags";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SHUTDOWN_IGNORE_PREDEFINED: &'static str = "ShutdownIgnorePredefinedReasons";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SHUTDOWN_STATE_SNAPSHOT: &'static str = "ShutdownStateSnapshot";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SILENTINSTALL: &'static str = "SilentInstall";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SLSUPPORT: &'static str = "SLSupport";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SOFTCOMPATMODE: &'static str = "SoftCompatMode";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SRCPATH: &'static str = "SourcePath";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SRVNAMECACHE: &'static str = "ServerNameCache";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SRVNAMECACHECOUNT: &'static str = "ServerNameCacheMax";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SRVNAMECACHENETPROV: &'static str = "ServerNameCacheNumNets";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_START_ON_BOOT: &'static str = "StartOnBoot";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_STAT: &'static str = "Status";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_STATICDRIVE: &'static str = "StaticDrive";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_STATICVXD: &'static str = "StaticVxD";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_STDDOSOPTION: &'static str = "StdOption";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SUBMODEL: &'static str = "Submodel";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SUPPORTBURST: &'static str = "SupportBurst";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SUPPORTLFN: &'static str = "SupportLFN";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SUPPORTTUNNELLING: &'static str = "SupportTunnelling";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SYMBOLIC_LINK: &'static str = "SymbolicLink";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SYNCDATAXFER: &'static str = "SyncDataXfer";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SYSDM: &'static str = "SysDM";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SYSDMFUNC: &'static str = "SysDMFunc";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SYSTEMCPL_NOCONFIGPAGE: &'static str = "NoConfigPage";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SYSTEMCPL_NODEVMGRPAGE: &'static str = "NoDevMgrPage";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SYSTEMCPL_NOFILESYSPAGE: &'static str = "NoFileSysPage";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SYSTEMCPL_NOVIRTMEMPAGE: &'static str = "NoVirtMemPage";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SYSTEMROOT: &'static str = "SystemRoot";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SYSTRAYBATFLAGS: &'static str = "PowerFlags";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SYSTRAYPCCARDFLAGS: &'static str = "PCMCIAFlags";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_SYSTRAYSVCS: &'static str = "Services";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_TABLE_STAT: &'static str = "TableStatus";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_TAPE: &'static str = "TAPE";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_TRANSITION: &'static str = "Transition";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_TRANSPORT: &'static str = "Transport";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_TZACTBIAS: &'static str = "ActiveTimeBias";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_TZBIAS: &'static str = "Bias";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_TZDLTBIAS: &'static str = "DaylightBias";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_TZDLTFLAG: &'static str = "DaylightFlag";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_TZDLTNAME: &'static str = "DaylightName";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_TZDLTSTART: &'static str = "DaylightStart";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_TZNOAUTOTIME: &'static str = "DisableAutoDaylightTimeSet";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_TZNOCHANGEEND: &'static str = "NoChangeEnd";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_TZNOCHANGESTART: &'static str = "NoChangeStart";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_TZSTDBIAS: &'static str = "StandardBias";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_TZSTDNAME: &'static str = "StandardName";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_TZSTDSTART: &'static str = "StandardStart";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_UI_NUMBER: &'static str = "UINumber";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_UI_NUMBER_DESC_FORMAT: &'static str = "UINumberDescFormat";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_UNDOCK_WITHOUT_LOGON: &'static str = "UndockWithoutLogon";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_UNINSTALLER_COMMANDLINE: &'static str = "UninstallString";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_UNINSTALLER_DISPLAYNAME: &'static str = "DisplayName";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_UPGRADE: &'static str = "Upgrade";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_UPPERFILTERS: &'static str = "UpperFilters";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_UPPER_FILTER_DEFAULT_LEVEL: &'static str = "UpperFilterDefaultLevel";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_UPPER_FILTER_LEVELS: &'static str = "UpperFilterLevels";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_USERSETTINGS: &'static str = "AdapterSettings";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_USER_NAME: &'static str = "UserName";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_USRDRVLET: &'static str = "UserDriveLetterAssignment";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_VDD: &'static str = "vdd";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_VER: &'static str = "Ver";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_VERIFYKEY: &'static str = "VerifyKey";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_VIRTUALHDIRQ: &'static str = "VirtualHDIRQ";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_VOLIDLETIMEOUT: &'static str = "VolumeIdleTimeout";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_VPOWERDFLAGS: &'static str = "Flags";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_VRES: &'static str = "VRes";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_VXDGROUPS: &'static str = "VXDGroups";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_WAITFORUNDOCK: &'static str = "WaitForUndock";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_WAITFORUNDOCKFUNC: &'static str = "WaitForUndockFunc";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_WIN31FILESYSTEM: &'static str = "Win31FileSystem";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_WIN31PROVIDER: &'static str = "Win31Provider";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_WINBOOTDIR: &'static str = "WinbootDir";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_WINCP: &'static str = "ACP";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_WINDIR: &'static str = "WinDir";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_WINOLDAPP_DISABLED: &'static str = "Disabled";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_WINOLDAPP_NOREALMODE: &'static str = "NoRealMode";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_WORKGROUP: &'static str = "Workgroup";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_WRAPPER: &'static str = "Wrapper";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_WRINTTHRESHOLD: &'static str = "WRIntThreshold";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_WRKGRP_FORCEMAPPING: &'static str = "WrkgrpForceMapping";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REGSTR_VAL_WRKGRP_REQUIRED: &'static str = "WrkgrpRequired";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub type REG_CREATE_KEY_DISPOSITION = u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_CREATED_NEW_KEY: REG_CREATE_KEY_DISPOSITION = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_OPENED_EXISTING_KEY: REG_CREATE_KEY_DISPOSITION = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_KEY_INSTDEV: &'static str = "Installed";
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_MUI_STRING_TRUNCATE: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub type REG_NOTIFY_FILTER = u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_NOTIFY_CHANGE_NAME: REG_NOTIFY_FILTER = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_NOTIFY_CHANGE_ATTRIBUTES: REG_NOTIFY_FILTER = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_NOTIFY_CHANGE_LAST_SET: REG_NOTIFY_FILTER = 4u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_NOTIFY_CHANGE_SECURITY: REG_NOTIFY_FILTER = 8u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_NOTIFY_THREAD_AGNOSTIC: REG_NOTIFY_FILTER = 268435456u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub type REG_OPEN_CREATE_OPTIONS = u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_OPTION_RESERVED: REG_OPEN_CREATE_OPTIONS = 0u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_OPTION_NON_VOLATILE: REG_OPEN_CREATE_OPTIONS = 0u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_OPTION_VOLATILE: REG_OPEN_CREATE_OPTIONS = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_OPTION_CREATE_LINK: REG_OPEN_CREATE_OPTIONS = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_OPTION_BACKUP_RESTORE: REG_OPEN_CREATE_OPTIONS = 4u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_OPTION_OPEN_LINK: REG_OPEN_CREATE_OPTIONS = 8u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_OPTION_DONT_VIRTUALIZE: REG_OPEN_CREATE_OPTIONS = 16u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_PROCESS_APPKEY: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub type REG_RESTORE_KEY_FLAGS = i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_FORCE_RESTORE: REG_RESTORE_KEY_FLAGS = 8i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_WHOLE_HIVE_VOLATILE: REG_RESTORE_KEY_FLAGS = 1i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub type REG_SAM_FLAGS = u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const KEY_QUERY_VALUE: REG_SAM_FLAGS = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const KEY_SET_VALUE: REG_SAM_FLAGS = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const KEY_CREATE_SUB_KEY: REG_SAM_FLAGS = 4u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const KEY_ENUMERATE_SUB_KEYS: REG_SAM_FLAGS = 8u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const KEY_NOTIFY: REG_SAM_FLAGS = 16u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const KEY_CREATE_LINK: REG_SAM_FLAGS = 32u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const KEY_WOW64_32KEY: REG_SAM_FLAGS = 512u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const KEY_WOW64_64KEY: REG_SAM_FLAGS = 256u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const KEY_WOW64_RES: REG_SAM_FLAGS = 768u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const KEY_READ: REG_SAM_FLAGS = 131097u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const KEY_WRITE: REG_SAM_FLAGS = 131078u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const KEY_EXECUTE: REG_SAM_FLAGS = 131097u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const KEY_ALL_ACCESS: REG_SAM_FLAGS = 983103u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub type REG_SAVE_FORMAT = u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_STANDARD_FORMAT: REG_SAVE_FORMAT = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_LATEST_FORMAT: REG_SAVE_FORMAT = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_NO_COMPRESSION: REG_SAVE_FORMAT = 4u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_SECURE_CONNECTION: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_USE_CURRENT_SECURITY_CONTEXT: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub type REG_VALUE_TYPE = u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_NONE: REG_VALUE_TYPE = 0u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_SZ: REG_VALUE_TYPE = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_EXPAND_SZ: REG_VALUE_TYPE = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_BINARY: REG_VALUE_TYPE = 3u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_DWORD: REG_VALUE_TYPE = 4u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_DWORD_LITTLE_ENDIAN: REG_VALUE_TYPE = 4u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_DWORD_BIG_ENDIAN: REG_VALUE_TYPE = 5u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_LINK: REG_VALUE_TYPE = 6u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_MULTI_SZ: REG_VALUE_TYPE = 7u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_RESOURCE_LIST: REG_VALUE_TYPE = 8u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_FULL_RESOURCE_DESCRIPTOR: REG_VALUE_TYPE = 9u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_RESOURCE_REQUIREMENTS_LIST: REG_VALUE_TYPE = 10u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_QWORD: REG_VALUE_TYPE = 11u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const REG_QWORD_LITTLE_ENDIAN: REG_VALUE_TYPE = 11u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const RRF_NOEXPAND: u32 = 268435456u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub type RRF_RT = u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const RRF_RT_ANY: RRF_RT = 65535u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const RRF_RT_DWORD: RRF_RT = 24u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const RRF_RT_QWORD: RRF_RT = 72u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const RRF_RT_REG_BINARY: RRF_RT = 8u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const RRF_RT_REG_DWORD: RRF_RT = 16u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const RRF_RT_REG_EXPAND_SZ: RRF_RT = 4u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const RRF_RT_REG_MULTI_SZ: RRF_RT = 32u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const RRF_RT_REG_NONE: RRF_RT = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const RRF_RT_REG_QWORD: RRF_RT = 64u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const RRF_RT_REG_SZ: RRF_RT = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const RRF_SUBKEY_WOW6432KEY: u32 = 131072u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const RRF_SUBKEY_WOW6464KEY: u32 = 65536u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const RRF_WOW64_MASK: u32 = 196608u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const RRF_ZEROONFAILURE: u32 = 536870912u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const SUF_BATCHINF: i32 = 4i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const SUF_CLEAN: i32 = 8i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const SUF_EXPRESS: i32 = 2i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const SUF_FIRSTTIME: i32 = 1i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const SUF_INSETUP: i32 = 16i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const SUF_NETHDBOOT: i32 = 64i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const SUF_NETRPLBOOT: i32 = 128i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const SUF_NETSETUP: i32 = 32i32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const SUF_SBSCOPYOK: i32 = 256i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct VALENTA {
    pub ve_valuename: super::super::Foundation::PSTR,
    pub ve_valuelen: u32,
    pub ve_valueptr: usize,
    pub ve_type: REG_VALUE_TYPE,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for VALENTA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for VALENTA {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct VALENTW {
    pub ve_valuename: super::super::Foundation::PWSTR,
    pub ve_valuelen: u32,
    pub ve_valueptr: usize,
    pub ve_type: REG_VALUE_TYPE,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for VALENTW {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for VALENTW {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const VPDF_DISABLEPWRMGMT: u32 = 1u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const VPDF_DISABLEPWRSTATUSPOLL: u32 = 8u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const VPDF_DISABLERINGRESUME: u32 = 16u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const VPDF_FORCEAPM10MODE: u32 = 2u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const VPDF_SHOWMULTIBATT: u32 = 32u32;
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub const VPDF_SKIPINTELSLCHECK: u32 = 4u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub struct provider_info {
    pub pi_R0_1val: PQUERYHANDLER,
    pub pi_R0_allvals: PQUERYHANDLER,
    pub pi_R3_1val: PQUERYHANDLER,
    pub pi_R3_allvals: PQUERYHANDLER,
    pub pi_flags: u32,
    pub pi_key_context: *mut ::core::ffi::c_void,
}
impl ::core::marker::Copy for provider_info {}
impl ::core::clone::Clone for provider_info {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct pvalueA {
    pub pv_valuename: super::super::Foundation::PSTR,
    pub pv_valuelen: i32,
    pub pv_value_context: *mut ::core::ffi::c_void,
    pub pv_type: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for pvalueA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for pvalueA {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Registry', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct pvalueW {
    pub pv_valuename: super::super::Foundation::PWSTR,
    pub pv_valuelen: i32,
    pub pv_value_context: *mut ::core::ffi::c_void,
    pub pv_type: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for pvalueW {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for pvalueW {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_System_Registry'*"]
pub struct val_context {
    pub valuelen: i32,
    pub value_context: *mut ::core::ffi::c_void,
    pub val_buff_ptr: *mut ::core::ffi::c_void,
}
impl ::core::marker::Copy for val_context {}
impl ::core::clone::Clone for val_context {
    fn clone(&self) -> Self {
        *self
    }
}
