// This file is automatically generated, DO NOT EDIT
//
// To regenerate this file run the `crates/witx-bindgen` command

use core::mem::MaybeUninit;

pub use crate::error::Error;
pub type Result<T, E = Error> = core::result::Result<T, E>;
pub type Size = usize;
pub type Filesize = u64;
pub type Timestamp = u64;
pub type Clockid = u32;
/// The clock measuring real time. Time value zero corresponds with
/// 1970-01-01T00:00:00Z.
pub const CLOCKID_REALTIME: Clockid = 0;
/// The store-wide monotonic clock, which is defined as a clock measuring
/// real time, whose value cannot be adjusted and which cannot have negative
/// clock jumps. The epoch of this clock is undefined. The absolute time
/// value of this clock therefore has no meaning.
pub const CLOCKID_MONOTONIC: Clockid = 1;
/// The CPU-time clock associated with the current process.
pub const CLOCKID_PROCESS_CPUTIME_ID: Clockid = 2;
/// The CPU-time clock associated with the current thread.
pub const CLOCKID_THREAD_CPUTIME_ID: Clockid = 3;
pub type Errno = u16;
/// No error occurred. System call completed successfully.
pub const ERRNO_SUCCESS: Errno = 0;
/// Argument list too long.
pub const ERRNO_2BIG: Errno = 1;
/// Permission denied.
pub const ERRNO_ACCES: Errno = 2;
/// Address in use.
pub const ERRNO_ADDRINUSE: Errno = 3;
/// Address not available.
pub const ERRNO_ADDRNOTAVAIL: Errno = 4;
/// Address family not supported.
pub const ERRNO_AFNOSUPPORT: Errno = 5;
/// Resource unavailable, or operation would block.
pub const ERRNO_AGAIN: Errno = 6;
/// Connection already in progress.
pub const ERRNO_ALREADY: Errno = 7;
/// Bad file descriptor.
pub const ERRNO_BADF: Errno = 8;
/// Bad message.
pub const ERRNO_BADMSG: Errno = 9;
/// Device or resource busy.
pub const ERRNO_BUSY: Errno = 10;
/// Operation canceled.
pub const ERRNO_CANCELED: Errno = 11;
/// No child processes.
pub const ERRNO_CHILD: Errno = 12;
/// Connection aborted.
pub const ERRNO_CONNABORTED: Errno = 13;
/// Connection refused.
pub const ERRNO_CONNREFUSED: Errno = 14;
/// Connection reset.
pub const ERRNO_CONNRESET: Errno = 15;
/// Resource deadlock would occur.
pub const ERRNO_DEADLK: Errno = 16;
/// Destination address required.
pub const ERRNO_DESTADDRREQ: Errno = 17;
/// Mathematics argument out of domain of function.
pub const ERRNO_DOM: Errno = 18;
/// Reserved.
pub const ERRNO_DQUOT: Errno = 19;
/// File exists.
pub const ERRNO_EXIST: Errno = 20;
/// Bad address.
pub const ERRNO_FAULT: Errno = 21;
/// File too large.
pub const ERRNO_FBIG: Errno = 22;
/// Host is unreachable.
pub const ERRNO_HOSTUNREACH: Errno = 23;
/// Identifier removed.
pub const ERRNO_IDRM: Errno = 24;
/// Illegal byte sequence.
pub const ERRNO_ILSEQ: Errno = 25;
/// Operation in progress.
pub const ERRNO_INPROGRESS: Errno = 26;
/// Interrupted function.
pub const ERRNO_INTR: Errno = 27;
/// Invalid argument.
pub const ERRNO_INVAL: Errno = 28;
/// I/O error.
pub const ERRNO_IO: Errno = 29;
/// Socket is connected.
pub const ERRNO_ISCONN: Errno = 30;
/// Is a directory.
pub const ERRNO_ISDIR: Errno = 31;
/// Too many levels of symbolic links.
pub const ERRNO_LOOP: Errno = 32;
/// File descriptor value too large.
pub const ERRNO_MFILE: Errno = 33;
/// Too many links.
pub const ERRNO_MLINK: Errno = 34;
/// Message too large.
pub const ERRNO_MSGSIZE: Errno = 35;
/// Reserved.
pub const ERRNO_MULTIHOP: Errno = 36;
/// Filename too long.
pub const ERRNO_NAMETOOLONG: Errno = 37;
/// Network is down.
pub const ERRNO_NETDOWN: Errno = 38;
/// Connection aborted by network.
pub const ERRNO_NETRESET: Errno = 39;
/// Network unreachable.
pub const ERRNO_NETUNREACH: Errno = 40;
/// Too many files open in system.
pub const ERRNO_NFILE: Errno = 41;
/// No buffer space available.
pub const ERRNO_NOBUFS: Errno = 42;
/// No such device.
pub const ERRNO_NODEV: Errno = 43;
/// No such file or directory.
pub const ERRNO_NOENT: Errno = 44;
/// Executable file format error.
pub const ERRNO_NOEXEC: Errno = 45;
/// No locks available.
pub const ERRNO_NOLCK: Errno = 46;
/// Reserved.
pub const ERRNO_NOLINK: Errno = 47;
/// Not enough space.
pub const ERRNO_NOMEM: Errno = 48;
/// No message of the desired type.
pub const ERRNO_NOMSG: Errno = 49;
/// Protocol not available.
pub const ERRNO_NOPROTOOPT: Errno = 50;
/// No space left on device.
pub const ERRNO_NOSPC: Errno = 51;
/// Function not supported.
pub const ERRNO_NOSYS: Errno = 52;
/// The socket is not connected.
pub const ERRNO_NOTCONN: Errno = 53;
/// Not a directory or a symbolic link to a directory.
pub const ERRNO_NOTDIR: Errno = 54;
/// Directory not empty.
pub const ERRNO_NOTEMPTY: Errno = 55;
/// State not recoverable.
pub const ERRNO_NOTRECOVERABLE: Errno = 56;
/// Not a socket.
pub const ERRNO_NOTSOCK: Errno = 57;
/// Not supported, or operation not supported on socket.
pub const ERRNO_NOTSUP: Errno = 58;
/// Inappropriate I/O control operation.
pub const ERRNO_NOTTY: Errno = 59;
/// No such device or address.
pub const ERRNO_NXIO: Errno = 60;
/// Value too large to be stored in data type.
pub const ERRNO_OVERFLOW: Errno = 61;
/// Previous owner died.
pub const ERRNO_OWNERDEAD: Errno = 62;
/// Operation not permitted.
pub const ERRNO_PERM: Errno = 63;
/// Broken pipe.
pub const ERRNO_PIPE: Errno = 64;
/// Protocol error.
pub const ERRNO_PROTO: Errno = 65;
/// Protocol not supported.
pub const ERRNO_PROTONOSUPPORT: Errno = 66;
/// Protocol wrong type for socket.
pub const ERRNO_PROTOTYPE: Errno = 67;
/// Result too large.
pub const ERRNO_RANGE: Errno = 68;
/// Read-only file system.
pub const ERRNO_ROFS: Errno = 69;
/// Invalid seek.
pub const ERRNO_SPIPE: Errno = 70;
/// No such process.
pub const ERRNO_SRCH: Errno = 71;
/// Reserved.
pub const ERRNO_STALE: Errno = 72;
/// Connection timed out.
pub const ERRNO_TIMEDOUT: Errno = 73;
/// Text file busy.
pub const ERRNO_TXTBSY: Errno = 74;
/// Cross-device link.
pub const ERRNO_XDEV: Errno = 75;
/// Extension: Capabilities insufficient.
pub const ERRNO_NOTCAPABLE: Errno = 76;
pub fn errno_name(code: u16) -> &'static str {
    match code {
        ERRNO_SUCCESS => "SUCCESS",
        ERRNO_2BIG => "2BIG",
        ERRNO_ACCES => "ACCES",
        ERRNO_ADDRINUSE => "ADDRINUSE",
        ERRNO_ADDRNOTAVAIL => "ADDRNOTAVAIL",
        ERRNO_AFNOSUPPORT => "AFNOSUPPORT",
        ERRNO_AGAIN => "AGAIN",
        ERRNO_ALREADY => "ALREADY",
        ERRNO_BADF => "BADF",
        ERRNO_BADMSG => "BADMSG",
        ERRNO_BUSY => "BUSY",
        ERRNO_CANCELED => "CANCELED",
        ERRNO_CHILD => "CHILD",
        ERRNO_CONNABORTED => "CONNABORTED",
        ERRNO_CONNREFUSED => "CONNREFUSED",
        ERRNO_CONNRESET => "CONNRESET",
        ERRNO_DEADLK => "DEADLK",
        ERRNO_DESTADDRREQ => "DESTADDRREQ",
        ERRNO_DOM => "DOM",
        ERRNO_DQUOT => "DQUOT",
        ERRNO_EXIST => "EXIST",
        ERRNO_FAULT => "FAULT",
        ERRNO_FBIG => "FBIG",
        ERRNO_HOSTUNREACH => "HOSTUNREACH",
        ERRNO_IDRM => "IDRM",
        ERRNO_ILSEQ => "ILSEQ",
        ERRNO_INPROGRESS => "INPROGRESS",
        ERRNO_INTR => "INTR",
        ERRNO_INVAL => "INVAL",
        ERRNO_IO => "IO",
        ERRNO_ISCONN => "ISCONN",
        ERRNO_ISDIR => "ISDIR",
        ERRNO_LOOP => "LOOP",
        ERRNO_MFILE => "MFILE",
        ERRNO_MLINK => "MLINK",
        ERRNO_MSGSIZE => "MSGSIZE",
        ERRNO_MULTIHOP => "MULTIHOP",
        ERRNO_NAMETOOLONG => "NAMETOOLONG",
        ERRNO_NETDOWN => "NETDOWN",
        ERRNO_NETRESET => "NETRESET",
        ERRNO_NETUNREACH => "NETUNREACH",
        ERRNO_NFILE => "NFILE",
        ERRNO_NOBUFS => "NOBUFS",
        ERRNO_NODEV => "NODEV",
        ERRNO_NOENT => "NOENT",
        ERRNO_NOEXEC => "NOEXEC",
        ERRNO_NOLCK => "NOLCK",
        ERRNO_NOLINK => "NOLINK",
        ERRNO_NOMEM => "NOMEM",
        ERRNO_NOMSG => "NOMSG",
        ERRNO_NOPROTOOPT => "NOPROTOOPT",
        ERRNO_NOSPC => "NOSPC",
        ERRNO_NOSYS => "NOSYS",
        ERRNO_NOTCONN => "NOTCONN",
        ERRNO_NOTDIR => "NOTDIR",
        ERRNO_NOTEMPTY => "NOTEMPTY",
        ERRNO_NOTRECOVERABLE => "NOTRECOVERABLE",
        ERRNO_NOTSOCK => "NOTSOCK",
        ERRNO_NOTSUP => "NOTSUP",
        ERRNO_NOTTY => "NOTTY",
        ERRNO_NXIO => "NXIO",
        ERRNO_OVERFLOW => "OVERFLOW",
        ERRNO_OWNERDEAD => "OWNERDEAD",
        ERRNO_PERM => "PERM",
        ERRNO_PIPE => "PIPE",
        ERRNO_PROTO => "PROTO",
        ERRNO_PROTONOSUPPORT => "PROTONOSUPPORT",
        ERRNO_PROTOTYPE => "PROTOTYPE",
        ERRNO_RANGE => "RANGE",
        ERRNO_ROFS => "ROFS",
        ERRNO_SPIPE => "SPIPE",
        ERRNO_SRCH => "SRCH",
        ERRNO_STALE => "STALE",
        ERRNO_TIMEDOUT => "TIMEDOUT",
        ERRNO_TXTBSY => "TXTBSY",
        ERRNO_XDEV => "XDEV",
        ERRNO_NOTCAPABLE => "NOTCAPABLE",
        _ => "Unknown error.",
    }
}
pub fn errno_docs(code: u16) -> &'static str {
    match code {
        ERRNO_SUCCESS => "No error occurred. System call completed successfully.",
        ERRNO_2BIG => "Argument list too long.",
        ERRNO_ACCES => "Permission denied.",
        ERRNO_ADDRINUSE => "Address in use.",
        ERRNO_ADDRNOTAVAIL => "Address not available.",
        ERRNO_AFNOSUPPORT => "Address family not supported.",
        ERRNO_AGAIN => "Resource unavailable, or operation would block.",
        ERRNO_ALREADY => "Connection already in progress.",
        ERRNO_BADF => "Bad file descriptor.",
        ERRNO_BADMSG => "Bad message.",
        ERRNO_BUSY => "Device or resource busy.",
        ERRNO_CANCELED => "Operation canceled.",
        ERRNO_CHILD => "No child processes.",
        ERRNO_CONNABORTED => "Connection aborted.",
        ERRNO_CONNREFUSED => "Connection refused.",
        ERRNO_CONNRESET => "Connection reset.",
        ERRNO_DEADLK => "Resource deadlock would occur.",
        ERRNO_DESTADDRREQ => "Destination address required.",
        ERRNO_DOM => "Mathematics argument out of domain of function.",
        ERRNO_DQUOT => "Reserved.",
        ERRNO_EXIST => "File exists.",
        ERRNO_FAULT => "Bad address.",
        ERRNO_FBIG => "File too large.",
        ERRNO_HOSTUNREACH => "Host is unreachable.",
        ERRNO_IDRM => "Identifier removed.",
        ERRNO_ILSEQ => "Illegal byte sequence.",
        ERRNO_INPROGRESS => "Operation in progress.",
        ERRNO_INTR => "Interrupted function.",
        ERRNO_INVAL => "Invalid argument.",
        ERRNO_IO => "I/O error.",
        ERRNO_ISCONN => "Socket is connected.",
        ERRNO_ISDIR => "Is a directory.",
        ERRNO_LOOP => "Too many levels of symbolic links.",
        ERRNO_MFILE => "File descriptor value too large.",
        ERRNO_MLINK => "Too many links.",
        ERRNO_MSGSIZE => "Message too large.",
        ERRNO_MULTIHOP => "Reserved.",
        ERRNO_NAMETOOLONG => "Filename too long.",
        ERRNO_NETDOWN => "Network is down.",
        ERRNO_NETRESET => "Connection aborted by network.",
        ERRNO_NETUNREACH => "Network unreachable.",
        ERRNO_NFILE => "Too many files open in system.",
        ERRNO_NOBUFS => "No buffer space available.",
        ERRNO_NODEV => "No such device.",
        ERRNO_NOENT => "No such file or directory.",
        ERRNO_NOEXEC => "Executable file format error.",
        ERRNO_NOLCK => "No locks available.",
        ERRNO_NOLINK => "Reserved.",
        ERRNO_NOMEM => "Not enough space.",
        ERRNO_NOMSG => "No message of the desired type.",
        ERRNO_NOPROTOOPT => "Protocol not available.",
        ERRNO_NOSPC => "No space left on device.",
        ERRNO_NOSYS => "Function not supported.",
        ERRNO_NOTCONN => "The socket is not connected.",
        ERRNO_NOTDIR => "Not a directory or a symbolic link to a directory.",
        ERRNO_NOTEMPTY => "Directory not empty.",
        ERRNO_NOTRECOVERABLE => "State not recoverable.",
        ERRNO_NOTSOCK => "Not a socket.",
        ERRNO_NOTSUP => "Not supported, or operation not supported on socket.",
        ERRNO_NOTTY => "Inappropriate I/O control operation.",
        ERRNO_NXIO => "No such device or address.",
        ERRNO_OVERFLOW => "Value too large to be stored in data type.",
        ERRNO_OWNERDEAD => "Previous owner died.",
        ERRNO_PERM => "Operation not permitted.",
        ERRNO_PIPE => "Broken pipe.",
        ERRNO_PROTO => "Protocol error.",
        ERRNO_PROTONOSUPPORT => "Protocol not supported.",
        ERRNO_PROTOTYPE => "Protocol wrong type for socket.",
        ERRNO_RANGE => "Result too large.",
        ERRNO_ROFS => "Read-only file system.",
        ERRNO_SPIPE => "Invalid seek.",
        ERRNO_SRCH => "No such process.",
        ERRNO_STALE => "Reserved.",
        ERRNO_TIMEDOUT => "Connection timed out.",
        ERRNO_TXTBSY => "Text file busy.",
        ERRNO_XDEV => "Cross-device link.",
        ERRNO_NOTCAPABLE => "Extension: Capabilities insufficient.",
        _ => "Unknown error.",
    }
}
pub type Rights = u64;
/// The right to invoke `fd_datasync`.
/// If `path_open` is set, includes the right to invoke
/// `path_open` with `fdflags::dsync`.
pub const RIGHTS_FD_DATASYNC: Rights = 0x1;
/// The right to invoke `fd_read` and `sock_recv`.
/// If `rights::fd_seek` is set, includes the right to invoke `fd_pread`.
pub const RIGHTS_FD_READ: Rights = 0x2;
/// The right to invoke `fd_seek`. This flag implies `rights::fd_tell`.
pub const RIGHTS_FD_SEEK: Rights = 0x4;
/// The right to invoke `fd_fdstat_set_flags`.
pub const RIGHTS_FD_FDSTAT_SET_FLAGS: Rights = 0x8;
/// The right to invoke `fd_sync`.
/// If `path_open` is set, includes the right to invoke
/// `path_open` with `fdflags::rsync` and `fdflags::dsync`.
pub const RIGHTS_FD_SYNC: Rights = 0x10;
/// The right to invoke `fd_seek` in such a way that the file offset
/// remains unaltered (i.e., `whence::cur` with offset zero), or to
/// invoke `fd_tell`.
pub const RIGHTS_FD_TELL: Rights = 0x20;
/// The right to invoke `fd_write` and `sock_send`.
/// If `rights::fd_seek` is set, includes the right to invoke `fd_pwrite`.
pub const RIGHTS_FD_WRITE: Rights = 0x40;
/// The right to invoke `fd_advise`.
pub const RIGHTS_FD_ADVISE: Rights = 0x80;
/// The right to invoke `fd_allocate`.
pub const RIGHTS_FD_ALLOCATE: Rights = 0x100;
/// The right to invoke `path_create_directory`.
pub const RIGHTS_PATH_CREATE_DIRECTORY: Rights = 0x200;
/// If `path_open` is set, the right to invoke `path_open` with `oflags::creat`.
pub const RIGHTS_PATH_CREATE_FILE: Rights = 0x400;
/// The right to invoke `path_link` with the file descriptor as the
/// source directory.
pub const RIGHTS_PATH_LINK_SOURCE: Rights = 0x800;
/// The right to invoke `path_link` with the file descriptor as the
/// target directory.
pub const RIGHTS_PATH_LINK_TARGET: Rights = 0x1000;
/// The right to invoke `path_open`.
pub const RIGHTS_PATH_OPEN: Rights = 0x2000;
/// The right to invoke `fd_readdir`.
pub const RIGHTS_FD_READDIR: Rights = 0x4000;
/// The right to invoke `path_readlink`.
pub const RIGHTS_PATH_READLINK: Rights = 0x8000;
/// The right to invoke `path_rename` with the file descriptor as the source directory.
pub const RIGHTS_PATH_RENAME_SOURCE: Rights = 0x10000;
/// The right to invoke `path_rename` with the file descriptor as the target directory.
pub const RIGHTS_PATH_RENAME_TARGET: Rights = 0x20000;
/// The right to invoke `path_filestat_get`.
pub const RIGHTS_PATH_FILESTAT_GET: Rights = 0x40000;
/// The right to change a file's size (there is no `path_filestat_set_size`).
/// If `path_open` is set, includes the right to invoke `path_open` with `oflags::trunc`.
pub const RIGHTS_PATH_FILESTAT_SET_SIZE: Rights = 0x80000;
/// The right to invoke `path_filestat_set_times`.
pub const RIGHTS_PATH_FILESTAT_SET_TIMES: Rights = 0x100000;
/// The right to invoke `fd_filestat_get`.
pub const RIGHTS_FD_FILESTAT_GET: Rights = 0x200000;
/// The right to invoke `fd_filestat_set_size`.
pub const RIGHTS_FD_FILESTAT_SET_SIZE: Rights = 0x400000;
/// The right to invoke `fd_filestat_set_times`.
pub const RIGHTS_FD_FILESTAT_SET_TIMES: Rights = 0x800000;
/// The right to invoke `path_symlink`.
pub const RIGHTS_PATH_SYMLINK: Rights = 0x1000000;
/// The right to invoke `path_remove_directory`.
pub const RIGHTS_PATH_REMOVE_DIRECTORY: Rights = 0x2000000;
/// The right to invoke `path_unlink_file`.
pub const RIGHTS_PATH_UNLINK_FILE: Rights = 0x4000000;
/// If `rights::fd_read` is set, includes the right to invoke `poll_oneoff` to subscribe to `eventtype::fd_read`.
/// If `rights::fd_write` is set, includes the right to invoke `poll_oneoff` to subscribe to `eventtype::fd_write`.
pub const RIGHTS_POLL_FD_READWRITE: Rights = 0x8000000;
/// The right to invoke `sock_shutdown`.
pub const RIGHTS_SOCK_SHUTDOWN: Rights = 0x10000000;
pub type Fd = u32;
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct Iovec {
    /// The address of the buffer to be filled.
    pub buf: *mut u8,
    /// The length of the buffer to be filled.
    pub buf_len: Size,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct Ciovec {
    /// The address of the buffer to be written.
    pub buf: *const u8,
    /// The length of the buffer to be written.
    pub buf_len: Size,
}
pub type IovecArray<'a> = &'a [Iovec];
pub type CiovecArray<'a> = &'a [Ciovec];
pub type Filedelta = i64;
pub type Whence = u8;
/// Seek relative to start-of-file.
pub const WHENCE_SET: Whence = 0;
/// Seek relative to current position.
pub const WHENCE_CUR: Whence = 1;
/// Seek relative to end-of-file.
pub const WHENCE_END: Whence = 2;
pub type Dircookie = u64;
pub type Dirnamlen = u32;
pub type Inode = u64;
pub type Filetype = u8;
/// The type of the file descriptor or file is unknown or is different from any of the other types specified.
pub const FILETYPE_UNKNOWN: Filetype = 0;
/// The file descriptor or file refers to a block device inode.
pub const FILETYPE_BLOCK_DEVICE: Filetype = 1;
/// The file descriptor or file refers to a character device inode.
pub const FILETYPE_CHARACTER_DEVICE: Filetype = 2;
/// The file descriptor or file refers to a directory inode.
pub const FILETYPE_DIRECTORY: Filetype = 3;
/// The file descriptor or file refers to a regular file inode.
pub const FILETYPE_REGULAR_FILE: Filetype = 4;
/// The file descriptor or file refers to a datagram socket.
pub const FILETYPE_SOCKET_DGRAM: Filetype = 5;
/// The file descriptor or file refers to a byte-stream socket.
pub const FILETYPE_SOCKET_STREAM: Filetype = 6;
/// The file refers to a symbolic link inode.
pub const FILETYPE_SYMBOLIC_LINK: Filetype = 7;
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct Dirent {
    /// The offset of the next directory entry stored in this directory.
    pub d_next: Dircookie,
    /// The serial number of the file referred to by this directory entry.
    pub d_ino: Inode,
    /// The length of the name of the directory entry.
    pub d_namlen: Dirnamlen,
    /// The type of the file referred to by this directory entry.
    pub d_type: Filetype,
}
pub type Advice = u8;
/// The application has no advice to give on its behavior with respect to the specified data.
pub const ADVICE_NORMAL: Advice = 0;
/// The application expects to access the specified data sequentially from lower offsets to higher offsets.
pub const ADVICE_SEQUENTIAL: Advice = 1;
/// The application expects to access the specified data in a random order.
pub const ADVICE_RANDOM: Advice = 2;
/// The application expects to access the specified data in the near future.
pub const ADVICE_WILLNEED: Advice = 3;
/// The application expects that it will not access the specified data in the near future.
pub const ADVICE_DONTNEED: Advice = 4;
/// The application expects to access the specified data once and then not reuse it thereafter.
pub const ADVICE_NOREUSE: Advice = 5;
pub type Fdflags = u16;
/// Append mode: Data written to the file is always appended to the file's end.
pub const FDFLAGS_APPEND: Fdflags = 0x1;
/// Write according to synchronized I/O data integrity completion. Only the data stored in the file is synchronized.
pub const FDFLAGS_DSYNC: Fdflags = 0x2;
/// Non-blocking mode.
pub const FDFLAGS_NONBLOCK: Fdflags = 0x4;
/// Synchronized read I/O operations.
pub const FDFLAGS_RSYNC: Fdflags = 0x8;
/// Write according to synchronized I/O file integrity completion. In
/// addition to synchronizing the data stored in the file, the implementation
/// may also synchronously update the file's metadata.
pub const FDFLAGS_SYNC: Fdflags = 0x10;
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct Fdstat {
    /// File type.
    pub fs_filetype: Filetype,
    /// File descriptor flags.
    pub fs_flags: Fdflags,
    /// Rights that apply to this file descriptor.
    pub fs_rights_base: Rights,
    /// Maximum set of rights that may be installed on new file descriptors that
    /// are created through this file descriptor, e.g., through `path_open`.
    pub fs_rights_inheriting: Rights,
}
pub type Device = u64;
pub type Fstflags = u16;
/// Adjust the last data access timestamp to the value stored in `filestat::atim`.
pub const FSTFLAGS_ATIM: Fstflags = 0x1;
/// Adjust the last data access timestamp to the time of clock `clockid::realtime`.
pub const FSTFLAGS_ATIM_NOW: Fstflags = 0x2;
/// Adjust the last data modification timestamp to the value stored in `filestat::mtim`.
pub const FSTFLAGS_MTIM: Fstflags = 0x4;
/// Adjust the last data modification timestamp to the time of clock `clockid::realtime`.
pub const FSTFLAGS_MTIM_NOW: Fstflags = 0x8;
pub type Lookupflags = u32;
/// As long as the resolved path corresponds to a symbolic link, it is expanded.
pub const LOOKUPFLAGS_SYMLINK_FOLLOW: Lookupflags = 0x1;
pub type Oflags = u16;
/// Create file if it does not exist.
pub const OFLAGS_CREAT: Oflags = 0x1;
/// Fail if not a directory.
pub const OFLAGS_DIRECTORY: Oflags = 0x2;
/// Fail if file already exists.
pub const OFLAGS_EXCL: Oflags = 0x4;
/// Truncate file to size 0.
pub const OFLAGS_TRUNC: Oflags = 0x8;
pub type Linkcount = u64;
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct Filestat {
    /// Device ID of device containing the file.
    pub dev: Device,
    /// File serial number.
    pub ino: Inode,
    /// File type.
    pub filetype: Filetype,
    /// Number of hard links to the file.
    pub nlink: Linkcount,
    /// For regular files, the file size in bytes. For symbolic links, the length in bytes of the pathname contained in the symbolic link.
    pub size: Filesize,
    /// Last data access timestamp.
    pub atim: Timestamp,
    /// Last data modification timestamp.
    pub mtim: Timestamp,
    /// Last file status change timestamp.
    pub ctim: Timestamp,
}
pub type Userdata = u64;
pub type Eventtype = u8;
/// The time value of clock `subscription_clock::id` has
/// reached timestamp `subscription_clock::timeout`.
pub const EVENTTYPE_CLOCK: Eventtype = 0;
/// File descriptor `subscription_fd_readwrite::file_descriptor` has data
/// available for reading. This event always triggers for regular files.
pub const EVENTTYPE_FD_READ: Eventtype = 1;
/// File descriptor `subscription_fd_readwrite::file_descriptor` has capacity
/// available for writing. This event always triggers for regular files.
pub const EVENTTYPE_FD_WRITE: Eventtype = 2;
pub type Eventrwflags = u16;
/// The peer of this socket has closed or disconnected.
pub const EVENTRWFLAGS_FD_READWRITE_HANGUP: Eventrwflags = 0x1;
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct EventFdReadwrite {
    /// The number of bytes available for reading or writing.
    pub nbytes: Filesize,
    /// The state of the file descriptor.
    pub flags: Eventrwflags,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct Event {
    /// User-provided value that got attached to `subscription::userdata`.
    pub userdata: Userdata,
    /// If non-zero, an error that occurred while processing the subscription request.
    pub error: Errno,
    /// The type of event that occured
    pub r#type: Eventtype,
    /// The contents of the event, if it is an `eventtype::fd_read` or
    /// `eventtype::fd_write`. `eventtype::clock` events ignore this field.
    pub fd_readwrite: EventFdReadwrite,
}
pub type Subclockflags = u16;
/// If set, treat the timestamp provided in
/// `subscription_clock::timeout` as an absolute timestamp of clock
/// `subscription_clock::id`. If clear, treat the timestamp
/// provided in `subscription_clock::timeout` relative to the
/// current time value of clock `subscription_clock::id`.
pub const SUBCLOCKFLAGS_SUBSCRIPTION_CLOCK_ABSTIME: Subclockflags = 0x1;
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct SubscriptionClock {
    /// The clock against which to compare the timestamp.
    pub id: Clockid,
    /// The absolute or relative timestamp.
    pub timeout: Timestamp,
    /// The amount of time that the implementation may wait additionally
    /// to coalesce with other events.
    pub precision: Timestamp,
    /// Flags specifying whether the timeout is absolute or relative
    pub flags: Subclockflags,
}
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct SubscriptionFdReadwrite {
    /// The file descriptor on which to wait for it to become ready for reading or writing.
    pub file_descriptor: Fd,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union SubscriptionUU {
    pub clock: SubscriptionClock,
    pub fd_read: SubscriptionFdReadwrite,
    pub fd_write: SubscriptionFdReadwrite,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SubscriptionU {
    pub tag: Eventtype,
    pub u: SubscriptionUU,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct Subscription {
    /// User-provided value that is attached to the subscription in the
    /// implementation and returned through `event::userdata`.
    pub userdata: Userdata,
    /// The type of the event to which to subscribe, and its contents
    pub u: SubscriptionU,
}
pub type Exitcode = u32;
pub type Signal = u8;
/// No signal. Note that POSIX has special semantics for `kill(pid, 0)`,
/// so this value is reserved.
pub const SIGNAL_NONE: Signal = 0;
/// Hangup.
/// Action: Terminates the process.
pub const SIGNAL_HUP: Signal = 1;
/// Terminate interrupt signal.
/// Action: Terminates the process.
pub const SIGNAL_INT: Signal = 2;
/// Terminal quit signal.
/// Action: Terminates the process.
pub const SIGNAL_QUIT: Signal = 3;
/// Illegal instruction.
/// Action: Terminates the process.
pub const SIGNAL_ILL: Signal = 4;
/// Trace/breakpoint trap.
/// Action: Terminates the process.
pub const SIGNAL_TRAP: Signal = 5;
/// Process abort signal.
/// Action: Terminates the process.
pub const SIGNAL_ABRT: Signal = 6;
/// Access to an undefined portion of a memory object.
/// Action: Terminates the process.
pub const SIGNAL_BUS: Signal = 7;
/// Erroneous arithmetic operation.
/// Action: Terminates the process.
pub const SIGNAL_FPE: Signal = 8;
/// Kill.
/// Action: Terminates the process.
pub const SIGNAL_KILL: Signal = 9;
/// User-defined signal 1.
/// Action: Terminates the process.
pub const SIGNAL_USR1: Signal = 10;
/// Invalid memory reference.
/// Action: Terminates the process.
pub const SIGNAL_SEGV: Signal = 11;
/// User-defined signal 2.
/// Action: Terminates the process.
pub const SIGNAL_USR2: Signal = 12;
/// Write on a pipe with no one to read it.
/// Action: Ignored.
pub const SIGNAL_PIPE: Signal = 13;
/// Alarm clock.
/// Action: Terminates the process.
pub const SIGNAL_ALRM: Signal = 14;
/// Termination signal.
/// Action: Terminates the process.
pub const SIGNAL_TERM: Signal = 15;
/// Child process terminated, stopped, or continued.
/// Action: Ignored.
pub const SIGNAL_CHLD: Signal = 16;
/// Continue executing, if stopped.
/// Action: Continues executing, if stopped.
pub const SIGNAL_CONT: Signal = 17;
/// Stop executing.
/// Action: Stops executing.
pub const SIGNAL_STOP: Signal = 18;
/// Terminal stop signal.
/// Action: Stops executing.
pub const SIGNAL_TSTP: Signal = 19;
/// Background process attempting read.
/// Action: Stops executing.
pub const SIGNAL_TTIN: Signal = 20;
/// Background process attempting write.
/// Action: Stops executing.
pub const SIGNAL_TTOU: Signal = 21;
/// High bandwidth data is available at a socket.
/// Action: Ignored.
pub const SIGNAL_URG: Signal = 22;
/// CPU time limit exceeded.
/// Action: Terminates the process.
pub const SIGNAL_XCPU: Signal = 23;
/// File size limit exceeded.
/// Action: Terminates the process.
pub const SIGNAL_XFSZ: Signal = 24;
/// Virtual timer expired.
/// Action: Terminates the process.
pub const SIGNAL_VTALRM: Signal = 25;
/// Profiling timer expired.
/// Action: Terminates the process.
pub const SIGNAL_PROF: Signal = 26;
/// Window changed.
/// Action: Ignored.
pub const SIGNAL_WINCH: Signal = 27;
/// I/O possible.
/// Action: Terminates the process.
pub const SIGNAL_POLL: Signal = 28;
/// Power failure.
/// Action: Terminates the process.
pub const SIGNAL_PWR: Signal = 29;
/// Bad system call.
/// Action: Terminates the process.
pub const SIGNAL_SYS: Signal = 30;
pub type Riflags = u16;
/// Returns the message without removing it from the socket's receive queue.
pub const RIFLAGS_RECV_PEEK: Riflags = 0x1;
/// On byte-stream sockets, block until the full amount of data can be returned.
pub const RIFLAGS_RECV_WAITALL: Riflags = 0x2;
pub type Roflags = u16;
/// Returned by `sock_recv`: Message data has been truncated.
pub const ROFLAGS_RECV_DATA_TRUNCATED: Roflags = 0x1;
pub type Siflags = u16;
pub type Sdflags = u8;
/// Disables further receive operations.
pub const SDFLAGS_RD: Sdflags = 0x1;
/// Disables further send operations.
pub const SDFLAGS_WR: Sdflags = 0x2;
pub type Preopentype = u8;
/// A pre-opened directory.
pub const PREOPENTYPE_DIR: Preopentype = 0;
#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct PrestatDir {
    /// The length of the directory name for use with `fd_prestat_dir_name`.
    pub pr_name_len: Size,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union PrestatU {
    pub dir: PrestatDir,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct Prestat {
    pub tag: Preopentype,
    pub u: PrestatU,
}

/// Read command-line argument data.
/// The size of the array should match that returned by `args_sizes_get`
pub unsafe fn args_get(argv: *mut *mut u8, argv_buf: *mut u8) -> Result<()> {
    let rc = wasi_snapshot_preview1::args_get(argv, argv_buf);
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Return command-line argument data sizes.
///
/// ## Return
///
/// * `argc` - The number of arguments.
/// * `argv_buf_size` - The size of the argument string data.
pub unsafe fn args_sizes_get() -> Result<(Size, Size)> {
    let mut argc = MaybeUninit::uninit();
    let mut argv_buf_size = MaybeUninit::uninit();
    let rc = wasi_snapshot_preview1::args_sizes_get(argc.as_mut_ptr(), argv_buf_size.as_mut_ptr());
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok((argc.assume_init(), argv_buf_size.assume_init()))
    }
}

/// Read environment variable data.
/// The sizes of the buffers should match that returned by `environ_sizes_get`.
pub unsafe fn environ_get(environ: *mut *mut u8, environ_buf: *mut u8) -> Result<()> {
    let rc = wasi_snapshot_preview1::environ_get(environ, environ_buf);
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Return environment variable data sizes.
///
/// ## Return
///
/// * `environc` - The number of environment variable arguments.
/// * `environ_buf_size` - The size of the environment variable data.
pub unsafe fn environ_sizes_get() -> Result<(Size, Size)> {
    let mut environc = MaybeUninit::uninit();
    let mut environ_buf_size = MaybeUninit::uninit();
    let rc = wasi_snapshot_preview1::environ_sizes_get(
        environc.as_mut_ptr(),
        environ_buf_size.as_mut_ptr(),
    );
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok((environc.assume_init(), environ_buf_size.assume_init()))
    }
}

/// Return the resolution of a clock.
/// Implementations are required to provide a non-zero value for supported clocks. For unsupported clocks,
/// return `errno::inval`.
/// Note: This is similar to `clock_getres` in POSIX.
///
/// ## Parameters
///
/// * `id` - The clock for which to return the resolution.
///
/// ## Return
///
/// * `resolution` - The resolution of the clock.
pub unsafe fn clock_res_get(id: Clockid) -> Result<Timestamp> {
    let mut resolution = MaybeUninit::uninit();
    let rc = wasi_snapshot_preview1::clock_res_get(id, resolution.as_mut_ptr());
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(resolution.assume_init())
    }
}

/// Return the time value of a clock.
/// Note: This is similar to `clock_gettime` in POSIX.
///
/// ## Parameters
///
/// * `id` - The clock for which to return the time.
/// * `precision` - The maximum lag (exclusive) that the returned time value may have, compared to its actual value.
///
/// ## Return
///
/// * `time` - The time value of the clock.
pub unsafe fn clock_time_get(id: Clockid, precision: Timestamp) -> Result<Timestamp> {
    let mut time = MaybeUninit::uninit();
    let rc = wasi_snapshot_preview1::clock_time_get(id, precision, time.as_mut_ptr());
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(time.assume_init())
    }
}

/// Provide file advisory information on a file descriptor.
/// Note: This is similar to `posix_fadvise` in POSIX.
///
/// ## Parameters
///
/// * `offset` - The offset within the file to which the advisory applies.
/// * `len` - The length of the region to which the advisory applies.
/// * `advice` - The advice.
pub unsafe fn fd_advise(fd: Fd, offset: Filesize, len: Filesize, advice: Advice) -> Result<()> {
    let rc = wasi_snapshot_preview1::fd_advise(fd, offset, len, advice);
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Force the allocation of space in a file.
/// Note: This is similar to `posix_fallocate` in POSIX.
///
/// ## Parameters
///
/// * `offset` - The offset at which to start the allocation.
/// * `len` - The length of the area that is allocated.
pub unsafe fn fd_allocate(fd: Fd, offset: Filesize, len: Filesize) -> Result<()> {
    let rc = wasi_snapshot_preview1::fd_allocate(fd, offset, len);
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Close a file descriptor.
/// Note: This is similar to `close` in POSIX.
pub unsafe fn fd_close(fd: Fd) -> Result<()> {
    let rc = wasi_snapshot_preview1::fd_close(fd);
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Synchronize the data of a file to disk.
/// Note: This is similar to `fdatasync` in POSIX.
pub unsafe fn fd_datasync(fd: Fd) -> Result<()> {
    let rc = wasi_snapshot_preview1::fd_datasync(fd);
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Get the attributes of a file descriptor.
/// Note: This returns similar flags to `fsync(fd, F_GETFL)` in POSIX, as well as additional fields.
///
/// ## Return
///
/// * `stat` - The buffer where the file descriptor's attributes are stored.
pub unsafe fn fd_fdstat_get(fd: Fd) -> Result<Fdstat> {
    let mut stat = MaybeUninit::uninit();
    let rc = wasi_snapshot_preview1::fd_fdstat_get(fd, stat.as_mut_ptr());
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(stat.assume_init())
    }
}

/// Adjust the flags associated with a file descriptor.
/// Note: This is similar to `fcntl(fd, F_SETFL, flags)` in POSIX.
///
/// ## Parameters
///
/// * `flags` - The desired values of the file descriptor flags.
pub unsafe fn fd_fdstat_set_flags(fd: Fd, flags: Fdflags) -> Result<()> {
    let rc = wasi_snapshot_preview1::fd_fdstat_set_flags(fd, flags);
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Adjust the rights associated with a file descriptor.
/// This can only be used to remove rights, and returns `errno::notcapable` if called in a way that would attempt to add rights
///
/// ## Parameters
///
/// * `fs_rights_base` - The desired rights of the file descriptor.
pub unsafe fn fd_fdstat_set_rights(
    fd: Fd,
    fs_rights_base: Rights,
    fs_rights_inheriting: Rights,
) -> Result<()> {
    let rc = wasi_snapshot_preview1::fd_fdstat_set_rights(fd, fs_rights_base, fs_rights_inheriting);
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Return the attributes of an open file.
///
/// ## Return
///
/// * `buf` - The buffer where the file's attributes are stored.
pub unsafe fn fd_filestat_get(fd: Fd) -> Result<Filestat> {
    let mut buf = MaybeUninit::uninit();
    let rc = wasi_snapshot_preview1::fd_filestat_get(fd, buf.as_mut_ptr());
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(buf.assume_init())
    }
}

/// Adjust the size of an open file. If this increases the file's size, the extra bytes are filled with zeros.
/// Note: This is similar to `ftruncate` in POSIX.
///
/// ## Parameters
///
/// * `size` - The desired file size.
pub unsafe fn fd_filestat_set_size(fd: Fd, size: Filesize) -> Result<()> {
    let rc = wasi_snapshot_preview1::fd_filestat_set_size(fd, size);
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Adjust the timestamps of an open file or directory.
/// Note: This is similar to `futimens` in POSIX.
///
/// ## Parameters
///
/// * `atim` - The desired values of the data access timestamp.
/// * `mtim` - The desired values of the data modification timestamp.
/// * `fst_flags` - A bitmask indicating which timestamps to adjust.
pub unsafe fn fd_filestat_set_times(
    fd: Fd,
    atim: Timestamp,
    mtim: Timestamp,
    fst_flags: Fstflags,
) -> Result<()> {
    let rc = wasi_snapshot_preview1::fd_filestat_set_times(fd, atim, mtim, fst_flags);
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Read from a file descriptor, without using and updating the file descriptor's offset.
/// Note: This is similar to `preadv` in POSIX.
///
/// ## Parameters
///
/// * `iovs` - List of scatter/gather vectors in which to store data.
/// * `offset` - The offset within the file at which to read.
///
/// ## Return
///
/// * `nread` - The number of bytes read.
pub unsafe fn fd_pread(fd: Fd, iovs: IovecArray<'_>, offset: Filesize) -> Result<Size> {
    let mut nread = MaybeUninit::uninit();
    let rc =
        wasi_snapshot_preview1::fd_pread(fd, iovs.as_ptr(), iovs.len(), offset, nread.as_mut_ptr());
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(nread.assume_init())
    }
}

/// Return a description of the given preopened file descriptor.
///
/// ## Return
///
/// * `buf` - The buffer where the description is stored.
pub unsafe fn fd_prestat_get(fd: Fd) -> Result<Prestat> {
    let mut buf = MaybeUninit::uninit();
    let rc = wasi_snapshot_preview1::fd_prestat_get(fd, buf.as_mut_ptr());
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(buf.assume_init())
    }
}

/// Return a description of the given preopened file descriptor.
///
/// ## Parameters
///
/// * `path` - A buffer into which to write the preopened directory name.
pub unsafe fn fd_prestat_dir_name(fd: Fd, path: *mut u8, path_len: Size) -> Result<()> {
    let rc = wasi_snapshot_preview1::fd_prestat_dir_name(fd, path, path_len);
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Write to a file descriptor, without using and updating the file descriptor's offset.
/// Note: This is similar to `pwritev` in POSIX.
///
/// ## Parameters
///
/// * `iovs` - List of scatter/gather vectors from which to retrieve data.
/// * `offset` - The offset within the file at which to write.
///
/// ## Return
///
/// * `nwritten` - The number of bytes written.
pub unsafe fn fd_pwrite(fd: Fd, iovs: CiovecArray<'_>, offset: Filesize) -> Result<Size> {
    let mut nwritten = MaybeUninit::uninit();
    let rc = wasi_snapshot_preview1::fd_pwrite(
        fd,
        iovs.as_ptr(),
        iovs.len(),
        offset,
        nwritten.as_mut_ptr(),
    );
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(nwritten.assume_init())
    }
}

/// Read from a file descriptor.
/// Note: This is similar to `readv` in POSIX.
///
/// ## Parameters
///
/// * `iovs` - List of scatter/gather vectors to which to store data.
///
/// ## Return
///
/// * `nread` - The number of bytes read.
pub unsafe fn fd_read(fd: Fd, iovs: IovecArray<'_>) -> Result<Size> {
    let mut nread = MaybeUninit::uninit();
    let rc = wasi_snapshot_preview1::fd_read(fd, iovs.as_ptr(), iovs.len(), nread.as_mut_ptr());
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(nread.assume_init())
    }
}

/// Read directory entries from a directory.
/// When successful, the contents of the output buffer consist of a sequence of
/// directory entries. Each directory entry consists of a `dirent` object,
/// followed by `dirent::d_namlen` bytes holding the name of the directory
/// entry.
/// This function fills the output buffer as much as possible, potentially
/// truncating the last directory entry. This allows the caller to grow its
/// read buffer size in case it's too small to fit a single large directory
/// entry, or skip the oversized directory entry.
///
/// ## Parameters
///
/// * `buf` - The buffer where directory entries are stored
/// * `cookie` - The location within the directory to start reading
///
/// ## Return
///
/// * `bufused` - The number of bytes stored in the read buffer. If less than the size of the read buffer, the end of the directory has been reached.
pub unsafe fn fd_readdir(fd: Fd, buf: *mut u8, buf_len: Size, cookie: Dircookie) -> Result<Size> {
    let mut bufused = MaybeUninit::uninit();
    let rc = wasi_snapshot_preview1::fd_readdir(fd, buf, buf_len, cookie, bufused.as_mut_ptr());
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(bufused.assume_init())
    }
}

/// Atomically replace a file descriptor by renumbering another file descriptor.
/// Due to the strong focus on thread safety, this environment does not provide
/// a mechanism to duplicate or renumber a file descriptor to an arbitrary
/// number, like `dup2()`. This would be prone to race conditions, as an actual
/// file descriptor with the same number could be allocated by a different
/// thread at the same time.
/// This function provides a way to atomically renumber file descriptors, which
/// would disappear if `dup2()` were to be removed entirely.
///
/// ## Parameters
///
/// * `to` - The file descriptor to overwrite.
pub unsafe fn fd_renumber(fd: Fd, to: Fd) -> Result<()> {
    let rc = wasi_snapshot_preview1::fd_renumber(fd, to);
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Move the offset of a file descriptor.
/// Note: This is similar to `lseek` in POSIX.
///
/// ## Parameters
///
/// * `offset` - The number of bytes to move.
/// * `whence` - The base from which the offset is relative.
///
/// ## Return
///
/// * `newoffset` - The new offset of the file descriptor, relative to the start of the file.
pub unsafe fn fd_seek(fd: Fd, offset: Filedelta, whence: Whence) -> Result<Filesize> {
    let mut newoffset = MaybeUninit::uninit();
    let rc = wasi_snapshot_preview1::fd_seek(fd, offset, whence, newoffset.as_mut_ptr());
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(newoffset.assume_init())
    }
}

/// Synchronize the data and metadata of a file to disk.
/// Note: This is similar to `fsync` in POSIX.
pub unsafe fn fd_sync(fd: Fd) -> Result<()> {
    let rc = wasi_snapshot_preview1::fd_sync(fd);
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Return the current offset of a file descriptor.
/// Note: This is similar to `lseek(fd, 0, SEEK_CUR)` in POSIX.
///
/// ## Return
///
/// * `offset` - The current offset of the file descriptor, relative to the start of the file.
pub unsafe fn fd_tell(fd: Fd) -> Result<Filesize> {
    let mut offset = MaybeUninit::uninit();
    let rc = wasi_snapshot_preview1::fd_tell(fd, offset.as_mut_ptr());
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(offset.assume_init())
    }
}

/// Write to a file descriptor.
/// Note: This is similar to `writev` in POSIX.
///
/// ## Parameters
///
/// * `iovs` - List of scatter/gather vectors from which to retrieve data.
///
/// ## Return
///
/// * `nwritten` - The number of bytes written.
pub unsafe fn fd_write(fd: Fd, iovs: CiovecArray<'_>) -> Result<Size> {
    let mut nwritten = MaybeUninit::uninit();
    let rc = wasi_snapshot_preview1::fd_write(fd, iovs.as_ptr(), iovs.len(), nwritten.as_mut_ptr());
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(nwritten.assume_init())
    }
}

/// Create a directory.
/// Note: This is similar to `mkdirat` in POSIX.
///
/// ## Parameters
///
/// * `path` - The path at which to create the directory.
pub unsafe fn path_create_directory(fd: Fd, path: &str) -> Result<()> {
    let rc = wasi_snapshot_preview1::path_create_directory(fd, path.as_ptr(), path.len());
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Return the attributes of a file or directory.
/// Note: This is similar to `stat` in POSIX.
///
/// ## Parameters
///
/// * `flags` - Flags determining the method of how the path is resolved.
/// * `path` - The path of the file or directory to inspect.
///
/// ## Return
///
/// * `buf` - The buffer where the file's attributes are stored.
pub unsafe fn path_filestat_get(fd: Fd, flags: Lookupflags, path: &str) -> Result<Filestat> {
    let mut buf = MaybeUninit::uninit();
    let rc = wasi_snapshot_preview1::path_filestat_get(
        fd,
        flags,
        path.as_ptr(),
        path.len(),
        buf.as_mut_ptr(),
    );
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(buf.assume_init())
    }
}

/// Adjust the timestamps of a file or directory.
/// Note: This is similar to `utimensat` in POSIX.
///
/// ## Parameters
///
/// * `flags` - Flags determining the method of how the path is resolved.
/// * `path` - The path of the file or directory to operate on.
/// * `atim` - The desired values of the data access timestamp.
/// * `mtim` - The desired values of the data modification timestamp.
/// * `fst_flags` - A bitmask indicating which timestamps to adjust.
pub unsafe fn path_filestat_set_times(
    fd: Fd,
    flags: Lookupflags,
    path: &str,
    atim: Timestamp,
    mtim: Timestamp,
    fst_flags: Fstflags,
) -> Result<()> {
    let rc = wasi_snapshot_preview1::path_filestat_set_times(
        fd,
        flags,
        path.as_ptr(),
        path.len(),
        atim,
        mtim,
        fst_flags,
    );
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Create a hard link.
/// Note: This is similar to `linkat` in POSIX.
///
/// ## Parameters
///
/// * `old_flags` - Flags determining the method of how the path is resolved.
/// * `old_path` - The source path from which to link.
/// * `new_fd` - The working directory at which the resolution of the new path starts.
/// * `new_path` - The destination path at which to create the hard link.
pub unsafe fn path_link(
    old_fd: Fd,
    old_flags: Lookupflags,
    old_path: &str,
    new_fd: Fd,
    new_path: &str,
) -> Result<()> {
    let rc = wasi_snapshot_preview1::path_link(
        old_fd,
        old_flags,
        old_path.as_ptr(),
        old_path.len(),
        new_fd,
        new_path.as_ptr(),
        new_path.len(),
    );
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Open a file or directory.
/// The returned file descriptor is not guaranteed to be the lowest-numbered
/// file descriptor not currently open; it is randomized to prevent
/// applications from depending on making assumptions about indexes, since this
/// is error-prone in multi-threaded contexts. The returned file descriptor is
/// guaranteed to be less than 2**31.
/// Note: This is similar to `openat` in POSIX.
///
/// ## Parameters
///
/// * `dirflags` - Flags determining the method of how the path is resolved.
/// * `path` - The relative path of the file or directory to open, relative to the
///   `path_open::fd` directory.
/// * `oflags` - The method by which to open the file.
/// * `fs_rights_base` - The initial rights of the newly created file descriptor. The
///   implementation is allowed to return a file descriptor with fewer rights
///   than specified, if and only if those rights do not apply to the type of
///   file being opened.
///   The *base* rights are rights that will apply to operations using the file
///   descriptor itself, while the *inheriting* rights are rights that apply to
///   file descriptors derived from it.
///
/// ## Return
///
/// * `opened_fd` - The file descriptor of the file that has been opened.
pub unsafe fn path_open(
    fd: Fd,
    dirflags: Lookupflags,
    path: &str,
    oflags: Oflags,
    fs_rights_base: Rights,
    fs_rights_inheriting: Rights,
    fdflags: Fdflags,
) -> Result<Fd> {
    let mut opened_fd = MaybeUninit::uninit();
    let rc = wasi_snapshot_preview1::path_open(
        fd,
        dirflags,
        path.as_ptr(),
        path.len(),
        oflags,
        fs_rights_base,
        fs_rights_inheriting,
        fdflags,
        opened_fd.as_mut_ptr(),
    );
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(opened_fd.assume_init())
    }
}

/// Read the contents of a symbolic link.
/// Note: This is similar to `readlinkat` in POSIX.
///
/// ## Parameters
///
/// * `path` - The path of the symbolic link from which to read.
/// * `buf` - The buffer to which to write the contents of the symbolic link.
///
/// ## Return
///
/// * `bufused` - The number of bytes placed in the buffer.
pub unsafe fn path_readlink(fd: Fd, path: &str, buf: *mut u8, buf_len: Size) -> Result<Size> {
    let mut bufused = MaybeUninit::uninit();
    let rc = wasi_snapshot_preview1::path_readlink(
        fd,
        path.as_ptr(),
        path.len(),
        buf,
        buf_len,
        bufused.as_mut_ptr(),
    );
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(bufused.assume_init())
    }
}

/// Remove a directory.
/// Return `errno::notempty` if the directory is not empty.
/// Note: This is similar to `unlinkat(fd, path, AT_REMOVEDIR)` in POSIX.
///
/// ## Parameters
///
/// * `path` - The path to a directory to remove.
pub unsafe fn path_remove_directory(fd: Fd, path: &str) -> Result<()> {
    let rc = wasi_snapshot_preview1::path_remove_directory(fd, path.as_ptr(), path.len());
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Rename a file or directory.
/// Note: This is similar to `renameat` in POSIX.
///
/// ## Parameters
///
/// * `old_path` - The source path of the file or directory to rename.
/// * `new_fd` - The working directory at which the resolution of the new path starts.
/// * `new_path` - The destination path to which to rename the file or directory.
pub unsafe fn path_rename(fd: Fd, old_path: &str, new_fd: Fd, new_path: &str) -> Result<()> {
    let rc = wasi_snapshot_preview1::path_rename(
        fd,
        old_path.as_ptr(),
        old_path.len(),
        new_fd,
        new_path.as_ptr(),
        new_path.len(),
    );
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Create a symbolic link.
/// Note: This is similar to `symlinkat` in POSIX.
///
/// ## Parameters
///
/// * `old_path` - The contents of the symbolic link.
/// * `new_path` - The destination path at which to create the symbolic link.
pub unsafe fn path_symlink(old_path: &str, fd: Fd, new_path: &str) -> Result<()> {
    let rc = wasi_snapshot_preview1::path_symlink(
        old_path.as_ptr(),
        old_path.len(),
        fd,
        new_path.as_ptr(),
        new_path.len(),
    );
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Unlink a file.
/// Return `errno::isdir` if the path refers to a directory.
/// Note: This is similar to `unlinkat(fd, path, 0)` in POSIX.
///
/// ## Parameters
///
/// * `path` - The path to a file to unlink.
pub unsafe fn path_unlink_file(fd: Fd, path: &str) -> Result<()> {
    let rc = wasi_snapshot_preview1::path_unlink_file(fd, path.as_ptr(), path.len());
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Concurrently poll for the occurrence of a set of events.
///
/// ## Parameters
///
/// * `r#in` - The events to which to subscribe.
/// * `out` - The events that have occurred.
/// * `nsubscriptions` - Both the number of subscriptions and events.
///
/// ## Return
///
/// * `nevents` - The number of events stored.
pub unsafe fn poll_oneoff(
    r#in: *const Subscription,
    out: *mut Event,
    nsubscriptions: Size,
) -> Result<Size> {
    let mut nevents = MaybeUninit::uninit();
    let rc = wasi_snapshot_preview1::poll_oneoff(r#in, out, nsubscriptions, nevents.as_mut_ptr());
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(nevents.assume_init())
    }
}

/// Terminate the process normally. An exit code of 0 indicates successful
/// termination of the program. The meanings of other values is dependent on
/// the environment.
///
/// ## Parameters
///
/// * `rval` - The exit code returned by the process.
pub unsafe fn proc_exit(rval: Exitcode) {
    wasi_snapshot_preview1::proc_exit(rval);
}

/// Send a signal to the process of the calling thread.
/// Note: This is similar to `raise` in POSIX.
///
/// ## Parameters
///
/// * `sig` - The signal condition to trigger.
pub unsafe fn proc_raise(sig: Signal) -> Result<()> {
    let rc = wasi_snapshot_preview1::proc_raise(sig);
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Temporarily yield execution of the calling thread.
/// Note: This is similar to `sched_yield` in POSIX.
pub unsafe fn sched_yield() -> Result<()> {
    let rc = wasi_snapshot_preview1::sched_yield();
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Write high-quality random data into a buffer.
/// This function blocks when the implementation is unable to immediately
/// provide sufficient high-quality random data.
/// This function may execute slowly, so when large mounts of random data are
/// required, it's advisable to use this function to seed a pseudo-random
/// number generator, rather than to provide the random data directly.
///
/// ## Parameters
///
/// * `buf` - The buffer to fill with random data.
pub unsafe fn random_get(buf: *mut u8, buf_len: Size) -> Result<()> {
    let rc = wasi_snapshot_preview1::random_get(buf, buf_len);
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

/// Receive a message from a socket.
/// Note: This is similar to `recv` in POSIX, though it also supports reading
/// the data into multiple buffers in the manner of `readv`.
///
/// ## Parameters
///
/// * `ri_data` - List of scatter/gather vectors to which to store data.
/// * `ri_flags` - Message flags.
///
/// ## Return
///
/// * `ro_datalen` - Number of bytes stored in ri_data.
/// * `ro_flags` - Message flags.
pub unsafe fn sock_recv(
    fd: Fd,
    ri_data: IovecArray<'_>,
    ri_flags: Riflags,
) -> Result<(Size, Roflags)> {
    let mut ro_datalen = MaybeUninit::uninit();
    let mut ro_flags = MaybeUninit::uninit();
    let rc = wasi_snapshot_preview1::sock_recv(
        fd,
        ri_data.as_ptr(),
        ri_data.len(),
        ri_flags,
        ro_datalen.as_mut_ptr(),
        ro_flags.as_mut_ptr(),
    );
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok((ro_datalen.assume_init(), ro_flags.assume_init()))
    }
}

/// Send a message on a socket.
/// Note: This is similar to `send` in POSIX, though it also supports writing
/// the data from multiple buffers in the manner of `writev`.
///
/// ## Parameters
///
/// * `si_data` - List of scatter/gather vectors to which to retrieve data
/// * `si_flags` - Message flags.
///
/// ## Return
///
/// * `so_datalen` - Number of bytes transmitted.
pub unsafe fn sock_send(fd: Fd, si_data: CiovecArray<'_>, si_flags: Siflags) -> Result<Size> {
    let mut so_datalen = MaybeUninit::uninit();
    let rc = wasi_snapshot_preview1::sock_send(
        fd,
        si_data.as_ptr(),
        si_data.len(),
        si_flags,
        so_datalen.as_mut_ptr(),
    );
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(so_datalen.assume_init())
    }
}

/// Shut down socket send and receive channels.
/// Note: This is similar to `shutdown` in POSIX.
///
/// ## Parameters
///
/// * `how` - Which channels on the socket to shut down.
pub unsafe fn sock_shutdown(fd: Fd, how: Sdflags) -> Result<()> {
    let rc = wasi_snapshot_preview1::sock_shutdown(fd, how);
    if let Some(err) = Error::from_raw_error(rc) {
        Err(err)
    } else {
        Ok(())
    }
}

pub mod wasi_snapshot_preview1 {
    use super::*;
    #[link(wasm_import_module = "wasi_snapshot_preview1")]
    extern "C" {
        /// Read command-line argument data.
        /// The size of the array should match that returned by `args_sizes_get`
        pub fn args_get(argv: *mut *mut u8, argv_buf: *mut u8) -> Errno;
        /// Return command-line argument data sizes.
        pub fn args_sizes_get(argc: *mut Size, argv_buf_size: *mut Size) -> Errno;
        /// Read environment variable data.
        /// The sizes of the buffers should match that returned by `environ_sizes_get`.
        pub fn environ_get(environ: *mut *mut u8, environ_buf: *mut u8) -> Errno;
        /// Return environment variable data sizes.
        pub fn environ_sizes_get(environc: *mut Size, environ_buf_size: *mut Size) -> Errno;
        /// Return the resolution of a clock.
        /// Implementations are required to provide a non-zero value for supported clocks. For unsupported clocks,
        /// return `errno::inval`.
        /// Note: This is similar to `clock_getres` in POSIX.
        pub fn clock_res_get(id: Clockid, resolution: *mut Timestamp) -> Errno;
        /// Return the time value of a clock.
        /// Note: This is similar to `clock_gettime` in POSIX.
        pub fn clock_time_get(id: Clockid, precision: Timestamp, time: *mut Timestamp) -> Errno;
        /// Provide file advisory information on a file descriptor.
        /// Note: This is similar to `posix_fadvise` in POSIX.
        pub fn fd_advise(fd: Fd, offset: Filesize, len: Filesize, advice: Advice) -> Errno;
        /// Force the allocation of space in a file.
        /// Note: This is similar to `posix_fallocate` in POSIX.
        pub fn fd_allocate(fd: Fd, offset: Filesize, len: Filesize) -> Errno;
        /// Close a file descriptor.
        /// Note: This is similar to `close` in POSIX.
        pub fn fd_close(fd: Fd) -> Errno;
        /// Synchronize the data of a file to disk.
        /// Note: This is similar to `fdatasync` in POSIX.
        pub fn fd_datasync(fd: Fd) -> Errno;
        /// Get the attributes of a file descriptor.
        /// Note: This returns similar flags to `fsync(fd, F_GETFL)` in POSIX, as well as additional fields.
        pub fn fd_fdstat_get(fd: Fd, stat: *mut Fdstat) -> Errno;
        /// Adjust the flags associated with a file descriptor.
        /// Note: This is similar to `fcntl(fd, F_SETFL, flags)` in POSIX.
        pub fn fd_fdstat_set_flags(fd: Fd, flags: Fdflags) -> Errno;
        /// Adjust the rights associated with a file descriptor.
        /// This can only be used to remove rights, and returns `errno::notcapable` if called in a way that would attempt to add rights
        pub fn fd_fdstat_set_rights(
            fd: Fd,
            fs_rights_base: Rights,
            fs_rights_inheriting: Rights,
        ) -> Errno;
        /// Return the attributes of an open file.
        pub fn fd_filestat_get(fd: Fd, buf: *mut Filestat) -> Errno;
        /// Adjust the size of an open file. If this increases the file's size, the extra bytes are filled with zeros.
        /// Note: This is similar to `ftruncate` in POSIX.
        pub fn fd_filestat_set_size(fd: Fd, size: Filesize) -> Errno;
        /// Adjust the timestamps of an open file or directory.
        /// Note: This is similar to `futimens` in POSIX.
        pub fn fd_filestat_set_times(
            fd: Fd,
            atim: Timestamp,
            mtim: Timestamp,
            fst_flags: Fstflags,
        ) -> Errno;
        /// Read from a file descriptor, without using and updating the file descriptor's offset.
        /// Note: This is similar to `preadv` in POSIX.
        pub fn fd_pread(
            fd: Fd,
            iovs_ptr: *const Iovec,
            iovs_len: usize,
            offset: Filesize,
            nread: *mut Size,
        ) -> Errno;
        /// Return a description of the given preopened file descriptor.
        pub fn fd_prestat_get(fd: Fd, buf: *mut Prestat) -> Errno;
        /// Return a description of the given preopened file descriptor.
        pub fn fd_prestat_dir_name(fd: Fd, path: *mut u8, path_len: Size) -> Errno;
        /// Write to a file descriptor, without using and updating the file descriptor's offset.
        /// Note: This is similar to `pwritev` in POSIX.
        pub fn fd_pwrite(
            fd: Fd,
            iovs_ptr: *const Ciovec,
            iovs_len: usize,
            offset: Filesize,
            nwritten: *mut Size,
        ) -> Errno;
        /// Read from a file descriptor.
        /// Note: This is similar to `readv` in POSIX.
        pub fn fd_read(fd: Fd, iovs_ptr: *const Iovec, iovs_len: usize, nread: *mut Size) -> Errno;
        /// Read directory entries from a directory.
        /// When successful, the contents of the output buffer consist of a sequence of
        /// directory entries. Each directory entry consists of a `dirent` object,
        /// followed by `dirent::d_namlen` bytes holding the name of the directory
        /// entry.
        /// This function fills the output buffer as much as possible, potentially
        /// truncating the last directory entry. This allows the caller to grow its
        /// read buffer size in case it's too small to fit a single large directory
        /// entry, or skip the oversized directory entry.
        pub fn fd_readdir(
            fd: Fd,
            buf: *mut u8,
            buf_len: Size,
            cookie: Dircookie,
            bufused: *mut Size,
        ) -> Errno;
        /// Atomically replace a file descriptor by renumbering another file descriptor.
        /// Due to the strong focus on thread safety, this environment does not provide
        /// a mechanism to duplicate or renumber a file descriptor to an arbitrary
        /// number, like `dup2()`. This would be prone to race conditions, as an actual
        /// file descriptor with the same number could be allocated by a different
        /// thread at the same time.
        /// This function provides a way to atomically renumber file descriptors, which
        /// would disappear if `dup2()` were to be removed entirely.
        pub fn fd_renumber(fd: Fd, to: Fd) -> Errno;
        /// Move the offset of a file descriptor.
        /// Note: This is similar to `lseek` in POSIX.
        pub fn fd_seek(
            fd: Fd,
            offset: Filedelta,
            whence: Whence,
            newoffset: *mut Filesize,
        ) -> Errno;
        /// Synchronize the data and metadata of a file to disk.
        /// Note: This is similar to `fsync` in POSIX.
        pub fn fd_sync(fd: Fd) -> Errno;
        /// Return the current offset of a file descriptor.
        /// Note: This is similar to `lseek(fd, 0, SEEK_CUR)` in POSIX.
        pub fn fd_tell(fd: Fd, offset: *mut Filesize) -> Errno;
        /// Write to a file descriptor.
        /// Note: This is similar to `writev` in POSIX.
        pub fn fd_write(
            fd: Fd,
            iovs_ptr: *const Ciovec,
            iovs_len: usize,
            nwritten: *mut Size,
        ) -> Errno;
        /// Create a directory.
        /// Note: This is similar to `mkdirat` in POSIX.
        pub fn path_create_directory(fd: Fd, path_ptr: *const u8, path_len: usize) -> Errno;
        /// Return the attributes of a file or directory.
        /// Note: This is similar to `stat` in POSIX.
        pub fn path_filestat_get(
            fd: Fd,
            flags: Lookupflags,
            path_ptr: *const u8,
            path_len: usize,
            buf: *mut Filestat,
        ) -> Errno;
        /// Adjust the timestamps of a file or directory.
        /// Note: This is similar to `utimensat` in POSIX.
        pub fn path_filestat_set_times(
            fd: Fd,
            flags: Lookupflags,
            path_ptr: *const u8,
            path_len: usize,
            atim: Timestamp,
            mtim: Timestamp,
            fst_flags: Fstflags,
        ) -> Errno;
        /// Create a hard link.
        /// Note: This is similar to `linkat` in POSIX.
        pub fn path_link(
            old_fd: Fd,
            old_flags: Lookupflags,
            old_path_ptr: *const u8,
            old_path_len: usize,
            new_fd: Fd,
            new_path_ptr: *const u8,
            new_path_len: usize,
        ) -> Errno;
        /// Open a file or directory.
        /// The returned file descriptor is not guaranteed to be the lowest-numbered
        /// file descriptor not currently open; it is randomized to prevent
        /// applications from depending on making assumptions about indexes, since this
        /// is error-prone in multi-threaded contexts. The returned file descriptor is
        /// guaranteed to be less than 2**31.
        /// Note: This is similar to `openat` in POSIX.
        pub fn path_open(
            fd: Fd,
            dirflags: Lookupflags,
            path_ptr: *const u8,
            path_len: usize,
            oflags: Oflags,
            fs_rights_base: Rights,
            fs_rights_inheriting: Rights,
            fdflags: Fdflags,
            opened_fd: *mut Fd,
        ) -> Errno;
        /// Read the contents of a symbolic link.
        /// Note: This is similar to `readlinkat` in POSIX.
        pub fn path_readlink(
            fd: Fd,
            path_ptr: *const u8,
            path_len: usize,
            buf: *mut u8,
            buf_len: Size,
            bufused: *mut Size,
        ) -> Errno;
        /// Remove a directory.
        /// Return `errno::notempty` if the directory is not empty.
        /// Note: This is similar to `unlinkat(fd, path, AT_REMOVEDIR)` in POSIX.
        pub fn path_remove_directory(fd: Fd, path_ptr: *const u8, path_len: usize) -> Errno;
        /// Rename a file or directory.
        /// Note: This is similar to `renameat` in POSIX.
        pub fn path_rename(
            fd: Fd,
            old_path_ptr: *const u8,
            old_path_len: usize,
            new_fd: Fd,
            new_path_ptr: *const u8,
            new_path_len: usize,
        ) -> Errno;
        /// Create a symbolic link.
        /// Note: This is similar to `symlinkat` in POSIX.
        pub fn path_symlink(
            old_path_ptr: *const u8,
            old_path_len: usize,
            fd: Fd,
            new_path_ptr: *const u8,
            new_path_len: usize,
        ) -> Errno;
        /// Unlink a file.
        /// Return `errno::isdir` if the path refers to a directory.
        /// Note: This is similar to `unlinkat(fd, path, 0)` in POSIX.
        pub fn path_unlink_file(fd: Fd, path_ptr: *const u8, path_len: usize) -> Errno;
        /// Concurrently poll for the occurrence of a set of events.
        pub fn poll_oneoff(
            r#in: *const Subscription,
            out: *mut Event,
            nsubscriptions: Size,
            nevents: *mut Size,
        ) -> Errno;
        /// Terminate the process normally. An exit code of 0 indicates successful
        /// termination of the program. The meanings of other values is dependent on
        /// the environment.
        pub fn proc_exit(rval: Exitcode) -> !;
        /// Send a signal to the process of the calling thread.
        /// Note: This is similar to `raise` in POSIX.
        pub fn proc_raise(sig: Signal) -> Errno;
        /// Temporarily yield execution of the calling thread.
        /// Note: This is similar to `sched_yield` in POSIX.
        pub fn sched_yield() -> Errno;
        /// Write high-quality random data into a buffer.
        /// This function blocks when the implementation is unable to immediately
        /// provide sufficient high-quality random data.
        /// This function may execute slowly, so when large mounts of random data are
        /// required, it's advisable to use this function to seed a pseudo-random
        /// number generator, rather than to provide the random data directly.
        pub fn random_get(buf: *mut u8, buf_len: Size) -> Errno;
        /// Receive a message from a socket.
        /// Note: This is similar to `recv` in POSIX, though it also supports reading
        /// the data into multiple buffers in the manner of `readv`.
        pub fn sock_recv(
            fd: Fd,
            ri_data_ptr: *const Iovec,
            ri_data_len: usize,
            ri_flags: Riflags,
            ro_datalen: *mut Size,
            ro_flags: *mut Roflags,
        ) -> Errno;
        /// Send a message on a socket.
        /// Note: This is similar to `send` in POSIX, though it also supports writing
        /// the data from multiple buffers in the manner of `writev`.
        pub fn sock_send(
            fd: Fd,
            si_data_ptr: *const Ciovec,
            si_data_len: usize,
            si_flags: Siflags,
            so_datalen: *mut Size,
        ) -> Errno;
        /// Shut down socket send and receive channels.
        /// Note: This is similar to `shutdown` in POSIX.
        pub fn sock_shutdown(fd: Fd, how: Sdflags) -> Errno;
    }
}
