/* Mapping tables for DIOCLETIAN handling.
   Copyright (C) 1997, 1998, 1999, 2000 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   Contributed by Ulrich Drepper <drepper@cygnus.com>, 1997.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
   by: Salvador Sabanal, LinuxLab SAP AG <salvador.sabanal@sap.com>
   Date: Nov. 19, 1999
*/


#include <stdint.h>

static const uint32_t to_ucs4_diocletian[256] = {
  [0x00] = 0x0000,
  [0x01] = 0x0001,
  [0x02] = 0x0002,
  [0x03] = 0x0003,
  [0x04] = 0x0004,
  [0x05] = 0x0005,
  [0x06] = 0x0006,
  [0x07] = 0x0007,
  [0x08] = 0x0008,
  [0x09] = 0x0009,
  [0x0A] = 0x000A,
  [0x0B] = 0x000B,
  [0x0C] = 0x000C,
  [0x0D] = 0x000D,
  [0x0E] = 0x000E,
  [0x0F] = 0x000F,
  [0x10] = 0x0010,
  [0x11] = 0x0011,
  [0x12] = 0x0012,
  [0x13] = 0x0013,
  [0x14] = 0x0014,
  [0x15] = 0x0015,
  [0x16] = 0x0016,
  [0x17] = 0x0017,
  [0x18] = 0x0018,
  [0x19] = 0x0019,
  [0x1A] = 0x001A,
  [0x1B] = 0x001B,
  [0x1C] = 0x001C,
  [0x1D] = 0x001D,
  [0x1E] = 0x001E,
  [0x1F] = 0x001F,
  [0x20] = 0x0020,
  [0x21] = 0x0021,
  [0x22] = 0x0022,
  [0x23] = 0x0023,
  [0x24] = 0x0024,
  [0x25] = 0x0025,
  [0x26] = 0x0026,
  [0x27] = 0x0027,
  [0x28] = 0x0028,
  [0x29] = 0x0029,
  [0x2A] = 0x002A,
  [0x2B] = 0x002B,
  [0x2C] = 0x002C,
  [0x2D] = 0x002D,
  [0x2E] = 0x002E,
  [0x2F] = 0x002F,
  [0x30] = 0x0030,
  [0x31] = 0x0031,
  [0x32] = 0x0032,
  [0x33] = 0x0033,
  [0x34] = 0x0034,
  [0x35] = 0x0035,
  [0x36] = 0x0036,
  [0x37] = 0x0037,
  [0x38] = 0x0038,
  [0x39] = 0x0039,
  [0x3A] = 0x003A,
  [0x3B] = 0x003B,
  [0x3C] = 0x003C,
  [0x3D] = 0x003D,
  [0x3E] = 0x003E,
  [0x3F] = 0x003F,
  [0x40] = 0x0040,
  [0x41] = 0x0041,
  [0x42] = 0x0042,
  [0x43] = 0x0043,
  [0x44] = 0x0044,
  [0x45] = 0x0045,
  [0x46] = 0x0046,
  [0x47] = 0x0047,
  [0x48] = 0x0048,
  [0x49] = 0x0049,
  [0x4A] = 0x004A,
  [0x4B] = 0x004B,
  [0x4C] = 0x004C,
  [0x4D] = 0x004D,
  [0x4E] = 0x004E,
  [0x4F] = 0x004F,
  [0x50] = 0x0050,
  [0x51] = 0x0051,
  [0x52] = 0x0052,
  [0x53] = 0x0053,
  [0x54] = 0x0054,
  [0x55] = 0x0055,
  [0x56] = 0x0056,
  [0x57] = 0x0057,
  [0x58] = 0x0058,
  [0x59] = 0x0059,
  [0x5A] = 0x005A,
  [0x5B] = 0x005B,
  [0x5C] = 0x005C,
  [0x5D] = 0x005D,
  [0x5E] = 0x005E,
  [0x5F] = 0x005F,
  [0x60] = 0x0060,
  [0x61] = 0x0061,
  [0x62] = 0x0062,
  [0x63] = 0x0063,
  [0x64] = 0x0064,
  [0x65] = 0x0065,
  [0x66] = 0x0066,
  [0x67] = 0x0067,
  [0x68] = 0x0068,
  [0x69] = 0x0069,
  [0x6A] = 0x006A,
  [0x6B] = 0x006B,
  [0x6C] = 0x006C,
  [0x6D] = 0x006D,
  [0x6E] = 0x006E,
  [0x6F] = 0x006F,
  [0x70] = 0x0070,
  [0x71] = 0x0071,
  [0x72] = 0x0072,
  [0x73] = 0x0073,
  [0x74] = 0x0074,
  [0x75] = 0x0075,
  [0x76] = 0x0076,
  [0x77] = 0x0077,
  [0x78] = 0x0078,
  [0x79] = 0x0079,
  [0x7A] = 0x007A,
  [0x7B] = 0x007B,
  [0x7C] = 0x007C,
  [0x7D] = 0x007D,
  [0x7E] = 0x007E,
  [0x7F] = 0x007F,
  [0x80] = 0x0080,
  [0x81] = 0x0081,
  [0x82] = 0x0082,
  [0x83] = 0x0083,
  [0x84] = 0x0084,
  [0x85] = 0x0085,
  [0x86] = 0x0086,
  [0x87] = 0x0087,
  [0x88] = 0x0088,
  [0x89] = 0x0089,
  [0x8A] = 0x008A,
  [0x8B] = 0x008B,
  [0x8C] = 0x008C,
  [0x8D] = 0x008D,
  [0x8E] = 0x008E,
  [0x8F] = 0x008F,
  [0x90] = 0x0090,
  [0x91] = 0x0091,
  [0x92] = 0x0092,
  [0x93] = 0x0093,
  [0x94] = 0x0094,
  [0x95] = 0x0095,
  [0x96] = 0x0096,
  [0x97] = 0x0097,
  [0x98] = 0x0098,
  [0x99] = 0x0099,
  [0x9A] = 0x009A,
  [0x9B] = 0x009B,
  [0x9C] = 0x009C,
  [0x9D] = 0x009D,
  [0x9E] = 0x009E,
  [0x9F] = 0x009F,
  [0xA0] = 0x00A0,
  [0xA1] = 0x00A1,
  [0xA2] = 0x00A2,
  [0xA3] = 0x00A3,
  [0xA4] = 0x00A4,
  [0xA5] = 0x00A5,
  [0xA6] = 0x00A6,
  [0xA7] = 0x00A7,
  [0xA8] = 0x00A8,
  [0xA9] = 0x00A9,
  [0xAA] = 0x00AA,
  [0xAB] = 0x00AB,
  [0xAC] = 0x00AC,
  [0xAD] = 0x00AD,
  [0xAE] = 0x00AE,
  [0xAF] = 0x00AF,
  [0xB0] = 0x00B0,
  [0xB1] = 0x00B1,
  [0xB2] = 0x00B2,
  [0xB3] = 0x00B3,
  [0xB4] = 0x00B4,
  [0xB5] = 0x00B5,
  [0xB6] = 0x00B6,
  [0xB7] = 0x00B7,
  [0xB8] = 0x00B8,
  [0xB9] = 0x00B9,
  [0xBA] = 0x00BA,
  [0xBB] = 0x00BB,
  [0xBC] = 0x00BC,
  [0xBD] = 0x00BD,
  [0xBE] = 0x00BE,
  [0xBF] = 0x00BF,
  [0xC0] = 0x00C0,
  [0xC1] = 0x00C1,
  [0xC2] = 0x00C2,
  [0xC3] = 0x00C3,
  [0xC4] = 0x00C4,
  [0xC5] = 0x00C5,
  [0xC6] = 0x00C6,
  [0xC7] = 0x00C7,
  [0xC8] = 0x00C8,
  [0xC9] = 0x00C9,
  [0xCA] = 0x00CA,
  [0xCB] = 0x00CB,
  [0xCC] = 0x00CC,
  [0xCD] = 0x00CD,
  [0xCE] = 0x00CE,
  [0xCF] = 0x00CF,
  [0xD0] = 0x00D0,
  [0xD1] = 0x00D1,
  [0xD2] = 0x00D2,
  [0xD3] = 0x00D3,
  [0xD4] = 0x00D4,
  [0xD5] = 0x00D5,
  [0xD6] = 0x00D6,
  [0xD7] = 0x03A7,
  [0xD8] = 0x00D8,
  [0xD9] = 0x00D9,
  [0xDA] = 0x00DA,
  [0xDB] = 0x00DB,
  [0xDC] = 0x00DC,
  [0xDD] = 0x00DD,
  [0xDE] = 0x00DE,
  [0xDF] = 0x00DF,
  [0xE0] = 0x00E0,
  [0xE1] = 0x00E1,
  [0xE2] = 0x00E2,
  [0xE3] = 0x00E3,
  [0xE4] = 0x00E4,
  [0xE5] = 0x00E5,
  [0xE6] = 0x00E6,
  [0xE7] = 0x00E7,
  [0xE8] = 0x00E8,
  [0xE9] = 0x00E9,
  [0xEA] = 0x00EA,
  [0xEB] = 0x00EB,
  [0xEC] = 0x00EC,
  [0xED] = 0x00ED,
  [0xEE] = 0x00EE,
  [0xEF] = 0x00EF,
  [0xF0] = 0x00F0,
  [0xF1] = 0x00F1,
  [0xF2] = 0x00F2,
  [0xF3] = 0x00F3,
  [0xF4] = 0x00F4,
  [0xF5] = 0x00F5,
  [0xF6] = 0x00F6,
  [0xF7] = 0x03C7,
  [0xF8] = 0x00F8,
  [0xF9] = 0x00F9,
  [0xFA] = 0x00FA,
  [0xFB] = 0x00FB,
  [0xFC] = 0x00FC,
  [0xFD] = 0x00FD,
  [0xFE] = 0x00FE,
  [0xFF] = 0x00FF
};

static const uint32_t from_ucs4_diocletian[0x3c8] = {
  [0x0000] = 0x00,
  [0x0001] = 0x01,
  [0x0002] = 0x02,
  [0x0003] = 0x03,
  [0x0004] = 0x04,
  [0x0005] = 0x05,
  [0x0006] = 0x06,
  [0x0007] = 0x07,
  [0x0008] = 0x08,
  [0x0009] = 0x09,
  [0x000A] = 0x0A,
  [0x000B] = 0x0B,
  [0x000C] = 0x0C,
  [0x000D] = 0x0D,
  [0x000E] = 0x0E,
  [0x000F] = 0x0F,
  [0x0010] = 0x10,
  [0x0011] = 0x11,
  [0x0012] = 0x12,
  [0x0013] = 0x13,
  [0x0014] = 0x14,
  [0x0015] = 0x15,
  [0x0016] = 0x16,
  [0x0017] = 0x17,
  [0x0018] = 0x18,
  [0x0019] = 0x19,
  [0x001A] = 0x1A,
  [0x001B] = 0x1B,
  [0x001C] = 0x1C,
  [0x001D] = 0x1D,
  [0x001E] = 0x1E,
  [0x001F] = 0x1F,
  [0x0020] = 0x20,
  [0x0021] = 0x21,
  [0x0022] = 0x22,
  [0x0023] = 0x23,
  [0x0024] = 0x24,
  [0x0025] = 0x25,
  [0x0026] = 0x26,
  [0x0027] = 0x27,
  [0x0028] = 0x28,
  [0x0029] = 0x29,
  [0x002A] = 0x2A,
  [0x002B] = 0x2B,
  [0x002C] = 0x2C,
  [0x002D] = 0x2D,
  [0x002E] = 0x2E,
  [0x002F] = 0x2F,
  [0x0030] = 0x30,
  [0x0031] = 0x31,
  [0x0032] = 0x32,
  [0x0033] = 0x33,
  [0x0034] = 0x34,
  [0x0035] = 0x35,
  [0x0036] = 0x36,
  [0x0037] = 0x37,
  [0x0038] = 0x38,
  [0x0039] = 0x39,
  [0x003A] = 0x3A,
  [0x003B] = 0x3B,
  [0x003C] = 0x3C,
  [0x003D] = 0x3D,
  [0x003E] = 0x3E,
  [0x003F] = 0x3F,
  [0x0040] = 0x40,
  [0x0041] = 0x41,
  [0x0042] = 0x42,
  [0x0043] = 0x43,
  [0x0044] = 0x44,
  [0x0045] = 0x45,
  [0x0046] = 0x46,
  [0x0047] = 0x47,
  [0x0048] = 0x48,
  [0x0049] = 0x49,
  [0x004A] = 0x4A,
  [0x004B] = 0x4B,
  [0x004C] = 0x4C,
  [0x004D] = 0x4D,
  [0x004E] = 0x4E,
  [0x004F] = 0x4F,
  [0x0050] = 0x50,
  [0x0051] = 0x51,
  [0x0052] = 0x52,
  [0x0053] = 0x53,
  [0x0054] = 0x54,
  [0x0055] = 0x55,
  [0x0056] = 0x56,
  [0x0057] = 0x57,
  [0x0058] = 0x58,
  [0x0059] = 0x59,
  [0x005A] = 0x5A,
  [0x005B] = 0x5B,
  [0x005C] = 0x5C,
  [0x005D] = 0x5D,
  [0x005E] = 0x5E,
  [0x005F] = 0x5F,
  [0x0060] = 0x60,
  [0x0061] = 0x61,
  [0x0062] = 0x62,
  [0x0063] = 0x63,
  [0x0064] = 0x64,
  [0x0065] = 0x65,
  [0x0066] = 0x66,
  [0x0067] = 0x67,
  [0x0068] = 0x68,
  [0x0069] = 0x69,
  [0x006A] = 0x6A,
  [0x006B] = 0x6B,
  [0x006C] = 0x6C,
  [0x006D] = 0x6D,
  [0x006E] = 0x6E,
  [0x006F] = 0x6F,
  [0x0070] = 0x70,
  [0x0071] = 0x71,
  [0x0072] = 0x72,
  [0x0073] = 0x73,
  [0x0074] = 0x74,
  [0x0075] = 0x75,
  [0x0076] = 0x76,
  [0x0077] = 0x77,
  [0x0078] = 0x78,
  [0x0079] = 0x79,
  [0x007A] = 0x7A,
  [0x007B] = 0x7B,
  [0x007C] = 0x7C,
  [0x007D] = 0x7D,
  [0x007E] = 0x7E,
  [0x007F] = 0x7F,
  [0x0080] = 0x80,
  [0x0081] = 0x81,
  [0x0082] = 0x82,
  [0x0083] = 0x83,
  [0x0084] = 0x84,
  [0x0085] = 0x85,
  [0x0086] = 0x86,
  [0x0087] = 0x87,
  [0x0088] = 0x88,
  [0x0089] = 0x89,
  [0x008A] = 0x8A,
  [0x008B] = 0x8B,
  [0x008C] = 0x8C,
  [0x008D] = 0x8D,
  [0x008E] = 0x8E,
  [0x008F] = 0x8F,
  [0x0090] = 0x90,
  [0x0091] = 0x91,
  [0x0092] = 0x92,
  [0x0093] = 0x93,
  [0x0094] = 0x94,
  [0x0095] = 0x95,
  [0x0096] = 0x96,
  [0x0097] = 0x97,
  [0x0098] = 0x98,
  [0x0099] = 0x99,
  [0x009A] = 0x9A,
  [0x009B] = 0x9B,
  [0x009C] = 0x9C,
  [0x009D] = 0x9D,
  [0x009E] = 0x9E,
  [0x009F] = 0x9F,
  [0x00A0] = 0xA0,
  [0x00A1] = 0xA1,
  [0x00A2] = 0xA2,
  [0x00A3] = 0xA3,
  [0x00A4] = 0xA4,
  [0x00A5] = 0xA5,
  [0x00A6] = 0xA6,
  [0x00A7] = 0xA7,
  [0x00A8] = 0xA8,
  [0x00A9] = 0xA9,
  [0x00AA] = 0xAA,
  [0x00AB] = 0xAB,
  [0x00AC] = 0xAC,
  [0x00AD] = 0xAD,
  [0x00AE] = 0xAE,
  [0x00AF] = 0xAF,
  [0x00B0] = 0xB0,
  [0x00B1] = 0xB1,
  [0x00B2] = 0xB2,
  [0x00B3] = 0xB3,
  [0x00B4] = 0xB4,
  [0x00B5] = 0xB5,
  [0x00B6] = 0xB6,
  [0x00B7] = 0xB7,
  [0x00B8] = 0xB8,
  [0x00B9] = 0xB9,
  [0x00BA] = 0xBA,
  [0x00BB] = 0xBB,
  [0x00BC] = 0xBC,
  [0x00BD] = 0xBD,
  [0x00BE] = 0xBE,
  [0x00BF] = 0xBF,
  [0x00C0] = 0xC0,
  [0x00C1] = 0xC1,
  [0x00C2] = 0xC2,
  [0x00C3] = 0xC3,
  [0x00C4] = 0xC4,
  [0x00C5] = 0xC5,
  [0x00C6] = 0xC6,
  [0x00C7] = 0xC7,
  [0x00C8] = 0xC8,
  [0x00C9] = 0xC9,
  [0x00CA] = 0xCA,
  [0x00CB] = 0xCB,
  [0x00CC] = 0xCC,
  [0x00CD] = 0xCD,
  [0x00CE] = 0xCE,
  [0x00CF] = 0xCF,
  [0x00D0] = 0xD0,
  [0x00D1] = 0xD1,
  [0x00D2] = 0xD2,
  [0x00D3] = 0xD3,
  [0x00D4] = 0xD4,
  [0x00D5] = 0xD5,
  [0x00D6] = 0xD6,
  [0x03A7] = 0xD7,
  [0x00D8] = 0xD8,
  [0x00D9] = 0xD9,
  [0x00DA] = 0xDA,
  [0x00DB] = 0xDB,
  [0x00DC] = 0xDC,
  [0x00DD] = 0xDD,
  [0x00DE] = 0xDE,
  [0x00DF] = 0xDF,
  [0x00E0] = 0xE0,
  [0x00E1] = 0xE1,
  [0x00E2] = 0xE2,
  [0x00E3] = 0xE3,
  [0x00E4] = 0xE4,
  [0x00E5] = 0xE5,
  [0x00E6] = 0xE6,
  [0x00E7] = 0xE7,
  [0x00E8] = 0xE8,
  [0x00E9] = 0xE9,
  [0x00EA] = 0xEA,
  [0x00EB] = 0xEB,
  [0x00EC] = 0xEC,
  [0x00ED] = 0xED,
  [0x00EE] = 0xEE,
  [0x00EF] = 0xEF,
  [0x00F0] = 0xF0,
  [0x00F1] = 0xF1,
  [0x00F2] = 0xF2,
  [0x00F3] = 0xF3,
  [0x00F4] = 0xF4,
  [0x00F5] = 0xF5,
  [0x00F6] = 0xF6,
  [0x03C7] = 0xF7,
  [0x00F8] = 0xF8,
  [0x00F9] = 0xF9,
  [0x00FA] = 0xFA,
  [0x00FB] = 0xFB,
  [0x00FC] = 0xFC,
  [0x00FD] = 0xFD,
  [0x00FE] = 0xFE,
  [0x00FF] = 0xFF
};

/* Definitions used in the body of the `gconv' function.  */
#define CHARSET_NAME            "DIOCLETIAN//"
#define FROM_LOOP               from_diocletian
#define TO_LOOP                 to_diocletian
#define DEFINE_INIT             1
#define DEFINE_FINI             1
#define MIN_NEEDED_FROM         1
#define MIN_NEEDED_TO           4


/* First define the conversion function from the 8bit charset to UCS4.  */
#define MIN_NEEDED_INPUT        MIN_NEEDED_FROM
#define MIN_NEEDED_OUTPUT       MIN_NEEDED_TO
#define LOOPFCT                 FROM_LOOP
#define BODY \
  {                                                                           \
    uint32_t ch = to_ucs4_diocletian[*inptr];                                 \
    ++inptr;                                                                  \
                                                                              \
    *((uint32_t *) outptr)++ = ch;                                            \
  }
#include <iconv/loop.c>


/* Next, define the other direction.  */
#define MIN_NEEDED_INPUT        MIN_NEEDED_TO
#define MIN_NEEDED_OUTPUT       MIN_NEEDED_FROM
#define LOOPFCT                 TO_LOOP
#define BODY \
  {                                                                           \
    uint32_t ch = *((uint32_t *) inptr);                                      \
                                                                              \
    if (ch != 0 && from_ucs4_diocletian[ch] == '\0')                          \
      {                                                                       \
        /* This is an illegal character.  */                                  \
        result = __GCONV_ILLEGAL_INPUT;                                       \
        break;                                                                \
      }                                                                       \
                                                                              \
    *outptr++ = from_ucs4_diocletian[ch];                                     \
    inptr += 4;                                                               \
  }
#include <iconv/loop.c>

/* Now define the toplevel functions.  */
#include <iconv/skeleton.c>

