/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wts.tools.ant;

import com.sun.wts.tools.ant.Command;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenamePattern {
    private String from;
    private String to;
    private final List<String> excludes = new ArrayList<String>();
    private static final Function[] FUNCTIONS = new Function[]{new Function(){

        public String apply(String s) {
            return s;
        }

        String applyExclude(String s) {
            return RenamePattern.cutEnd(s);
        }
    }, new Function(){

        public String apply(String s) {
            return RenamePattern.cutEnd(s) + ';';
        }
    }, new Function(){

        public String apply(String s) {
            return s.replace('.', '/');
        }
    }, new Function(){

        public String apply(String s) {
            return s.replace('.', '\\');
        }
    }};

    public RenamePattern() {
    }

    public RenamePattern(String from, String to) {
        this.from = from;
        this.to = to;
    }

    String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from + '.';
    }

    String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to + '.';
    }

    public void setExcludes(String excludes) {
        StringTokenizer st = new StringTokenizer(excludes, ",");
        while (st.hasMoreTokens()) {
            this.excludes.add(st.nextToken().trim() + ".");
        }
    }

    private static String cutEnd(String s) {
        return s.substring(0, s.length() - 1);
    }

    public void addCommands(List<Command> commands) {
        for (Function f : FUNCTIONS) {
            ArrayList<Pattern> exclusions = new ArrayList<Pattern>();
            for (String exclude : this.excludes) {
                exclusions.add(Pattern.compile(f.applyExclude(exclude), 16));
            }
            commands.add(new Command(Pattern.compile(f.apply(this.from), 16), f.apply(this.to), exclusions));
        }
    }

    String convertPath(String relPath) {
        String norm = relPath.replace('/', '.').replace('\\', '.');
        if (norm.startsWith(this.from)) {
            for (String e : this.excludes) {
                if (!norm.startsWith(e)) continue;
                return null;
            }
            return this.to.replace('.', File.separatorChar) + relPath.substring(this.from.length());
        }
        return null;
    }

    static abstract class Function {
        Function() {
        }

        abstract String apply(String var1);

        String applyExclude(String s) {
            return this.apply(s);
        }
    }
}

